/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.layout;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.NamedArg;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.shape.StrokeType;

public final class BorderStrokeStyle {
    private static final List<Double> DOTTED_LIST = Collections.unmodifiableList(BorderStrokeStyle.asList(0.0, 2.0));
    private static final List<Double> DASHED_LIST = Collections.unmodifiableList(BorderStrokeStyle.asList(2.0, 1.4));
    public static final BorderStrokeStyle NONE = new BorderStrokeStyle(StrokeType.INSIDE, StrokeLineJoin.MITER, StrokeLineCap.BUTT, 0.0, 0.0, null);
    public static final BorderStrokeStyle DOTTED = new BorderStrokeStyle(StrokeType.INSIDE, StrokeLineJoin.MITER, StrokeLineCap.ROUND, 10.0, 0.0, DOTTED_LIST);
    public static final BorderStrokeStyle DASHED = new BorderStrokeStyle(StrokeType.INSIDE, StrokeLineJoin.MITER, StrokeLineCap.BUTT, 10.0, 0.0, DASHED_LIST);
    public static final BorderStrokeStyle SOLID = new BorderStrokeStyle(StrokeType.INSIDE, StrokeLineJoin.MITER, StrokeLineCap.BUTT, 10.0, 0.0, null);
    private final StrokeType type;
    private final StrokeLineJoin lineJoin;
    private final StrokeLineCap lineCap;
    private final double miterLimit;
    private final double dashOffset;
    private final List<Double> dashArray;
    private final int hash;

    public final StrokeType getType() {
        return this.type;
    }

    public final StrokeLineJoin getLineJoin() {
        return this.lineJoin;
    }

    public final StrokeLineCap getLineCap() {
        return this.lineCap;
    }

    public final double getMiterLimit() {
        return this.miterLimit;
    }

    public final double getDashOffset() {
        return this.dashOffset;
    }

    public final List<Double> getDashArray() {
        return this.dashArray;
    }

    public BorderStrokeStyle(@NamedArg(value="type") StrokeType type, @NamedArg(value="lineJoin") StrokeLineJoin lineJoin, @NamedArg(value="lineCap") StrokeLineCap lineCap, @NamedArg(value="miterLimit") double miterLimit, @NamedArg(value="dashOffset") double dashOffset, @NamedArg(value="dashArray") List<Double> dashArray) {
        this.type = type != null ? type : StrokeType.CENTERED;
        this.lineJoin = lineJoin != null ? lineJoin : StrokeLineJoin.MITER;
        this.lineCap = lineCap != null ? lineCap : StrokeLineCap.BUTT;
        this.miterLimit = miterLimit;
        this.dashOffset = dashOffset;
        if (dashArray == null) {
            this.dashArray = Collections.emptyList();
        } else if (dashArray == DASHED_LIST || dashArray == DOTTED_LIST) {
            this.dashArray = dashArray;
        } else {
            ArrayList<Double> list = new ArrayList<Double>(dashArray);
            this.dashArray = Collections.unmodifiableList(list);
        }
        int result = this.type.hashCode();
        result = 31 * result + this.lineJoin.hashCode();
        result = 31 * result + this.lineCap.hashCode();
        long temp = this.miterLimit != 0.0 ? Double.doubleToLongBits(this.miterLimit) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.dashOffset != 0.0 ? Double.doubleToLongBits(this.dashOffset) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        this.hash = result = 31 * result + this.dashArray.hashCode();
    }

    public String toString() {
        if (this == NONE) {
            return "BorderStyle.NONE";
        }
        if (this == DASHED) {
            return "BorderStyle.DASHED";
        }
        if (this == DOTTED) {
            return "BorderStyle.DOTTED";
        }
        if (this == SOLID) {
            return "BorderStyle.SOLID";
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("BorderStyle: ");
        buffer.append((Object)this.type);
        buffer.append(", ");
        buffer.append((Object)this.lineJoin);
        buffer.append(", ");
        buffer.append((Object)this.lineCap);
        buffer.append(", ");
        buffer.append(this.miterLimit);
        buffer.append(", ");
        buffer.append(this.dashOffset);
        buffer.append(", [");
        if (this.dashArray != null) {
            buffer.append(this.dashArray);
        }
        buffer.append("]");
        return buffer.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (this == NONE && o != NONE || o == NONE && this != NONE) {
            return false;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BorderStrokeStyle that = (BorderStrokeStyle)o;
        if (this.hash != that.hash) {
            return false;
        }
        if (Double.compare(that.dashOffset, this.dashOffset) != 0) {
            return false;
        }
        if (Double.compare(that.miterLimit, this.miterLimit) != 0) {
            return false;
        }
        if (!this.dashArray.equals(that.dashArray)) {
            return false;
        }
        if (this.lineCap != that.lineCap) {
            return false;
        }
        if (this.lineJoin != that.lineJoin) {
            return false;
        }
        return this.type == that.type;
    }

    public int hashCode() {
        return this.hash;
    }

    private static List<Double> asList(double ... items) {
        ArrayList<Double> list = new ArrayList<Double>(items.length);
        for (int i = 0; i < items.length; ++i) {
            list.add(items[i]);
        }
        return list;
    }
}

