/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.chart;

import com.sun.javafx.collections.NonIterableChange;
import com.sun.javafx.css.converters.BooleanConverter;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.property.StringPropertyBase;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableBooleanProperty;
import javafx.css.StyleableProperty;
import javafx.geometry.Orientation;
import javafx.geometry.Side;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.chart.Axis;
import javafx.scene.chart.Chart;
import javafx.scene.layout.Region;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.Line;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.Rectangle;
import javafx.util.Duration;

public abstract class XYChart<X, Y>
extends Chart {
    private final BitSet colorBits = new BitSet(8);
    static String DEFAULT_COLOR = "default-color";
    final Map<Series<X, Y>, Integer> seriesColorMap = new HashMap<Series<X, Y>, Integer>();
    private boolean rangeValid = false;
    private final Line verticalZeroLine = new Line();
    private final Line horizontalZeroLine = new Line();
    private final Path verticalGridLines = new Path();
    private final Path horizontalGridLines = new Path();
    private final Path horizontalRowFill = new Path();
    private final Path verticalRowFill = new Path();
    private final Region plotBackground = new Region();
    private final Group plotArea = new Group(){

        @Override
        public void requestLayout() {
        }
    };
    private final Group plotContent = new Group();
    private final Rectangle plotAreaClip = new Rectangle();
    private final List<Series<X, Y>> displayedSeries = new ArrayList<Series<X, Y>>();
    private final ListChangeListener<Series<X, Y>> seriesChanged = c -> {
        ObservableList series = c.getList();
        while (c.next()) {
            if (c.wasPermutated()) {
                this.displayedSeries.sort((o1, o2) -> series.indexOf(o2) - series.indexOf(o1));
            }
            if (c.getRemoved().size() > 0) {
                this.updateLegend();
            }
            HashSet<Series<X, Y>> dupCheck = new HashSet<Series<X, Y>>(this.displayedSeries);
            dupCheck.removeAll(c.getRemoved());
            for (Series d : c.getAddedSubList()) {
                if (dupCheck.add(d)) continue;
                throw new IllegalArgumentException("Duplicate series added");
            }
            for (Series s : c.getRemoved()) {
                s.setToRemove = true;
                this.seriesRemoved(s);
                int idx = this.seriesColorMap.remove(s);
                this.colorBits.clear(idx);
            }
            for (int i = c.getFrom(); i < c.getTo() && !c.wasPermutated(); ++i) {
                Series s;
                s = (Series)c.getList().get(i);
                s.setChart(this);
                if (s.setToRemove) {
                    s.setToRemove = false;
                    s.getChart().seriesBeingRemovedIsAdded(s);
                }
                this.displayedSeries.add(s);
                int nextClearBit = this.colorBits.nextClearBit(0);
                this.colorBits.set(nextClearBit, true);
                s.defaultColorStyleClass = DEFAULT_COLOR + nextClearBit % 8;
                this.seriesColorMap.put(s, nextClearBit % 8);
                this.seriesAdded(s, i);
            }
            if (c.getFrom() < c.getTo()) {
                this.updateLegend();
            }
            this.seriesChanged(c);
        }
        this.invalidateRange();
        this.requestChartLayout();
    };
    private final Axis<X> xAxis;
    private final Axis<Y> yAxis;
    private ObjectProperty<ObservableList<Series<X, Y>>> data = new ObjectPropertyBase<ObservableList<Series<X, Y>>>(){
        private ObservableList<Series<X, Y>> old;

        @Override
        protected void invalidated() {
            ObservableList current = (ObservableList)this.getValue();
            int saveAnimationState = -1;
            if (this.old != null) {
                this.old.removeListener(XYChart.this.seriesChanged);
                if (current != null && this.old.size() > 0) {
                    saveAnimationState = ((Series)this.old.get(0)).getChart().getAnimated() ? 1 : 2;
                    ((Series)this.old.get(0)).getChart().setAnimated(false);
                }
            }
            if (current != null) {
                current.addListener(XYChart.this.seriesChanged);
            }
            if (this.old != null || current != null) {
                int toIndex;
                final List removed = this.old != null ? this.old : Collections.emptyList();
                int n = toIndex = current != null ? current.size() : 0;
                if (toIndex > 0 || !removed.isEmpty()) {
                    XYChart.this.seriesChanged.onChanged(new NonIterableChange<Series<X, Y>>(0, toIndex, current){

                        @Override
                        public List<Series<X, Y>> getRemoved() {
                            return removed;
                        }

                        @Override
                        protected int[] getPermutation() {
                            return new int[0];
                        }
                    });
                }
            } else if (this.old != null && this.old.size() > 0) {
                XYChart.this.seriesChanged.onChanged(new NonIterableChange<Series<X, Y>>(0, 0, current){

                    @Override
                    public List<Series<X, Y>> getRemoved() {
                        return old;
                    }

                    @Override
                    protected int[] getPermutation() {
                        return new int[0];
                    }
                });
            }
            if (current != null && current.size() > 0 && saveAnimationState != -1) {
                ((Series)current.get(0)).getChart().setAnimated(saveAnimationState == 1);
            }
            this.old = current;
        }

        @Override
        public Object getBean() {
            return XYChart.this;
        }

        @Override
        public String getName() {
            return "data";
        }
    };
    private BooleanProperty verticalGridLinesVisible = new StyleableBooleanProperty(true){

        @Override
        protected void invalidated() {
            XYChart.this.requestChartLayout();
        }

        @Override
        public Object getBean() {
            return XYChart.this;
        }

        @Override
        public String getName() {
            return "verticalGridLinesVisible";
        }

        @Override
        public CssMetaData<XYChart<?, ?>, Boolean> getCssMetaData() {
            return StyleableProperties.VERTICAL_GRID_LINE_VISIBLE;
        }
    };
    private BooleanProperty horizontalGridLinesVisible = new StyleableBooleanProperty(true){

        @Override
        protected void invalidated() {
            XYChart.this.requestChartLayout();
        }

        @Override
        public Object getBean() {
            return XYChart.this;
        }

        @Override
        public String getName() {
            return "horizontalGridLinesVisible";
        }

        @Override
        public CssMetaData<XYChart<?, ?>, Boolean> getCssMetaData() {
            return StyleableProperties.HORIZONTAL_GRID_LINE_VISIBLE;
        }
    };
    private BooleanProperty alternativeColumnFillVisible = new StyleableBooleanProperty(false){

        @Override
        protected void invalidated() {
            XYChart.this.requestChartLayout();
        }

        @Override
        public Object getBean() {
            return XYChart.this;
        }

        @Override
        public String getName() {
            return "alternativeColumnFillVisible";
        }

        @Override
        public CssMetaData<XYChart<?, ?>, Boolean> getCssMetaData() {
            return StyleableProperties.ALTERNATIVE_COLUMN_FILL_VISIBLE;
        }
    };
    private BooleanProperty alternativeRowFillVisible = new StyleableBooleanProperty(true){

        @Override
        protected void invalidated() {
            XYChart.this.requestChartLayout();
        }

        @Override
        public Object getBean() {
            return XYChart.this;
        }

        @Override
        public String getName() {
            return "alternativeRowFillVisible";
        }

        @Override
        public CssMetaData<XYChart<?, ?>, Boolean> getCssMetaData() {
            return StyleableProperties.ALTERNATIVE_ROW_FILL_VISIBLE;
        }
    };
    private BooleanProperty verticalZeroLineVisible = new StyleableBooleanProperty(true){

        @Override
        protected void invalidated() {
            XYChart.this.requestChartLayout();
        }

        @Override
        public Object getBean() {
            return XYChart.this;
        }

        @Override
        public String getName() {
            return "verticalZeroLineVisible";
        }

        @Override
        public CssMetaData<XYChart<?, ?>, Boolean> getCssMetaData() {
            return StyleableProperties.VERTICAL_ZERO_LINE_VISIBLE;
        }
    };
    private BooleanProperty horizontalZeroLineVisible = new StyleableBooleanProperty(true){

        @Override
        protected void invalidated() {
            XYChart.this.requestChartLayout();
        }

        @Override
        public Object getBean() {
            return XYChart.this;
        }

        @Override
        public String getName() {
            return "horizontalZeroLineVisible";
        }

        @Override
        public CssMetaData<XYChart<?, ?>, Boolean> getCssMetaData() {
            return StyleableProperties.HORIZONTAL_ZERO_LINE_VISIBLE;
        }
    };

    public Axis<X> getXAxis() {
        return this.xAxis;
    }

    public Axis<Y> getYAxis() {
        return this.yAxis;
    }

    public final ObservableList<Series<X, Y>> getData() {
        return (ObservableList)this.data.getValue();
    }

    public final void setData(ObservableList<Series<X, Y>> value) {
        this.data.setValue(value);
    }

    public final ObjectProperty<ObservableList<Series<X, Y>>> dataProperty() {
        return this.data;
    }

    public final boolean getVerticalGridLinesVisible() {
        return this.verticalGridLinesVisible.get();
    }

    public final void setVerticalGridLinesVisible(boolean value) {
        this.verticalGridLinesVisible.set(value);
    }

    public final BooleanProperty verticalGridLinesVisibleProperty() {
        return this.verticalGridLinesVisible;
    }

    public final boolean isHorizontalGridLinesVisible() {
        return this.horizontalGridLinesVisible.get();
    }

    public final void setHorizontalGridLinesVisible(boolean value) {
        this.horizontalGridLinesVisible.set(value);
    }

    public final BooleanProperty horizontalGridLinesVisibleProperty() {
        return this.horizontalGridLinesVisible;
    }

    public final boolean isAlternativeColumnFillVisible() {
        return this.alternativeColumnFillVisible.getValue();
    }

    public final void setAlternativeColumnFillVisible(boolean value) {
        this.alternativeColumnFillVisible.setValue(value);
    }

    public final BooleanProperty alternativeColumnFillVisibleProperty() {
        return this.alternativeColumnFillVisible;
    }

    public final boolean isAlternativeRowFillVisible() {
        return this.alternativeRowFillVisible.getValue();
    }

    public final void setAlternativeRowFillVisible(boolean value) {
        this.alternativeRowFillVisible.setValue(value);
    }

    public final BooleanProperty alternativeRowFillVisibleProperty() {
        return this.alternativeRowFillVisible;
    }

    public final boolean isVerticalZeroLineVisible() {
        return this.verticalZeroLineVisible.get();
    }

    public final void setVerticalZeroLineVisible(boolean value) {
        this.verticalZeroLineVisible.set(value);
    }

    public final BooleanProperty verticalZeroLineVisibleProperty() {
        return this.verticalZeroLineVisible;
    }

    public final boolean isHorizontalZeroLineVisible() {
        return this.horizontalZeroLineVisible.get();
    }

    public final void setHorizontalZeroLineVisible(boolean value) {
        this.horizontalZeroLineVisible.set(value);
    }

    public final BooleanProperty horizontalZeroLineVisibleProperty() {
        return this.horizontalZeroLineVisible;
    }

    protected ObservableList<Node> getPlotChildren() {
        return this.plotContent.getChildren();
    }

    public XYChart(Axis<X> xAxis, Axis<Y> yAxis) {
        this.xAxis = xAxis;
        if (xAxis.getSide() == null) {
            xAxis.setSide(Side.BOTTOM);
        }
        xAxis.setEffectiveOrientation(Orientation.HORIZONTAL);
        this.yAxis = yAxis;
        if (yAxis.getSide() == null) {
            yAxis.setSide(Side.LEFT);
        }
        yAxis.setEffectiveOrientation(Orientation.VERTICAL);
        xAxis.autoRangingProperty().addListener((ov, t, t1) -> this.updateAxisRange());
        yAxis.autoRangingProperty().addListener((ov, t, t1) -> this.updateAxisRange());
        this.getChartChildren().addAll((Node[])new Node[]{this.plotBackground, this.plotArea, xAxis, yAxis});
        this.plotArea.setAutoSizeChildren(false);
        this.plotContent.setAutoSizeChildren(false);
        this.plotAreaClip.setSmooth(false);
        this.plotArea.setClip(this.plotAreaClip);
        this.plotArea.getChildren().addAll((Node[])new Node[]{this.verticalRowFill, this.horizontalRowFill, this.verticalGridLines, this.horizontalGridLines, this.verticalZeroLine, this.horizontalZeroLine, this.plotContent});
        this.plotContent.getStyleClass().setAll((String[])new String[]{"plot-content"});
        this.plotBackground.getStyleClass().setAll((String[])new String[]{"chart-plot-background"});
        this.verticalRowFill.getStyleClass().setAll((String[])new String[]{"chart-alternative-column-fill"});
        this.horizontalRowFill.getStyleClass().setAll((String[])new String[]{"chart-alternative-row-fill"});
        this.verticalGridLines.getStyleClass().setAll((String[])new String[]{"chart-vertical-grid-lines"});
        this.horizontalGridLines.getStyleClass().setAll((String[])new String[]{"chart-horizontal-grid-lines"});
        this.verticalZeroLine.getStyleClass().setAll((String[])new String[]{"chart-vertical-zero-line"});
        this.horizontalZeroLine.getStyleClass().setAll((String[])new String[]{"chart-horizontal-zero-line"});
        this.plotContent.setManaged(false);
        this.plotArea.setManaged(false);
        this.animatedProperty().addListener((valueModel, oldValue, newValue) -> {
            if (this.getXAxis() != null) {
                this.getXAxis().setAnimated((boolean)newValue);
            }
            if (this.getYAxis() != null) {
                this.getYAxis().setAnimated((boolean)newValue);
            }
        });
    }

    final int getDataSize() {
        ObservableList<Series<X, Y>> data = this.getData();
        return data != null ? data.size() : 0;
    }

    private void seriesNameChanged() {
        this.updateLegend();
        this.requestChartLayout();
    }

    private void dataItemsChanged(Series<X, Y> series, List<Data<X, Y>> removed, int addedFrom, int addedTo, boolean permutation) {
        for (Data<X, Y> data : removed) {
            this.dataItemRemoved(data, series);
        }
        for (int i = addedFrom; i < addedTo; ++i) {
            Data data = (Data)series.getData().get(i);
            this.dataItemAdded(series, i, data);
        }
        this.invalidateRange();
        this.requestChartLayout();
    }

    private void dataXValueChanged(Data<X, Y> item) {
        if (item.getCurrentX() != item.getXValue()) {
            this.invalidateRange();
        }
        this.dataItemChanged(item);
        if (this.shouldAnimate()) {
            this.animate(new KeyFrame(Duration.ZERO, new KeyValue(item.currentXProperty(), item.getCurrentX())), new KeyFrame(Duration.millis(700.0), new KeyValue(item.currentXProperty(), item.getXValue(), Interpolator.EASE_BOTH)));
        } else {
            item.setCurrentX(item.getXValue());
            this.requestChartLayout();
        }
    }

    private void dataYValueChanged(Data<X, Y> item) {
        if (item.getCurrentY() != item.getYValue()) {
            this.invalidateRange();
        }
        this.dataItemChanged(item);
        if (this.shouldAnimate()) {
            this.animate(new KeyFrame(Duration.ZERO, new KeyValue(item.currentYProperty(), item.getCurrentY())), new KeyFrame(Duration.millis(700.0), new KeyValue(item.currentYProperty(), item.getYValue(), Interpolator.EASE_BOTH)));
        } else {
            item.setCurrentY(item.getYValue());
            this.requestChartLayout();
        }
    }

    private void dataExtraValueChanged(Data<X, Y> item) {
        if (item.getCurrentY() != item.getYValue()) {
            this.invalidateRange();
        }
        this.dataItemChanged(item);
        if (this.shouldAnimate()) {
            this.animate(new KeyFrame(Duration.ZERO, new KeyValue(item.currentYProperty(), item.getCurrentY())), new KeyFrame(Duration.millis(700.0), new KeyValue(item.currentYProperty(), item.getYValue(), Interpolator.EASE_BOTH)));
        } else {
            item.setCurrentY(item.getYValue());
            this.requestChartLayout();
        }
    }

    protected void updateLegend() {
    }

    void seriesBeingRemovedIsAdded(Series<X, Y> series) {
    }

    void dataBeingRemovedIsAdded(Data<X, Y> item, Series<X, Y> series) {
    }

    protected abstract void dataItemAdded(Series<X, Y> var1, int var2, Data<X, Y> var3);

    protected abstract void dataItemRemoved(Data<X, Y> var1, Series<X, Y> var2);

    protected abstract void dataItemChanged(Data<X, Y> var1);

    protected abstract void seriesAdded(Series<X, Y> var1, int var2);

    protected abstract void seriesRemoved(Series<X, Y> var1);

    protected void seriesChanged(ListChangeListener.Change<? extends Series> c) {
    }

    private void invalidateRange() {
        this.rangeValid = false;
    }

    protected void updateAxisRange() {
        Axis<X> xa = this.getXAxis();
        Axis<Y> ya = this.getYAxis();
        ArrayList xData = null;
        ArrayList yData = null;
        if (xa.isAutoRanging()) {
            xData = new ArrayList();
        }
        if (ya.isAutoRanging()) {
            yData = new ArrayList();
        }
        if (xData != null || yData != null) {
            for (Series series : this.getData()) {
                for (Data data : series.getData()) {
                    if (xData != null) {
                        xData.add(data.getXValue());
                    }
                    if (yData == null) continue;
                    yData.add(data.getYValue());
                }
            }
            if (xData != null) {
                xa.invalidateRange(xData);
            }
            if (yData != null) {
                ya.invalidateRange(yData);
            }
        }
    }

    protected abstract void layoutPlotChildren();

    @Override
    protected final void layoutChartChildren(double top, double left, double width, double height) {
        double pos;
        ArrayList<Double> tickPositionsNegative;
        Axis.TickMark tick;
        int i;
        if (this.getData() == null) {
            return;
        }
        if (!this.rangeValid) {
            this.rangeValid = true;
            if (this.getData() != null) {
                this.updateAxisRange();
            }
        }
        top = this.snapPosition(top);
        left = this.snapPosition(left);
        Axis<X> xa = this.getXAxis();
        ObservableList<Axis.TickMark<X>> xaTickMarks = xa.getTickMarks();
        Axis<Y> ya = this.getYAxis();
        ObservableList<Axis.TickMark<Y>> yaTickMarks = ya.getTickMarks();
        if (xa == null || ya == null) {
            return;
        }
        double xAxisWidth = 0.0;
        double xAxisHeight = 30.0;
        double yAxisWidth = 0.0;
        double yAxisHeight = 0.0;
        for (int count = 0; count < 5; ++count) {
            double newXAxisHeight;
            yAxisHeight = this.snapSize(height - xAxisHeight);
            if (yAxisHeight < 0.0) {
                yAxisHeight = 0.0;
            }
            if ((xAxisWidth = this.snapSize(width - (yAxisWidth = ya.prefWidth(yAxisHeight)))) < 0.0) {
                xAxisWidth = 0.0;
            }
            if ((newXAxisHeight = xa.prefHeight(xAxisWidth)) == xAxisHeight) break;
            xAxisHeight = newXAxisHeight;
        }
        xAxisWidth = Math.ceil(xAxisWidth);
        xAxisHeight = Math.ceil(xAxisHeight);
        yAxisWidth = Math.ceil(yAxisWidth);
        yAxisHeight = Math.ceil(yAxisHeight);
        double xAxisY = 0.0;
        switch (xa.getEffectiveSide()) {
            case TOP: {
                xa.setVisible(true);
                xAxisY = top + 1.0;
                top += xAxisHeight;
                break;
            }
            case BOTTOM: {
                xa.setVisible(true);
                xAxisY = top + yAxisHeight;
            }
        }
        double yAxisX = 0.0;
        switch (ya.getEffectiveSide()) {
            case LEFT: {
                ya.setVisible(true);
                yAxisX = left + 1.0;
                left += yAxisWidth;
                break;
            }
            case RIGHT: {
                ya.setVisible(true);
                yAxisX = left + xAxisWidth;
            }
        }
        xa.resizeRelocate(left, xAxisY, xAxisWidth, xAxisHeight);
        ya.resizeRelocate(yAxisX, top, yAxisWidth, yAxisHeight);
        xa.requestAxisLayout();
        xa.layout();
        ya.requestAxisLayout();
        ya.layout();
        this.layoutPlotChildren();
        double xAxisZero = xa.getZeroPosition();
        double yAxisZero = ya.getZeroPosition();
        if (Double.isNaN(xAxisZero) || !this.isVerticalZeroLineVisible()) {
            this.verticalZeroLine.setVisible(false);
        } else {
            this.verticalZeroLine.setStartX(left + xAxisZero + 0.5);
            this.verticalZeroLine.setStartY(top);
            this.verticalZeroLine.setEndX(left + xAxisZero + 0.5);
            this.verticalZeroLine.setEndY(top + yAxisHeight);
            this.verticalZeroLine.setVisible(true);
        }
        if (Double.isNaN(yAxisZero) || !this.isHorizontalZeroLineVisible()) {
            this.horizontalZeroLine.setVisible(false);
        } else {
            this.horizontalZeroLine.setStartX(left);
            this.horizontalZeroLine.setStartY(top + yAxisZero + 0.5);
            this.horizontalZeroLine.setEndX(left + xAxisWidth);
            this.horizontalZeroLine.setEndY(top + yAxisZero + 0.5);
            this.horizontalZeroLine.setVisible(true);
        }
        this.plotBackground.resizeRelocate(left, top, xAxisWidth, yAxisHeight);
        this.plotAreaClip.setX(left);
        this.plotAreaClip.setY(top);
        this.plotAreaClip.setWidth(xAxisWidth + 1.0);
        this.plotAreaClip.setHeight(yAxisHeight + 1.0);
        this.plotContent.setLayoutX(left);
        this.plotContent.setLayoutY(top);
        this.plotContent.requestLayout();
        this.verticalGridLines.getElements().clear();
        if (this.getVerticalGridLinesVisible()) {
            for (i = 0; i < xaTickMarks.size(); ++i) {
                tick = (Axis.TickMark)xaTickMarks.get(i);
                double x = xa.getDisplayPosition(tick.getValue());
                if (x == xAxisZero && this.isVerticalZeroLineVisible() || !(x > 0.0) || !(x <= xAxisWidth)) continue;
                this.verticalGridLines.getElements().add(new MoveTo(left + x + 0.5, top));
                this.verticalGridLines.getElements().add(new LineTo(left + x + 0.5, top + yAxisHeight));
            }
        }
        this.horizontalGridLines.getElements().clear();
        if (this.isHorizontalGridLinesVisible()) {
            for (i = 0; i < yaTickMarks.size(); ++i) {
                tick = (Axis.TickMark)yaTickMarks.get(i);
                double y = ya.getDisplayPosition(tick.getValue());
                if (y == yAxisZero && this.isHorizontalZeroLineVisible() || !(y >= 0.0) || !(y < yAxisHeight)) continue;
                this.horizontalGridLines.getElements().add(new MoveTo(left, top + y + 0.5));
                this.horizontalGridLines.getElements().add(new LineTo(left + xAxisWidth, top + y + 0.5));
            }
        }
        this.verticalRowFill.getElements().clear();
        if (this.isAlternativeColumnFillVisible()) {
            double x2;
            double x1;
            int i2;
            ArrayList<Double> tickPositionsPositive = new ArrayList<Double>();
            tickPositionsNegative = new ArrayList<Double>();
            for (i2 = 0; i2 < xaTickMarks.size(); ++i2) {
                pos = xa.getDisplayPosition(((Axis.TickMark)xaTickMarks.get(i2)).getValue());
                if (pos == xAxisZero) {
                    tickPositionsPositive.add(pos);
                    tickPositionsNegative.add(pos);
                    continue;
                }
                if (pos < xAxisZero) {
                    tickPositionsPositive.add(pos);
                    continue;
                }
                tickPositionsNegative.add(pos);
            }
            Collections.sort(tickPositionsPositive);
            Collections.sort(tickPositionsNegative);
            for (i2 = 1; i2 < tickPositionsPositive.size(); i2 += 2) {
                if (i2 + 1 >= tickPositionsPositive.size()) continue;
                x1 = (Double)tickPositionsPositive.get(i2);
                x2 = (Double)tickPositionsPositive.get(i2 + 1);
                this.verticalRowFill.getElements().addAll((PathElement[])new PathElement[]{new MoveTo(left + x1, top), new LineTo(left + x1, top + yAxisHeight), new LineTo(left + x2, top + yAxisHeight), new LineTo(left + x2, top), new ClosePath()});
            }
            for (i2 = 0; i2 < tickPositionsNegative.size(); i2 += 2) {
                if (i2 + 1 >= tickPositionsNegative.size()) continue;
                x1 = (Double)tickPositionsNegative.get(i2);
                x2 = (Double)tickPositionsNegative.get(i2 + 1);
                this.verticalRowFill.getElements().addAll((PathElement[])new PathElement[]{new MoveTo(left + x1, top), new LineTo(left + x1, top + yAxisHeight), new LineTo(left + x2, top + yAxisHeight), new LineTo(left + x2, top), new ClosePath()});
            }
        }
        this.horizontalRowFill.getElements().clear();
        if (this.isAlternativeRowFillVisible()) {
            double y2;
            double y1;
            int i3;
            ArrayList<Double> tickPositionsPositive = new ArrayList<Double>();
            tickPositionsNegative = new ArrayList();
            for (i3 = 0; i3 < yaTickMarks.size(); ++i3) {
                pos = ya.getDisplayPosition(((Axis.TickMark)yaTickMarks.get(i3)).getValue());
                if (pos == yAxisZero) {
                    tickPositionsPositive.add(pos);
                    tickPositionsNegative.add(pos);
                    continue;
                }
                if (pos < yAxisZero) {
                    tickPositionsPositive.add(pos);
                    continue;
                }
                tickPositionsNegative.add(pos);
            }
            Collections.sort(tickPositionsPositive);
            Collections.sort(tickPositionsNegative);
            for (i3 = 1; i3 < tickPositionsPositive.size(); i3 += 2) {
                if (i3 + 1 >= tickPositionsPositive.size()) continue;
                y1 = (Double)tickPositionsPositive.get(i3);
                y2 = (Double)tickPositionsPositive.get(i3 + 1);
                this.horizontalRowFill.getElements().addAll((PathElement[])new PathElement[]{new MoveTo(left, top + y1), new LineTo(left + xAxisWidth, top + y1), new LineTo(left + xAxisWidth, top + y2), new LineTo(left, top + y2), new ClosePath()});
            }
            for (i3 = 0; i3 < tickPositionsNegative.size(); i3 += 2) {
                if (i3 + 1 >= tickPositionsNegative.size()) continue;
                y1 = (Double)tickPositionsNegative.get(i3);
                y2 = (Double)tickPositionsNegative.get(i3 + 1);
                this.horizontalRowFill.getElements().addAll((PathElement[])new PathElement[]{new MoveTo(left, top + y1), new LineTo(left + xAxisWidth, top + y1), new LineTo(left + xAxisWidth, top + y2), new LineTo(left, top + y2), new ClosePath()});
            }
        }
    }

    int getSeriesIndex(Series<X, Y> series) {
        return this.displayedSeries.indexOf(series);
    }

    int getSeriesSize() {
        return this.displayedSeries.size();
    }

    protected final void removeSeriesFromDisplay(Series<X, Y> series) {
        if (series != null) {
            series.setToRemove = false;
        }
        ((Series)series).setChart(null);
        this.displayedSeries.remove(series);
    }

    protected final Iterator<Series<X, Y>> getDisplayedSeriesIterator() {
        return Collections.unmodifiableList(this.displayedSeries).iterator();
    }

    final KeyFrame[] createSeriesRemoveTimeLine(Series<X, Y> series, long fadeOutTime) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        nodes.add(series.getNode());
        for (Data data : series.getData()) {
            if (data.getNode() == null) continue;
            nodes.add(data.getNode());
        }
        KeyValue[] startValues = new KeyValue[nodes.size()];
        KeyValue[] keyValueArray = new KeyValue[nodes.size()];
        for (int j = 0; j < nodes.size(); ++j) {
            startValues[j] = new KeyValue(((Node)nodes.get(j)).opacityProperty(), 1);
            keyValueArray[j] = new KeyValue(((Node)nodes.get(j)).opacityProperty(), 0);
        }
        return new KeyFrame[]{new KeyFrame(Duration.ZERO, startValues), new KeyFrame(Duration.millis(fadeOutTime), actionEvent -> {
            this.getPlotChildren().removeAll((Collection<?>)nodes);
            this.removeSeriesFromDisplay(series);
        }, keyValueArray)};
    }

    protected final X getCurrentDisplayedXValue(Data<X, Y> item) {
        return item.getCurrentX();
    }

    protected final void setCurrentDisplayedXValue(Data<X, Y> item, X value) {
        item.setCurrentX(value);
    }

    protected final ObjectProperty<X> currentDisplayedXValueProperty(Data<X, Y> item) {
        return item.currentXProperty();
    }

    protected final Y getCurrentDisplayedYValue(Data<X, Y> item) {
        return item.getCurrentY();
    }

    protected final void setCurrentDisplayedYValue(Data<X, Y> item, Y value) {
        item.setCurrentY(value);
    }

    protected final ObjectProperty<Y> currentDisplayedYValueProperty(Data<X, Y> item) {
        return item.currentYProperty();
    }

    protected final Object getCurrentDisplayedExtraValue(Data<X, Y> item) {
        return item.getCurrentExtraValue();
    }

    protected final void setCurrentDisplayedExtraValue(Data<X, Y> item, Object value) {
        item.setCurrentExtraValue(value);
    }

    protected final ObjectProperty<Object> currentDisplayedExtraValueProperty(Data<X, Y> item) {
        return item.currentExtraValueProperty();
    }

    protected final Iterator<Data<X, Y>> getDisplayedDataIterator(Series<X, Y> series) {
        return Collections.unmodifiableList(((Series)series).displayedData).iterator();
    }

    protected final void removeDataItemFromDisplay(Series<X, Y> series, Data<X, Y> item) {
        ((Series)series).removeDataItemRef(item);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return XYChart.getClassCssMetaData();
    }

    public static final class Series<X, Y> {
        String defaultColorStyleClass;
        boolean setToRemove = false;
        private List<Data<X, Y>> displayedData = new ArrayList<Data<X, Y>>();
        private final ListChangeListener<Data<X, Y>> dataChangeListener = new ListChangeListener<Data<X, Y>>(){

            @Override
            public void onChanged(ListChangeListener.Change<? extends Data<X, Y>> c) {
                ObservableList data = c.getList();
                XYChart chart = this.getChart();
                while (c.next()) {
                    HashSet<Data> dupCheck;
                    if (chart != null) {
                        if (c.wasPermutated()) {
                            displayedData.sort((o1, o2) -> data.indexOf(o2) - data.indexOf(o1));
                            return;
                        }
                        dupCheck = new HashSet(displayedData);
                        dupCheck.removeAll(c.getRemoved());
                        for (Data data2 : c.getAddedSubList()) {
                            if (dupCheck.add(data2)) continue;
                            throw new IllegalArgumentException("Duplicate data added");
                        }
                        for (Data data3 : c.getRemoved()) {
                            data3.setToRemove = true;
                        }
                        if (c.getAddedSize() > 0) {
                            for (Data data4 : c.getAddedSubList()) {
                                if (!data4.setToRemove) continue;
                                if (chart != null) {
                                    chart.dataBeingRemovedIsAdded(data4, this);
                                }
                                data4.setToRemove = false;
                            }
                            for (Data data5 : c.getAddedSubList()) {
                                data5.setSeries(this);
                            }
                            if (c.getFrom() == 0) {
                                displayedData.addAll(0, c.getAddedSubList());
                            } else {
                                displayedData.addAll(displayedData.indexOf(data.get(c.getFrom() - 1)) + 1, c.getAddedSubList());
                            }
                        }
                        chart.dataItemsChanged(this, c.getRemoved(), c.getFrom(), c.getTo(), c.wasPermutated());
                        continue;
                    }
                    dupCheck = new HashSet<Data>();
                    for (Data data6 : data) {
                        if (dupCheck.add(data6)) continue;
                        throw new IllegalArgumentException("Duplicate data added");
                    }
                    for (Data data7 : c.getAddedSubList()) {
                        data7.setSeries(this);
                    }
                }
            }
        };
        private final ReadOnlyObjectWrapper<XYChart<X, Y>> chart = new ReadOnlyObjectWrapper<XYChart<X, Y>>(this, "chart"){

            @Override
            protected void invalidated() {
                if (this.get() == null) {
                    displayedData.clear();
                } else {
                    displayedData.addAll(this.getData());
                }
            }
        };
        private final StringProperty name = new StringPropertyBase(){

            @Override
            protected void invalidated() {
                this.get();
                if (this.getChart() != null) {
                    this.getChart().seriesNameChanged();
                }
            }

            @Override
            public Object getBean() {
                return this;
            }

            @Override
            public String getName() {
                return "name";
            }
        };
        private ObjectProperty<Node> node = new SimpleObjectProperty<Node>(this, "node");
        private final ObjectProperty<ObservableList<Data<X, Y>>> data = new ObjectPropertyBase<ObservableList<Data<X, Y>>>(){
            private ObservableList<Data<X, Y>> old;

            @Override
            protected void invalidated() {
                ObservableList current = (ObservableList)this.getValue();
                if (this.old != null) {
                    this.old.removeListener(dataChangeListener);
                }
                if (current != null) {
                    current.addListener(dataChangeListener);
                }
                if (this.old != null || current != null) {
                    int toIndex;
                    final List removed = this.old != null ? this.old : Collections.emptyList();
                    int n = toIndex = current != null ? current.size() : 0;
                    if (toIndex > 0 || !removed.isEmpty()) {
                        dataChangeListener.onChanged(new NonIterableChange<Data<X, Y>>(0, toIndex, current){

                            @Override
                            public List<Data<X, Y>> getRemoved() {
                                return removed;
                            }

                            @Override
                            protected int[] getPermutation() {
                                return new int[0];
                            }
                        });
                    }
                } else if (this.old != null && this.old.size() > 0) {
                    dataChangeListener.onChanged(new NonIterableChange<Data<X, Y>>(0, 0, current){

                        @Override
                        public List<Data<X, Y>> getRemoved() {
                            return old;
                        }

                        @Override
                        protected int[] getPermutation() {
                            return new int[0];
                        }
                    });
                }
                this.old = current;
            }

            @Override
            public Object getBean() {
                return this;
            }

            @Override
            public String getName() {
                return "data";
            }
        };

        public final XYChart<X, Y> getChart() {
            return (XYChart)this.chart.get();
        }

        private void setChart(XYChart<X, Y> value) {
            this.chart.set(value);
        }

        public final ReadOnlyObjectProperty<XYChart<X, Y>> chartProperty() {
            return this.chart.getReadOnlyProperty();
        }

        public final String getName() {
            return (String)this.name.get();
        }

        public final void setName(String value) {
            this.name.set(value);
        }

        public final StringProperty nameProperty() {
            return this.name;
        }

        public final Node getNode() {
            return (Node)this.node.get();
        }

        public final void setNode(Node value) {
            this.node.set(value);
        }

        public final ObjectProperty<Node> nodeProperty() {
            return this.node;
        }

        public final ObservableList<Data<X, Y>> getData() {
            return (ObservableList)this.data.getValue();
        }

        public final void setData(ObservableList<Data<X, Y>> value) {
            this.data.setValue(value);
        }

        public final ObjectProperty<ObservableList<Data<X, Y>>> dataProperty() {
            return this.data;
        }

        public Series() {
            this(FXCollections.observableArrayList());
        }

        public Series(ObservableList<Data<X, Y>> data) {
            this.setData(data);
            for (Data data2 : data) {
                data2.setSeries(this);
            }
        }

        public Series(String name, ObservableList<Data<X, Y>> data) {
            this(data);
            this.setName(name);
        }

        public String toString() {
            return "Series[" + this.getName() + "]";
        }

        private void removeDataItemRef(Data<X, Y> item) {
            if (item != null) {
                ((Data)item).setToRemove = false;
            }
            this.displayedData.remove(item);
        }

        int getItemIndex(Data<X, Y> item) {
            return this.displayedData.indexOf(item);
        }

        Data<X, Y> getItem(int i) {
            return this.displayedData.get(i);
        }

        int getDataSize() {
            return this.displayedData.size();
        }
    }

    public static final class Data<X, Y> {
        private boolean setToRemove = false;
        private Series<X, Y> series;
        private ObjectProperty<X> xValue = new ObjectPropertyBase<X>(this){
            final /* synthetic */ Data this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            protected void invalidated() {
                this.get();
                if (this.this$0.series != null) {
                    XYChart chart = this.this$0.series.getChart();
                    if (chart != null) {
                        chart.dataXValueChanged(this.this$0);
                    }
                } else {
                    this.this$0.setCurrentX(this.get());
                }
            }

            @Override
            public Object getBean() {
                return this.this$0;
            }

            @Override
            public String getName() {
                return "XValue";
            }
        };
        private ObjectProperty<Y> yValue = new ObjectPropertyBase<Y>(this){
            final /* synthetic */ Data this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            protected void invalidated() {
                this.get();
                if (this.this$0.series != null) {
                    XYChart chart = this.this$0.series.getChart();
                    if (chart != null) {
                        chart.dataYValueChanged(this.this$0);
                    }
                } else {
                    this.this$0.setCurrentY(this.get());
                }
            }

            @Override
            public Object getBean() {
                return this.this$0;
            }

            @Override
            public String getName() {
                return "YValue";
            }
        };
        private ObjectProperty<Object> extraValue = new ObjectPropertyBase<Object>(this){
            final /* synthetic */ Data this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            protected void invalidated() {
                XYChart chart;
                this.get();
                if (this.this$0.series != null && (chart = this.this$0.series.getChart()) != null) {
                    chart.dataExtraValueChanged(this.this$0);
                }
            }

            @Override
            public Object getBean() {
                return this.this$0;
            }

            @Override
            public String getName() {
                return "extraValue";
            }
        };
        private ObjectProperty<Node> node = new SimpleObjectProperty<Node>(this, (Object)this, "node"){
            final /* synthetic */ Data this$0;
            {
                this.this$0 = this$0;
                super(x0, x1);
            }

            @Override
            protected void invalidated() {
                Node node = (Node)this.get();
                if (node != null) {
                    node.accessibleTextProperty().unbind();
                    node.accessibleTextProperty().bind(new StringBinding(){
                        {
                            this.bind(this$0.currentXProperty(), this$0.currentYProperty());
                        }

                        @Override
                        protected String computeValue() {
                            String seriesName = this$0.series != null ? this$0.series.getName() : "";
                            return seriesName + " X Axis is " + this$0.getCurrentX() + " Y Axis is " + this$0.getCurrentY();
                        }
                    });
                }
            }
        };
        private ObjectProperty<X> currentX = new SimpleObjectProperty<X>(this, "currentX");
        private ObjectProperty<Y> currentY = new SimpleObjectProperty<Y>(this, "currentY");
        private ObjectProperty<Object> currentExtraValue = new SimpleObjectProperty<Object>(this, "currentExtraValue");

        void setSeries(Series<X, Y> series) {
            this.series = series;
        }

        public final X getXValue() {
            return (X)this.xValue.get();
        }

        public final void setXValue(X value) {
            this.xValue.set(value);
            if (this.currentX.get() == null || this.series != null && this.series.getChart() == null) {
                this.currentX.setValue(value);
            }
        }

        public final ObjectProperty<X> XValueProperty() {
            return this.xValue;
        }

        public final Y getYValue() {
            return (Y)this.yValue.get();
        }

        public final void setYValue(Y value) {
            this.yValue.set(value);
            if (this.currentY.get() == null || this.series != null && this.series.getChart() == null) {
                this.currentY.setValue(value);
            }
        }

        public final ObjectProperty<Y> YValueProperty() {
            return this.yValue;
        }

        public final Object getExtraValue() {
            return this.extraValue.get();
        }

        public final void setExtraValue(Object value) {
            this.extraValue.set(value);
        }

        public final ObjectProperty<Object> extraValueProperty() {
            return this.extraValue;
        }

        public final Node getNode() {
            return (Node)this.node.get();
        }

        public final void setNode(Node value) {
            this.node.set(value);
        }

        public final ObjectProperty<Node> nodeProperty() {
            return this.node;
        }

        final X getCurrentX() {
            return (X)this.currentX.get();
        }

        final void setCurrentX(X value) {
            this.currentX.set(value);
        }

        final ObjectProperty<X> currentXProperty() {
            return this.currentX;
        }

        final Y getCurrentY() {
            return (Y)this.currentY.get();
        }

        final void setCurrentY(Y value) {
            this.currentY.set(value);
        }

        final ObjectProperty<Y> currentYProperty() {
            return this.currentY;
        }

        final Object getCurrentExtraValue() {
            return this.currentExtraValue.getValue();
        }

        final void setCurrentExtraValue(Object value) {
            this.currentExtraValue.setValue(value);
        }

        final ObjectProperty<Object> currentExtraValueProperty() {
            return this.currentExtraValue;
        }

        public Data() {
        }

        public Data(X xValue, Y yValue) {
            this.setXValue(xValue);
            this.setYValue(yValue);
            this.setCurrentX(xValue);
            this.setCurrentY(yValue);
        }

        public Data(X xValue, Y yValue, Object extraValue) {
            this.setXValue(xValue);
            this.setYValue(yValue);
            this.setExtraValue(extraValue);
            this.setCurrentX(xValue);
            this.setCurrentY(yValue);
            this.setCurrentExtraValue(extraValue);
        }

        public String toString() {
            return "Data[" + this.getXValue() + "," + this.getYValue() + "," + this.getExtraValue() + "]";
        }
    }

    private static class StyleableProperties {
        private static final CssMetaData<XYChart<?, ?>, Boolean> HORIZONTAL_GRID_LINE_VISIBLE = new CssMetaData<XYChart<?, ?>, Boolean>("-fx-horizontal-grid-lines-visible", BooleanConverter.getInstance(), Boolean.TRUE){

            @Override
            public boolean isSettable(XYChart<?, ?> node) {
                return ((XYChart)node).horizontalGridLinesVisible == null || !((XYChart)node).horizontalGridLinesVisible.isBound();
            }

            @Override
            public StyleableProperty<Boolean> getStyleableProperty(XYChart<?, ?> node) {
                return (StyleableProperty)((Object)node.horizontalGridLinesVisibleProperty());
            }
        };
        private static final CssMetaData<XYChart<?, ?>, Boolean> HORIZONTAL_ZERO_LINE_VISIBLE = new CssMetaData<XYChart<?, ?>, Boolean>("-fx-horizontal-zero-line-visible", BooleanConverter.getInstance(), Boolean.TRUE){

            @Override
            public boolean isSettable(XYChart<?, ?> node) {
                return ((XYChart)node).horizontalZeroLineVisible == null || !((XYChart)node).horizontalZeroLineVisible.isBound();
            }

            @Override
            public StyleableProperty<Boolean> getStyleableProperty(XYChart<?, ?> node) {
                return (StyleableProperty)((Object)node.horizontalZeroLineVisibleProperty());
            }
        };
        private static final CssMetaData<XYChart<?, ?>, Boolean> ALTERNATIVE_ROW_FILL_VISIBLE = new CssMetaData<XYChart<?, ?>, Boolean>("-fx-alternative-row-fill-visible", BooleanConverter.getInstance(), Boolean.TRUE){

            @Override
            public boolean isSettable(XYChart<?, ?> node) {
                return ((XYChart)node).alternativeRowFillVisible == null || !((XYChart)node).alternativeRowFillVisible.isBound();
            }

            @Override
            public StyleableProperty<Boolean> getStyleableProperty(XYChart<?, ?> node) {
                return (StyleableProperty)((Object)node.alternativeRowFillVisibleProperty());
            }
        };
        private static final CssMetaData<XYChart<?, ?>, Boolean> VERTICAL_GRID_LINE_VISIBLE = new CssMetaData<XYChart<?, ?>, Boolean>("-fx-vertical-grid-lines-visible", BooleanConverter.getInstance(), Boolean.TRUE){

            @Override
            public boolean isSettable(XYChart<?, ?> node) {
                return ((XYChart)node).verticalGridLinesVisible == null || !((XYChart)node).verticalGridLinesVisible.isBound();
            }

            @Override
            public StyleableProperty<Boolean> getStyleableProperty(XYChart<?, ?> node) {
                return (StyleableProperty)((Object)node.verticalGridLinesVisibleProperty());
            }
        };
        private static final CssMetaData<XYChart<?, ?>, Boolean> VERTICAL_ZERO_LINE_VISIBLE = new CssMetaData<XYChart<?, ?>, Boolean>("-fx-vertical-zero-line-visible", BooleanConverter.getInstance(), Boolean.TRUE){

            @Override
            public boolean isSettable(XYChart<?, ?> node) {
                return ((XYChart)node).verticalZeroLineVisible == null || !((XYChart)node).verticalZeroLineVisible.isBound();
            }

            @Override
            public StyleableProperty<Boolean> getStyleableProperty(XYChart<?, ?> node) {
                return (StyleableProperty)((Object)node.verticalZeroLineVisibleProperty());
            }
        };
        private static final CssMetaData<XYChart<?, ?>, Boolean> ALTERNATIVE_COLUMN_FILL_VISIBLE = new CssMetaData<XYChart<?, ?>, Boolean>("-fx-alternative-column-fill-visible", BooleanConverter.getInstance(), Boolean.TRUE){

            @Override
            public boolean isSettable(XYChart<?, ?> node) {
                return ((XYChart)node).alternativeColumnFillVisible == null || !((XYChart)node).alternativeColumnFillVisible.isBound();
            }

            @Override
            public StyleableProperty<Boolean> getStyleableProperty(XYChart<?, ?> node) {
                return (StyleableProperty)((Object)node.alternativeColumnFillVisibleProperty());
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(Chart.getClassCssMetaData());
            styleables.add(HORIZONTAL_GRID_LINE_VISIBLE);
            styleables.add(HORIZONTAL_ZERO_LINE_VISIBLE);
            styleables.add(ALTERNATIVE_ROW_FILL_VISIBLE);
            styleables.add(VERTICAL_GRID_LINE_VISIBLE);
            styleables.add(VERTICAL_ZERO_LINE_VISIBLE);
            styleables.add(ALTERNATIVE_COLUMN_FILL_VISIBLE);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

