/*
 * Decompiled with CFR 0.152.
 */
package javafx.embed.swing;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javafx.scene.input.DataFormat;

final class DataFlavorUtils {
    DataFlavorUtils() {
    }

    static String getFxMimeType(DataFlavor flavor) {
        return flavor.getPrimaryType() + "/" + flavor.getSubType();
    }

    static DataFlavor[] getDataFlavors(String[] mimeTypes) {
        ArrayList<DataFlavor> flavors = new ArrayList<DataFlavor>(mimeTypes.length);
        for (String mime : mimeTypes) {
            DataFlavor flavor = null;
            try {
                flavor = new DataFlavor(mime);
            }
            catch (ClassNotFoundException e) {
                continue;
            }
            flavors.add(flavor);
        }
        return flavors.toArray(new DataFlavor[0]);
    }

    static DataFlavor getDataFlavor(DataFormat format) {
        DataFlavor[] flavors = DataFlavorUtils.getDataFlavors(format.getIdentifiers().toArray(new String[1]));
        return flavors.length == 0 ? null : flavors[0];
    }

    static String getMimeType(DataFormat format) {
        Iterator<String> iterator = format.getIdentifiers().iterator();
        if (iterator.hasNext()) {
            String id = iterator.next();
            return id;
        }
        return null;
    }

    static DataFormat getDataFormat(DataFlavor flavor) {
        String mimeType = DataFlavorUtils.getFxMimeType(flavor);
        DataFormat dataFormat = DataFormat.lookupMimeType(mimeType);
        if (dataFormat == null) {
            dataFormat = new DataFormat(mimeType);
        }
        return dataFormat;
    }

    static Object adjustFxData(DataFlavor flavor, Object fxData) throws UnsupportedEncodingException {
        if (fxData instanceof String) {
            if (flavor.isRepresentationClassInputStream()) {
                String encoding = flavor.getParameter("charset");
                return new ByteArrayInputStream(encoding != null ? ((String)fxData).getBytes(encoding) : ((String)fxData).getBytes());
            }
            if (flavor.isRepresentationClassByteBuffer()) {
                // empty if block
            }
        }
        if (fxData instanceof ByteBuffer && flavor.isRepresentationClassInputStream()) {
            return new ByteBufferInputStream((ByteBuffer)fxData);
        }
        return fxData;
    }

    static Object adjustSwingData(DataFlavor flavor, String mimeType, Object swingData) {
        if (swingData == null) {
            return swingData;
        }
        if (flavor.isFlavorJavaFileListType()) {
            List fileList = (List)swingData;
            String[] paths = new String[fileList.size()];
            int i = 0;
            for (File f : fileList) {
                paths[i++] = f.getPath();
            }
            return paths;
        }
        DataFormat dataFormat = DataFormat.lookupMimeType(mimeType);
        if (DataFormat.PLAIN_TEXT.equals(dataFormat)) {
            if (flavor.isFlavorTextType()) {
                if (swingData instanceof InputStream) {
                    InputStream in = (InputStream)swingData;
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    byte[] bb = new byte[64];
                    try {
                        int len = in.read(bb);
                        while (len != -1) {
                            out.write(bb, 0, len);
                            len = in.read(bb);
                        }
                        out.close();
                        return new String(out.toByteArray());
                    }
                    catch (Exception exception) {}
                }
            } else if (swingData != null) {
                return swingData.toString();
            }
        }
        return swingData;
    }

    static Map<String, DataFlavor> adjustSwingDataFlavors(DataFlavor[] flavors) {
        HashMap mimeType2Flavors = new HashMap(flavors.length);
        for (DataFlavor flavor : flavors) {
            Set<DataFlavor> mimeTypeFlavors;
            String mimeType = DataFlavorUtils.getFxMimeType(flavor);
            if (mimeType2Flavors.containsKey(mimeType)) {
                mimeTypeFlavors = (Set)mimeType2Flavors.get(mimeType);
                try {
                    mimeTypeFlavors.add(flavor);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {}
                continue;
            }
            mimeTypeFlavors = new HashSet();
            if (flavor.isFlavorTextType()) {
                mimeTypeFlavors.add(DataFlavor.stringFlavor);
                mimeTypeFlavors = Collections.unmodifiableSet(mimeTypeFlavors);
            } else {
                mimeTypeFlavors.add(flavor);
            }
            mimeType2Flavors.put(mimeType, mimeTypeFlavors);
        }
        HashMap<String, DataFlavor> mimeType2Flavor = new HashMap<String, DataFlavor>();
        for (String mimeType : mimeType2Flavors.keySet()) {
            DataFlavor[] mimeTypeFlavors = ((Set)mimeType2Flavors.get(mimeType)).toArray(new DataFlavor[0]);
            if (mimeTypeFlavors.length == 1) {
                mimeType2Flavor.put(mimeType, mimeTypeFlavors[0]);
                continue;
            }
            mimeType2Flavor.put(mimeType, mimeTypeFlavors[0]);
        }
        return mimeType2Flavor;
    }

    private static Object readData(Transferable t, DataFlavor flavor) {
        Object obj = null;
        try {
            obj = t.getTransferData(flavor);
        }
        catch (UnsupportedFlavorException ex) {
            ex.printStackTrace(System.err);
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
        return obj;
    }

    static Map<String, Object> readAllData(Transferable t, Map<String, DataFlavor> fxMimeType2DataFlavor, boolean fetchData) {
        Object obj;
        HashMap<String, Object> fxMimeType2Data = new HashMap<String, Object>();
        for (DataFlavor flavor : t.getTransferDataFlavors()) {
            Object object = obj = fetchData ? DataFlavorUtils.readData(t, flavor) : null;
            if (obj == null && fetchData) continue;
            String mimeType = DataFlavorUtils.getFxMimeType(flavor);
            obj = DataFlavorUtils.adjustSwingData(flavor, mimeType, obj);
            fxMimeType2Data.put(mimeType, obj);
        }
        for (Map.Entry entry : fxMimeType2DataFlavor.entrySet()) {
            DataFlavor flavor;
            String mimeType = (String)entry.getKey();
            flavor = (DataFlavor)entry.getValue();
            Object object = obj = fetchData ? DataFlavorUtils.readData(t, flavor) : null;
            if (obj == null && fetchData) continue;
            obj = DataFlavorUtils.adjustSwingData(flavor, mimeType, obj);
            fxMimeType2Data.put((String)entry.getKey(), obj);
        }
        return fxMimeType2Data;
    }

    private static class ByteBufferInputStream
    extends InputStream {
        private final ByteBuffer bb;

        private ByteBufferInputStream(ByteBuffer bb) {
            this.bb = bb;
        }

        @Override
        public int available() {
            return this.bb.remaining();
        }

        @Override
        public int read() throws IOException {
            if (!this.bb.hasRemaining()) {
                return -1;
            }
            return this.bb.get() & 0xFF;
        }

        @Override
        public int read(byte[] bytes, int off, int len) throws IOException {
            if (!this.bb.hasRemaining()) {
                return -1;
            }
            len = Math.min(len, this.bb.remaining());
            this.bb.get(bytes, off, len);
            return len;
        }
    }
}

