/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.animation.shared;

import com.sun.scenario.animation.shared.ClipInterpolator;
import com.sun.scenario.animation.shared.InterpolationInterval;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.beans.value.WritableValue;

class GeneralClipInterpolator
extends ClipInterpolator {
    private KeyFrame[] keyFrames;
    private long[] keyFrameTicks;
    private InterpolationInterval[][] interval = new InterpolationInterval[0][];
    private int[] undefinedStartValues = new int[0];
    private boolean invalid = true;

    GeneralClipInterpolator(KeyFrame[] keyFrames, long[] keyFrameTicks) {
        this.keyFrames = keyFrames;
        this.keyFrameTicks = keyFrameTicks;
    }

    @Override
    ClipInterpolator setKeyFrames(KeyFrame[] keyFrames, long[] keyFrameTicks) {
        if (ClipInterpolator.getRealKeyFrameCount(keyFrames) == 2) {
            return ClipInterpolator.create(keyFrames, keyFrameTicks);
        }
        this.keyFrames = keyFrames;
        this.keyFrameTicks = keyFrameTicks;
        this.invalid = true;
        return this;
    }

    @Override
    void validate(boolean forceSync) {
        if (this.invalid) {
            int undefinedStartValuesCount;
            int index;
            HashMap lastKeyValues = new HashMap();
            int n = this.keyFrames.length;
            for (index = 0; index < n; ++index) {
                KeyFrame keyFrame = this.keyFrames[index];
                if (this.keyFrameTicks[index] != 0L) break;
                for (KeyValue keyValue : keyFrame.getValues()) {
                    lastKeyValues.put(keyValue.getTarget(), keyValue);
                }
            }
            HashMap map = new HashMap();
            HashSet undefinedValues = new HashSet();
            while (index < n) {
                KeyFrame keyFrame = this.keyFrames[index];
                long ticks = this.keyFrameTicks[index];
                for (KeyValue rightKeyValue : keyFrame.getValues()) {
                    WritableValue<?> target = rightKeyValue.getTarget();
                    ArrayList<InterpolationInterval> list = (ArrayList<InterpolationInterval>)map.get(target);
                    KeyValue leftKeyValue = (KeyValue)lastKeyValues.get(target);
                    if (list == null) {
                        list = new ArrayList<InterpolationInterval>();
                        map.put(target, list);
                        if (leftKeyValue == null) {
                            list.add(InterpolationInterval.create(rightKeyValue, ticks));
                            undefinedValues.add(target);
                        } else {
                            list.add(InterpolationInterval.create(rightKeyValue, ticks, leftKeyValue, ticks));
                        }
                    } else {
                        assert (leftKeyValue != null);
                        list.add(InterpolationInterval.create(rightKeyValue, ticks, leftKeyValue, ticks - ((InterpolationInterval)list.get((int)(list.size() - 1))).ticks));
                    }
                    lastKeyValues.put(target, rightKeyValue);
                }
                ++index;
            }
            int targetCount = map.size();
            if (this.interval.length != targetCount) {
                this.interval = new InterpolationInterval[targetCount][];
            }
            if (this.undefinedStartValues.length != (undefinedStartValuesCount = undefinedValues.size())) {
                this.undefinedStartValues = new int[undefinedStartValuesCount];
            }
            int undefinedStartValuesIndex = 0;
            Iterator iterator = map.entrySet().iterator();
            for (int i = 0; i < targetCount; ++i) {
                Map.Entry entry = iterator.next();
                this.interval[i] = new InterpolationInterval[((List)entry.getValue()).size()];
                ((List)entry.getValue()).toArray(this.interval[i]);
                if (!undefinedValues.contains(entry.getKey())) continue;
                this.undefinedStartValues[undefinedStartValuesIndex++] = i;
            }
            this.invalid = false;
        } else if (forceSync) {
            for (int index : this.undefinedStartValues) {
                this.interval[index][0].recalculateStartValue();
            }
        }
    }

    @Override
    void interpolate(long ticks) {
        block0: for (InterpolationInterval[] intervalList : this.interval) {
            int intervalCount = intervalList.length;
            long leftTicks = 0L;
            for (int intervalIndex = 0; intervalIndex < intervalCount - 1; ++intervalIndex) {
                InterpolationInterval i = intervalList[intervalIndex];
                long rightTicks = i.ticks;
                if (ticks <= rightTicks) {
                    double frac = (double)(ticks - leftTicks) / (double)(rightTicks - leftTicks);
                    i.interpolate(frac);
                    continue block0;
                }
                leftTicks = rightTicks;
            }
            InterpolationInterval i = intervalList[intervalCount - 1];
            double frac = Math.min(1.0, (double)(ticks - leftTicks) / (double)(i.ticks - leftTicks));
            i.interpolate(frac);
        }
    }
}

