/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.skin.TableColumnHeader;
import com.sun.javafx.scene.control.skin.TableHeaderRow;
import com.sun.javafx.scene.control.skin.VirtualContainerBase;
import com.sun.javafx.scene.control.skin.resources.ControlResources;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.util.Iterator;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.collections.WeakListChangeListener;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.AccessibleAttribute;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Cell;
import javafx.scene.control.Control;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.Label;
import javafx.scene.control.ResizeFeaturesBase;
import javafx.scene.control.ScrollToEvent;
import javafx.scene.control.Skinnable;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TableFocusModel;
import javafx.scene.control.TablePositionBase;
import javafx.scene.control.TableSelectionModel;
import javafx.scene.control.TableView;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.util.Callback;

public abstract class TableViewSkinBase<M, S, C extends Control, B extends BehaviorBase<C>, I extends IndexedCell<M>, TC extends TableColumnBase<S, ?>>
extends VirtualContainerBase<C, B, I> {
    public static final String REFRESH = "tableRefreshKey";
    public static final String RECREATE = "tableRecreateKey";
    private boolean contentWidthDirty = true;
    private Region columnReorderLine;
    private Region columnReorderOverlay;
    private TableHeaderRow tableHeaderRow;
    private Callback<C, I> rowFactory;
    private StackPane placeholderRegion;
    private Label placeholderLabel;
    private static final String EMPTY_TABLE_TEXT = ControlResources.getString("TableView.noContent");
    private static final String NO_COLUMNS_TEXT = ControlResources.getString("TableView.noColumns");
    private int visibleColCount;
    protected boolean needCellsRebuilt = true;
    protected boolean needCellsRecreated = true;
    protected boolean needCellsReconfigured = false;
    private int itemCount = -1;
    protected boolean forceCellRecreate = false;
    private static final boolean IS_PANNABLE = AccessController.doPrivileged(() -> Boolean.getBoolean("com.sun.javafx.scene.control.skin.TableViewSkin.pannable"));
    private MapChangeListener<Object, Object> propertiesMapListener = c -> {
        if (!c.wasAdded()) {
            return;
        }
        if (REFRESH.equals(c.getKey())) {
            this.refreshView();
            ((Node)((Object)this.getSkinnable())).getProperties().remove(REFRESH);
        } else if (RECREATE.equals(c.getKey())) {
            this.forceCellRecreate = true;
            this.refreshView();
            ((Node)((Object)this.getSkinnable())).getProperties().remove(RECREATE);
        }
    };
    private ListChangeListener<S> rowCountListener = c -> {
        while (c.next()) {
            if (c.wasReplaced()) {
                this.itemCount = 0;
                break;
            }
            if (c.getRemovedSize() != this.itemCount) continue;
            this.itemCount = 0;
            break;
        }
        if (this.getSkinnable() instanceof TableView) {
            this.edit(-1, null);
        }
        this.rowCountDirty = true;
        ((Parent)((Object)this.getSkinnable())).requestLayout();
    };
    private ListChangeListener<TC> visibleLeafColumnsListener = c -> {
        this.updateVisibleColumnCount();
        while (c.next()) {
            this.updateVisibleLeafColumnWidthListeners(c.getAddedSubList(), c.getRemoved());
        }
    };
    private InvalidationListener widthListener = observable -> {
        this.needCellsReconfigured = true;
        if (this.getSkinnable() != null) {
            ((Parent)((Object)this.getSkinnable())).requestLayout();
        }
    };
    private InvalidationListener itemsChangeListener;
    private WeakListChangeListener<S> weakRowCountListener = new WeakListChangeListener<S>(this.rowCountListener);
    private WeakListChangeListener<TC> weakVisibleLeafColumnsListener = new WeakListChangeListener<TC>(this.visibleLeafColumnsListener);
    private WeakInvalidationListener weakWidthListener = new WeakInvalidationListener(this.widthListener);
    private WeakInvalidationListener weakItemsChangeListener;
    private static final double GOLDEN_RATIO_MULTIPLIER = 0.618033987;

    public TableViewSkinBase(C control, B behavior) {
        super(control, behavior);
    }

    protected void init(C control) {
        this.flow.setPannable(IS_PANNABLE);
        this.flow.setCreateCell(flow1 -> this.createCell());
        InvalidationListener hbarValueListener = valueModel -> this.horizontalScroll();
        this.flow.getHbar().valueProperty().addListener(hbarValueListener);
        this.flow.getHbar().setUnitIncrement(15.0);
        this.flow.getHbar().setBlockIncrement(80.0);
        this.columnReorderLine = new Region();
        this.columnReorderLine.getStyleClass().setAll((String[])new String[]{"column-resize-line"});
        this.columnReorderLine.setManaged(false);
        this.columnReorderLine.setVisible(false);
        this.columnReorderOverlay = new Region();
        this.columnReorderOverlay.getStyleClass().setAll((String[])new String[]{"column-overlay"});
        this.columnReorderOverlay.setVisible(false);
        this.columnReorderOverlay.setManaged(false);
        this.tableHeaderRow = this.createTableHeaderRow();
        this.tableHeaderRow.setFocusTraversable(false);
        this.getChildren().addAll((Node[])new Node[]{this.tableHeaderRow, this.flow, this.columnReorderOverlay, this.columnReorderLine});
        this.updateVisibleColumnCount();
        this.updateVisibleLeafColumnWidthListeners(this.getVisibleLeafColumns(), FXCollections.emptyObservableList());
        this.tableHeaderRow.reorderingProperty().addListener(valueModel -> ((Parent)((Object)this.getSkinnable())).requestLayout());
        this.getVisibleLeafColumns().addListener(this.weakVisibleLeafColumnsListener);
        this.updateTableItems(null, (ObservableList)this.itemsProperty().get());
        this.itemsChangeListener = new InvalidationListener(){
            private WeakReference<ObservableList<S>> weakItemsRef;
            {
                this.weakItemsRef = new WeakReference(TableViewSkinBase.this.itemsProperty().get());
            }

            @Override
            public void invalidated(Observable observable) {
                ObservableList oldItems = (ObservableList)this.weakItemsRef.get();
                this.weakItemsRef = new WeakReference(TableViewSkinBase.this.itemsProperty().get());
                TableViewSkinBase.this.updateTableItems(oldItems, (ObservableList)TableViewSkinBase.this.itemsProperty().get());
            }
        };
        this.weakItemsChangeListener = new WeakInvalidationListener(this.itemsChangeListener);
        this.itemsProperty().addListener(this.weakItemsChangeListener);
        ObservableMap<Object, Object> properties = ((Node)control).getProperties();
        properties.remove(REFRESH);
        properties.remove(RECREATE);
        properties.addListener(this.propertiesMapListener);
        ((Node)control).addEventHandler(ScrollToEvent.scrollToColumn(), event -> this.scrollHorizontally((TableColumnBase)event.getScrollTarget()));
        InvalidationListener widthObserver = valueModel -> {
            this.contentWidthDirty = true;
            ((Parent)((Object)this.getSkinnable())).requestLayout();
        };
        this.flow.widthProperty().addListener(widthObserver);
        this.flow.getVbar().widthProperty().addListener(widthObserver);
        this.registerChangeListener(this.rowFactoryProperty(), "ROW_FACTORY");
        this.registerChangeListener(this.placeholderProperty(), "PLACEHOLDER");
        this.registerChangeListener(((Region)control).widthProperty(), "WIDTH");
        this.registerChangeListener(this.flow.getVbar().visibleProperty(), "VBAR_VISIBLE");
    }

    protected abstract TableSelectionModel<S> getSelectionModel();

    protected abstract TableFocusModel<S, TC> getFocusModel();

    protected abstract TablePositionBase<? extends TC> getFocusedCell();

    protected abstract ObservableList<? extends TC> getVisibleLeafColumns();

    protected abstract int getVisibleLeafIndex(TC var1);

    protected abstract TC getVisibleLeafColumn(int var1);

    protected abstract ObservableList<TC> getColumns();

    protected abstract ObservableList<TC> getSortOrder();

    protected abstract ObjectProperty<ObservableList<S>> itemsProperty();

    protected abstract ObjectProperty<Callback<C, I>> rowFactoryProperty();

    protected abstract ObjectProperty<Node> placeholderProperty();

    protected abstract BooleanProperty tableMenuButtonVisibleProperty();

    protected abstract ObjectProperty<Callback<ResizeFeaturesBase, Boolean>> columnResizePolicyProperty();

    protected abstract boolean resizeColumn(TC var1, double var2);

    protected abstract void resizeColumnToFitContent(TC var1, int var2);

    protected abstract void edit(int var1, TC var2);

    @Override
    protected void handleControlPropertyChanged(String p) {
        super.handleControlPropertyChanged(p);
        if ("ROW_FACTORY".equals(p)) {
            Callback<C, I> oldFactory = this.rowFactory;
            this.rowFactory = (Callback)this.rowFactoryProperty().get();
            if (oldFactory != this.rowFactory) {
                this.needCellsRebuilt = true;
                ((Parent)((Object)this.getSkinnable())).requestLayout();
            }
        } else if ("PLACEHOLDER".equals(p)) {
            this.updatePlaceholderRegionVisibility();
        } else if ("VBAR_VISIBLE".equals(p)) {
            this.updateContentWidth();
        }
    }

    @Override
    public void dispose() {
        this.getVisibleLeafColumns().removeListener(this.weakVisibleLeafColumnsListener);
        this.itemsProperty().removeListener(this.weakItemsChangeListener);
        ((Node)((Object)this.getSkinnable())).getProperties().removeListener(this.propertiesMapListener);
        this.updateTableItems((ObservableList)this.itemsProperty().get(), null);
        super.dispose();
    }

    protected TableHeaderRow createTableHeaderRow() {
        return new TableHeaderRow(this);
    }

    public TableHeaderRow getTableHeaderRow() {
        return this.tableHeaderRow;
    }

    public Region getColumnReorderLine() {
        return this.columnReorderLine;
    }

    public int onScrollPageDown(boolean isFocusDriven) {
        int newSelectionIndex;
        boolean isLeadIndex;
        boolean isSelected;
        TableSelectionModel<S> sm = this.getSelectionModel();
        if (sm == null) {
            return -1;
        }
        int itemCount = this.getItemCount();
        Object lastVisibleCell = this.flow.getLastVisibleCellWithinViewPort();
        if (lastVisibleCell == null) {
            return -1;
        }
        int lastVisibleCellIndex = ((IndexedCell)lastVisibleCell).getIndex();
        int n = lastVisibleCellIndex = lastVisibleCellIndex >= itemCount ? itemCount - 1 : lastVisibleCellIndex;
        if (isFocusDriven) {
            isSelected = ((Node)lastVisibleCell).isFocused() || this.isCellFocused(lastVisibleCellIndex);
        } else {
            boolean bl = isSelected = ((Cell)lastVisibleCell).isSelected() || this.isCellSelected(lastVisibleCellIndex);
        }
        if (isSelected && (isLeadIndex = this.isLeadIndex(isFocusDriven, lastVisibleCellIndex))) {
            this.flow.showAsFirst(lastVisibleCell);
            Object newLastVisibleCell = this.flow.getLastVisibleCellWithinViewPort();
            lastVisibleCell = newLastVisibleCell == null ? lastVisibleCell : newLastVisibleCell;
        }
        newSelectionIndex = (newSelectionIndex = ((IndexedCell)lastVisibleCell).getIndex()) >= itemCount ? itemCount - 1 : newSelectionIndex;
        this.flow.show(newSelectionIndex);
        return newSelectionIndex;
    }

    public int onScrollPageUp(boolean isFocusDriven) {
        boolean isLeadIndex;
        Object firstVisibleCell = this.flow.getFirstVisibleCellWithinViewPort();
        if (firstVisibleCell == null) {
            return -1;
        }
        int firstVisibleCellIndex = ((IndexedCell)firstVisibleCell).getIndex();
        boolean isSelected = false;
        if (isFocusDriven) {
            isSelected = ((Node)firstVisibleCell).isFocused() || this.isCellFocused(firstVisibleCellIndex);
        } else {
            boolean bl = isSelected = ((Cell)firstVisibleCell).isSelected() || this.isCellSelected(firstVisibleCellIndex);
        }
        if (isSelected && (isLeadIndex = this.isLeadIndex(isFocusDriven, firstVisibleCellIndex))) {
            this.flow.showAsLast(firstVisibleCell);
            Object newFirstVisibleCell = this.flow.getFirstVisibleCellWithinViewPort();
            firstVisibleCell = newFirstVisibleCell == null ? firstVisibleCell : newFirstVisibleCell;
        }
        int newSelectionIndex = ((IndexedCell)firstVisibleCell).getIndex();
        this.flow.show(newSelectionIndex);
        return newSelectionIndex;
    }

    private boolean isLeadIndex(boolean isFocusDriven, int index) {
        TableSelectionModel<S> sm = this.getSelectionModel();
        TableFocusModel<S, TC> fm = this.getFocusModel();
        return isFocusDriven && fm.getFocusedIndex() == index || !isFocusDriven && sm.getSelectedIndex() == index;
    }

    boolean isColumnPartiallyOrFullyVisible(TC col) {
        TableColumnBase c;
        if (col == null || !((TableColumnBase)col).isVisible()) {
            return false;
        }
        double scrollX = this.flow.getHbar().getValue();
        double start = 0.0;
        ObservableList<TC> visibleLeafColumns = this.getVisibleLeafColumns();
        int max = visibleLeafColumns.size();
        for (int i = 0; i < max && !(c = (TableColumnBase)visibleLeafColumns.get(i)).equals(col); ++i) {
            start += c.getWidth();
        }
        double end = start + ((TableColumnBase)col).getWidth();
        Insets padding = ((Region)((Object)this.getSkinnable())).getPadding();
        double headerWidth = ((Region)((Object)this.getSkinnable())).getWidth() - padding.getLeft() + padding.getRight();
        return (start >= scrollX || end > scrollX) && (start < headerWidth + scrollX || end <= headerWidth + scrollX);
    }

    protected void horizontalScroll() {
        this.tableHeaderRow.updateScrollX();
    }

    @Override
    protected void updateRowCount() {
        int newCount;
        this.updatePlaceholderRegionVisibility();
        int oldCount = this.itemCount;
        this.itemCount = newCount = this.getItemCount();
        this.flow.setCellCount(newCount);
        if (this.forceCellRecreate) {
            this.needCellsRecreated = true;
            this.forceCellRecreate = false;
        } else if (newCount != oldCount) {
            this.needCellsRebuilt = true;
        } else {
            this.needCellsReconfigured = true;
        }
    }

    protected void onFocusPreviousCell() {
        TableFocusModel<S, TC> fm = this.getFocusModel();
        if (fm == null) {
            return;
        }
        this.flow.show(fm.getFocusedIndex());
    }

    protected void onFocusNextCell() {
        TableFocusModel<S, TC> fm = this.getFocusModel();
        if (fm == null) {
            return;
        }
        this.flow.show(fm.getFocusedIndex());
    }

    protected void onSelectPreviousCell() {
        TableSelectionModel<S> sm = this.getSelectionModel();
        if (sm == null) {
            return;
        }
        this.flow.show(sm.getSelectedIndex());
    }

    protected void onSelectNextCell() {
        TableSelectionModel<S> sm = this.getSelectionModel();
        if (sm == null) {
            return;
        }
        this.flow.show(sm.getSelectedIndex());
    }

    protected void onSelectLeftCell() {
        this.scrollHorizontally();
    }

    protected void onSelectRightCell() {
        this.scrollHorizontally();
    }

    protected void onMoveToFirstCell() {
        this.flow.show(0);
        this.flow.setPosition(0.0);
    }

    protected void onMoveToLastCell() {
        int endPos = this.getItemCount();
        this.flow.show(endPos);
        this.flow.setPosition(1.0);
    }

    public void updateTableItems(ObservableList<S> oldList, ObservableList<S> newList) {
        if (oldList != null) {
            oldList.removeListener(this.weakRowCountListener);
        }
        if (newList != null) {
            newList.addListener(this.weakRowCountListener);
        }
        this.rowCountDirty = true;
        ((Parent)((Object)this.getSkinnable())).requestLayout();
    }

    private void checkContentWidthState() {
        if (this.contentWidthDirty || this.getItemCount() == 0) {
            this.updateContentWidth();
            this.contentWidthDirty = false;
        }
    }

    @Override
    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return 400.0;
    }

    @Override
    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        double prefHeight = this.computePrefHeight(-1.0, topInset, rightInset, bottomInset, leftInset);
        ObservableList<TC> cols = this.getVisibleLeafColumns();
        if (cols == null || cols.isEmpty()) {
            return prefHeight * 0.618033987;
        }
        double pw = leftInset + rightInset;
        int max = cols.size();
        for (int i = 0; i < max; ++i) {
            TableColumnBase tc = (TableColumnBase)cols.get(i);
            pw += Math.max(tc.getPrefWidth(), tc.getMinWidth());
        }
        return Math.max(pw, prefHeight * 0.618033987);
    }

    @Override
    protected void layoutChildren(double x, double y, double w, double h) {
        Skinnable table = this.getSkinnable();
        if (table == null) {
            return;
        }
        super.layoutChildren(x, y, w, h);
        if (this.needCellsRecreated) {
            this.flow.recreateCells();
        } else if (this.needCellsRebuilt) {
            this.flow.rebuildCells();
        } else if (this.needCellsReconfigured) {
            this.flow.reconfigureCells();
        }
        this.needCellsRebuilt = false;
        this.needCellsRecreated = false;
        this.needCellsReconfigured = false;
        double baselineOffset = ((Node)((Object)table)).getLayoutBounds().getHeight() / 2.0;
        double tableHeaderRowHeight = this.tableHeaderRow.prefHeight(-1.0);
        this.layoutInArea(this.tableHeaderRow, x, y, w, tableHeaderRowHeight, baselineOffset, HPos.CENTER, VPos.CENTER);
        y += tableHeaderRowHeight;
        double flowHeight = Math.floor(h - tableHeaderRowHeight);
        if (this.getItemCount() == 0 || this.visibleColCount == 0) {
            this.layoutInArea(this.placeholderRegion, x, y, w, flowHeight, baselineOffset, HPos.CENTER, VPos.CENTER);
        } else {
            this.layoutInArea(this.flow, x, y, w, flowHeight, baselineOffset, HPos.CENTER, VPos.CENTER);
        }
        if (this.tableHeaderRow.getReorderingRegion() != null) {
            TableColumnHeader reorderingColumnHeader = this.tableHeaderRow.getReorderingRegion();
            TableColumnBase reorderingColumn = reorderingColumnHeader.getTableColumn();
            if (reorderingColumn != null) {
                TableColumnHeader n = this.tableHeaderRow.getReorderingRegion();
                double minX = this.tableHeaderRow.sceneToLocal(n.localToScene(n.getBoundsInLocal())).getMinX();
                double overlayWidth = reorderingColumnHeader.getWidth();
                if (minX < 0.0) {
                    overlayWidth += minX;
                }
                double d = minX = minX < 0.0 ? 0.0 : minX;
                if (minX + overlayWidth > w) {
                    overlayWidth = w - minX;
                    if (this.flow.getVbar().isVisible()) {
                        overlayWidth -= this.flow.getVbar().getWidth() - 1.0;
                    }
                }
                double contentAreaHeight = flowHeight;
                if (this.flow.getHbar().isVisible()) {
                    contentAreaHeight -= this.flow.getHbar().getHeight();
                }
                this.columnReorderOverlay.resize(overlayWidth, contentAreaHeight);
                this.columnReorderOverlay.setLayoutX(minX);
                this.columnReorderOverlay.setLayoutY(this.tableHeaderRow.getHeight());
            }
            double cw = this.columnReorderLine.snappedLeftInset() + this.columnReorderLine.snappedRightInset();
            double lineHeight = h - (this.flow.getHbar().isVisible() ? this.flow.getHbar().getHeight() - 1.0 : 0.0);
            this.columnReorderLine.resizeRelocate(0.0, this.columnReorderLine.snappedTopInset(), cw, lineHeight);
        }
        this.columnReorderLine.setVisible(this.tableHeaderRow.isReordering());
        this.columnReorderOverlay.setVisible(this.tableHeaderRow.isReordering());
        this.checkContentWidthState();
    }

    private void updateVisibleColumnCount() {
        this.visibleColCount = this.getVisibleLeafColumns().size();
        this.updatePlaceholderRegionVisibility();
        this.needCellsRebuilt = true;
        ((Parent)((Object)this.getSkinnable())).requestLayout();
    }

    private void updateVisibleLeafColumnWidthListeners(List<? extends TC> added, List<? extends TC> removed) {
        TableColumnBase tc;
        int i;
        int max = removed.size();
        for (i = 0; i < max; ++i) {
            tc = (TableColumnBase)removed.get(i);
            tc.widthProperty().removeListener(this.weakWidthListener);
        }
        max = added.size();
        for (i = 0; i < max; ++i) {
            tc = (TableColumnBase)added.get(i);
            tc.widthProperty().addListener(this.weakWidthListener);
        }
        this.needCellsRebuilt = true;
        ((Parent)((Object)this.getSkinnable())).requestLayout();
    }

    protected final void updatePlaceholderRegionVisibility() {
        boolean visible;
        boolean bl = visible = this.visibleColCount == 0 || this.getItemCount() == 0;
        if (visible) {
            Node placeholderNode;
            if (this.placeholderRegion == null) {
                this.placeholderRegion = new StackPane();
                this.placeholderRegion.getStyleClass().setAll((String[])new String[]{"placeholder"});
                this.getChildren().add(this.placeholderRegion);
            }
            if ((placeholderNode = (Node)this.placeholderProperty().get()) == null) {
                if (this.placeholderLabel == null) {
                    this.placeholderLabel = new Label();
                }
                String s = this.visibleColCount == 0 ? NO_COLUMNS_TEXT : EMPTY_TABLE_TEXT;
                this.placeholderLabel.setText(s);
                this.placeholderRegion.getChildren().setAll((Node[])new Node[]{this.placeholderLabel});
            } else {
                this.placeholderRegion.getChildren().setAll((Node[])new Node[]{placeholderNode});
            }
        }
        this.flow.setVisible(!visible);
        if (this.placeholderRegion != null) {
            this.placeholderRegion.setVisible(visible);
        }
    }

    private void updateContentWidth() {
        double contentWidth = this.flow.getWidth();
        if (this.flow.getVbar().isVisible()) {
            contentWidth -= this.flow.getVbar().getWidth();
        }
        if (contentWidth <= 0.0) {
            Skinnable c = this.getSkinnable();
            contentWidth = ((Region)((Object)c)).getWidth() - (this.snappedLeftInset() + this.snappedRightInset());
        }
        contentWidth = Math.max(0.0, contentWidth);
        ((Node)((Object)this.getSkinnable())).getProperties().put("TableView.contentWidth", Math.floor(contentWidth));
    }

    private void refreshView() {
        this.rowCountDirty = true;
        Skinnable c = this.getSkinnable();
        if (c != null) {
            ((Parent)((Object)c)).requestLayout();
        }
    }

    protected void scrollHorizontally() {
        TableFocusModel<S, TC> fm = this.getFocusModel();
        if (fm == null) {
            return;
        }
        TC col = this.getFocusedCell().getTableColumn();
        this.scrollHorizontally(col);
    }

    protected void scrollHorizontally(TC col) {
        double newPos;
        TableColumnBase c;
        if (col == null || !((TableColumnBase)col).isVisible()) {
            return;
        }
        Skinnable control = this.getSkinnable();
        TableColumnHeader header = this.tableHeaderRow.getColumnHeaderFor((TableColumnBase<?, ?>)col);
        if (header == null || header.getWidth() <= 0.0) {
            Platform.runLater(() -> this.scrollHorizontally(col));
            return;
        }
        double start = 0.0;
        Iterator iterator = this.getVisibleLeafColumns().iterator();
        while (iterator.hasNext() && !(c = (TableColumnBase)iterator.next()).equals(col)) {
            start += c.getWidth();
        }
        double end = start + ((TableColumnBase)col).getWidth();
        double headerWidth = ((Region)((Object)control)).getWidth() - this.snappedLeftInset() - this.snappedRightInset();
        double pos = this.flow.getHbar().getValue();
        double max = this.flow.getHbar().getMax();
        if (start < pos && start >= 0.0) {
            newPos = start;
        } else {
            double delta = start < 0.0 || end > headerWidth ? start - pos : 0.0;
            newPos = pos + delta > max ? max : pos + delta;
        }
        this.flow.getHbar().setValue(newPos);
    }

    private boolean isCellSelected(int row) {
        TableSelectionModel<S> sm = this.getSelectionModel();
        if (sm == null) {
            return false;
        }
        if (!sm.isCellSelectionEnabled()) {
            return false;
        }
        int columnCount = this.getVisibleLeafColumns().size();
        for (int col = 0; col < columnCount; ++col) {
            if (!sm.isSelected(row, (TableColumnBase<S, ?>)this.getVisibleLeafColumn(col))) continue;
            return true;
        }
        return false;
    }

    private boolean isCellFocused(int row) {
        TableFocusModel<S, TC> fm = this.getFocusModel();
        if (fm == null) {
            return false;
        }
        int columnCount = this.getVisibleLeafColumns().size();
        for (int col = 0; col < columnCount; ++col) {
            if (!fm.isFocused(row, this.getVisibleLeafColumn(col))) continue;
            return true;
        }
        return false;
    }

    @Override
    protected Object queryAccessibleAttribute(AccessibleAttribute attribute, Object ... parameters) {
        switch (attribute) {
            case FOCUS_ITEM: {
                TableFocusModel<S, TC> fm = this.getFocusModel();
                int focusedIndex = fm.getFocusedIndex();
                if (focusedIndex == -1) {
                    if (this.placeholderRegion != null && this.placeholderRegion.isVisible()) {
                        return this.placeholderRegion.getChildren().get(0);
                    }
                    if (this.getItemCount() > 0) {
                        focusedIndex = 0;
                    } else {
                        return null;
                    }
                }
                return this.flow.getPrivateCell(focusedIndex);
            }
            case CELL_AT_ROW_COLUMN: {
                int rowIndex = (Integer)parameters[0];
                return this.flow.getPrivateCell(rowIndex);
            }
            case COLUMN_AT_INDEX: {
                int index = (Integer)parameters[0];
                TC column = this.getVisibleLeafColumn(index);
                return this.getTableHeaderRow().getColumnHeaderFor((TableColumnBase<?, ?>)column);
            }
            case HEADER: {
                return this.getTableHeaderRow();
            }
            case VERTICAL_SCROLLBAR: {
                return this.flow.getVbar();
            }
            case HORIZONTAL_SCROLLBAR: {
                return this.flow.getHbar();
            }
        }
        return super.queryAccessibleAttribute(attribute, parameters);
    }
}

