/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.behavior;

import com.sun.javafx.scene.control.behavior.OptionalBoolean;
import com.sun.javafx.tk.Toolkit;
import com.sun.javafx.util.Utils;
import javafx.event.EventType;
import javafx.scene.control.Control;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;

public class KeyBinding {
    private KeyCode code;
    private EventType<KeyEvent> eventType = KeyEvent.KEY_PRESSED;
    private String action;
    private OptionalBoolean shift = OptionalBoolean.FALSE;
    private OptionalBoolean ctrl = OptionalBoolean.FALSE;
    private OptionalBoolean alt = OptionalBoolean.FALSE;
    private OptionalBoolean meta = OptionalBoolean.FALSE;

    public KeyBinding(KeyCode code, String action) {
        this.code = code;
        this.action = action;
    }

    public KeyBinding(KeyCode code, EventType<KeyEvent> type, String action) {
        this.code = code;
        this.eventType = type;
        this.action = action;
    }

    public KeyBinding shift() {
        return this.shift(OptionalBoolean.TRUE);
    }

    public KeyBinding shift(OptionalBoolean value) {
        this.shift = value;
        return this;
    }

    public KeyBinding ctrl() {
        return this.ctrl(OptionalBoolean.TRUE);
    }

    public KeyBinding ctrl(OptionalBoolean value) {
        this.ctrl = value;
        return this;
    }

    public KeyBinding alt() {
        return this.alt(OptionalBoolean.TRUE);
    }

    public KeyBinding alt(OptionalBoolean value) {
        this.alt = value;
        return this;
    }

    public KeyBinding meta() {
        return this.meta(OptionalBoolean.TRUE);
    }

    public KeyBinding meta(OptionalBoolean value) {
        this.meta = value;
        return this;
    }

    public KeyBinding shortcut() {
        if (Toolkit.getToolkit().getClass().getName().endsWith("StubToolkit")) {
            if (Utils.isMac()) {
                return this.meta();
            }
            return this.ctrl();
        }
        switch (Toolkit.getToolkit().getPlatformShortcutKey()) {
            case SHIFT: {
                return this.shift();
            }
            case CONTROL: {
                return this.ctrl();
            }
            case ALT: {
                return this.alt();
            }
            case META: {
                return this.meta();
            }
        }
        return this;
    }

    public final KeyCode getCode() {
        return this.code;
    }

    public final EventType<KeyEvent> getType() {
        return this.eventType;
    }

    public final String getAction() {
        return this.action;
    }

    public final OptionalBoolean getShift() {
        return this.shift;
    }

    public final OptionalBoolean getCtrl() {
        return this.ctrl;
    }

    public final OptionalBoolean getAlt() {
        return this.alt;
    }

    public final OptionalBoolean getMeta() {
        return this.meta;
    }

    public int getSpecificity(Control control, KeyEvent event) {
        int s = 0;
        if (this.code != null && this.code != event.getCode()) {
            return 0;
        }
        s = 1;
        if (!this.shift.equals(event.isShiftDown())) {
            return 0;
        }
        if (this.shift != OptionalBoolean.ANY) {
            ++s;
        }
        if (!this.ctrl.equals(event.isControlDown())) {
            return 0;
        }
        if (this.ctrl != OptionalBoolean.ANY) {
            ++s;
        }
        if (!this.alt.equals(event.isAltDown())) {
            return 0;
        }
        if (this.alt != OptionalBoolean.ANY) {
            ++s;
        }
        if (!this.meta.equals(event.isMetaDown())) {
            return 0;
        }
        if (this.meta != OptionalBoolean.ANY) {
            ++s;
        }
        if (this.eventType != null && this.eventType != event.getEventType()) {
            return 0;
        }
        return ++s;
    }

    public String toString() {
        return "KeyBinding [code=" + (Object)((Object)this.code) + ", shift=" + (Object)((Object)this.shift) + ", ctrl=" + (Object)((Object)this.ctrl) + ", alt=" + (Object)((Object)this.alt) + ", meta=" + (Object)((Object)this.meta) + ", type=" + this.eventType + ", action=" + this.action + "]";
    }
}

