/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.CipherCore;
import com.sun.crypto.provider.ConstructKeys;
import com.sun.crypto.provider.DESCrypt;
import com.sun.crypto.provider.DESedeCrypt;
import com.sun.crypto.provider.SunJCE;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.SecretKeySpec;

final class PBES1Core {
    private CipherCore cipher;
    private MessageDigest md;
    private int blkSize;
    private String algo = null;
    private byte[] salt = null;
    private int iCount = 10;

    PBES1Core(String cipherAlg) throws NoSuchAlgorithmException, NoSuchPaddingException {
        this.algo = cipherAlg;
        if (this.algo.equals("DES")) {
            this.cipher = new CipherCore(new DESCrypt(), 8);
        } else if (this.algo.equals("DESede")) {
            this.cipher = new CipherCore(new DESedeCrypt(), 8);
        } else {
            throw new NoSuchAlgorithmException("No Cipher implementation for PBEWithMD5And" + this.algo);
        }
        this.cipher.setMode("CBC");
        this.cipher.setPadding("PKCS5Padding");
        this.md = MessageDigest.getInstance("MD5");
    }

    void setMode(String mode) throws NoSuchAlgorithmException {
        this.cipher.setMode(mode);
    }

    void setPadding(String paddingScheme) throws NoSuchPaddingException {
        this.cipher.setPadding(paddingScheme);
    }

    int getBlockSize() {
        return 8;
    }

    int getOutputSize(int inputLen) {
        return this.cipher.getOutputSize(inputLen);
    }

    byte[] getIV() {
        return this.cipher.getIV();
    }

    AlgorithmParameters getParameters() {
        AlgorithmParameters params = null;
        if (this.salt == null) {
            this.salt = new byte[8];
            SunJCE.getRandom().nextBytes(this.salt);
        }
        PBEParameterSpec pbeSpec = new PBEParameterSpec(this.salt, this.iCount);
        try {
            params = AlgorithmParameters.getInstance("PBEWithMD5And" + (this.algo.equalsIgnoreCase("DES") ? "DES" : "TripleDES"), SunJCE.getInstance());
            params.init(pbeSpec);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new RuntimeException("SunJCE called, but not configured");
        }
        catch (InvalidParameterSpecException ipse) {
            throw new RuntimeException("PBEParameterSpec not supported");
        }
        return params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void init(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        byte[] derivedKey;
        if ((opmode == 2 || opmode == 4) && params == null) {
            throw new InvalidAlgorithmParameterException("Parameters missing");
        }
        if (key == null) {
            throw new InvalidKeyException("Null key");
        }
        byte[] passwdBytes = key.getEncoded();
        try {
            if (passwdBytes == null || !key.getAlgorithm().regionMatches(true, 0, "PBE", 0, 3)) {
                throw new InvalidKeyException("Missing password");
            }
            if (params == null) {
                this.salt = new byte[8];
                random.nextBytes(this.salt);
            } else {
                if (!(params instanceof PBEParameterSpec)) {
                    throw new InvalidAlgorithmParameterException("Wrong parameter type: PBE expected");
                }
                this.salt = ((PBEParameterSpec)params).getSalt();
                if (this.salt.length != 8) {
                    throw new InvalidAlgorithmParameterException("Salt must be 8 bytes long");
                }
                this.iCount = ((PBEParameterSpec)params).getIterationCount();
                if (this.iCount <= 0) {
                    throw new InvalidAlgorithmParameterException("IterationCount must be a positive number");
                }
            }
            derivedKey = this.deriveCipherKey(passwdBytes);
        }
        finally {
            if (passwdBytes != null) {
                Arrays.fill(passwdBytes, (byte)0);
            }
        }
        SecretKeySpec cipherKey = new SecretKeySpec(derivedKey, 0, derivedKey.length - 8, this.algo);
        IvParameterSpec ivSpec = new IvParameterSpec(derivedKey, derivedKey.length - 8, 8);
        this.cipher.init(opmode, (Key)cipherKey, ivSpec, random);
    }

    private byte[] deriveCipherKey(byte[] passwdBytes) {
        byte[] result = null;
        if (this.algo.equals("DES")) {
            byte[] concat = new byte[Math.addExact(passwdBytes.length, this.salt.length)];
            System.arraycopy(passwdBytes, 0, concat, 0, passwdBytes.length);
            System.arraycopy(this.salt, 0, concat, passwdBytes.length, this.salt.length);
            byte[] toBeHashed = concat;
            for (int i = 0; i < this.iCount; ++i) {
                this.md.update(toBeHashed);
                toBeHashed = this.md.digest();
            }
            Arrays.fill(concat, (byte)0);
            result = toBeHashed;
        } else if (this.algo.equals("DESede")) {
            int i;
            for (i = 0; i < 4 && this.salt[i] == this.salt[i + 4]; ++i) {
            }
            if (i == 4) {
                for (i = 0; i < 2; ++i) {
                    byte tmp = this.salt[i];
                    this.salt[i] = this.salt[3 - i];
                    this.salt[3 - i] = tmp;
                }
            }
            byte[] toBeHashed = null;
            result = new byte[32];
            for (i = 0; i < 2; ++i) {
                toBeHashed = new byte[this.salt.length / 2];
                System.arraycopy(this.salt, i * (this.salt.length / 2), toBeHashed, 0, toBeHashed.length);
                for (int j = 0; j < this.iCount; ++j) {
                    this.md.update(toBeHashed);
                    this.md.update(passwdBytes);
                    toBeHashed = this.md.digest();
                }
                System.arraycopy(toBeHashed, 0, result, i * 16, toBeHashed.length);
            }
        }
        this.md.reset();
        return result;
    }

    void init(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        PBEParameterSpec pbeSpec = null;
        if (params != null) {
            try {
                pbeSpec = params.getParameterSpec(PBEParameterSpec.class);
            }
            catch (InvalidParameterSpecException ipse) {
                throw new InvalidAlgorithmParameterException("Wrong parameter type: PBE expected");
            }
        }
        this.init(opmode, key, pbeSpec, random);
    }

    byte[] update(byte[] input, int inputOffset, int inputLen) {
        return this.cipher.update(input, inputOffset, inputLen);
    }

    int update(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        return this.cipher.update(input, inputOffset, inputLen, output, outputOffset);
    }

    byte[] doFinal(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        return this.cipher.doFinal(input, inputOffset, inputLen);
    }

    int doFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        return this.cipher.doFinal(input, inputOffset, inputLen, output, outputOffset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] wrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        byte[] result = null;
        byte[] encodedKey = null;
        try {
            encodedKey = key.getEncoded();
            if (encodedKey == null || encodedKey.length == 0) {
                throw new InvalidKeyException("Cannot get an encoding of the key to be wrapped");
            }
            result = this.doFinal(encodedKey, 0, encodedKey.length);
        }
        catch (BadPaddingException badPaddingException) {
        }
        finally {
            if (encodedKey != null) {
                Arrays.fill(encodedKey, (byte)0);
            }
        }
        return result;
    }

    Key unwrap(byte[] wrappedKey, String wrappedKeyAlgorithm, int wrappedKeyType) throws InvalidKeyException, NoSuchAlgorithmException {
        byte[] encodedKey;
        try {
            encodedKey = this.doFinal(wrappedKey, 0, wrappedKey.length);
        }
        catch (BadPaddingException ePadding) {
            throw new InvalidKeyException("The wrapped key is not padded correctly");
        }
        catch (IllegalBlockSizeException eBlockSize) {
            throw new InvalidKeyException("The wrapped key does not have the correct length");
        }
        return ConstructKeys.constructKey(encodedKey, wrappedKeyAlgorithm, wrappedKeyType);
    }
}

