/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.FilePermission;
import java.io.IOException;
import java.net.URI;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessDeniedException;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.LinkOption;
import java.nio.file.LinkPermission;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.ProviderMismatchException;
import java.nio.file.attribute.AclFileAttributeView;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileOwnerAttributeView;
import java.nio.file.attribute.UserDefinedFileAttributeView;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import sun.misc.Unsafe;
import sun.nio.ch.ThreadPool;
import sun.nio.fs.AbstractFileSystemProvider;
import sun.nio.fs.DynamicFileAttributeView;
import sun.nio.fs.FileOwnerAttributeViewImpl;
import sun.nio.fs.NativeBuffer;
import sun.nio.fs.Util;
import sun.nio.fs.WindowsAclFileAttributeView;
import sun.nio.fs.WindowsChannelFactory;
import sun.nio.fs.WindowsDirectoryStream;
import sun.nio.fs.WindowsException;
import sun.nio.fs.WindowsFileAttributeViews;
import sun.nio.fs.WindowsFileAttributes;
import sun.nio.fs.WindowsFileCopy;
import sun.nio.fs.WindowsFileStore;
import sun.nio.fs.WindowsFileSystem;
import sun.nio.fs.WindowsLinkSupport;
import sun.nio.fs.WindowsNativeDispatcher;
import sun.nio.fs.WindowsPath;
import sun.nio.fs.WindowsPathType;
import sun.nio.fs.WindowsSecurity;
import sun.nio.fs.WindowsSecurityDescriptor;
import sun.nio.fs.WindowsUriSupport;
import sun.nio.fs.WindowsUserDefinedFileAttributeView;

public class WindowsFileSystemProvider
extends AbstractFileSystemProvider {
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private static final String USER_DIR = "user.dir";
    private final WindowsFileSystem theFileSystem = new WindowsFileSystem(this, System.getProperty("user.dir"));

    @Override
    public String getScheme() {
        return "file";
    }

    private void checkUri(URI uri) {
        if (!uri.getScheme().equalsIgnoreCase(this.getScheme())) {
            throw new IllegalArgumentException("URI does not match this provider");
        }
        if (uri.getAuthority() != null) {
            throw new IllegalArgumentException("Authority component present");
        }
        if (uri.getPath() == null) {
            throw new IllegalArgumentException("Path component is undefined");
        }
        if (!uri.getPath().equals("/")) {
            throw new IllegalArgumentException("Path component should be '/'");
        }
        if (uri.getQuery() != null) {
            throw new IllegalArgumentException("Query component present");
        }
        if (uri.getFragment() != null) {
            throw new IllegalArgumentException("Fragment component present");
        }
    }

    @Override
    public FileSystem newFileSystem(URI uri, Map<String, ?> env) throws IOException {
        this.checkUri(uri);
        throw new FileSystemAlreadyExistsException();
    }

    @Override
    public final FileSystem getFileSystem(URI uri) {
        this.checkUri(uri);
        return this.theFileSystem;
    }

    @Override
    public Path getPath(URI uri) {
        return WindowsUriSupport.fromUri(this.theFileSystem, uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileChannel newFileChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        if (path == null) {
            throw new NullPointerException();
        }
        if (!(path instanceof WindowsPath)) {
            throw new ProviderMismatchException();
        }
        WindowsPath file = (WindowsPath)path;
        WindowsSecurityDescriptor sd = WindowsSecurityDescriptor.fromAttribute(attrs);
        try {
            FileChannel fileChannel = WindowsChannelFactory.newFileChannel(file.getPathForWin32Calls(), file.getPathForPermissionCheck(), options, sd.address());
            return fileChannel;
        }
        catch (WindowsException x) {
            x.rethrowAsIOException(file);
            FileChannel fileChannel = null;
            return fileChannel;
        }
        finally {
            if (sd != null) {
                sd.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AsynchronousFileChannel newAsynchronousFileChannel(Path path, Set<? extends OpenOption> options, ExecutorService executor, FileAttribute<?> ... attrs) throws IOException {
        if (path == null) {
            throw new NullPointerException();
        }
        if (!(path instanceof WindowsPath)) {
            throw new ProviderMismatchException();
        }
        WindowsPath file = (WindowsPath)path;
        ThreadPool pool = executor == null ? null : ThreadPool.wrap(executor, 0);
        WindowsSecurityDescriptor sd = WindowsSecurityDescriptor.fromAttribute(attrs);
        try {
            AsynchronousFileChannel asynchronousFileChannel = WindowsChannelFactory.newAsynchronousFileChannel(file.getPathForWin32Calls(), file.getPathForPermissionCheck(), options, sd.address(), pool);
            return asynchronousFileChannel;
        }
        catch (WindowsException x) {
            x.rethrowAsIOException(file);
            AsynchronousFileChannel asynchronousFileChannel = null;
            return asynchronousFileChannel;
        }
        finally {
            if (sd != null) {
                sd.release();
            }
        }
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Path obj, Class<V> view, LinkOption ... options) {
        WindowsPath file = WindowsPath.toWindowsPath(obj);
        if (view == null) {
            throw new NullPointerException();
        }
        boolean followLinks = Util.followLinks(options);
        if (view == BasicFileAttributeView.class) {
            return (V)WindowsFileAttributeViews.createBasicView(file, followLinks);
        }
        if (view == DosFileAttributeView.class) {
            return (V)WindowsFileAttributeViews.createDosView(file, followLinks);
        }
        if (view == AclFileAttributeView.class) {
            return (V)new WindowsAclFileAttributeView(file, followLinks);
        }
        if (view == FileOwnerAttributeView.class) {
            return (V)new FileOwnerAttributeViewImpl(new WindowsAclFileAttributeView(file, followLinks));
        }
        if (view == UserDefinedFileAttributeView.class) {
            return (V)new WindowsUserDefinedFileAttributeView(file, followLinks);
        }
        return (V)((FileAttributeView)null);
    }

    @Override
    public <A extends BasicFileAttributes> A readAttributes(Path file, Class<A> type, LinkOption ... options) throws IOException {
        Class<BasicFileAttributeView> view;
        if (type == BasicFileAttributes.class) {
            view = BasicFileAttributeView.class;
        } else if (type == DosFileAttributes.class) {
            view = DosFileAttributeView.class;
        } else {
            if (type == null) {
                throw new NullPointerException();
            }
            throw new UnsupportedOperationException();
        }
        return (A)this.getFileAttributeView(file, view, options).readAttributes();
    }

    @Override
    public DynamicFileAttributeView getFileAttributeView(Path obj, String name, LinkOption ... options) {
        WindowsPath file = WindowsPath.toWindowsPath(obj);
        boolean followLinks = Util.followLinks(options);
        if (name.equals("basic")) {
            return WindowsFileAttributeViews.createBasicView(file, followLinks);
        }
        if (name.equals("dos")) {
            return WindowsFileAttributeViews.createDosView(file, followLinks);
        }
        if (name.equals("acl")) {
            return new WindowsAclFileAttributeView(file, followLinks);
        }
        if (name.equals("owner")) {
            return new FileOwnerAttributeViewImpl(new WindowsAclFileAttributeView(file, followLinks));
        }
        if (name.equals("user")) {
            return new WindowsUserDefinedFileAttributeView(file, followLinks);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SeekableByteChannel newByteChannel(Path obj, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        WindowsPath file = WindowsPath.toWindowsPath(obj);
        WindowsSecurityDescriptor sd = WindowsSecurityDescriptor.fromAttribute(attrs);
        try {
            FileChannel fileChannel = WindowsChannelFactory.newFileChannel(file.getPathForWin32Calls(), file.getPathForPermissionCheck(), options, sd.address());
            return fileChannel;
        }
        catch (WindowsException x) {
            x.rethrowAsIOException(file);
            SeekableByteChannel seekableByteChannel = null;
            return seekableByteChannel;
        }
        finally {
            sd.release();
        }
    }

    @Override
    boolean implDelete(Path obj, boolean failIfNotExists) throws IOException {
        WindowsPath file = WindowsPath.toWindowsPath(obj);
        file.checkDelete();
        WindowsFileAttributes attrs = null;
        try {
            attrs = WindowsFileAttributes.get(file, false);
            if (attrs.isDirectory() || attrs.isDirectoryLink()) {
                WindowsNativeDispatcher.RemoveDirectory(file.getPathForWin32Calls());
            } else {
                WindowsNativeDispatcher.DeleteFile(file.getPathForWin32Calls());
            }
            return true;
        }
        catch (WindowsException x) {
            if (!(failIfNotExists || x.lastError() != 2 && x.lastError() != 3)) {
                return false;
            }
            if (attrs != null && attrs.isDirectory() && (x.lastError() == 145 || x.lastError() == 183)) {
                throw new DirectoryNotEmptyException(file.getPathForExceptionMessage());
            }
            x.rethrowAsIOException(file);
            return false;
        }
    }

    @Override
    public void copy(Path source, Path target, CopyOption ... options) throws IOException {
        WindowsFileCopy.copy(WindowsPath.toWindowsPath(source), WindowsPath.toWindowsPath(target), options);
    }

    @Override
    public void move(Path source, Path target, CopyOption ... options) throws IOException {
        WindowsFileCopy.move(WindowsPath.toWindowsPath(source), WindowsPath.toWindowsPath(target), options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean hasDesiredAccess(WindowsPath file, int rights) throws IOException {
        boolean hasRights = false;
        String target = WindowsLinkSupport.getFinalPath(file, true);
        NativeBuffer aclBuffer = WindowsAclFileAttributeView.getFileSecurity(target, 7);
        try {
            hasRights = WindowsSecurity.checkAccessMask(aclBuffer.address(), rights, 1179785, 1179926, 1179808, 0x1F01FF);
        }
        catch (WindowsException exc) {
            exc.rethrowAsIOException(file);
        }
        finally {
            aclBuffer.release();
        }
        return hasRights;
    }

    private void checkReadAccess(WindowsPath file) throws IOException {
        try {
            Set opts = Collections.emptySet();
            FileChannel fc = WindowsChannelFactory.newFileChannel(file.getPathForWin32Calls(), file.getPathForPermissionCheck(), opts, 0L);
            fc.close();
        }
        catch (WindowsException exc) {
            try {
                new WindowsDirectoryStream(file, null).close();
            }
            catch (IOException ioe) {
                exc.rethrowAsIOException(file);
            }
        }
    }

    @Override
    public void checkAccess(Path obj, AccessMode ... modes) throws IOException {
        WindowsPath file = WindowsPath.toWindowsPath(obj);
        boolean r = false;
        boolean w = false;
        boolean x = false;
        block7: for (AccessMode mode : modes) {
            switch (mode) {
                case READ: {
                    r = true;
                    continue block7;
                }
                case WRITE: {
                    w = true;
                    continue block7;
                }
                case EXECUTE: {
                    x = true;
                    continue block7;
                }
                default: {
                    throw new AssertionError((Object)"Should not get here");
                }
            }
        }
        if (!w && !x) {
            this.checkReadAccess(file);
            return;
        }
        int mask = 0;
        if (r) {
            file.checkRead();
            mask |= 1;
        }
        if (w) {
            file.checkWrite();
            mask |= 2;
        }
        if (x) {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkExec(file.getPathForPermissionCheck());
            }
            mask |= 0x20;
        }
        if (!WindowsFileSystemProvider.hasDesiredAccess(file, mask)) {
            throw new AccessDeniedException(file.getPathForExceptionMessage(), null, "Permissions does not allow requested access");
        }
        if (w) {
            try {
                WindowsFileAttributes attrs = WindowsFileAttributes.get(file, true);
                if (!attrs.isDirectory() && attrs.isReadOnly()) {
                    throw new AccessDeniedException(file.getPathForExceptionMessage(), null, "DOS readonly attribute is set");
                }
            }
            catch (WindowsException exc) {
                exc.rethrowAsIOException(file);
            }
            if (WindowsFileStore.create(file).isReadOnly()) {
                throw new AccessDeniedException(file.getPathForExceptionMessage(), null, "Read-only file system");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSameFile(Path obj1, Path obj2) throws IOException {
        WindowsPath file1 = WindowsPath.toWindowsPath(obj1);
        if (file1.equals(obj2)) {
            return true;
        }
        if (obj2 == null) {
            throw new NullPointerException();
        }
        if (!(obj2 instanceof WindowsPath)) {
            return false;
        }
        WindowsPath file2 = (WindowsPath)obj2;
        file1.checkRead();
        file2.checkRead();
        long h1 = 0L;
        try {
            h1 = file1.openForReadAttributeAccess(true);
        }
        catch (WindowsException x) {
            x.rethrowAsIOException(file1);
        }
        try {
            boolean bl;
            WindowsFileAttributes attrs1 = null;
            try {
                attrs1 = WindowsFileAttributes.readAttributes(h1);
            }
            catch (WindowsException x) {
                x.rethrowAsIOException(file1);
            }
            long h2 = 0L;
            try {
                h2 = file2.openForReadAttributeAccess(true);
            }
            catch (WindowsException x) {
                x.rethrowAsIOException(file2);
            }
            try {
                WindowsFileAttributes attrs2 = null;
                try {
                    attrs2 = WindowsFileAttributes.readAttributes(h2);
                }
                catch (WindowsException x) {
                    x.rethrowAsIOException(file2);
                }
                bl = WindowsFileAttributes.isSameFile(attrs1, attrs2);
            }
            catch (Throwable throwable) {
                WindowsNativeDispatcher.CloseHandle(h2);
                throw throwable;
            }
            WindowsNativeDispatcher.CloseHandle(h2);
            return bl;
        }
        finally {
            WindowsNativeDispatcher.CloseHandle(h1);
        }
    }

    @Override
    public boolean isHidden(Path obj) throws IOException {
        WindowsPath file = WindowsPath.toWindowsPath(obj);
        file.checkRead();
        WindowsFileAttributes attrs = null;
        try {
            attrs = WindowsFileAttributes.get(file, true);
        }
        catch (WindowsException x) {
            x.rethrowAsIOException(file);
        }
        if (attrs.isDirectory()) {
            return false;
        }
        return attrs.isHidden();
    }

    @Override
    public FileStore getFileStore(Path obj) throws IOException {
        WindowsPath file = WindowsPath.toWindowsPath(obj);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("getFileStoreAttributes"));
            file.checkRead();
        }
        return WindowsFileStore.create(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createDirectory(Path obj, FileAttribute<?> ... attrs) throws IOException {
        WindowsPath dir = WindowsPath.toWindowsPath(obj);
        dir.checkWrite();
        WindowsSecurityDescriptor sd = WindowsSecurityDescriptor.fromAttribute(attrs);
        try {
            WindowsNativeDispatcher.CreateDirectory(dir.getPathForWin32Calls(), sd.address());
        }
        catch (WindowsException x) {
            if (x.lastError() == 5) {
                try {
                    if (WindowsFileAttributes.get(dir, false).isDirectory()) {
                        throw new FileAlreadyExistsException(dir.toString());
                    }
                }
                catch (WindowsException windowsException) {
                    // empty catch block
                }
            }
            x.rethrowAsIOException(dir);
        }
        finally {
            sd.release();
        }
    }

    @Override
    public DirectoryStream<Path> newDirectoryStream(Path obj, DirectoryStream.Filter<? super Path> filter) throws IOException {
        WindowsPath dir = WindowsPath.toWindowsPath(obj);
        dir.checkRead();
        if (filter == null) {
            throw new NullPointerException();
        }
        return new WindowsDirectoryStream(dir, filter);
    }

    @Override
    public void createSymbolicLink(Path obj1, Path obj2, FileAttribute<?> ... attrs) throws IOException {
        WindowsPath parent;
        WindowsPath link = WindowsPath.toWindowsPath(obj1);
        WindowsPath target = WindowsPath.toWindowsPath(obj2);
        if (!link.getFileSystem().supportsLinks()) {
            throw new UnsupportedOperationException("Symbolic links not supported on this operating system");
        }
        if (attrs.length > 0) {
            WindowsSecurityDescriptor.fromAttribute(attrs);
            throw new UnsupportedOperationException("Initial file attributesnot supported when creating symbolic link");
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new LinkPermission("symbolic"));
            link.checkWrite();
        }
        if (target.type() == WindowsPathType.DRIVE_RELATIVE) {
            throw new IOException("Cannot create symbolic link to working directory relative target");
        }
        WindowsPath resolvedTarget = target.type() == WindowsPathType.RELATIVE ? ((parent = link.getParent()) == null ? target : parent.resolve(target)) : link.resolve(target);
        int flags = 0;
        try {
            WindowsFileAttributes wattrs = WindowsFileAttributes.get(resolvedTarget, false);
            if (wattrs.isDirectory() || wattrs.isDirectoryLink()) {
                flags |= 1;
            }
        }
        catch (WindowsException wattrs) {
            // empty catch block
        }
        try {
            WindowsNativeDispatcher.CreateSymbolicLink(link.getPathForWin32Calls(), WindowsPath.addPrefixIfNeeded(target.toString()), flags);
        }
        catch (WindowsException x) {
            if (x.lastError() == 4392) {
                x.rethrowAsIOException(link, target);
            }
            x.rethrowAsIOException(link);
        }
    }

    @Override
    public void createLink(Path obj1, Path obj2) throws IOException {
        WindowsPath link = WindowsPath.toWindowsPath(obj1);
        WindowsPath existing = WindowsPath.toWindowsPath(obj2);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new LinkPermission("hard"));
            link.checkWrite();
            existing.checkWrite();
        }
        try {
            WindowsNativeDispatcher.CreateHardLink(link.getPathForWin32Calls(), existing.getPathForWin32Calls());
        }
        catch (WindowsException x) {
            x.rethrowAsIOException(link, existing);
        }
    }

    @Override
    public Path readSymbolicLink(Path obj1) throws IOException {
        WindowsPath link = WindowsPath.toWindowsPath(obj1);
        WindowsFileSystem fs = link.getFileSystem();
        if (!fs.supportsLinks()) {
            throw new UnsupportedOperationException("symbolic links not supported");
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            FilePermission perm = new FilePermission(link.getPathForPermissionCheck(), "readlink");
            sm.checkPermission(perm);
        }
        String target = WindowsLinkSupport.readLink(link);
        return WindowsPath.createFromNormalizedPath(fs, target);
    }
}

