/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.Pipe;
import java.nio.channels.SelectableChannel;
import java.nio.channels.Selector;
import java.nio.channels.spi.SelectorProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import sun.nio.ch.IOUtil;
import sun.nio.ch.Net;
import sun.nio.ch.PollArrayWrapper;
import sun.nio.ch.SelChImpl;
import sun.nio.ch.SelectionKeyImpl;
import sun.nio.ch.SelectorImpl;
import sun.nio.ch.SinkChannelImpl;
import sun.nio.ch.SocketChannelImpl;

final class WindowsSelectorImpl
extends SelectorImpl {
    private final int INIT_CAP = 8;
    private static final int MAX_SELECTABLE_FDS = 1024;
    private SelectionKeyImpl[] channelArray = new SelectionKeyImpl[8];
    private PollArrayWrapper pollWrapper;
    private int totalChannels = 1;
    private int threadsCount = 0;
    private final List<SelectThread> threads = new ArrayList<SelectThread>();
    private final Pipe wakeupPipe;
    private final int wakeupSourceFd;
    private final int wakeupSinkFd;
    private Object closeLock = new Object();
    private final FdMap fdMap = new FdMap();
    private final SubSelector subSelector = new SubSelector();
    private long timeout;
    private final Object interruptLock = new Object();
    private volatile boolean interruptTriggered = false;
    private final StartLock startLock = new StartLock();
    private final FinishLock finishLock = new FinishLock();
    private long updateCount = 0L;

    WindowsSelectorImpl(SelectorProvider sp) throws IOException {
        super(sp);
        this.pollWrapper = new PollArrayWrapper(8);
        this.wakeupPipe = Pipe.open();
        this.wakeupSourceFd = ((SelChImpl)((Object)this.wakeupPipe.source())).getFDVal();
        SinkChannelImpl sink = (SinkChannelImpl)this.wakeupPipe.sink();
        sink.sc.socket().setTcpNoDelay(true);
        this.wakeupSinkFd = sink.getFDVal();
        this.pollWrapper.addWakeupSocket(this.wakeupSourceFd, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int doSelect(long timeout) throws IOException {
        if (this.channelArray == null) {
            throw new ClosedSelectorException();
        }
        this.timeout = timeout;
        this.processDeregisterQueue();
        if (this.interruptTriggered) {
            this.resetWakeupSocket();
            return 0;
        }
        this.adjustThreadsCount();
        this.finishLock.reset();
        this.startLock.startThreads();
        try {
            this.begin();
            try {
                this.subSelector.poll();
            }
            catch (IOException e) {
                this.finishLock.setException(e);
            }
            if (this.threads.size() > 0) {
                this.finishLock.waitForHelperThreads();
            }
        }
        finally {
            this.end();
        }
        this.finishLock.checkForException();
        this.processDeregisterQueue();
        int updated = this.updateSelectedKeys();
        this.resetWakeupSocket();
        return updated;
    }

    private void adjustThreadsCount() {
        block3: {
            block2: {
                if (this.threadsCount <= this.threads.size()) break block2;
                for (int i = this.threads.size(); i < this.threadsCount; ++i) {
                    SelectThread newThread = new SelectThread(i);
                    this.threads.add(newThread);
                    newThread.setDaemon(true);
                    newThread.start();
                }
                break block3;
            }
            if (this.threadsCount >= this.threads.size()) break block3;
            for (int i = this.threads.size() - 1; i >= this.threadsCount; --i) {
                this.threads.remove(i).makeZombie();
            }
        }
    }

    private void setWakeupSocket() {
        this.setWakeupSocket0(this.wakeupSinkFd);
    }

    private native void setWakeupSocket0(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetWakeupSocket() {
        Object object = this.interruptLock;
        synchronized (object) {
            if (!this.interruptTriggered) {
                return;
            }
            this.resetWakeupSocket0(this.wakeupSourceFd);
            this.interruptTriggered = false;
        }
    }

    private native void resetWakeupSocket0(int var1);

    private native boolean discardUrgentData(int var1);

    private int updateSelectedKeys() {
        ++this.updateCount;
        int numKeysUpdated = 0;
        numKeysUpdated += this.subSelector.processSelectedKeys(this.updateCount);
        for (SelectThread t : this.threads) {
            numKeysUpdated += t.subSelector.processSelectedKeys(this.updateCount);
        }
        return numKeysUpdated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void implClose() throws IOException {
        Object object = this.closeLock;
        synchronized (object) {
            if (this.channelArray != null && this.pollWrapper != null) {
                Object object2 = this.interruptLock;
                synchronized (object2) {
                    this.interruptTriggered = true;
                }
                this.wakeupPipe.sink().close();
                this.wakeupPipe.source().close();
                for (int i = 1; i < this.totalChannels; ++i) {
                    if (i % 1024 == 0) continue;
                    this.deregister(this.channelArray[i]);
                    SelectableChannel selch = this.channelArray[i].channel();
                    if (selch.isOpen() || selch.isRegistered()) continue;
                    ((SelChImpl)((Object)selch)).kill();
                }
                this.pollWrapper.free();
                this.pollWrapper = null;
                this.selectedKeys = null;
                this.channelArray = null;
                for (SelectThread t : this.threads) {
                    t.makeZombie();
                }
                this.startLock.startThreads();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void implRegister(SelectionKeyImpl ski) {
        Object object = this.closeLock;
        synchronized (object) {
            if (this.pollWrapper == null) {
                throw new ClosedSelectorException();
            }
            this.growIfNeeded();
            this.channelArray[this.totalChannels] = ski;
            ski.setIndex(this.totalChannels);
            this.fdMap.put(ski);
            this.keys.add(ski);
            this.pollWrapper.addEntry(this.totalChannels, ski);
            ++this.totalChannels;
        }
    }

    private void growIfNeeded() {
        if (this.channelArray.length == this.totalChannels) {
            int newSize = this.totalChannels * 2;
            SelectionKeyImpl[] temp = new SelectionKeyImpl[newSize];
            System.arraycopy(this.channelArray, 1, temp, 1, this.totalChannels - 1);
            this.channelArray = temp;
            this.pollWrapper.grow(newSize);
        }
        if (this.totalChannels % 1024 == 0) {
            this.pollWrapper.addWakeupSocket(this.wakeupSourceFd, this.totalChannels);
            ++this.totalChannels;
            ++this.threadsCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void implDereg(SelectionKeyImpl ski) throws IOException {
        int i = ski.getIndex();
        assert (i >= 0);
        Object object = this.closeLock;
        synchronized (object) {
            if (i != this.totalChannels - 1) {
                SelectionKeyImpl endChannel;
                this.channelArray[i] = endChannel = this.channelArray[this.totalChannels - 1];
                endChannel.setIndex(i);
                this.pollWrapper.replaceEntry(this.pollWrapper, this.totalChannels - 1, this.pollWrapper, i);
            }
            ski.setIndex(-1);
        }
        this.channelArray[this.totalChannels - 1] = null;
        --this.totalChannels;
        if (this.totalChannels != 1 && this.totalChannels % 1024 == 1) {
            --this.totalChannels;
            --this.threadsCount;
        }
        this.fdMap.remove(ski);
        this.keys.remove(ski);
        this.selectedKeys.remove(ski);
        this.deregister(ski);
        SelectableChannel selch = ski.channel();
        if (!selch.isOpen() && !selch.isRegistered()) {
            ((SelChImpl)((Object)selch)).kill();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putEventOps(SelectionKeyImpl sk, int ops) {
        Object object = this.closeLock;
        synchronized (object) {
            if (this.pollWrapper == null) {
                throw new ClosedSelectorException();
            }
            int index = sk.getIndex();
            if (index == -1) {
                throw new CancelledKeyException();
            }
            this.pollWrapper.putEventOps(index, ops);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Selector wakeup() {
        Object object = this.interruptLock;
        synchronized (object) {
            if (!this.interruptTriggered) {
                this.setWakeupSocket();
                this.interruptTriggered = true;
            }
        }
        return this;
    }

    static {
        IOUtil.load();
    }

    private final class SelectThread
    extends Thread {
        private final int index;
        final SubSelector subSelector;
        private long lastRun = 0L;
        private volatile boolean zombie;

        private SelectThread(int i) {
            this.index = i;
            this.subSelector = new SubSelector(i);
            this.lastRun = WindowsSelectorImpl.this.startLock.runsCounter;
        }

        void makeZombie() {
            this.zombie = true;
        }

        boolean isZombie() {
            return this.zombie;
        }

        @Override
        public void run() {
            while (!WindowsSelectorImpl.this.startLock.waitForStart(this)) {
                try {
                    this.subSelector.poll(this.index);
                }
                catch (IOException e) {
                    WindowsSelectorImpl.this.finishLock.setException(e);
                }
                WindowsSelectorImpl.this.finishLock.threadFinished();
            }
            return;
        }
    }

    private final class SubSelector {
        private final int pollArrayIndex;
        private final int[] readFds = new int[1025];
        private final int[] writeFds = new int[1025];
        private final int[] exceptFds = new int[1025];

        private SubSelector() {
            this.pollArrayIndex = 0;
        }

        private SubSelector(int threadIndex) {
            this.pollArrayIndex = (threadIndex + 1) * 1024;
        }

        private int poll() throws IOException {
            return this.poll0(((WindowsSelectorImpl)WindowsSelectorImpl.this).pollWrapper.pollArrayAddress, Math.min(WindowsSelectorImpl.this.totalChannels, 1024), this.readFds, this.writeFds, this.exceptFds, WindowsSelectorImpl.this.timeout);
        }

        private int poll(int index) throws IOException {
            return this.poll0(((WindowsSelectorImpl)WindowsSelectorImpl.this).pollWrapper.pollArrayAddress + (long)(this.pollArrayIndex * PollArrayWrapper.SIZE_POLLFD), Math.min(1024, WindowsSelectorImpl.this.totalChannels - (index + 1) * 1024), this.readFds, this.writeFds, this.exceptFds, WindowsSelectorImpl.this.timeout);
        }

        private native int poll0(long var1, int var3, int[] var4, int[] var5, int[] var6, long var7);

        private int processSelectedKeys(long updateCount) {
            int numKeysUpdated = 0;
            numKeysUpdated += this.processFDSet(updateCount, this.readFds, Net.POLLIN, false);
            numKeysUpdated += this.processFDSet(updateCount, this.writeFds, Net.POLLCONN | Net.POLLOUT, false);
            return numKeysUpdated += this.processFDSet(updateCount, this.exceptFds, Net.POLLIN | Net.POLLCONN | Net.POLLOUT, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int processFDSet(long updateCount, int[] fds, int rOps, boolean isExceptFds) {
            int numKeysUpdated = 0;
            for (int i = 1; i <= fds[0]; ++i) {
                int desc = fds[i];
                if (desc == WindowsSelectorImpl.this.wakeupSourceFd) {
                    Object object = WindowsSelectorImpl.this.interruptLock;
                    synchronized (object) {
                        WindowsSelectorImpl.this.interruptTriggered = true;
                        continue;
                    }
                }
                MapEntry me = WindowsSelectorImpl.this.fdMap.get(desc);
                if (me == null) continue;
                SelectionKeyImpl sk = me.ski;
                if (isExceptFds && sk.channel() instanceof SocketChannelImpl && WindowsSelectorImpl.this.discardUrgentData(desc)) continue;
                if (WindowsSelectorImpl.this.selectedKeys.contains(sk)) {
                    if (me.clearedCount != updateCount) {
                        if (sk.channel.translateAndSetReadyOps(rOps, sk) && me.updateCount != updateCount) {
                            me.updateCount = updateCount;
                            ++numKeysUpdated;
                        }
                    } else if (sk.channel.translateAndUpdateReadyOps(rOps, sk) && me.updateCount != updateCount) {
                        me.updateCount = updateCount;
                        ++numKeysUpdated;
                    }
                    me.clearedCount = updateCount;
                    continue;
                }
                if (me.clearedCount != updateCount) {
                    sk.channel.translateAndSetReadyOps(rOps, sk);
                    if ((sk.nioReadyOps() & sk.nioInterestOps()) != 0) {
                        WindowsSelectorImpl.this.selectedKeys.add(sk);
                        me.updateCount = updateCount;
                        ++numKeysUpdated;
                    }
                } else {
                    sk.channel.translateAndUpdateReadyOps(rOps, sk);
                    if ((sk.nioReadyOps() & sk.nioInterestOps()) != 0) {
                        WindowsSelectorImpl.this.selectedKeys.add(sk);
                        me.updateCount = updateCount;
                        ++numKeysUpdated;
                    }
                }
                me.clearedCount = updateCount;
            }
            return numKeysUpdated;
        }
    }

    private final class FinishLock {
        private int threadsToFinish;
        IOException exception = null;

        private FinishLock() {
        }

        private void reset() {
            this.threadsToFinish = WindowsSelectorImpl.this.threads.size();
        }

        private synchronized void threadFinished() {
            if (this.threadsToFinish == WindowsSelectorImpl.this.threads.size()) {
                WindowsSelectorImpl.this.wakeup();
            }
            --this.threadsToFinish;
            if (this.threadsToFinish == 0) {
                this.notify();
            }
        }

        private synchronized void waitForHelperThreads() {
            if (this.threadsToFinish == WindowsSelectorImpl.this.threads.size()) {
                WindowsSelectorImpl.this.wakeup();
            }
            while (this.threadsToFinish != 0) {
                try {
                    WindowsSelectorImpl.this.finishLock.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        private synchronized void setException(IOException e) {
            this.exception = e;
        }

        private void checkForException() throws IOException {
            if (this.exception == null) {
                return;
            }
            StringBuffer message = new StringBuffer("An exception occurred during the execution of select(): \n");
            message.append(this.exception);
            message.append('\n');
            this.exception = null;
            throw new IOException(message.toString());
        }
    }

    private final class StartLock {
        private long runsCounter;

        private StartLock() {
        }

        private synchronized void startThreads() {
            ++this.runsCounter;
            this.notifyAll();
        }

        private synchronized boolean waitForStart(SelectThread thread) {
            while (this.runsCounter == thread.lastRun) {
                try {
                    WindowsSelectorImpl.this.startLock.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            if (thread.isZombie()) {
                return true;
            }
            thread.lastRun = this.runsCounter;
            return false;
        }
    }

    private static final class MapEntry {
        SelectionKeyImpl ski;
        long updateCount = 0L;
        long clearedCount = 0L;

        MapEntry(SelectionKeyImpl ski) {
            this.ski = ski;
        }
    }

    private static final class FdMap
    extends HashMap<Integer, MapEntry> {
        static final long serialVersionUID = 0L;

        private FdMap() {
        }

        private MapEntry get(int desc) {
            return (MapEntry)this.get(new Integer(desc));
        }

        private MapEntry put(SelectionKeyImpl ski) {
            return this.put(new Integer(ski.channel.getFDVal()), new MapEntry(ski));
        }

        private MapEntry remove(SelectionKeyImpl ski) {
            Integer fd = new Integer(ski.channel.getFDVal());
            MapEntry x = (MapEntry)this.get(fd);
            if (x != null && x.ski.channel == ski.channel) {
                return (MapEntry)this.remove(fd);
            }
            return null;
        }
    }
}

