/*
 * Decompiled with CFR 0.152.
 */
package javax.sql.rowset.serial;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Map;
import sun.reflect.misc.ReflectUtil;

public class SQLInputImpl
implements SQLInput {
    private boolean lastValueWasNull;
    private int idx;
    private Object[] attrib;
    private Map<String, Class<?>> map;

    public SQLInputImpl(Object[] attributes, Map<String, Class<?>> map) throws SQLException {
        if (attributes == null || map == null) {
            throw new SQLException("Cannot instantiate a SQLInputImpl object with null parameters");
        }
        this.attrib = Arrays.copyOf(attributes, attributes.length);
        this.idx = -1;
        this.map = map;
    }

    private Object getNextAttribute() throws SQLException {
        if (++this.idx >= this.attrib.length) {
            throw new SQLException("SQLInputImpl exception: Invalid read position");
        }
        this.lastValueWasNull = this.attrib[this.idx] == null;
        return this.attrib[this.idx];
    }

    @Override
    public String readString() throws SQLException {
        return (String)this.getNextAttribute();
    }

    @Override
    public boolean readBoolean() throws SQLException {
        Boolean attrib = (Boolean)this.getNextAttribute();
        return attrib == null ? false : attrib;
    }

    @Override
    public byte readByte() throws SQLException {
        Byte attrib = (Byte)this.getNextAttribute();
        return attrib == null ? (byte)0 : attrib;
    }

    @Override
    public short readShort() throws SQLException {
        Short attrib = (Short)this.getNextAttribute();
        return attrib == null ? (short)0 : attrib;
    }

    @Override
    public int readInt() throws SQLException {
        Integer attrib = (Integer)this.getNextAttribute();
        return attrib == null ? 0 : attrib;
    }

    @Override
    public long readLong() throws SQLException {
        Long attrib = (Long)this.getNextAttribute();
        return attrib == null ? 0L : attrib;
    }

    @Override
    public float readFloat() throws SQLException {
        Float attrib = (Float)this.getNextAttribute();
        return attrib == null ? 0.0f : attrib.floatValue();
    }

    @Override
    public double readDouble() throws SQLException {
        Double attrib = (Double)this.getNextAttribute();
        return attrib == null ? 0.0 : attrib;
    }

    @Override
    public BigDecimal readBigDecimal() throws SQLException {
        return (BigDecimal)this.getNextAttribute();
    }

    @Override
    public byte[] readBytes() throws SQLException {
        return (byte[])this.getNextAttribute();
    }

    @Override
    public Date readDate() throws SQLException {
        return (Date)this.getNextAttribute();
    }

    @Override
    public Time readTime() throws SQLException {
        return (Time)this.getNextAttribute();
    }

    @Override
    public Timestamp readTimestamp() throws SQLException {
        return (Timestamp)this.getNextAttribute();
    }

    @Override
    public Reader readCharacterStream() throws SQLException {
        return (Reader)this.getNextAttribute();
    }

    @Override
    public InputStream readAsciiStream() throws SQLException {
        return (InputStream)this.getNextAttribute();
    }

    @Override
    public InputStream readBinaryStream() throws SQLException {
        return (InputStream)this.getNextAttribute();
    }

    @Override
    public Object readObject() throws SQLException {
        Struct s;
        Class<?> c;
        Object attrib = this.getNextAttribute();
        if (attrib instanceof Struct && (c = this.map.get((s = (Struct)attrib).getSQLTypeName())) != null) {
            SQLData obj = null;
            try {
                obj = (SQLData)ReflectUtil.newInstance(c);
            }
            catch (Exception ex) {
                throw new SQLException("Unable to Instantiate: ", ex);
            }
            Object[] attribs = s.getAttributes(this.map);
            SQLInputImpl sqlInput = new SQLInputImpl(attribs, this.map);
            obj.readSQL(sqlInput, s.getSQLTypeName());
            return obj;
        }
        return attrib;
    }

    @Override
    public Ref readRef() throws SQLException {
        return (Ref)this.getNextAttribute();
    }

    @Override
    public Blob readBlob() throws SQLException {
        return (Blob)this.getNextAttribute();
    }

    @Override
    public Clob readClob() throws SQLException {
        return (Clob)this.getNextAttribute();
    }

    @Override
    public Array readArray() throws SQLException {
        return (Array)this.getNextAttribute();
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.lastValueWasNull;
    }

    @Override
    public URL readURL() throws SQLException {
        return (URL)this.getNextAttribute();
    }

    @Override
    public NClob readNClob() throws SQLException {
        return (NClob)this.getNextAttribute();
    }

    @Override
    public String readNString() throws SQLException {
        return (String)this.getNextAttribute();
    }

    @Override
    public SQLXML readSQLXML() throws SQLException {
        return (SQLXML)this.getNextAttribute();
    }

    @Override
    public RowId readRowId() throws SQLException {
        return (RowId)this.getNextAttribute();
    }
}

