/*
 * Decompiled with CFR 0.152.
 */
package java.time.chrono;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.time.Clock;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.chrono.AbstractChronology;
import java.time.chrono.ChronoLocalDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.time.chrono.Era;
import java.time.chrono.HijrahDate;
import java.time.chrono.HijrahEra;
import java.time.format.ResolverStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.time.temporal.ValueRange;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import sun.util.calendar.BaseCalendar;
import sun.util.logging.PlatformLogger;

public final class HijrahChronology
extends AbstractChronology
implements Serializable {
    private final transient String typeId;
    private final transient String calendarType;
    private static final long serialVersionUID = 3127340209035924785L;
    public static final HijrahChronology INSTANCE;
    private volatile transient boolean initComplete;
    private transient int[] hijrahEpochMonthStartDays;
    private transient int minEpochDay;
    private transient int maxEpochDay;
    private transient int hijrahStartEpochMonth;
    private transient int minMonthLength;
    private transient int maxMonthLength;
    private transient int minYearLength;
    private transient int maxYearLength;
    private static final transient Properties calendarProperties;
    private static final String PROP_PREFIX = "calendar.hijrah.";
    private static final String PROP_TYPE_SUFFIX = ".type";
    private static final String KEY_ID = "id";
    private static final String KEY_TYPE = "type";
    private static final String KEY_VERSION = "version";
    private static final String KEY_ISO_START = "iso-start";

    private static void registerVariants() {
        for (String name : calendarProperties.stringPropertyNames()) {
            String id;
            if (!name.startsWith(PROP_PREFIX) || (id = name.substring(PROP_PREFIX.length())).indexOf(46) >= 0 || id.equals(INSTANCE.getId())) continue;
            try {
                HijrahChronology chrono = new HijrahChronology(id);
                AbstractChronology.registerChrono(chrono);
            }
            catch (DateTimeException ex) {
                PlatformLogger logger = PlatformLogger.getLogger("java.time.chrono");
                logger.severe("Unable to initialize Hijrah calendar: " + id, ex);
            }
        }
    }

    private HijrahChronology(String id) throws DateTimeException {
        if (id.isEmpty()) {
            throw new IllegalArgumentException("calendar id is empty");
        }
        String propName = PROP_PREFIX + id + PROP_TYPE_SUFFIX;
        String calType = calendarProperties.getProperty(propName);
        if (calType == null || calType.isEmpty()) {
            throw new DateTimeException("calendarType is missing or empty for: " + propName);
        }
        this.typeId = id;
        this.calendarType = calType;
    }

    private void checkCalendarInit() {
        if (!this.initComplete) {
            this.loadCalendarData();
            this.initComplete = true;
        }
    }

    @Override
    public String getId() {
        return this.typeId;
    }

    @Override
    public String getCalendarType() {
        return this.calendarType;
    }

    @Override
    public HijrahDate date(Era era, int yearOfEra, int month, int dayOfMonth) {
        return this.date(this.prolepticYear(era, yearOfEra), month, dayOfMonth);
    }

    @Override
    public HijrahDate date(int prolepticYear, int month, int dayOfMonth) {
        return HijrahDate.of(this, prolepticYear, month, dayOfMonth);
    }

    @Override
    public HijrahDate dateYearDay(Era era, int yearOfEra, int dayOfYear) {
        return this.dateYearDay(this.prolepticYear(era, yearOfEra), dayOfYear);
    }

    @Override
    public HijrahDate dateYearDay(int prolepticYear, int dayOfYear) {
        HijrahDate date = HijrahDate.of(this, prolepticYear, 1, 1);
        if (dayOfYear > date.lengthOfYear()) {
            throw new DateTimeException("Invalid dayOfYear: " + dayOfYear);
        }
        return date.plusDays(dayOfYear - 1);
    }

    @Override
    public HijrahDate dateEpochDay(long epochDay) {
        return HijrahDate.ofEpochDay(this, epochDay);
    }

    @Override
    public HijrahDate dateNow() {
        return this.dateNow(Clock.systemDefaultZone());
    }

    @Override
    public HijrahDate dateNow(ZoneId zone) {
        return this.dateNow(Clock.system(zone));
    }

    @Override
    public HijrahDate dateNow(Clock clock) {
        return this.date(LocalDate.now(clock));
    }

    @Override
    public HijrahDate date(TemporalAccessor temporal) {
        if (temporal instanceof HijrahDate) {
            return (HijrahDate)temporal;
        }
        return HijrahDate.ofEpochDay(this, temporal.getLong(ChronoField.EPOCH_DAY));
    }

    public ChronoLocalDateTime<HijrahDate> localDateTime(TemporalAccessor temporal) {
        return super.localDateTime(temporal);
    }

    public ChronoZonedDateTime<HijrahDate> zonedDateTime(TemporalAccessor temporal) {
        return super.zonedDateTime(temporal);
    }

    public ChronoZonedDateTime<HijrahDate> zonedDateTime(Instant instant, ZoneId zone) {
        return super.zonedDateTime(instant, zone);
    }

    @Override
    public boolean isLeapYear(long prolepticYear) {
        this.checkCalendarInit();
        if (prolepticYear < (long)this.getMinimumYear() || prolepticYear > (long)this.getMaximumYear()) {
            return false;
        }
        int len = this.getYearLength((int)prolepticYear);
        return len > 354;
    }

    @Override
    public int prolepticYear(Era era, int yearOfEra) {
        if (!(era instanceof HijrahEra)) {
            throw new ClassCastException("Era must be HijrahEra");
        }
        return yearOfEra;
    }

    @Override
    public HijrahEra eraOf(int eraValue) {
        switch (eraValue) {
            case 1: {
                return HijrahEra.AH;
            }
        }
        throw new DateTimeException("invalid Hijrah era");
    }

    @Override
    public List<Era> eras() {
        return Arrays.asList(HijrahEra.values());
    }

    @Override
    public ValueRange range(ChronoField field) {
        this.checkCalendarInit();
        if (field instanceof ChronoField) {
            ChronoField f = field;
            switch (f) {
                case DAY_OF_MONTH: {
                    return ValueRange.of(1L, 1L, this.getMinimumMonthLength(), this.getMaximumMonthLength());
                }
                case DAY_OF_YEAR: {
                    return ValueRange.of(1L, this.getMaximumDayOfYear());
                }
                case ALIGNED_WEEK_OF_MONTH: {
                    return ValueRange.of(1L, 5L);
                }
                case YEAR: 
                case YEAR_OF_ERA: {
                    return ValueRange.of(this.getMinimumYear(), this.getMaximumYear());
                }
                case ERA: {
                    return ValueRange.of(1L, 1L);
                }
            }
            return field.range();
        }
        return field.range();
    }

    @Override
    public HijrahDate resolveDate(Map<TemporalField, Long> fieldValues, ResolverStyle resolverStyle) {
        return (HijrahDate)super.resolveDate(fieldValues, resolverStyle);
    }

    int checkValidYear(long prolepticYear) {
        if (prolepticYear < (long)this.getMinimumYear() || prolepticYear > (long)this.getMaximumYear()) {
            throw new DateTimeException("Invalid Hijrah year: " + prolepticYear);
        }
        return (int)prolepticYear;
    }

    void checkValidDayOfYear(int dayOfYear) {
        if (dayOfYear < 1 || dayOfYear > this.getMaximumDayOfYear()) {
            throw new DateTimeException("Invalid Hijrah day of year: " + dayOfYear);
        }
    }

    void checkValidMonth(int month) {
        if (month < 1 || month > 12) {
            throw new DateTimeException("Invalid Hijrah month: " + month);
        }
    }

    int[] getHijrahDateInfo(int epochDay) {
        this.checkCalendarInit();
        if (epochDay < this.minEpochDay || epochDay >= this.maxEpochDay) {
            throw new DateTimeException("Hijrah date out of range");
        }
        int epochMonth = this.epochDayToEpochMonth(epochDay);
        int year = this.epochMonthToYear(epochMonth);
        int month = this.epochMonthToMonth(epochMonth);
        int day1 = this.epochMonthToEpochDay(epochMonth);
        int date = epochDay - day1;
        int[] dateInfo = new int[]{year, month + 1, date + 1};
        return dateInfo;
    }

    long getEpochDay(int prolepticYear, int monthOfYear, int dayOfMonth) {
        this.checkCalendarInit();
        this.checkValidMonth(monthOfYear);
        int epochMonth = this.yearToEpochMonth(prolepticYear) + (monthOfYear - 1);
        if (epochMonth < 0 || epochMonth >= this.hijrahEpochMonthStartDays.length) {
            throw new DateTimeException("Invalid Hijrah date, year: " + prolepticYear + ", month: " + monthOfYear);
        }
        if (dayOfMonth < 1 || dayOfMonth > this.getMonthLength(prolepticYear, monthOfYear)) {
            throw new DateTimeException("Invalid Hijrah day of month: " + dayOfMonth);
        }
        return this.epochMonthToEpochDay(epochMonth) + (dayOfMonth - 1);
    }

    int getDayOfYear(int prolepticYear, int month) {
        return this.yearMonthToDayOfYear(prolepticYear, month - 1);
    }

    int getMonthLength(int prolepticYear, int monthOfYear) {
        int epochMonth = this.yearToEpochMonth(prolepticYear) + (monthOfYear - 1);
        if (epochMonth < 0 || epochMonth >= this.hijrahEpochMonthStartDays.length) {
            throw new DateTimeException("Invalid Hijrah date, year: " + prolepticYear + ", month: " + monthOfYear);
        }
        return this.epochMonthLength(epochMonth);
    }

    int getYearLength(int prolepticYear) {
        return this.yearMonthToDayOfYear(prolepticYear, 12);
    }

    int getMinimumYear() {
        return this.epochMonthToYear(0);
    }

    int getMaximumYear() {
        return this.epochMonthToYear(this.hijrahEpochMonthStartDays.length - 1) - 1;
    }

    int getMaximumMonthLength() {
        return this.maxMonthLength;
    }

    int getMinimumMonthLength() {
        return this.minMonthLength;
    }

    int getMaximumDayOfYear() {
        return this.maxYearLength;
    }

    int getSmallestMaximumDayOfYear() {
        return this.minYearLength;
    }

    private int epochDayToEpochMonth(int epochDay) {
        int ndx = Arrays.binarySearch(this.hijrahEpochMonthStartDays, epochDay);
        if (ndx < 0) {
            ndx = -ndx - 2;
        }
        return ndx;
    }

    private int epochMonthToYear(int epochMonth) {
        return (epochMonth + this.hijrahStartEpochMonth) / 12;
    }

    private int yearToEpochMonth(int year) {
        return year * 12 - this.hijrahStartEpochMonth;
    }

    private int epochMonthToMonth(int epochMonth) {
        return (epochMonth + this.hijrahStartEpochMonth) % 12;
    }

    private int epochMonthToEpochDay(int epochMonth) {
        return this.hijrahEpochMonthStartDays[epochMonth];
    }

    private int yearMonthToDayOfYear(int prolepticYear, int month) {
        int epochMonthFirst = this.yearToEpochMonth(prolepticYear);
        return this.epochMonthToEpochDay(epochMonthFirst + month) - this.epochMonthToEpochDay(epochMonthFirst);
    }

    private int epochMonthLength(int epochMonth) {
        return this.hijrahEpochMonthStartDays[epochMonth + 1] - this.hijrahEpochMonthStartDays[epochMonth];
    }

    private static Properties readConfigProperties(String resource) throws Exception {
        try {
            return AccessController.doPrivileged(() -> {
                String libDir = System.getProperty("java.home") + File.separator + "lib";
                File file = new File(libDir, resource);
                Properties props = new Properties();
                try (FileInputStream is = new FileInputStream(file);){
                    props.load(is);
                }
                return props;
            });
        }
        catch (PrivilegedActionException pax) {
            throw pax.getException();
        }
    }

    private void loadCalendarData() {
        try {
            String resourceName = calendarProperties.getProperty(PROP_PREFIX + this.typeId);
            Objects.requireNonNull(resourceName, "Resource missing for calendar: calendar.hijrah." + this.typeId);
            Properties props = HijrahChronology.readConfigProperties(resourceName);
            HashMap<Integer, int[]> years = new HashMap<Integer, int[]>();
            int minYear = Integer.MAX_VALUE;
            int maxYear = Integer.MIN_VALUE;
            String id = null;
            String type = null;
            String version = null;
            int isoStart = 0;
            block16: for (Map.Entry entry : props.entrySet()) {
                String key;
                switch (key = (String)entry.getKey()) {
                    case "id": {
                        id = (String)entry.getValue();
                        continue block16;
                    }
                    case "type": {
                        type = (String)entry.getValue();
                        continue block16;
                    }
                    case "version": {
                        version = (String)entry.getValue();
                        continue block16;
                    }
                    case "iso-start": {
                        int[] ymd = this.parseYMD((String)entry.getValue());
                        isoStart = (int)LocalDate.of(ymd[0], ymd[1], ymd[2]).toEpochDay();
                        continue block16;
                    }
                }
                try {
                    int year = Integer.valueOf(key);
                    int[] months = this.parseMonths((String)entry.getValue());
                    years.put(year, months);
                    maxYear = Math.max(maxYear, year);
                    minYear = Math.min(minYear, year);
                }
                catch (NumberFormatException nfe) {
                    throw new IllegalArgumentException("bad key: " + key);
                }
            }
            if (!this.getId().equals(id)) {
                throw new IllegalArgumentException("Configuration is for a different calendar: " + id);
            }
            if (!this.getCalendarType().equals(type)) {
                throw new IllegalArgumentException("Configuration is for a different calendar type: " + type);
            }
            if (version == null || version.isEmpty()) {
                throw new IllegalArgumentException("Configuration does not contain a version");
            }
            if (isoStart == 0) {
                throw new IllegalArgumentException("Configuration does not contain a ISO start date");
            }
            this.hijrahStartEpochMonth = minYear * 12;
            this.minEpochDay = isoStart;
            this.hijrahEpochMonthStartDays = this.createEpochMonths(this.minEpochDay, minYear, maxYear, years);
            this.maxEpochDay = this.hijrahEpochMonthStartDays[this.hijrahEpochMonthStartDays.length - 1];
            for (int year = minYear; year < maxYear; ++year) {
                int length = this.getYearLength(year);
                this.minYearLength = Math.min(this.minYearLength, length);
                this.maxYearLength = Math.max(this.maxYearLength, length);
            }
        }
        catch (Exception ex) {
            PlatformLogger logger = PlatformLogger.getLogger("java.time.chrono");
            logger.severe("Unable to initialize Hijrah calendar proxy: " + this.typeId, ex);
            throw new DateTimeException("Unable to initialize HijrahCalendar: " + this.typeId, ex);
        }
    }

    private int[] createEpochMonths(int epochDay, int minYear, int maxYear, Map<Integer, int[]> years) {
        int numMonths = (maxYear - minYear + 1) * 12 + 1;
        int epochMonth = 0;
        int[] epochMonths = new int[numMonths];
        this.minMonthLength = Integer.MAX_VALUE;
        this.maxMonthLength = Integer.MIN_VALUE;
        for (int year = minYear; year <= maxYear; ++year) {
            int[] months = years.get(year);
            for (int month = 0; month < 12; ++month) {
                int length = months[month];
                epochMonths[epochMonth++] = epochDay;
                if (length < 29 || length > 32) {
                    throw new IllegalArgumentException("Invalid month length in year: " + minYear);
                }
                epochDay += length;
                this.minMonthLength = Math.min(this.minMonthLength, length);
                this.maxMonthLength = Math.max(this.maxMonthLength, length);
            }
        }
        epochMonths[epochMonth++] = epochDay;
        if (epochMonth != epochMonths.length) {
            throw new IllegalStateException("Did not fill epochMonths exactly: ndx = " + epochMonth + " should be " + epochMonths.length);
        }
        return epochMonths;
    }

    private int[] parseMonths(String line) {
        int[] months = new int[12];
        Object[] numbers = line.split("\\s");
        if (numbers.length != 12) {
            throw new IllegalArgumentException("wrong number of months on line: " + Arrays.toString(numbers) + "; count: " + numbers.length);
        }
        for (int i = 0; i < 12; ++i) {
            try {
                months[i] = Integer.valueOf((String)numbers[i]);
                continue;
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("bad key: " + (String)numbers[i]);
            }
        }
        return months;
    }

    private int[] parseYMD(String string) {
        string = string.trim();
        try {
            if (string.charAt(4) != '-' || string.charAt(7) != '-') {
                throw new IllegalArgumentException("date must be yyyy-MM-dd");
            }
            int[] ymd = new int[]{Integer.valueOf(string.substring(0, 4)), Integer.valueOf(string.substring(5, 7)), Integer.valueOf(string.substring(8, 10))};
            return ymd;
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("date must be yyyy-MM-dd", ex);
        }
    }

    @Override
    Object writeReplace() {
        return super.writeReplace();
    }

    private void readObject(ObjectInputStream s) throws InvalidObjectException {
        throw new InvalidObjectException("Deserialization via serialization delegate");
    }

    static {
        try {
            calendarProperties = BaseCalendar.getCalendarProperties();
        }
        catch (IOException ioe) {
            throw new InternalError("Can't initialize lib/calendars.properties", ioe);
        }
        try {
            INSTANCE = new HijrahChronology("Hijrah-umalqura");
            AbstractChronology.registerChrono(INSTANCE, "Hijrah");
            AbstractChronology.registerChrono(INSTANCE, "islamic");
        }
        catch (DateTimeException ex) {
            PlatformLogger logger = PlatformLogger.getLogger("java.time.chrono");
            logger.severe("Unable to initialize Hijrah calendar: Hijrah-umalqura", ex);
            throw new RuntimeException("Unable to initialize Hijrah-umalqura calendar", ex.getCause());
        }
        HijrahChronology.registerVariants();
    }
}

