/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMB;
import com.supermicro.ipmi.IPMIDCMOEMCommand;
import com.supermicro.ipmi.IPMISDRCommand;
import com.supermicro.ipmi.SDRRecordC0h_NMOEMSDR;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class NMScanPolicyCommand
extends SuperBladeCommand {
    @Override
    public void runCommand() throws Exception {
        IPMIDCMOEMCommand ipmiDCMOEMCommand = null;
        IPMISDRCommand ipmiSDRCommand = new IPMISDRCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        SDRRecordC0h_NMOEMSDR nmOEMSDR = ipmiSDRCommand.getNMSDR();
        if (nmOEMSDR == null || !nmOEMSDR.isNMOEMSDR()) {
            MOut.G(this).println("This device does not support Node Manager");
            this.statusCode = 153;
            return;
        }
        if (nmOEMSDR.isIPMB()) {
            IPMB ipmb = new IPMB(this.ipmiCMMOEMCommand.getIPMIInterface());
            ipmb.setAddress(nmOEMSDR.getSlaveAddress());
            ipmb.setChannel(nmOEMSDR.getChannel());
            ipmb.setIpmbType(0);
            ipmiDCMOEMCommand = new IPMIDCMOEMCommand(ipmb);
        } else {
            ipmiDCMOEMCommand = new IPMIDCMOEMCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        }
        int end = 255;
        if (this.parameters != null && this.parameters.length == 1) {
            String para1 = this.parameters[0];
            try {
                end = Integer.parseInt(para1);
            }
            catch (NumberFormatException ex) {
                MOut.G(this).print(ex.getMessage());
                this.statusCode = 147;
                return;
            }
        }
        for (int i = 0; i < end; ++i) {
            IPMIDCMOEMCommand.NodeManagerPolicy policy = null;
            try {
                policy = ipmiDCMOEMCommand.getNodeManagerPolicy((byte)0, (byte)i);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (policy == null) continue;
            MOut.G(this).println("============================================================");
            MOut.G(this).println("Policy ID = " + i + ", Power Limit = " + ByteUtility.twoBytesToIntLSB(policy.powerLimit) + " w");
            MOut.G(this).println("Policy state:");
            if ((policy.domainIDAndPolicyState & 0x10) == 16) {
                MOut.G(this).println(" Policy enabled");
            } else {
                MOut.G(this).println(" Policy is not enabled");
            }
            if ((policy.domainIDAndPolicyState & 0x20) == 32) {
                MOut.G(this).println(" Per Domain Node Manager policy control enabled");
            }
            if ((policy.domainIDAndPolicyState & 0x40) == 64) {
                MOut.G(this).println(" Global Node Manager policy control enabled");
            }
            MOut.G(this).println("Exception action:");
            if ((policy.policyException & 1) == 1) {
                MOut.G(this).println(" send alert");
            }
            if ((policy.policyException & 2) != 2) continue;
            MOut.G(this).println(" shutdown system");
        }
        this.statusCode = 0;
    }
}

