/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIMicroBladeOEMCommand;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.SessionControllerFactory;
import com.supermicro.ipmi.microblade.SwitchInfo;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.MicroBladeCommand;

public class MicroBladeSwitchLANIPCommand
extends MicroBladeCommand {
    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void execute() throws Exception {
        if (!this.validateForCMM()) {
            this.statusCode = 153;
            return;
        }
        IPMIMicroBladeOEMCommand ipmiMicroBladeOEMCommand = new IPMIMicroBladeOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.config, ipmiMicroBladeOEMCommand);
        if (sessionController == null) {
            this.statusCode = 145;
            return;
        }
        if (this.getParameters() == null) {
            MOut.G(this).println("Usage: microBlade switch lan ip <switch index> [IP]");
        } else if (this.getParameters().length == 1) {
            int sIndex = SwitchInfo.getIndex(this.getParameters()[0]);
            if (sIndex < 0) {
                MOut.G(this).println("The Switch index must be A1-A2 or B1-B2");
                this.statusCode = 147;
                sessionController.closeSession();
                return;
            }
            SwitchInfo switchInfo = ipmiMicroBladeOEMCommand.getSwitch((byte)sIndex, (byte)1);
            if (!switchInfo.isPresent()) {
                MOut.G(this).println("Switch " + this.getParameters()[0] + " is not presented");
                this.statusCode = 151;
                sessionController.closeSession();
                return;
            }
            MOut.G(this).println("Usage: microBlade switch lan ip <switch index> [IP]");
            String result = ipmiMicroBladeOEMCommand.getSwitchIP(sIndex + 1);
            MOut.G(this).println(this.getParameters()[0].toUpperCase() + " IP: " + result);
        } else if (this.getParameters().length == 2) {
            int sIndex = SwitchInfo.getIndex(this.getParameters()[0]);
            if (sIndex < 0) {
                MOut.G(this).println("The Switch index must be A1-A2 or B1-B2");
                this.statusCode = 147;
                sessionController.closeSession();
                return;
            }
            SwitchInfo switchInfo = ipmiMicroBladeOEMCommand.getSwitch((byte)sIndex, (byte)1);
            if (!switchInfo.isPresent()) {
                MOut.G(this).println("Switch " + this.getParameters()[0] + " is not presented");
                this.statusCode = 151;
                sessionController.closeSession();
                return;
            }
            boolean b = ipmiMicroBladeOEMCommand.setSwitchIP(sIndex + 1, this.getParameters()[1]);
            if (!b) {
                MOut.G(this).println("Update IP Fail");
                this.statusCode = 149;
                sessionController.closeSession();
                return;
            }
            MOut.G(this).println("Update IP Successfully");
        } else {
            MOut.G(this).println("Usage: microBlade switch lan ip <switch index> [IP]");
        }
        this.statusCode = 0;
        sessionController.closeSession();
    }
}

