/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMILanCommand;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class CMMNetmaskCommand
extends SuperBladeCommand {
    @Override
    public boolean preValidate() {
        this.preParameters.remove(0);
        byte cmmIndex = Byte.parseByte((String)this.preParameters.get(1));
        if (cmmIndex < 1 || cmmIndex > 2) {
            MOut.G(this).println("CMM Index out of range");
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        byte cmmIndex;
        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(this.config.getIp());
        if (!IPMIMessagingCommand.isMicroBladeCMMGUID(guid) && !this.isConnectToCMM((cmmIndex = Byte.parseByte((String)this.preParameters.get(1))) - 1)) {
            MOut.G(this).println("This function is only available for the CMM connected");
            this.statusCode = 152;
            return;
        }
        IPMILanCommand ipmiLanCommand = new IPMILanCommand(null);
        ipmiLanCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        if (this.parameters != null && this.parameters.length == 1) {
            String mask = this.parameters[0];
            if (!IPMILanCommand.isIPAddress(mask)) {
                MOut.G(this).println("Netmask format error!");
                this.statusCode = 147;
                return;
            }
            if (mask.equals("0.0.0.0")) {
                MOut.G(this).println("Netmask cannot be 0.0.0.0!");
                this.statusCode = 147;
                return;
            }
            int intValue = ByteUtility.ipToInt(mask);
            if (((0 - intValue & intValue) - 1 | intValue) != -1) {
                MOut.G(this).println("Wrong netmask!");
                this.statusCode = 147;
                return;
            }
            String oldMask = ipmiLanCommand.getSubnetMask();
            boolean result = ipmiLanCommand.setSubnetMask(mask);
            if (result) {
                MOut.G(this).println("old Netmask:" + oldMask);
                MOut.G(this).println("new Netmask:" + mask);
                this.statusCode = 0;
            } else {
                MOut.G(this).println(oldMask);
                MOut.G(this).println("Update Netmask failed");
                this.statusCode = 149;
            }
        } else {
            String mask = ipmiLanCommand.getSubnetMask();
            MOut.G(this).println(mask);
            this.statusCode = 0;
        }
    }
}

