/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMILanCommand;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class CMMMACCommand
extends SuperBladeCommand {
    @Override
    public boolean preValidate() {
        this.preParameters.remove(0);
        byte cmmIndex = Byte.parseByte((String)this.preParameters.get(1));
        if (cmmIndex < 1 || cmmIndex > 2) {
            MOut.G(this).println("CMM Index out of range");
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        byte cmmIndex;
        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(this.config.getIp());
        if (!IPMIMessagingCommand.isMicroBladeCMMGUID(guid) && !this.isConnectToCMM((cmmIndex = Byte.parseByte((String)this.preParameters.get(1))) - 1)) {
            MOut.G(this).println("This function is only available for the CMM connected");
            this.statusCode = 152;
            return;
        }
        IPMILanCommand ipmiLanCommand = new IPMILanCommand(null);
        ipmiLanCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        if (this.parameters != null && this.parameters.length == 1) {
            String newMAC = this.parameters[0];
            if (!IPMILanCommand.isMacAddress(newMAC)) {
                MOut.G(this).println("MAC format error!");
                this.statusCode = 147;
                return;
            }
            if (newMAC.equals("00:00:00:00:00:00")) {
                MOut.G(this).println("MAC cannot be 00:00:00:00:00:00!");
                this.statusCode = 147;
                return;
            }
            String oldMAC = ipmiLanCommand.getMAC();
            boolean result = ipmiLanCommand.setMAC(newMAC);
            if (result) {
                MOut.G(this).println("old MAC:" + oldMAC);
                MOut.G(this).println("new MAC:" + newMAC);
                this.statusCode = 0;
            } else {
                MOut.G(this).println(oldMAC);
                MOut.G(this).println("Update MAC failed");
                this.statusCode = 149;
            }
        } else {
            String mac = ipmiLanCommand.getMAC();
            MOut.G(this).println(mac);
            this.statusCode = 0;
        }
    }
}

