/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.nm.sensor;

import java.util.Arrays;

public class SensorReading {
    private static final int OFF_READING = 0;
    private static final int OFF_READING_STATUS = 1;
    private static final int OFF_SENSOR_STATE = 2;
    private static final int OFF_SENSOR_STATE_OPT = 3;
    private static final int BIT_MASK_SCAN = 64;
    private static final int BIT_MASK_AVAIL = 32;
    private byte[] readingData;

    public SensorReading(byte[] readingData) {
        this.readingData = readingData;
    }

    public byte[] getRaw() {
        return this.readingData;
    }

    public int getReading() {
        return this.readingData[0] & 0xFF;
    }

    public byte[] getSensorState() {
        if (this.readingData.length == 4) {
            return Arrays.copyOfRange(this.readingData, 2, 4);
        }
        return new byte[]{this.readingData[2]};
    }

    public boolean isScanning() {
        return (this.readingData[1] & 0x40) == 64;
    }

    public boolean isAvailable() {
        return (this.readingData[1] & 0x20) != 32;
    }
}

