/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.nm.sensor;

import com.supermicro.ipmi.nm.sensor.DiscreteSensor;
import com.supermicro.ipmi.nm.sensor.SensorDefine;
import java.util.HashMap;
import java.util.Map;

public class CPUThermalStatusSensor
extends DiscreteSensor {
    private static final Map<Integer, String> statusDefine = new HashMap<Integer, String>();
    private byte status;

    public CPUThermalStatusSensor(SensorDefine sd, byte[] readingData) {
        super(sd, readingData);
        this.status = this.sr.getSensorState()[0];
    }

    @Override
    public String getNormalSensorStateDesc() {
        StringBuilder statusString = new StringBuilder();
        for (Map.Entry<Integer, String> entry : statusDefine.entrySet()) {
            int off = entry.getKey();
            String stat = entry.getValue();
            if ((this.status >> off & 1) != 1) continue;
            statusString.append(stat);
            statusString.append(" ");
        }
        if (statusString.length() == 0) {
            statusString.append("Normal");
        }
        return statusString.toString();
    }

    static {
        statusDefine.put(0, "CT");
        statusDefine.put(1, "PROCHOT");
        statusDefine.put(2, "TCC");
        statusDefine.put(3, "LOG_CT");
        statusDefine.put(4, "LOG_PROCHOT");
        statusDefine.put(5, "LOG_TCC");
    }
}

