/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.microblade;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.microblade.AbstractSBEntity;
import com.supermicro.ipmi.microblade.Sensor;
import com.supermicro.ipmi.text.MOut;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.Map;

public class SB_B11DPT
extends AbstractSBEntity {
    public Sensor cpu1Temp = new Sensor();
    public Sensor cpu2Temp = new Sensor();
    public Sensor pchTemp = new Sensor();
    public Sensor cpu1vrm1Temp = new Sensor();
    public Sensor cpu1vrm2Temp = new Sensor();
    public Sensor cpu2vrm1Temp = new Sensor();
    public Sensor cpu2vrm2Temp = new Sensor();
    public Sensor dimmABCvrmTemp = new Sensor();
    public Sensor dimmDEFvrmTemp = new Sensor();
    public Sensor dimmGHJvrmTemp = new Sensor();
    public Sensor dimmKLMvrmTemp = new Sensor();
    public Sensor system1Temp = new Sensor();
    public Sensor system2Temp = new Sensor();
    public Sensor lsiTemp = new Sensor();
    public Sensor inletTemp = new Sensor();
    public Sensor AOC_IBHTemp = new Sensor();
    public Sensor dimmA1Temp = new Sensor();
    public Sensor dimmA2Temp = new Sensor();
    public Sensor dimmB1Temp = new Sensor();
    public Sensor dimmC1Temp = new Sensor();
    public Sensor dimmD1Temp = new Sensor();
    public Sensor dimmD2Temp = new Sensor();
    public Sensor dimmE1Temp = new Sensor();
    public Sensor dimmF1Temp = new Sensor();
    public Sensor dimmG1Temp = new Sensor();
    public Sensor dimmG2Temp = new Sensor();
    public Sensor dimmH1Temp = new Sensor();
    public Sensor dimmJ1Temp = new Sensor();
    public Sensor dimmK1Temp = new Sensor();
    public Sensor dimmK2Temp = new Sensor();
    public Sensor dimmL1Temp = new Sensor();
    public Sensor dimmM1Temp = new Sensor();
    public Sensor v12 = new Sensor();
    public Sensor v5 = new Sensor();
    public Sensor v3P3 = new Sensor();
    public Sensor vBAT = new Sensor();
    public Sensor vCPU1 = new Sensor();
    public Sensor vDIMMABC = new Sensor();
    public Sensor vCPU2 = new Sensor();
    public Sensor vDIMMDEF = new Sensor();
    public Sensor v5SB = new Sensor();
    public Sensor v3P3SB = new Sensor();
    public Sensor vDIMMGHJ = new Sensor();
    public Sensor vDIMMKLM = new Sensor();
    public Sensor p1v8 = new Sensor();
    public Sensor pvnn = new Sensor();
    public Sensor p1v05 = new Sensor();
    public Sensor AOC_OPHTemp = new Sensor();
    public Sensor watchdog = new Sensor();
    public Sensor pwr = new Sensor();
    public Sensor AOM_B_4MTemp = new Sensor();
    public Sensor AOC_B25GTemp = new Sensor();
    public Sensor nvme1_SSDTemp = new Sensor();
    public Sensor storageTemp = new Sensor();

    @Override
    public void fromRaw(byte[] raw) {
        Field[] fields;
        super.fromRaw(raw);
        int index = 0;
        for (Field field : fields = this.getClass().getDeclaredFields()) {
            try {
                ((Sensor)field.get(this)).fromRaw(ByteUtility.getBytes(raw, index, 12));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            index += 12;
        }
    }

    @Override
    public String toFormatedString() {
        StringBuffer formatedString = new StringBuffer();
        LinkedHashMap<Sensor, String[]> map = new LinkedHashMap<Sensor, String[]>();
        map.put(this.cpu1Temp, new String[]{"CPU1 Temp", "T"});
        map.put(this.cpu2Temp, new String[]{"CPU2 Temp", "T"});
        map.put(this.pchTemp, new String[]{"PCH Temp", "T"});
        map.put(this.cpu1vrm1Temp, new String[]{"CPU1VRM1 Temp", "T"});
        map.put(this.cpu1vrm2Temp, new String[]{"CPU1VRM2 Temp", "T"});
        map.put(this.cpu2vrm1Temp, new String[]{"CPU2VRM1 Temp", "T"});
        map.put(this.cpu2vrm2Temp, new String[]{"CPU2VRM2 Temp", "T"});
        map.put(this.dimmABCvrmTemp, new String[]{"VDIMMABCVRM Temp", "T"});
        map.put(this.dimmDEFvrmTemp, new String[]{"VDIMMDEFVRM Temp", "T"});
        map.put(this.dimmGHJvrmTemp, new String[]{"VDIMMGHJVRM Temp", "T"});
        map.put(this.dimmKLMvrmTemp, new String[]{"VDIMMKLMVRM Temp", "T"});
        map.put(this.system1Temp, new String[]{"System Temp", "T"});
        map.put(this.system2Temp, new String[]{"Peripheral Temp", "T"});
        map.put(this.inletTemp, new String[]{"Inlet Temp", "T"});
        map.put(this.AOC_B25GTemp, new String[]{"AOC-B25G Temp", "T"});
        map.put(this.AOC_IBHTemp, new String[]{"AOC-IBH Temp", "T"});
        map.put(this.AOC_OPHTemp, new String[]{"AOC-OPH Temp", "T"});
        map.put(this.lsiTemp, new String[]{"AOC-LSI Temp", "T"});
        map.put(this.AOM_B_4MTemp, new String[]{"AOM-B-4M Temp", "T"});
        map.put(this.dimmA1Temp, new String[]{"P1-DIMMA1 Temp", "T"});
        map.put(this.dimmA2Temp, new String[]{"P1-DIMMA2 Temp", "T"});
        map.put(this.dimmB1Temp, new String[]{"P1-DIMMB1 Temp", "T"});
        map.put(this.dimmC1Temp, new String[]{"P1-DIMMC1 Temp", "T"});
        map.put(this.dimmD1Temp, new String[]{"P1-DIMMD1 Temp", "T"});
        map.put(this.dimmD2Temp, new String[]{"P1-DIMMD2 Temp", "T"});
        map.put(this.dimmE1Temp, new String[]{"P1-DIMME1 Temp", "T"});
        map.put(this.dimmF1Temp, new String[]{"P1-DIMMF1 Temp", "T"});
        map.put(this.dimmG1Temp, new String[]{"P2-DIMMA1 Temp", "T"});
        map.put(this.dimmG2Temp, new String[]{"P2-DIMMA2 Temp", "T"});
        map.put(this.dimmH1Temp, new String[]{"P2-DIMMB1 Temp", "T"});
        map.put(this.dimmJ1Temp, new String[]{"P2-DIMMC1 Temp", "T"});
        map.put(this.dimmK1Temp, new String[]{"P2-DIMMD1 Temp", "T"});
        map.put(this.dimmK2Temp, new String[]{"P2-DIMMD2 Temp", "T"});
        map.put(this.dimmL1Temp, new String[]{"P2-DIMME1 Temp", "T"});
        map.put(this.dimmM1Temp, new String[]{"P2-DIMMF1 Temp", "T"});
        map.put(this.storageTemp, new String[]{"Storage Temp", "T"});
        map.put(this.v12, new String[]{"12V", "V"});
        map.put(this.v5, new String[]{"5VCC", "V"});
        map.put(this.v3P3, new String[]{"3.3VCC", "V"});
        map.put(this.vBAT, new String[]{"VBAT", "B"});
        map.put(this.vCPU1, new String[]{"Vcpu1", "V"});
        map.put(this.vCPU2, new String[]{"Vcpu2", "V"});
        map.put(this.vDIMMABC, new String[]{"VDIMMABC", "V"});
        map.put(this.vDIMMDEF, new String[]{"VDIMMDEF", "V"});
        map.put(this.vDIMMGHJ, new String[]{"VDIMMGHJ", "V"});
        map.put(this.vDIMMKLM, new String[]{"VDIMMKLM", "V"});
        map.put(this.v5SB, new String[]{"5VSB", "V"});
        map.put(this.v3P3SB, new String[]{"3.3VSB", "V"});
        map.put(this.pvnn, new String[]{"VNN PCH", "V"});
        map.put(this.p1v8, new String[]{"1.8V PCH", "V"});
        map.put(this.p1v05, new String[]{"1.05V PCH", "V"});
        map.put(this.watchdog, new String[]{"Watchdog", "W"});
        map.put(this.pwr, new String[]{"PW Consumption", "P"});
        map.put(this.nvme1_SSDTemp, new String[]{"NVMe1_SSDTemp", "T"});
        for (Map.Entry entry : map.entrySet()) {
            try {
                Sensor sensor = (Sensor)entry.getKey();
                String name = ((String[])entry.getValue())[0];
                String type = ((String[])entry.getValue())[1];
                if (sensor.reading == 0) {
                    formatedString.append(String.format(this.formatTemplate, "N/A", name, "N/A", "N/A", "N/A"));
                    continue;
                }
                if ("T".equalsIgnoreCase(type)) {
                    formatedString.append(String.format(this.formatTemplate, sensor.getStatusString(true), name, sensor.getHumanReading(sensor.reading) + "\u00b0C", sensor.getHumanReadingWithSign(sensor.min) + "\u00b0C", sensor.getHumanReadingWithSign(sensor.max) + "\u00b0C"));
                    continue;
                }
                if ("V".equalsIgnoreCase(type)) {
                    formatedString.append(String.format(this.formatTemplate, sensor.getStatusString(false), name, sensor.getHumanReading(sensor.reading) + " V", sensor.getHumanReading(sensor.min) + " V", sensor.getHumanReading(sensor.max) + " V"));
                    continue;
                }
                if ("B".equalsIgnoreCase(type)) {
                    formatedString.append(String.format(this.formatTemplate, this.vBAT.getStatusString(false).contains("Lower") ? this.vBAT.getStatusString(false) : "Normal", "VBAT", "presence", "N/A", "N/A"));
                    continue;
                }
                if ("W".equalsIgnoreCase(type)) {
                    formatedString.append(String.format(this.formatTemplate, "Normal", "Watchdog", this.getWatchDogStatus(this.watchdog.reading), "N/A", "N/A"));
                    continue;
                }
                if ("P".equalsIgnoreCase(type)) {
                    formatedString.append(String.format(this.formatTemplate, "Normal", "PW Consumption", this.pwr.getHumanReading(this.pwr.reading) + " W", "N/A", "N/A"));
                    continue;
                }
                MOut.G().println("Sensor Type Not Found.");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return formatedString.toString();
    }

    @Override
    public int getSensorDisplayNumber() {
        return 54;
    }
}

