/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.blade;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.blade.BladeEntity;
import com.supermicro.ipmi.blade.BladeSystemEntity;
import com.supermicro.ipmi.blade.FailureEntity;
import com.supermicro.ipmi.blade.MB_B7DBE_SensorEntity;
import com.supermicro.ipmi.blade.TemperatureData;
import java.util.ArrayList;

public class MB_B10DRI_SensorEntity
extends MB_B7DBE_SensorEntity {
    public static final String VCCP0 = "VCPU1";
    public static final String VCCP1 = "VCPU2";
    public static final String VDDQ_AB = "VDIMMAB";
    public static final String VDDQ_CD = "VDIMMCD";
    public static final String VDDQ_EF = "VDIMMEF";
    public static final String VDDQ_GH = "VDIMMGH";
    public static final String P1V05_PCH = "1.05V PCH";
    public static final String P1V5_PCH = "1.5V PCH";
    public static final String P1V2_AUX_BMC = "1.2V BMC";
    public static final String P3V3 = "3.3VCC";
    public static final String P3V3SB = "3.3VSB";
    public static final String P5V = "5VCC";
    public static final String P5VSB = "5VSB";
    public static final String P12V = "12V";
    public static final String CPU1VRMTemp = "CPU1 VRM";
    public static final String CPU2VRMTemp = "CPU2 VRM";
    public static final String DIMMABVRMTemp = "DIMMAB VRM";
    public static final String DIMMCDVRMTemp = "DIMMCD VRM";
    public static final String DIMMEFVRMTemp = "DIMMEF VRM";
    public static final String DIMMGHVRMTemp = "DIMMGH VRM";
    public static final String HOTSWAPTemp = "";
    public static final String IBTemp = "IB Temp";
    public static final String TenGTemp = "10G Temp";
    public static final String CurrPwr = "Power Consumption";
    public static final String SYSTEM_TEMP_1 = "System";
    public static final String SYSTEM_TEMP_2 = "Peripheral";
    public static final String PCH_TEMP = "PCH";
    public static final String DIMM_A1_TEMP = "DIMM_A1";
    public static final String DIMM_A2_TEMP = "DIMM_A2";
    public static final String DIMM_B1_TEMP = "DIMM_B1";
    public static final String DIMM_B2_TEMP = "DIMM_B2";
    public static final String DIMM_C1_TEMP = "DIMM_C1";
    public static final String DIMM_C2_TEMP = "DIMM_C2";
    public static final String DIMM_D1_TEMP = "DIMM_D1";
    public static final String DIMM_D2_TEMP = "DIMM_D2";
    public static final String DIMM_E1_TEMP = "DIMM_E1";
    public static final String DIMM_E2_TEMP = "DIMM_E2";
    public static final String DIMM_F1_TEMP = "DIMM_F1";
    public static final String DIMM_F2_TEMP = "DIMM_F2";
    public static final String DIMM_G1_TEMP = "DIMM_G1";
    public static final String DIMM_G2_TEMP = "DIMM_G2";
    public static final String DIMM_H1_TEMP = "DIMM_H1";
    public static final String DIMM_H2_TEMP = "DIMM_H2";
    public static final String LSI_TEMP = "LSI Temp";
    public static final String HDD0_TEMP = "HDD0 Temp";
    public static final String HDD1_TEMP = "HDD1 Temp";
    public static final String HDD2_TEMP = "HDD2 Temp";
    public static final String HDD3_TEMP = "HDD3 Temp";
    public static final String HDD4_TEMP = "HDD4 Temp";
    public static final String HDD5_TEMP = "HDD5 Temp";
    public static final String WATCHDOG = "Watchdog";
    protected byte vccp0;
    protected byte vccp1;
    protected byte vDIMMABVoltage;
    protected byte vDIMMCDVoltage;
    protected byte vDIMMEFVoltage;
    protected byte vDIMMGHVoltage;
    protected byte p1v05;
    protected byte p1v5;
    protected byte p1v2;
    protected byte p3v3;
    protected byte p3v3sb;
    protected byte p5v;
    protected byte p5vsb;
    protected byte p12v;
    protected byte system2Temp;
    protected byte cpu1vrmT;
    protected byte cpu2vrmT;
    protected byte dimABTemp;
    protected byte dimCDTemp;
    protected byte dimEFTemp;
    protected byte dimGHTemp;
    protected byte hotswapTemp;
    protected byte ibTemp;
    protected int pwr;
    protected byte pchTemp;
    protected byte dimmA1Temp;
    protected byte dimmA2Temp;
    protected byte dimmB1Temp;
    protected byte dimmB2Temp;
    protected byte dimmC1Temp;
    protected byte dimmC2Temp;
    protected byte dimmD1Temp;
    protected byte dimmD2Temp;
    protected byte dimmE1Temp;
    protected byte dimmE2Temp;
    protected byte dimmF1Temp;
    protected byte dimmF2Temp;
    protected byte dimmG1Temp;
    protected byte dimmG2Temp;
    protected byte dimmH1Temp;
    protected byte dimmH2Temp;
    protected byte lsiTemp;
    protected byte hdd0Temp;
    protected byte hdd1Temp;
    protected byte hdd2Temp;
    protected byte hdd3Temp;
    protected byte hdd4Temp;
    protected byte hdd5Temp;
    protected byte systemHealth;
    protected byte hdd0Status;
    protected byte hdd1Status;
    protected byte hdd2Status;
    protected byte hdd3Status;
    protected byte hdd4Status;
    protected byte hdd5Status;
    protected byte watchdog;
    protected byte cpu1TempLimit;
    protected byte cpu2TempLimit;
    protected byte staticPCHTempHighLimit = (byte)95;
    protected byte staticSystemTempHighLimit = (byte)85;

    @Override
    public boolean fromRaw(byte[] raw) {
        if (raw.length != BladeSystemEntity.MOTHER_BOARD_SENSORS_DATA_SIZE) {
            return false;
        }
        this.pollCount = raw[0];
        this.flag = raw[1];
        this.vccp0 = raw[2];
        this.vccp1 = raw[3];
        this.vDIMMABVoltage = raw[4];
        this.vDIMMCDVoltage = raw[5];
        this.vDIMMEFVoltage = raw[6];
        this.vDIMMGHVoltage = raw[7];
        this.p1v05 = raw[8];
        this.p1v5 = raw[9];
        this.p1v2 = raw[10];
        this.p3v3 = raw[11];
        this.p3v3sb = raw[12];
        this.p5v = raw[13];
        this.p5vsb = raw[14];
        this.p12v = raw[15];
        this.batteryVoltage = raw[16];
        this.remoteCPU1Temp = raw[17];
        this.remoteCPU2Temp = raw[18];
        this.systemTemp = raw[19];
        this.system2Temp = raw[20];
        this.pchTemp = raw[21];
        this.ibTemp = raw[23];
        this.cpu1vrmT = raw[24];
        this.cpu2vrmT = raw[25];
        this.dimABTemp = raw[26];
        this.dimCDTemp = raw[30];
        this.dimEFTemp = raw[31];
        this.dimGHTemp = raw[32];
        this.dimmA1Temp = raw[33];
        this.dimmA2Temp = raw[34];
        this.dimmB1Temp = raw[35];
        this.dimmB2Temp = raw[36];
        this.dimmC1Temp = raw[37];
        this.dimmC2Temp = raw[38];
        this.dimmD1Temp = raw[39];
        this.dimmD2Temp = raw[40];
        this.dimmE1Temp = raw[41];
        this.dimmE2Temp = raw[42];
        this.dimmF1Temp = raw[43];
        this.dimmF2Temp = raw[44];
        this.dimmG1Temp = raw[45];
        this.dimmG2Temp = raw[46];
        this.dimmH1Temp = raw[47];
        this.dimmH2Temp = raw[48];
        this.cpu1TempLimit = raw[49];
        this.cpu2TempLimit = raw[50];
        byte[] powerconsumption = new byte[2];
        System.arraycopy(raw, 51, powerconsumption, 0, 2);
        this.pwr = ByteUtility.twoBytesToInt(powerconsumption);
        this.lsiTemp = raw[53];
        this.hdd0Temp = raw[54];
        this.hdd1Temp = raw[55];
        this.hdd2Temp = raw[56];
        this.hdd3Temp = raw[57];
        this.hdd4Temp = raw[58];
        this.hdd5Temp = raw[59];
        this.systemHealth = raw[60];
        this.hdd0Status = raw[61];
        this.hdd1Status = raw[62];
        this.hdd2Status = raw[63];
        this.hdd3Status = raw[64];
        this.hdd4Status = raw[65];
        this.hdd5Status = raw[66];
        this.watchdog = raw[67];
        this.raw = raw;
        return true;
    }

    @Override
    public ArrayList generateFailureReport(BladeEntity bladeEntity, int moduleIndex) {
        ArrayList<FailureEntity> failures = new ArrayList<FailureEntity>();
        if (this.getFlag() != 1) {
            return failures;
        }
        if (this.checkRemoteCPU1Temp() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "CPU1 Temp"));
        }
        if (this.checkRemoteCPU2Temp() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "CPU2 Temp"));
        }
        if (this.checkSystemTemp() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, SYSTEM_TEMP_1));
        }
        if (this.checkSystemTemp2() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, SYSTEM_TEMP_2));
        }
        if (this.checkCpu1CoreVoltage() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, VCCP0));
        }
        if (this.checkCpu2CoreVoltage() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, VCCP1));
        }
        if (this.checkVDIMMABVoltage() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, VDDQ_AB));
        }
        if (this.checkVDIMMCDVoltage() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, VDDQ_CD));
        }
        if (this.checkVDIMMEFVoltage() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, VDDQ_EF));
        }
        if (this.checkVDIMMGHVoltage() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, VDDQ_GH));
        }
        if (this.checkp1v05() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, P1V05_PCH));
        }
        if (this.checkp1v5() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, P1V5_PCH));
        }
        if (this.checkp1v2() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, P1V2_AUX_BMC));
        }
        if (this.checkV3p3() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, P3V3));
        }
        if (this.checkV3p3sb() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, P3V3SB));
        }
        if (this.checkV5() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, P5V));
        }
        if (this.checkV5sb() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, P5VSB));
        }
        if (this.checkV12() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, P12V));
        }
        if (this.checkBatteryVoltage() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "VBAT"));
        }
        if (this.checkPCHTemp() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, PCH_TEMP));
        }
        if (this.checkIBTemp() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, IBTemp));
        }
        if (this.checkCPU1VRMTemp() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, CPU1VRMTemp));
        }
        if (this.checkCPU2VRMTemp() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, CPU2VRMTemp));
        }
        if (this.checkDIMMXXTemp(this.dimABTemp) == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, DIMMABVRMTemp));
        }
        if (this.checkDIMMXXTemp(this.dimCDTemp) == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, DIMMCDVRMTemp));
        }
        if (this.checkDIMMXXTemp(this.dimEFTemp) == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, DIMMEFVRMTemp));
        }
        if (this.checkDIMMXXTemp(this.dimGHTemp) == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, DIMMGHVRMTemp));
        }
        if (this.checkDIMMTemp(this.dimmA1Temp) == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, DIMM_A1_TEMP));
        }
        if (this.checkDIMMTemp(this.dimmA2Temp) == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, DIMM_A2_TEMP));
        }
        if (this.checkDIMMTemp(this.dimmB1Temp) == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, DIMM_B1_TEMP));
        }
        if (this.checkDIMMTemp(this.dimmB2Temp) == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, DIMM_B2_TEMP));
        }
        if (this.checkDIMMTemp(this.dimmC1Temp) == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, DIMM_C1_TEMP));
        }
        if (this.checkDIMMTemp(this.dimmC2Temp) == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, DIMM_C2_TEMP));
        }
        if (this.checkDIMMTemp(this.dimmD1Temp) == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, DIMM_D1_TEMP));
        }
        if (this.checkDIMMTemp(this.dimmD2Temp) == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, DIMM_D2_TEMP));
        }
        if (this.checkDIMMTemp(this.dimmE1Temp) == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, DIMM_E1_TEMP));
        }
        if (this.checkDIMMTemp(this.dimmE2Temp) == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, DIMM_E2_TEMP));
        }
        if (this.checkDIMMTemp(this.dimmF1Temp) == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, DIMM_F1_TEMP));
        }
        if (this.checkDIMMTemp(this.dimmF2Temp) == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, DIMM_F2_TEMP));
        }
        if (this.checkDIMMTemp(this.dimmG1Temp) == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, DIMM_G1_TEMP));
        }
        if (this.checkDIMMTemp(this.dimmG2Temp) == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, DIMM_G2_TEMP));
        }
        if (this.checkDIMMTemp(this.dimmH1Temp) == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, DIMM_H1_TEMP));
        }
        if (this.checkDIMMTemp(this.dimmH2Temp) == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, DIMM_H2_TEMP));
        }
        if (this.checkPower() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, CurrPwr));
        }
        if (this.checkLSITemp() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, LSI_TEMP));
        }
        if (this.checkHDDTemp(this.hdd0Temp) == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, HDD0_TEMP));
        }
        if (this.checkHDDTemp(this.hdd1Temp) == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, HDD1_TEMP));
        }
        if (this.checkHDDTemp(this.hdd2Temp) == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, HDD2_TEMP));
        }
        if (this.checkHDDTemp(this.hdd3Temp) == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, HDD3_TEMP));
        }
        if (this.checkHDDTemp(this.hdd4Temp) == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, HDD4_TEMP));
        }
        if (this.checkHDDTemp(this.hdd5Temp) == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, HDD5_TEMP));
        }
        return failures;
    }

    @Override
    public String toFormatedString() {
        this.formatedString = new StringBuffer();
        this.formatedString.append(String.format(this.formatTemplate, "Status", "Sensor", "Reading", "Low Limit", "High Limit"));
        this.formatedString.append(String.format(this.formatTemplate, "------", "------", "-------", "---------", "----------"));
        this.addRaw(this.checkRemoteCPU1Temp(), "CPU1 Temp", this.showCandF(this.getRemoteCPU1Temp()), "N/A", HOTSWAPTemp + this.showCandF(this.cpu1TempLimit));
        this.addRaw(this.checkRemoteCPU2Temp(), "CPU2 Temp", this.showCandF(this.getRemoteCPU2Temp()), "N/A", HOTSWAPTemp + this.showCandF(this.cpu2TempLimit));
        this.addRaw(this.checkSystemTemp(), SYSTEM_TEMP_1, this.showCandF(this.systemTemp), "N/A", HOTSWAPTemp + this.showCandF(this.getSystemHighTempLimit()));
        this.addRaw(this.checkSystemTemp2(), SYSTEM_TEMP_2, this.showCandF(this.system2Temp), "N/A", HOTSWAPTemp + this.showCandF(this.getSystemHighTempLimit()));
        this.addRaw(this.checkCPU1VRMTemp(), CPU1VRMTemp, this.showCandF(this.cpu1vrmT), "N/A", HOTSWAPTemp + this.showCandF(this.getCPUVRMTempHighLimit()));
        this.addRaw(this.checkCPU2VRMTemp(), CPU2VRMTemp, this.showCandF(this.cpu2vrmT), "N/A", HOTSWAPTemp + this.showCandF(this.getCPUVRMTempHighLimit()));
        this.addRaw(this.checkDIMMXXTemp(this.dimABTemp), DIMMABVRMTemp, this.showCandF(this.dimABTemp), "N/A", HOTSWAPTemp + this.showCandF(this.getDIMXXVRMHighTemp()));
        this.addRaw(this.checkDIMMXXTemp(this.dimCDTemp), DIMMCDVRMTemp, this.showCandF(this.dimCDTemp), "N/A", HOTSWAPTemp + this.showCandF(this.getDIMXXVRMHighTemp()));
        this.addRaw(this.checkDIMMXXTemp(this.dimEFTemp), DIMMEFVRMTemp, this.showCandF(this.dimEFTemp), "N/A", HOTSWAPTemp + this.showCandF(this.getDIMXXVRMHighTemp()));
        this.addRaw(this.checkDIMMXXTemp(this.dimGHTemp), DIMMGHVRMTemp, this.showCandF(this.dimGHTemp), "N/A", HOTSWAPTemp + this.showCandF(this.getDIMXXVRMHighTemp()));
        this.addRaw(this.checkPCHTemp(), PCH_TEMP, this.showCandF(this.pchTemp), "N/A", HOTSWAPTemp + this.showCandF(this.getControllerHighTempLimit()));
        this.addRaw(this.checkIBTemp(), IBTemp, this.showCandF(this.ibTemp), "N/A", HOTSWAPTemp + this.showCandF(this.getIBControllerHighLimit()));
        this.addRaw(this.checkLSITemp(), LSI_TEMP, this.showCandF(this.lsiTemp), "N/A", HOTSWAPTemp + this.showCandF(this.getLSITempLimit()));
        this.addRaw(this.checkDIMMTemp(this.dimmA1Temp), DIMM_A1_TEMP, this.showCandF(this.dimmA1Temp), "N/A", HOTSWAPTemp + this.showCandF((byte)85));
        this.addRaw(this.checkDIMMTemp(this.dimmA2Temp), DIMM_A2_TEMP, this.showCandF(this.dimmA2Temp), "N/A", HOTSWAPTemp + this.showCandF((byte)85));
        this.addRaw(this.checkDIMMTemp(this.dimmB1Temp), DIMM_B1_TEMP, this.showCandF(this.dimmB1Temp), "N/A", HOTSWAPTemp + this.showCandF((byte)85));
        this.addRaw(this.checkDIMMTemp(this.dimmB2Temp), DIMM_B2_TEMP, this.showCandF(this.dimmB2Temp), "N/A", HOTSWAPTemp + this.showCandF((byte)85));
        this.addRaw(this.checkDIMMTemp(this.dimmC1Temp), DIMM_C1_TEMP, this.showCandF(this.dimmC1Temp), "N/A", HOTSWAPTemp + this.showCandF((byte)85));
        this.addRaw(this.checkDIMMTemp(this.dimmC2Temp), DIMM_C2_TEMP, this.showCandF(this.dimmC2Temp), "N/A", HOTSWAPTemp + this.showCandF((byte)85));
        this.addRaw(this.checkDIMMTemp(this.dimmD1Temp), DIMM_D1_TEMP, this.showCandF(this.dimmD1Temp), "N/A", HOTSWAPTemp + this.showCandF((byte)85));
        this.addRaw(this.checkDIMMTemp(this.dimmD2Temp), DIMM_D2_TEMP, this.showCandF(this.dimmD2Temp), "N/A", HOTSWAPTemp + this.showCandF((byte)85));
        this.addRaw(this.checkDIMMTemp(this.dimmE1Temp), DIMM_E1_TEMP, this.showCandF(this.dimmE1Temp), "N/A", HOTSWAPTemp + this.showCandF((byte)85));
        this.addRaw(this.checkDIMMTemp(this.dimmE2Temp), DIMM_E2_TEMP, this.showCandF(this.dimmE2Temp), "N/A", HOTSWAPTemp + this.showCandF((byte)85));
        this.addRaw(this.checkDIMMTemp(this.dimmF1Temp), DIMM_F1_TEMP, this.showCandF(this.dimmF1Temp), "N/A", HOTSWAPTemp + this.showCandF((byte)85));
        this.addRaw(this.checkDIMMTemp(this.dimmF2Temp), DIMM_F2_TEMP, this.showCandF(this.dimmF2Temp), "N/A", HOTSWAPTemp + this.showCandF((byte)85));
        this.addRaw(this.checkDIMMTemp(this.dimmG1Temp), DIMM_G1_TEMP, this.showCandF(this.dimmG1Temp), "N/A", HOTSWAPTemp + this.showCandF((byte)85));
        this.addRaw(this.checkDIMMTemp(this.dimmG2Temp), DIMM_G2_TEMP, this.showCandF(this.dimmG2Temp), "N/A", HOTSWAPTemp + this.showCandF((byte)85));
        this.addRaw(this.checkDIMMTemp(this.dimmH1Temp), DIMM_H1_TEMP, this.showCandF(this.dimmH1Temp), "N/A", HOTSWAPTemp + this.showCandF((byte)85));
        this.addRaw(this.checkDIMMTemp(this.dimmH2Temp), DIMM_H2_TEMP, this.showCandF(this.dimmH2Temp), "N/A", HOTSWAPTemp + this.showCandF((byte)85));
        this.addRaw(this.checkHDDTemp(this.hdd0Temp), HDD0_TEMP, this.showCandF(this.hdd0Temp), "N/A", HOTSWAPTemp + this.showCandF(this.getHDDTempLimit()));
        this.addRaw(this.checkHDDTemp(this.hdd1Temp), HDD1_TEMP, this.showCandF(this.hdd1Temp), "N/A", HOTSWAPTemp + this.showCandF(this.getHDDTempLimit()));
        this.addRaw(this.checkHDDTemp(this.hdd2Temp), HDD2_TEMP, this.showCandF(this.hdd2Temp), "N/A", HOTSWAPTemp + this.showCandF(this.getHDDTempLimit()));
        this.addRaw(this.checkHDDTemp(this.hdd3Temp), HDD3_TEMP, this.showCandF(this.hdd3Temp), "N/A", HOTSWAPTemp + this.showCandF(this.getHDDTempLimit()));
        this.addRaw(this.checkHDDTemp(this.hdd4Temp), HDD4_TEMP, this.showCandF(this.hdd4Temp), "N/A", HOTSWAPTemp + this.showCandF(this.getHDDTempLimit()));
        this.addRaw(this.checkHDDTemp(this.hdd5Temp), HDD5_TEMP, this.showCandF(this.hdd5Temp), "N/A", HOTSWAPTemp + this.showCandF(this.getHDDTempLimit()));
        this.addRaw(this.checkCpu1CoreVoltage(), VCCP0, this.d2StrV(this.getCpu1CoreVoltageFormula()), this.d2StrV(this.getVccpLowLimit()), this.d2StrV(this.getVccpHighLimit()));
        this.addRaw(this.checkCpu2CoreVoltage(), VCCP1, this.d2StrV(this.getCpu2CoreVoltageFormula()), this.d2StrV(this.getVccpLowLimit()), this.d2StrV(this.getVccpHighLimit()));
        this.addRaw(this.checkVDIMMABVoltage(), VDDQ_AB, this.d2StrV(this.getVDIMMABVoltageFormula()), this.d2StrV(this.getVDIMMLowLimit()), this.d2StrV(this.getVDIMMHighLimit()));
        this.addRaw(this.checkVDIMMCDVoltage(), VDDQ_CD, this.d2StrV(this.getVDIMMCDVoltageFormula()), this.d2StrV(this.getVDIMMLowLimit()), this.d2StrV(this.getVDIMMHighLimit()));
        this.addRaw(this.checkVDIMMEFVoltage(), VDDQ_EF, this.d2StrV(this.getVDIMMEFVoltageFormula()), this.d2StrV(this.getVDIMMLowLimit()), this.d2StrV(this.getVDIMMHighLimit()));
        this.addRaw(this.checkVDIMMEFVoltage(), VDDQ_GH, this.d2StrV(this.getVDIMMGHVoltageFormula()), this.d2StrV(this.getVDIMMLowLimit()), this.d2StrV(this.getVDIMMHighLimit()));
        this.addRaw(this.checkp1v05(), P1V05_PCH, this.d2StrV(this.getP1V05Formula()), this.d2StrV(this.getP1V05LowLimit()), this.d2StrV(this.getP1V05HighLimit()));
        this.addRaw(this.checkp1v5(), P1V5_PCH, this.d2StrV(this.getP1V5Formula()), this.d2StrV(this.getP1V5LowLimit()), this.d2StrV(this.getP1V5HighLimit()));
        this.addRaw(this.checkp1v2(), P1V2_AUX_BMC, this.d2StrV(this.getP1V2Formula()), this.d2StrV(this.getP1V2LowLimit()), this.d2StrV(this.getP1V2HighLimit()));
        this.addRaw(this.checkV3p3(), P3V3, this.d2StrV(this.getV3p3Formula()), this.d2StrV(this.getP3V3LowLimit()), this.d2StrV(this.getP3V3HighLimit()));
        this.addRaw(this.checkV3p3sb(), P3V3SB, this.d2StrV(this.getV3p3sbFormula()), this.d2StrV(this.getP3V3LowLimit()), this.d2StrV(this.getP3V3HighLimit()));
        this.addRaw(this.checkV5(), P5V, this.d2StrV(this.getV5Formula()), this.d2StrV(this.getV5LowLimit()), this.d2StrV(this.getV5HighLimit()));
        this.addRaw(this.checkV5sb(), P5VSB, this.d2StrV(this.getV5sbFormula()), this.d2StrV(this.getV5LowLimit()), this.d2StrV(this.getV5HighLimit()));
        this.addRaw(this.checkV12(), P12V, this.d2StrV(this.getV12Formula()), this.d2StrV(this.getV12LowLimit()), this.d2StrV(this.getV12HighLimit()));
        this.addRaw(this.checkBatteryVoltage(), "VBAT", this.d2StrV(this.getBatteryVoltageFormula()), this.d2StrV(this.getBatteryVoltageLowLimit()), this.d2StrV(this.getBatteryVoltageHighLimit()));
        this.addRaw(this.checkPower(), CurrPwr, Integer.toString(this.pwr & 0xFF), "0", HOTSWAPTemp + this.getPowerHighLimit());
        this.addRaw(2, WATCHDOG, this.getWatchDogStatus(), "N/A", "N/A");
        return this.formatedString.toString();
    }

    @Override
    public ArrayList<TemperatureData> getTemperatures() {
        ArrayList<TemperatureData> list = new ArrayList<TemperatureData>();
        list.add(this.createTemperatureData(this.checkRemoteCPU1Temp(), "CPU1 Temp", this.showCandF(this.getRemoteCPU1Temp()), "N/A", HOTSWAPTemp + this.showCandF(this.cpu1TempLimit)));
        list.add(this.createTemperatureData(this.checkRemoteCPU2Temp(), "CPU2 Temp", this.showCandF(this.getRemoteCPU2Temp()), "N/A", HOTSWAPTemp + this.showCandF(this.cpu2TempLimit)));
        list.add(this.createTemperatureData(this.checkSystemTemp(), SYSTEM_TEMP_1, this.showCandF(this.getSystemTemp()), "N/A", HOTSWAPTemp + this.showCandF(this.staticSystemTempHighLimit)));
        list.add(this.createTemperatureData(this.checkSystemTemp2(), SYSTEM_TEMP_2, this.showCandF(this.system2Temp), "N/A", HOTSWAPTemp + this.showCandF(this.staticSystemTempHighLimit)));
        list.add(this.createTemperatureData(this.checkPCHTemp(), PCH_TEMP, this.showCandF(this.pchTemp), "N/A", HOTSWAPTemp + this.showCandF(this.getControllerHighTempLimit())));
        list.add(this.createTemperatureData(this.checkIBTemp(), IBTemp, this.showCandF(this.ibTemp), "N/A", HOTSWAPTemp + this.showCandF(this.getIBControllerHighLimit())));
        list.add(this.createTemperatureData(this.checkLSITemp(), LSI_TEMP, this.showCandF(this.lsiTemp), "N/A", HOTSWAPTemp + this.showCandF(this.getLSITempLimit())));
        list.add(this.createTemperatureData(this.checkCPU1VRMTemp(), CPU1VRMTemp, this.showCandF(this.cpu1vrmT), "N/A", HOTSWAPTemp + this.showCandF(this.getCPUVRMTempHighLimit())));
        list.add(this.createTemperatureData(this.checkCPU2VRMTemp(), CPU2VRMTemp, this.showCandF(this.cpu2vrmT), "N/A", HOTSWAPTemp + this.showCandF(this.getCPUVRMTempHighLimit())));
        list.add(this.createTemperatureData(this.checkDIMMXXTemp(this.dimABTemp), DIMMABVRMTemp, this.showCandF(this.dimABTemp), "N/A", HOTSWAPTemp + this.showCandF(this.getDIMXXVRMHighTemp())));
        list.add(this.createTemperatureData(this.checkDIMMXXTemp(this.dimCDTemp), DIMMCDVRMTemp, this.showCandF(this.dimCDTemp), "N/A", HOTSWAPTemp + this.showCandF(this.getDIMXXVRMHighTemp())));
        list.add(this.createTemperatureData(this.checkDIMMXXTemp(this.dimEFTemp), DIMMEFVRMTemp, this.showCandF(this.dimEFTemp), "N/A", HOTSWAPTemp + this.showCandF(this.getDIMXXVRMHighTemp())));
        list.add(this.createTemperatureData(this.checkDIMMXXTemp(this.dimGHTemp), DIMMGHVRMTemp, this.showCandF(this.dimGHTemp), "N/A", HOTSWAPTemp + this.showCandF(this.getDIMXXVRMHighTemp())));
        list.add(this.createTemperatureData(this.checkDIMMTemp(this.dimmA1Temp), DIMM_A1_TEMP, this.showCandF(this.dimmA1Temp), "N/A", HOTSWAPTemp + this.showCandF((byte)85)));
        list.add(this.createTemperatureData(this.checkDIMMTemp(this.dimmA2Temp), DIMM_A2_TEMP, this.showCandF(this.dimmA2Temp), "N/A", HOTSWAPTemp + this.showCandF((byte)85)));
        list.add(this.createTemperatureData(this.checkDIMMTemp(this.dimmB1Temp), DIMM_B1_TEMP, this.showCandF(this.dimmB1Temp), "N/A", HOTSWAPTemp + this.showCandF((byte)85)));
        list.add(this.createTemperatureData(this.checkDIMMTemp(this.dimmB2Temp), DIMM_B2_TEMP, this.showCandF(this.dimmB2Temp), "N/A", HOTSWAPTemp + this.showCandF((byte)85)));
        list.add(this.createTemperatureData(this.checkDIMMTemp(this.dimmC1Temp), DIMM_C1_TEMP, this.showCandF(this.dimmC1Temp), "N/A", HOTSWAPTemp + this.showCandF((byte)85)));
        list.add(this.createTemperatureData(this.checkDIMMTemp(this.dimmC2Temp), DIMM_C2_TEMP, this.showCandF(this.dimmC2Temp), "N/A", HOTSWAPTemp + this.showCandF((byte)85)));
        list.add(this.createTemperatureData(this.checkDIMMTemp(this.dimmD1Temp), DIMM_D1_TEMP, this.showCandF(this.dimmD1Temp), "N/A", HOTSWAPTemp + this.showCandF((byte)85)));
        list.add(this.createTemperatureData(this.checkDIMMTemp(this.dimmD2Temp), DIMM_D2_TEMP, this.showCandF(this.dimmD2Temp), "N/A", HOTSWAPTemp + this.showCandF((byte)85)));
        list.add(this.createTemperatureData(this.checkDIMMTemp(this.dimmE1Temp), DIMM_E1_TEMP, this.showCandF(this.dimmE1Temp), "N/A", HOTSWAPTemp + this.showCandF((byte)85)));
        list.add(this.createTemperatureData(this.checkDIMMTemp(this.dimmE2Temp), DIMM_E2_TEMP, this.showCandF(this.dimmE2Temp), "N/A", HOTSWAPTemp + this.showCandF((byte)85)));
        list.add(this.createTemperatureData(this.checkDIMMTemp(this.dimmF1Temp), DIMM_F1_TEMP, this.showCandF(this.dimmF1Temp), "N/A", HOTSWAPTemp + this.showCandF((byte)85)));
        list.add(this.createTemperatureData(this.checkDIMMTemp(this.dimmF2Temp), DIMM_F2_TEMP, this.showCandF(this.dimmF2Temp), "N/A", HOTSWAPTemp + this.showCandF((byte)85)));
        list.add(this.createTemperatureData(this.checkDIMMTemp(this.dimmG1Temp), DIMM_G1_TEMP, this.showCandF(this.dimmG1Temp), "N/A", HOTSWAPTemp + this.showCandF((byte)85)));
        list.add(this.createTemperatureData(this.checkDIMMTemp(this.dimmG2Temp), DIMM_G2_TEMP, this.showCandF(this.dimmG2Temp), "N/A", HOTSWAPTemp + this.showCandF((byte)85)));
        list.add(this.createTemperatureData(this.checkDIMMTemp(this.dimmH1Temp), DIMM_H1_TEMP, this.showCandF(this.dimmH1Temp), "N/A", HOTSWAPTemp + this.showCandF((byte)85)));
        list.add(this.createTemperatureData(this.checkDIMMTemp(this.dimmH2Temp), DIMM_H2_TEMP, this.showCandF(this.dimmH2Temp), "N/A", HOTSWAPTemp + this.showCandF((byte)85)));
        list.add(this.createTemperatureData(this.checkHDDTemp(this.hdd0Temp), HDD0_TEMP, this.showCandF(this.hdd0Temp), "N/A", HOTSWAPTemp + this.showCandF(this.getHDDTempLimit())));
        list.add(this.createTemperatureData(this.checkHDDTemp(this.hdd1Temp), HDD1_TEMP, this.showCandF(this.hdd1Temp), "N/A", HOTSWAPTemp + this.showCandF(this.getHDDTempLimit())));
        list.add(this.createTemperatureData(this.checkHDDTemp(this.hdd2Temp), HDD2_TEMP, this.showCandF(this.hdd2Temp), "N/A", HOTSWAPTemp + this.showCandF(this.getHDDTempLimit())));
        list.add(this.createTemperatureData(this.checkHDDTemp(this.hdd3Temp), HDD3_TEMP, this.showCandF(this.hdd3Temp), "N/A", HOTSWAPTemp + this.showCandF(this.getHDDTempLimit())));
        list.add(this.createTemperatureData(this.checkHDDTemp(this.hdd4Temp), HDD4_TEMP, this.showCandF(this.hdd4Temp), "N/A", HOTSWAPTemp + this.showCandF(this.getHDDTempLimit())));
        list.add(this.createTemperatureData(this.checkHDDTemp(this.hdd5Temp), HDD5_TEMP, this.showCandF(this.hdd5Temp), "N/A", HOTSWAPTemp + this.showCandF(this.getHDDTempLimit())));
        return list;
    }

    public double getVccpHighLimit() {
        return 2.09;
    }

    public double getVccpLowLimit() {
        return 1.26;
    }

    public double getVDIMMHighLimit() {
        return 1.42;
    }

    public double getVDIMMLowLimit() {
        return 0.98;
    }

    public double getP1V05HighLimit() {
        return 1.23;
    }

    public double getP1V05LowLimit() {
        return 0.9;
    }

    public double getP1V5HighLimit() {
        return 1.65;
    }

    public double getP1V5LowLimit() {
        return 1.35;
    }

    public double getP1V2HighLimit() {
        return 1.43;
    }

    public double getP1V2LowLimit() {
        return 1.11;
    }

    public double getP3V3HighLimit() {
        return 3.66;
    }

    public double getP3V3LowLimit() {
        return 2.84;
    }

    @Override
    public double getV5HighLimit() {
        return 5.55;
    }

    @Override
    public double getV5LowLimit() {
        return 4.3;
    }

    @Override
    public double getV12HighLimit() {
        return 13.32;
    }

    @Override
    public double getV12LowLimit() {
        return 10.32;
    }

    @Override
    public double getBatteryVoltageHighLimit() {
        return 3.6;
    }

    @Override
    public double getBatteryVoltageLowLimit() {
        return 2.5;
    }

    public double getPowerHighLimit() {
        return 550.0;
    }

    public byte getCPUVRMTempHighLimit() {
        return 92;
    }

    public byte getSystemHighTempLimit() {
        return 85;
    }

    public byte getDIMXXVRMHighTemp() {
        return 100;
    }

    public byte getControllerHighTempLimit() {
        return 95;
    }

    public byte getIBControllerHighLimit() {
        return 100;
    }

    public byte getLSITempLimit() {
        return 110;
    }

    public byte getHDDTempLimit() {
        return 85;
    }

    public void setVccp0(byte vccp0) {
        this.vccp0 = vccp0;
    }

    public void setVccp1(byte vccp1) {
        this.vccp1 = vccp1;
    }

    public void setvDIMMABVoltage(byte vDIMMABVoltage) {
        this.vDIMMABVoltage = vDIMMABVoltage;
    }

    public void setvDIMMCDVoltage(byte vDIMMCDVoltage) {
        this.vDIMMCDVoltage = vDIMMCDVoltage;
    }

    public void setvDIMMEFVoltage(byte vDIMMEFVoltage) {
        this.vDIMMEFVoltage = vDIMMEFVoltage;
    }

    public void setvDIMMGHVoltage(byte vDIMMGHVoltage) {
        this.vDIMMGHVoltage = vDIMMGHVoltage;
    }

    public byte getCpu1TempLimit() {
        return this.cpu1TempLimit;
    }

    public byte getCpu2TempLimit() {
        return this.cpu2TempLimit;
    }

    public byte getSystem2Temp() {
        return this.system2Temp;
    }

    public byte getPchTemp() {
        return this.pchTemp;
    }

    public byte getCpu1vrmT() {
        return this.cpu1vrmT;
    }

    public byte getCpu2vrmT() {
        return this.cpu2vrmT;
    }

    public byte getDimABTemp() {
        return this.dimABTemp;
    }

    public byte getDimCDTemp() {
        return this.dimCDTemp;
    }

    public byte getDimEFTemp() {
        return this.dimEFTemp;
    }

    public byte getDimGHTemp() {
        return this.dimGHTemp;
    }

    public byte getIbTemp() {
        return this.ibTemp;
    }

    public byte getDimmA1Temp() {
        return this.dimmA1Temp;
    }

    public byte getDimmA2Temp() {
        return this.dimmA2Temp;
    }

    public byte getDimmB1Temp() {
        return this.dimmB1Temp;
    }

    public byte getDimmB2Temp() {
        return this.dimmB2Temp;
    }

    public byte getDimmC1Temp() {
        return this.dimmC1Temp;
    }

    public byte getDimmC2Temp() {
        return this.dimmC2Temp;
    }

    public byte getDimmD1Temp() {
        return this.dimmD1Temp;
    }

    public byte getDimmD2Temp() {
        return this.dimmD2Temp;
    }

    public byte getDimmE1Temp() {
        return this.dimmE1Temp;
    }

    public byte getDimmE2Temp() {
        return this.dimmE2Temp;
    }

    public byte getDimmF1Temp() {
        return this.dimmF1Temp;
    }

    public byte getDimmF2Temp() {
        return this.dimmF2Temp;
    }

    public byte getDimmG1Temp() {
        return this.dimmG1Temp;
    }

    public byte getDimmG2Temp() {
        return this.dimmG2Temp;
    }

    public byte getDimmH1Temp() {
        return this.dimmH1Temp;
    }

    public byte getDimmH2Temp() {
        return this.dimmH2Temp;
    }

    public int getPwr() {
        return this.pwr & 0xFF;
    }

    public byte getLsiTemp() {
        return this.lsiTemp;
    }

    public byte getHdd0Temp() {
        return this.hdd0Temp;
    }

    public byte getHdd1Temp() {
        return this.hdd1Temp;
    }

    public byte getHdd2Temp() {
        return this.hdd2Temp;
    }

    public byte getHdd3Temp() {
        return this.hdd3Temp;
    }

    public byte getHdd4Temp() {
        return this.hdd4Temp;
    }

    public byte getHdd5Temp() {
        return this.hdd5Temp;
    }

    public String getWatchDogStatus() {
        String s = HOTSWAPTemp;
        switch (this.watchdog) {
            case 1: {
                s = "Tr. to Idle";
                break;
            }
            case 2: {
                s = "Tr. to Active";
                break;
            }
            case 4: {
                s = "Tr. to Busy";
            }
        }
        return s;
    }

    @Override
    public double getCpu1CoreVoltageFormula() {
        if (this.getRemoteCPU1Temp() == 7) {
            return 0.0;
        }
        return (double)(this.vccp0 & 0xFF) * 0.00977;
    }

    @Override
    public double getCpu2CoreVoltageFormula() {
        if (this.getRemoteCPU2Temp() == 7) {
            return 0.0;
        }
        return (double)(this.vccp1 & 0xFF) * 0.00977;
    }

    public double getVDIMMABVoltageFormula() {
        return (double)(this.vDIMMABVoltage & 0xFF) * 0.00977;
    }

    public double getVDIMMCDVoltageFormula() {
        return (double)(this.vDIMMCDVoltage & 0xFF) * 0.00977;
    }

    public double getVDIMMEFVoltageFormula() {
        return (double)(this.vDIMMEFVoltage & 0xFF) * 0.00977;
    }

    public double getVDIMMGHVoltageFormula() {
        return (double)(this.vDIMMGHVoltage & 0xFF) * 0.00977;
    }

    public double getP1V05Formula() {
        return (double)(this.p1v05 & 0xFF) * 0.00977;
    }

    public double getP1V5Formula() {
        return (double)(this.p1v5 & 0xFF) * 0.00977;
    }

    public double getP1V2Formula() {
        return (double)(this.p1v2 & 0xFF) * 0.00977;
    }

    @Override
    public double getV3p3Formula() {
        return (double)(this.p3v3 & 0xFF) * 0.01764;
    }

    public double getV3p3sbFormula() {
        return (double)(this.p3v3sb & 0xFF) * 0.01764;
    }

    @Override
    public double getV12Formula() {
        return (double)(this.p12v & 0xFF) * 0.06446;
    }

    @Override
    public double getV5Formula() {
        return (double)(this.p5v & 0xFF) * 0.02735;
    }

    @Override
    public double getV5sbFormula() {
        return (double)(this.p5vsb & 0xFF) * 0.02735;
    }

    @Override
    public double getBatteryVoltageFormula() {
        return (double)(this.batteryVoltage & 0xFF) * 0.029;
    }

    @Override
    public int checkCpu1CoreVoltage() {
        if (this.getRemoteCPU1Temp() == -127) {
            return 2;
        }
        if (this.getCpu1CoreVoltageFormula() == 0.0) {
            return 2;
        }
        if (this.getCpu1CoreVoltageFormula() <= this.getVccpLowLimit() || this.getCpu1CoreVoltageFormula() >= this.getVccpHighLimit()) {
            return 1;
        }
        return 0;
    }

    @Override
    public int checkCpu2CoreVoltage() {
        if (this.getRemoteCPU2Temp() == -127) {
            return 2;
        }
        if (this.getCpu2CoreVoltageFormula() == 0.0) {
            return 2;
        }
        if (this.getCpu2CoreVoltageFormula() <= this.getVccpLowLimit() || this.getCpu2CoreVoltageFormula() >= this.getVccpHighLimit()) {
            return 1;
        }
        return 0;
    }

    public int checkVDIMMABVoltage() {
        if (this.getRemoteCPU1Temp() == 7) {
            return 2;
        }
        if (this.getVDIMMABVoltageFormula() == 0.0) {
            return 2;
        }
        if (this.getVDIMMABVoltageFormula() <= this.getVDIMMLowLimit() || this.getVDIMMABVoltageFormula() >= this.getVDIMMHighLimit()) {
            return 1;
        }
        return 0;
    }

    public int checkVDIMMCDVoltage() {
        if (this.getRemoteCPU1Temp() == 7) {
            return 2;
        }
        if (this.getVDIMMCDVoltageFormula() == 0.0) {
            return 2;
        }
        if (this.getVDIMMCDVoltageFormula() <= this.getVDIMMLowLimit() || this.getVDIMMCDVoltageFormula() >= this.getVDIMMHighLimit()) {
            return 1;
        }
        return 0;
    }

    public int checkVDIMMEFVoltage() {
        if (this.getRemoteCPU2Temp() == 7) {
            return 2;
        }
        if (this.getVDIMMEFVoltageFormula() == 0.0) {
            return 2;
        }
        if (this.getVDIMMEFVoltageFormula() <= this.getVDIMMLowLimit() || this.getVDIMMEFVoltageFormula() >= this.getVDIMMHighLimit()) {
            return 1;
        }
        return 0;
    }

    public int checkVDIMMGHVoltage() {
        if (this.getRemoteCPU2Temp() == 7) {
            return 2;
        }
        if (this.getVDIMMGHVoltageFormula() == 0.0) {
            return 2;
        }
        if (this.getVDIMMGHVoltageFormula() <= this.getVDIMMLowLimit() || this.getVDIMMGHVoltageFormula() >= this.getVDIMMHighLimit()) {
            return 1;
        }
        return 0;
    }

    public int checkp1v05() {
        if (this.getP1V05Formula() == 0.0) {
            return 2;
        }
        if (this.getP1V05Formula() <= this.getP1V05LowLimit() || this.getP1V05Formula() >= this.getP1V05HighLimit()) {
            return 1;
        }
        return 0;
    }

    public int checkp1v5() {
        if (this.getP1V5Formula() == 0.0) {
            return 2;
        }
        if (this.getP1V5Formula() <= this.getP1V5LowLimit() || this.getP1V5Formula() >= this.getP1V5HighLimit()) {
            return 1;
        }
        return 0;
    }

    public int checkp1v2() {
        if (this.getP1V2Formula() == 0.0) {
            return 2;
        }
        if (this.getP1V2Formula() <= this.getP1V2LowLimit() || this.getP1V2Formula() >= this.getP1V2HighLimit()) {
            return 1;
        }
        return 0;
    }

    @Override
    public int checkV3p3() {
        if (this.getV3p3Formula() == 0.0) {
            return 2;
        }
        if (this.getV3p3Formula() <= this.getP3V3LowLimit() || this.getV3p3Formula() >= this.getP3V3HighLimit()) {
            return 1;
        }
        return 0;
    }

    public int checkV3p3sb() {
        if (this.getV3p3sbFormula() == 0.0) {
            return 2;
        }
        if (this.getV3p3sbFormula() <= this.getP3V3LowLimit() || this.getV3p3sbFormula() >= this.getP3V3HighLimit()) {
            return 1;
        }
        return 0;
    }

    @Override
    public int checkV12() {
        if (this.getV12Formula() == 0.0) {
            return 2;
        }
        if (this.getV12Formula() <= this.getV12LowLimit() || this.getV12Formula() >= this.getV12HighLimit()) {
            return 1;
        }
        return 0;
    }

    @Override
    public int checkV5() {
        if (this.getV5Formula() == 0.0) {
            return 2;
        }
        if (this.getV5Formula() <= this.getV5LowLimit() || this.getV5Formula() >= this.getV5HighLimit()) {
            return 1;
        }
        return 0;
    }

    @Override
    public int checkV5sb() {
        if (this.getV5sbFormula() == 0.0) {
            return 2;
        }
        if (this.getV5sbFormula() <= this.getV5LowLimit() || this.getV5sbFormula() >= this.getV5HighLimit()) {
            return 1;
        }
        return 0;
    }

    @Override
    public int checkBatteryVoltage() {
        if (this.getBatteryVoltageFormula() == 0.0) {
            return 2;
        }
        if (this.getBatteryVoltageFormula() <= this.getBatteryVoltageLowLimit() || this.getBatteryVoltageFormula() >= this.getBatteryVoltageHighLimit()) {
            return 1;
        }
        return 0;
    }

    @Override
    public int checkRemoteCPU1Temp() {
        if (this.getRemoteCPU1Temp() == -127) {
            return 2;
        }
        if (this.getRemoteCPU1Temp() < this.cpu1TempLimit) {
            return 0;
        }
        return 1;
    }

    @Override
    public int checkRemoteCPU2Temp() {
        if (this.getRemoteCPU2Temp() == -127) {
            return 2;
        }
        if (this.getRemoteCPU2Temp() < this.cpu2TempLimit) {
            return 0;
        }
        return 1;
    }

    @Override
    public int checkSystemTemp() {
        if (this.systemTemp < this.getSystemHighTempLimit()) {
            return 0;
        }
        return 1;
    }

    public int checkSystemTemp2() {
        if (this.system2Temp < this.getSystemHighTempLimit()) {
            return 0;
        }
        return 1;
    }

    public int checkPCHTemp() {
        if (this.pchTemp == 0) {
            return 2;
        }
        if (this.pchTemp < this.getControllerHighTempLimit()) {
            return 0;
        }
        return 1;
    }

    public int checkIBTemp() {
        if (this.ibTemp == 0) {
            return 2;
        }
        if (this.ibTemp < this.getIBControllerHighLimit()) {
            return 0;
        }
        return 1;
    }

    public int checkCPU1VRMTemp() {
        if (this.cpu1vrmT < this.getCPUVRMTempHighLimit()) {
            return 0;
        }
        return 1;
    }

    public int checkCPU2VRMTemp() {
        if (this.cpu2vrmT < this.getCPUVRMTempHighLimit()) {
            return 0;
        }
        return 1;
    }

    public int checkDIMMXXTemp(byte dimmXXTemp) {
        if (dimmXXTemp == 0) {
            return 2;
        }
        if ((dimmXXTemp & 0xFF) < this.getDIMXXVRMHighTemp()) {
            return 0;
        }
        return 1;
    }

    public int checkPower() {
        if (this.pwr == 0) {
            return 2;
        }
        if ((double)this.pwr < this.getPowerHighLimit()) {
            return 0;
        }
        return 1;
    }

    public int checkLSITemp() {
        if (this.lsiTemp == 0) {
            return 2;
        }
        if (this.lsiTemp <= this.getLSITempLimit()) {
            return 0;
        }
        return 1;
    }

    public int checkHDDTemp(byte hddx) {
        if (hddx == 0) {
            return 2;
        }
        if (hddx <= this.getHDDTempLimit()) {
            return 0;
        }
        return 1;
    }
}

