/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMICommand;
import com.supermicro.ipmi.IPMIInterface;
import com.supermicro.ipmi.IPMIMessage;

public class MDRRegionStatusCommand
extends IPMICommand {
    final byte intelRSDSpec = (byte)4;
    final byte smbiosRegion = 1;
    final byte iSCSIRegion = (byte)4;
    byte completionCode;
    int mdrVersion;
    int dataRegionID;
    byte dataValidation;
    int updateCount;
    int lockStatus;
    int maxRegionSize;
    int usedRegionSize;
    int regionChecksum;
    boolean isMDRVersion = false;
    boolean isDataRegionID = false;
    boolean isDataValidation = false;
    boolean isUpdateCount = false;
    boolean isLockStatus = false;
    boolean isMaxRegionSize = false;
    boolean isUsedRegionSize = false;
    boolean isRegionChecksum = false;

    public MDRRegionStatusCommand(IPMIInterface ipmiInterface) {
        super(ipmiInterface);
    }

    public byte getCompletionCode() {
        return this.completionCode;
    }

    public byte getValid() {
        return this.dataValidation;
    }

    public int getMDRVersion() {
        return this.mdrVersion;
    }

    public String getDataRegionID() {
        switch (this.dataRegionID) {
            case 1: {
                return "SMBIOS table";
            }
            case 4: {
                return "iSCSI Boot Options";
            }
        }
        return "Reserved";
    }

    public String getDataValidation() {
        switch (this.dataValidation) {
            case 0: {
                return "Invalid data";
            }
            case 1: {
                return "Valid data";
            }
        }
        return "Invalid data";
    }

    public int getUpdateCount() {
        return this.updateCount;
    }

    public String getLockStatus() {
        switch (this.lockStatus) {
            case 0: {
                return "Unlocked";
            }
            case 1: {
                return "Strict lock";
            }
            case 2: {
                return "Preemptable Lock";
            }
        }
        return "Reserved";
    }

    public int getMaxRegionSize() {
        return this.maxRegionSize;
    }

    public int getUsedRegionSize() {
        return this.usedRegionSize;
    }

    public int getRegionChecksum() {
        return this.regionChecksum;
    }

    public MDRRegionStatusCommand getMDRRegionStatus() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{4, 1};
        ipmiMessage.setCommandAndData((byte)-80, (byte)32, data);
        IPMIMessage resMessage = this.getIPMIInterface().send(ipmiMessage);
        MDRRegionStatusCommand mdrRegionStatus = new MDRRegionStatusCommand(this.getIPMIInterface());
        mdrRegionStatus.completionCode = resMessage.completionCode;
        if (resMessage != null && this.completionCode == 0) {
            try {
                mdrRegionStatus.mdrVersion = resMessage.data[1];
                mdrRegionStatus.isMDRVersion = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                mdrRegionStatus.dataRegionID = resMessage.data[2];
                mdrRegionStatus.isDataRegionID = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                mdrRegionStatus.dataValidation = resMessage.data[3];
                mdrRegionStatus.isDataValidation = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                mdrRegionStatus.updateCount = resMessage.data[4];
                mdrRegionStatus.isUpdateCount = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                mdrRegionStatus.lockStatus = resMessage.data[5];
                mdrRegionStatus.isLockStatus = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                byte[] MaxRegionSizeByte = new byte[]{resMessage.data[6], resMessage.data[7]};
                mdrRegionStatus.maxRegionSize = ByteUtility.twoBytesToIntLSB(MaxRegionSizeByte);
                mdrRegionStatus.isMaxRegionSize = true;
            }
            catch (Exception MaxRegionSizeByte) {
                // empty catch block
            }
            try {
                byte[] UsedRegionSizeByte = new byte[]{resMessage.data[8], resMessage.data[9]};
                mdrRegionStatus.usedRegionSize = ByteUtility.twoBytesToIntLSB(UsedRegionSizeByte);
                mdrRegionStatus.isUsedRegionSize = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                mdrRegionStatus.regionChecksum = resMessage.data[10];
                mdrRegionStatus.isRegionChecksum = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return mdrRegionStatus;
    }

    public String toFormatedHeader() {
        String formatTemplate = " %-24s | %24s \n";
        StringBuffer header = new StringBuffer();
        header.append(String.format(formatTemplate, "Item", "Value"));
        header.append(String.format(formatTemplate, "----", "-----"));
        return header.toString();
    }

    public String toFormatedString() {
        String format = " %-24s | %24s \n";
        StringBuffer fStr = new StringBuffer();
        fStr.append(String.format(format, "MDR Version", this.isMDRVersion ? Integer.valueOf(this.getMDRVersion()) : "N/A"));
        fStr.append(String.format(format, "Data Region ID", this.isDataRegionID ? this.getDataRegionID() : "N/A"));
        fStr.append(String.format(format, "Data Validation", this.isDataValidation ? this.getDataValidation() : "N/A"));
        fStr.append(String.format(format, "Update Count", this.isUpdateCount ? Integer.valueOf(this.getUpdateCount()) : "N/A"));
        fStr.append(String.format(format, "Lock Status", this.isLockStatus ? this.getLockStatus() : "N/A"));
        fStr.append(String.format(format, "Max Region Size", this.isMaxRegionSize ? Integer.valueOf(this.getMaxRegionSize()) : "N/A"));
        fStr.append(String.format(format, "Used Region Size", this.isUsedRegionSize ? Integer.valueOf(this.getUsedRegionSize()) : "N/A"));
        fStr.append(String.format(format, "Region Checksum", this.isRegionChecksum ? Integer.valueOf(this.getRegionChecksum()) : "N/A"));
        return fStr.toString();
    }
}

