/*
 * Decompiled with CFR 0.152.
 */
package nn.pp.sara;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Label;
import java.awt.Panel;
import java.util.Locale;
import nn.pp.rc.SasEvent;
import nn.pp.rckbd.KbdFactory;
import nn.pp.rckbd.KeyEventHandler;
import nn.pp.rckbd.SoftKbd;
import nn.pp.sara.InfoPanel;
import nn.pp.sara.InfoPanelPart;

class KeyboardPanel
extends InfoPanelPart {
    Label filteredLabel;
    boolean hasSource;
    SoftKbd kbd;
    KbdFactory kbdFactory = KbdFactory.getInstance();
    KeyEventHandler keh;

    KeyboardPanel(InfoPanel info, Locale mapping, String defkbd) {
        super(info, true);
        if (defkbd == null || defkbd.length() < 2) {
            defkbd = "pc104";
        }
        this.keh = new KeyEventHandler(this.kbdFactory.getKbdLayout(defkbd));
        this.kbd = this.kbdFactory.getSoftKbd(this.keh, mapping, "", false);
    }

    @Override
    String getHeader() {
        return "Keyboard Events";
    }

    @Override
    void addPartLayout() {
        Panel p = new Panel(new BorderLayout());
        Panel p2 = new Panel(new BorderLayout());
        this.filteredLabel = new Label();
        p2.add((Component)this.filteredLabel, "Center");
        p.add((Component)this.kbd.getAsPanel(), "Center");
        p.add((Component)p2, "South");
        this.add((Component)p, "Center");
    }

    private String getKeyName(Short keyno) {
        if (keyno == 127) {
            return "(filtered)";
        }
        String s = this.keh.getKeyString(keyno);
        if (s != null) {
            return "'" + s + "'";
        }
        return "0x" + Integer.toHexString(keyno.intValue());
    }

    @Override
    void handlePartSasEvent(SasEvent evt) {
        int keyno = evt.inputEvent.keycode;
        boolean down = (keyno & 0x80) == 128;
        Short sKeyno = new Short((short)(keyno &= 0x7F));
        if (keyno == 127) {
            if (down) {
                this.filteredLabel.setText("Filtered keys");
            } else {
                this.filteredLabel.setText("");
            }
        } else if (down) {
            this.keh.internalPressed(sKeyno, KeyEventHandler.KEYBOARD);
        } else {
            this.keh.released(sKeyno, KeyEventHandler.KEYBOARD);
        }
        String s = "Key " + this.getKeyName(sKeyno) + " ";
        s = down ? s + "pressed" : s + "released";
        this.info.newEvent(evt, "Keyboard", s);
    }

    public void newKbdMapping(Locale locale) {
        this.kbd.setMapping(locale);
    }

    public void newKbdLayout(String layout) {
        this.kbd.setLayout(layout);
        this.info.pack();
    }
}

