/*
 * Decompiled with CFR 0.152.
 */
package nn.pp.rc;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import nn.pp.rc.ImageLoader;
import nn.pp.rc.MouseHandler;
import nn.pp.rc.RCHandler;
import nn.pp.rc.RCRenderer;
import nn.pp.rc.ServerConsolePanelBase;
import nn.pp.rc.T;
import nn.pp.rckbd.KbdFactory;
import nn.pp.rckbd.KeyEventHandler;
import nn.pp.rckbd.KeyTranslator;
import nn.pp.rckbd.KeyTranslator_ja;
import smc.ext.KeyboardHook;
import smc.ext.OSDView;

public class RCCanvasPanel
extends Panel
implements OSDView {
    KeyboardHook keyhook;
    ServerConsolePanelBase scp;
    PrintStream logger;
    RCHandler rchandler;
    KeyEventHandler keyevth;
    KeyTranslator keytrans;
    MouseHandler mhandler;
    Locale locale;
    Hashtable hashMouseSync;
    boolean bMouseSyncCombo;
    int syncState;
    String[] synckeycodes;
    public Dimension mysize;
    Dimension scalesize;
    double scaleX = 1.0;
    double scaleY = 1.0;
    boolean is100pc = true;
    boolean scaleToFit = false;
    boolean interpol = false;
    boolean debug = false;
    boolean monitorMode;
    Image logo;
    public static Image customizedLogo = null;
    RCRenderer rdr;
    long eventMask = 131132L;
    int buttonmask = 0;

    public RCCanvasPanel(ServerConsolePanelBase scp, Locale locale, PrintStream logger, int initWidth, int initHeight, boolean monitorMode, KeyEventHandler keyevth, String synckeycodes) {
        this.logger = logger;
        this.monitorMode = monitorMode;
        this.keyevth = keyevth;
        this.scp = scp;
        this.locale = locale;
        try {
            this.enableInputMethods(false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.keytrans = KbdFactory.getInstance().getKeyTranslator(keyevth.getActualLayout().getName(), locale);
        this.scalesize = this.mysize = new Dimension(initWidth, initHeight);
        this.enableEvents(this.eventMask);
        try {
            this.initMouseSync(synckeycodes);
        }
        catch (ParseException e) {
            logger.println(T._("Console: Mousesync hotkey error:") + " " + e);
        }
        ImageLoader imgloader = new ImageLoader(null);
        this.logo = customizedLogo != null ? customizedLogo : imgloader.loadImage("nn/pp/rc/SM_Logo.gif");
        this.keyhook = new KeyboardHook();
    }

    public void setLogo(Image logo) {
        this.logo = logo;
    }

    public void setRCHandler(RCHandler rchandler) {
        if (this.rchandler != null) {
            this.keyevth.removeKeyboardListener(this.rchandler);
        }
        this.rchandler = rchandler;
        this.keyevth.addKeyboardListener(this.rchandler);
        this.rdr = rchandler.getRenderer();
        this.rdr.setInterpol(this.interpol);
        this.keyhook.setOsdManager(this.rdr.getOSDManager());
        this.rdr.getOSDManager().setOsdView(this);
        this.keyhook.initBladeKVMSwitch(this.scp.profile.remoteHost, this.scp.profile.username, this.scp.profile.password);
    }

    @Override
    public void repaintOSD() {
        this.repaint();
    }

    public void setRCRenderer(RCRenderer rdr) {
        this.rdr = rdr;
        this.keyhook.setOsdManager(rdr.getOSDManager());
    }

    public void setMouseHandler(MouseHandler mhandler) {
        this.mhandler = mhandler;
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public void paint(Graphics g) {
        if (this.rdr != null) {
            this.rdr.paint(g, !this.is100pc, this.scalesize);
        } else {
            g.setColor(Color.white);
            g.fillRect(0, 0, this.getSize().width, this.getSize().height);
            g.drawImage(this.logo, this.getSize().width / 2 - this.logo.getWidth(this) / 2, this.getSize().height / 2 - this.logo.getHeight(this) / 2, this);
        }
    }

    @Override
    public String toString() {
        if (this.rchandler == null) {
            return T._("Console not connected");
        }
        return MessageFormat.format(T._("Console({0}): Desktop size is {1} x {2}"), this.rchandler, new Integer(this.mysize.width), new Integer(this.mysize.height));
    }

    @Override
    public Dimension getPreferredSize() {
        return this.scalesize;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.scalesize;
    }

    public void setKbdLocale(Locale locale) {
        this.keytrans = KbdFactory.getInstance().getKeyTranslator(this.keyevth.getActualLayout().getName(), locale);
    }

    public void setMonitorMode(boolean mode) {
        this.monitorMode = mode;
        if (this.rchandler != null) {
            this.rchandler.proto.setMonitorMode(mode);
        }
    }

    public void adjustSize(Dimension newsize, boolean force) {
        if (force || newsize.width != this.mysize.width || newsize.height != this.mysize.height) {
            this.mysize = newsize;
            if (this.rdr != null) {
                this.rdr.setRenderSize(this.mysize);
            }
            if (this.scaleToFit) {
                this.setScaleToFit(this.scp.getBlankSize());
            } else {
                Dimension sz = this.setScaledDimension(newsize.width, newsize.height);
                this.scp.canvasSizeChanged(sz);
            }
            this.logger.println(this);
        }
    }

    public void forceAdjustSize() {
        this.adjustSize(this.mysize, true);
    }

    public void setInterpol(boolean interpol) {
        this.interpol = interpol;
        this.rdr.setInterpol(interpol);
    }

    public void setScale(double sx, double sy) {
        if (sx > 0.95 && sx < 1.05 && sy > 0.95 && sy < 1.05) {
            if (this.is100pc) {
                return;
            }
            this.is100pc = true;
            this.scaleY = 1.0;
            this.scaleX = 1.0;
        } else {
            this.is100pc = false;
            this.scaleX = sx;
            this.scaleY = sy;
        }
        Dimension newd = this.setScaledDimension(this.mysize.width, this.mysize.height);
        if (!this.scaleToFit) {
            this.scp.canvasSizeChanged(newd);
        }
    }

    public void setScaleToFit(boolean stf) {
        if (stf == this.scaleToFit) {
            return;
        }
        this.scaleToFit = stf;
        if (this.scaleToFit) {
            this.setScaleToFit(this.scp.getBlankSize());
        } else {
            this.setScale(1.0, 1.0);
        }
    }

    private void setScaleToFit(Dimension d) {
        this.setScale((double)d.width / (double)this.mysize.width, (double)d.height / (double)this.mysize.height);
    }

    private Dimension setScaledDimension(int width, int height) {
        this.scalesize = new Dimension((int)(this.scaleX * (double)width), (int)(this.scaleY * (double)height));
        this.setSize(this.scalesize);
        return this.scalesize;
    }

    @Override
    public void processEvent(AWTEvent e) {
        block23: {
            if (this.rchandler == null) {
                return;
            }
            if (this.debug && e instanceof KeyEvent) {
                this.logger.println(e);
            }
            try {
                block24: {
                    Short keynr;
                    KeyEvent ke;
                    int eID;
                    block25: {
                        block27: {
                            block26: {
                                eID = e.getID();
                                if (e instanceof ComponentEvent && eID == 101 && this.scaleToFit) {
                                    ServerConsolePanelBase scp = (ServerConsolePanelBase)e.getSource();
                                    this.setScaleToFit(scp.getBlankSize());
                                }
                                if (e instanceof MouseEvent) {
                                    MouseEvent me = (MouseEvent)e;
                                    if (!this.is100pc) {
                                        int mx = me.getX();
                                        int my = me.getY();
                                        me.translatePoint((int)((double)mx / this.scaleX) - mx, (int)((double)my / this.scaleY) - my);
                                    }
                                    if (me.getX() >= this.mysize.width || me.getY() >= this.mysize.height) {
                                        return;
                                    }
                                    this.mhandler.handleMouseEvent(me);
                                    break block23;
                                }
                                if (!(e instanceof KeyEvent)) break block24;
                                if (this.keyhook.keyboardHook((KeyEvent)e)) {
                                    this.repaint();
                                }
                                ke = (KeyEvent)e;
                                if (eID != 402) break block25;
                                if (!ke.isAltDown()) break block26;
                                if (ke.getKeyCode() == 10) break block27;
                            }
                            if (!ke.isAltDown()) break block25;
                            if (ke.getKeyCode() != 122) break block25;
                        }
                        if (this.scp.isFullScreenMode) {
                            this.scp.changeMode();
                            ke.consume();
                            return;
                        }
                        int reuslt = JOptionPane.showConfirmDialog(null, T._("Would you like to change to full screen mode") + " ?", T._("Confirmation"), 0);
                        if (reuslt == 0) {
                            JOptionPane.showMessageDialog(null, T._("Press Alt+Enter to return to window mode"), T._("Info"), 1);
                            this.scp.changeMode();
                            ke.consume();
                            return;
                        }
                    }
                    if (null == (keynr = this.keytrans.translateKeyEvent(ke))) {
                        if (400 != eID) {
                            System.out.println("ERROR: no key number found for " + e);
                        }
                        return;
                    }
                    if (this.debug) {
                        System.out.println("Key Translator " + this.keytrans.getLocale() + " found key number: " + keynr);
                    }
                    this.handleMouseSyncKey(keynr, eID);
                    if (this.keytrans instanceof KeyTranslator_ja && (keynr.intValue() >= 108 || keynr.intValue() == 0)) {
                        if (eID == 401) {
                            this.keyevth.handleHardKbdEvent(keynr, 400);
                        }
                    } else {
                        this.keyevth.handleHardKbdEvent(keynr, eID);
                    }
                    ke.consume();
                    break block23;
                }
                if (e instanceof FocusEvent) {
                    this.keyevth.releaseAllKeys();
                }
            }
            catch (Exception f) {
                f.printStackTrace();
            }
        }
    }

    public void sendDVOString() {
        KeyEvent keyEvent1 = new KeyEvent(this, 400, 0L, 0, 0, 'D', 0);
        KeyEvent keyEvent2 = new KeyEvent(this, 401, 0L, 0, 68, 'D', 0);
        KeyEvent keyEvent3 = new KeyEvent(this, 402, 0L, 0, 68, 'D', 0);
        KeyEvent keyEvent4 = new KeyEvent(this, 400, 0L, 0, 0, 'V', 0);
        KeyEvent keyEvent5 = new KeyEvent(this, 401, 0L, 0, 86, 'V', 0);
        KeyEvent keyEvent6 = new KeyEvent(this, 402, 0L, 0, 86, 'V', 0);
        KeyEvent keyEvent7 = new KeyEvent(this, 400, 0L, 0, 0, 'O', 0);
        KeyEvent keyEvent8 = new KeyEvent(this, 401, 0L, 0, 79, 'O', 0);
        KeyEvent keyEvent9 = new KeyEvent(this, 402, 0L, 0, 79, 'O', 0);
        KeyEvent keyEvent10 = new KeyEvent(this, 400, 0L, 0, 0, '\n', 0);
        KeyEvent keyEvent11 = new KeyEvent(this, 401, 0L, 0, 10, '\n', 0);
        KeyEvent keyEvent12 = new KeyEvent(this, 402, 0L, 0, 10, '\n', 0);
        this.processEvent(keyEvent1);
        this.delay();
        this.processEvent(keyEvent2);
        this.delay();
        this.processEvent(keyEvent3);
        this.delay();
        this.processEvent(keyEvent4);
        this.delay();
        this.processEvent(keyEvent5);
        this.delay();
        this.processEvent(keyEvent6);
        this.delay();
        this.processEvent(keyEvent7);
        this.delay();
        this.processEvent(keyEvent8);
        this.delay();
        this.processEvent(keyEvent9);
        this.delay();
        this.processEvent(keyEvent10);
        this.delay();
        this.processEvent(keyEvent11);
        this.delay();
        this.processEvent(keyEvent12);
        this.delay();
    }

    public void delay() {
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void handleMouseSyncKey(Short keynr, int eID) {
        if (this.hashMouseSync.isEmpty()) {
            return;
        }
        switch (eID) {
            case 401: {
                if (!this.hashMouseSync.containsKey(keynr)) break;
                this.hashMouseSync.put(keynr, new Boolean(true));
                break;
            }
            case 402: {
                if (!this.hashMouseSync.containsKey(keynr)) break;
                this.hashMouseSync.put(keynr, new Boolean(false));
            }
        }
        if (!this.hashMouseSync.contains(new Boolean(false))) {
            if (this.debug) {
                System.out.println("Sync: all keys pressed");
            }
            if (this.bMouseSyncCombo) {
                this.mhandler.handleMouseSyncKey();
                this.bMouseSyncCombo = false;
            }
        }
        if (!this.hashMouseSync.contains(new Boolean(true))) {
            this.bMouseSyncCombo = true;
        }
    }

    public void initMouseSync(String kcodes) throws ParseException {
        this.bMouseSyncCombo = true;
        this.hashMouseSync = new Hashtable();
        if (kcodes == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(kcodes);
        while (st.hasMoreTokens()) {
            try {
                int c = Integer.parseInt(st.nextToken(), 16);
                if (this.debug) {
                    System.out.println("Sync: parsed keyNo: " + c);
                }
                this.hashMouseSync.put(new Short((short)c), new Boolean(false));
            }
            catch (NumberFormatException e) {
                throw new ParseException(kcodes, 0);
            }
        }
    }

    public void switchKvmPort(short newport) {
        if (this.rchandler == null) {
            return;
        }
        try {
            this.rchandler.writeKvmSwitchEvent(newport);
        }
        catch (IOException e) {
            this.logger.println(T._("Console: Kvm port switch error:") + " " + e.getMessage());
        }
    }

    public void close() {
        this.keyhook.getBladeKVMSwitch().closeConnection();
        this.disableEvents(this.eventMask);
        this.rdr = null;
        this.repaint();
    }

    public void enableEvent() {
        this.enableEvents(this.eventMask);
    }
}

