/*
 * Decompiled with CFR 0.152.
 */
package nn.pp.rc;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import nn.pp.rc.JVMVersionInfo;

public class ImageLoader {
    private Hashtable imghash;
    Toolkit kit = Toolkit.getDefaultToolkit();
    private URL codeBase;
    private JVMVersionInfo verInfo;

    public ImageLoader(URL codeBase) {
        this.imghash = new Hashtable(5);
        this.verInfo = JVMVersionInfo.getJVMVersionInfo();
        this.codeBase = codeBase;
    }

    public Image loadImage(String imgname) {
        Image img = null;
        if (null != imgname && null == (img = (Image)this.imghash.get(imgname))) {
            String jv = System.getProperty("java.vendor");
            if (jv.startsWith("Netscape")) {
                img = this.getImageOldJava(imgname);
            } else if (this.verInfo.isPJava()) {
                if (this.codeBase != null) {
                    try {
                        URL imurl = new URL(this.codeBase, "/" + imgname);
                        img = Toolkit.getDefaultToolkit().getImage(imurl);
                    }
                    catch (MalformedURLException imurl) {}
                }
            } else {
                URL imurl = this.getClass().getClassLoader().getResource(imgname);
                img = Toolkit.getDefaultToolkit().getImage(imurl);
            }
            if (img != null) {
                this.imghash.put(imgname, img);
            }
        }
        return img;
    }

    private Image getImageOldJava(String imgname) {
        Image img = null;
        try {
            InputStream in = this.getClass().getClassLoader().getResourceAsStream(imgname);
            if (null == in) {
                return null;
            }
            byte[] buffer = new byte[in.available()];
            in.read(buffer);
            img = Toolkit.getDefaultToolkit().createImage(buffer);
        }
        catch (IOException e) {
            System.err.println("ImageLoader: getImageOldJava: " + e);
        }
        return img;
    }
}

