/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.NM20AbstractCommand;
import nn.pp.drvredir.ByteUtility;

public class NM20CPUCoreCommand
extends NM20AbstractCommand {
    @Override
    public void runNM20Command() throws Exception {
        if (this.parameters != null && this.parameters.length == 1) {
            int cores = 0;
            String para1 = this.parameters[0];
            try {
                cores = Integer.parseInt(para1);
            }
            catch (NumberFormatException ex) {
                MOut.G(this).print(ex.getMessage());
                this.statusCode = 147;
                return;
            }
            try {
                this.ipmiNM20Command.setMaxAllowedCPUCores((byte)0, cores);
                MOut.G(this).print("Done");
            }
            catch (Exception ex1) {
                MOut.G(this).println(ex1.getMessage());
                MOut.G(this).println("(Node Manager should be disabled for setting CPU cores)");
                this.statusCode = 148;
                return;
            }
            this.statusCode = 0;
            return;
        }
        try {
            int cores = this.ipmiNM20Command.getMaxAllowedCPUCores((byte)0);
            byte[] nOfCPUCores = this.ipmiNM20Command.getNumberOfCPUCoresRequest((byte)0);
            int CPUNumber = this.ipmiNM20Command.getHostCPUData((byte)0).getNumberOfInstalledCPU();
            MOut.G(this).println("Current Max allowed cores   = " + cores);
            MOut.G(this).println("Number of logical processors on the platform = " + ByteUtility.twoBytesToIntLSB(nOfCPUCores));
            MOut.G(this).println("Number of installed processor packages    = " + CPUNumber);
            if (CPUNumber != 0) {
                MOut.G(this).println("Number of logical cores on each processor = " + ByteUtility.twoBytesToIntLSB(nOfCPUCores) / CPUNumber);
            }
        }
        catch (Exception ex) {
            MOut.G(this).println(ex.getMessage());
            this.statusCode = 148;
            return;
        }
        this.statusCode = 0;
    }
}

