/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMILanCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class IPMILanIPV6ListCommand
extends SuperBladeCommand {
    String formatTemplate = "%5s | %-50s | %-6s \n";

    @Override
    public void runCommand() throws Exception {
        IPMILanCommand ipmiLanCommand = new IPMILanCommand(null);
        ipmiLanCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        byte by = ipmiLanCommand.getMaxStaticIPv6Number();
        MOut.G(this).println("Maximum number of IPv6 static address: " + by);
        MOut.G(this).print(this.toFormatedHeader());
        StringBuffer formatedString = new StringBuffer();
        for (byte i = 0; i < by; i = (byte)(i + 1)) {
            byte[] data = ipmiLanCommand.getStaticIPv6Array(i);
            formatedString.append(String.format(this.formatTemplate, i, this.parseIP(data), this.parsePrefix(data)));
        }
        MOut.G(this).println(formatedString.toString());
        this.statusCode = 0;
    }

    public String toFormatedHeader() {
        StringBuffer formatedString = new StringBuffer();
        formatedString.append(String.format(this.formatTemplate, "ID", "IPv6 Address", "Prefix"));
        formatedString.append(String.format(this.formatTemplate, "---", "------------", "------"));
        return formatedString.toString();
    }

    public String parseIP(byte[] data) {
        if ((data[2] & 0xFFFFFF80) != -128) {
            return "Disabled";
        }
        String ip = "";
        ip = ByteUtility.byteToHex(data[3]) + ByteUtility.byteToHex(data[4]) + ":" + ByteUtility.byteToHex(data[5]) + ByteUtility.byteToHex(data[6]) + ":" + ByteUtility.byteToHex(data[7]) + ByteUtility.byteToHex(data[8]) + ":" + ByteUtility.byteToHex(data[9]) + ByteUtility.byteToHex(data[10]) + ":" + ByteUtility.byteToHex(data[11]) + ByteUtility.byteToHex(data[12]) + ":" + ByteUtility.byteToHex(data[13]) + ByteUtility.byteToHex(data[14]) + ":" + ByteUtility.byteToHex(data[15]) + ByteUtility.byteToHex(data[16]) + ":" + ByteUtility.byteToHex(data[17]) + ByteUtility.byteToHex(data[18]);
        return ip;
    }

    public byte parsePrefix(byte[] data) {
        return data[19];
    }
}

