/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.blade;

import com.supermicro.ipmi.blade.BladeEntity;
import com.supermicro.ipmi.blade.BladeSystemEntity;
import com.supermicro.ipmi.blade.FailureEntity;
import com.supermicro.ipmi.blade.MB_B7DBE_SensorEntity;
import com.supermicro.ipmi.blade.TemperatureData;
import java.util.ArrayList;

public class MB_B9DRT_SensorEntity
extends MB_B7DBE_SensorEntity {
    public static final String SYSTEM_TEMP_1 = "System";
    public static final String SYSTEM_TEMP_2 = "Peripheral";
    public static final String V1P1 = "1.1V";
    public static final String DIMM_AB_VOLTAGE = "DIMM AB voltage";
    public static final String DIMM_CD_VOLTAGE = "DIMM CD voltage";
    public static final String DIMM_EF_VOLTAGE = "DIMM EF voltage";
    public static final String DIMM_GH_VOLTAGE = "DIMM GH voltage";
    public static final String V3P3SB = "3.3VSB";
    public static final String PCH_TEMP = "PCH Temp";
    public static final String DIMM_A1_TEMP = "DIMM_A1";
    public static final String DIMM_B1_TEMP = "DIMM_B1";
    public static final String DIMM_C1_TEMP = "DIMM_C1";
    public static final String DIMM_D1_TEMP = "DIMM_D1";
    public static final String DIMM_E1_TEMP = "DIMM_E1";
    public static final String DIMM_F1_TEMP = "DIMM_F1";
    public static final String DIMM_G1_TEMP = "DIMM_G1";
    public static final String DIMM_H1_TEMP = "DIMM_H1";
    private byte v1p1;
    private byte system2Temp;
    private byte vDIMMABVoltage;
    private byte vDIMMCDVoltage;
    private byte vDIMMEFVoltage;
    private byte vDIMMGHVoltage;
    private byte v3p3sb;
    private byte pchTemp;
    private byte dimmA1Temp;
    private byte dimmB1Temp;
    private byte dimmC1Temp;
    private byte dimmD1Temp;
    private byte dimmE1Temp;
    private byte dimmF1Temp;
    private byte dimmG1Temp;
    private byte dimmH1Temp;
    private byte cpu1TempLimit;
    private byte cpu2TempLimit;
    private byte staticPCHTempHighLimit = (byte)95;
    private byte staticSystemTempHighLimit = (byte)85;

    @Override
    public boolean fromRaw(byte[] raw) {
        if (raw.length != BladeSystemEntity.MOTHER_BOARD_SENSORS_DATA_SIZE) {
            return false;
        }
        this.pollCount = raw[0];
        this.flag = raw[1];
        this.remoteCPU1Temp = raw[2];
        this.remoteCPU2Temp = raw[3];
        this.systemTemp = raw[4];
        this.system2Temp = raw[5];
        this.cpu1CoreVoltage = raw[6];
        this.cpu2CoreVoltage = raw[7];
        this.vDIMMABVoltage = raw[8];
        this.vDIMMCDVoltage = raw[9];
        this.vDIMMEFVoltage = raw[10];
        this.vDIMMGHVoltage = raw[11];
        this.v1p2 = raw[12];
        this.v1p1 = raw[13];
        this.v1p5 = raw[14];
        this.v3p3 = raw[15];
        this.v3p3sb = raw[16];
        this.v5 = raw[17];
        this.v12 = raw[18];
        this.batteryVoltage = raw[19];
        this.pchTemp = raw[20];
        this.dimmA1Temp = raw[21];
        this.dimmB1Temp = raw[22];
        this.dimmC1Temp = raw[23];
        this.dimmD1Temp = raw[24];
        this.dimmE1Temp = raw[25];
        this.dimmF1Temp = raw[26];
        this.dimmG1Temp = raw[30];
        this.dimmH1Temp = raw[31];
        this.cpu1TempLimit = raw[32];
        this.cpu2TempLimit = raw[33];
        this.raw = raw;
        return true;
    }

    @Override
    public ArrayList generateFailureReport(BladeEntity bladeEntity, int moduleIndex) {
        ArrayList<FailureEntity> failures = new ArrayList<FailureEntity>();
        if (this.getFlag() != 1) {
            return failures;
        }
        if (this.checkRemoteCPU1Temp() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "CPU1 Temp"));
        }
        if (this.checkRemoteCPU2Temp() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "CPU2 Temp"));
        }
        if (this.checkSystemTemp() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, SYSTEM_TEMP_1));
        }
        if (this.checkSystemTemp2() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, SYSTEM_TEMP_2));
        }
        if (this.checkCpu1CoreVoltage() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "CPU1 Vcore"));
        }
        if (this.checkCpu2CoreVoltage() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "CPU2 Vcore"));
        }
        if (this.checkVDIMMABVoltage() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, DIMM_AB_VOLTAGE));
        }
        if (this.checkVDIMMCDVoltage() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, DIMM_CD_VOLTAGE));
        }
        if (this.checkVDIMMEFVoltage() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, DIMM_EF_VOLTAGE));
        }
        if (this.checkVDIMMGHVoltage() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, DIMM_GH_VOLTAGE));
        }
        if (this.checkCPUVTT() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "CPU VTT"));
        }
        if (this.checkV1p1() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, V1P1));
        }
        if (this.checkV1p5() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "1.5V"));
        }
        if (this.checkV3p3() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "3.3V"));
        }
        if (this.checkV3p3sb() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, V3P3SB));
        }
        if (this.checkV5() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "5V"));
        }
        if (this.checkV12() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "12V"));
        }
        if (this.checkBatteryVoltage() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "VBAT"));
        }
        if (this.checkPCHTemp() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, PCH_TEMP));
        }
        if (this.checkDIMMTemp(this.dimmA1Temp) == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, DIMM_A1_TEMP));
        }
        if (this.checkDIMMTemp(this.dimmB1Temp) == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, DIMM_B1_TEMP));
        }
        if (this.checkDIMMTemp(this.dimmC1Temp) == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, DIMM_C1_TEMP));
        }
        if (this.checkDIMMTemp(this.dimmD1Temp) == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, DIMM_D1_TEMP));
        }
        if (this.checkDIMMTemp(this.dimmE1Temp) == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, DIMM_E1_TEMP));
        }
        if (this.checkDIMMTemp(this.dimmF1Temp) == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, DIMM_F1_TEMP));
        }
        if (this.checkDIMMTemp(this.dimmG1Temp) == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, DIMM_G1_TEMP));
        }
        if (this.checkDIMMTemp(this.dimmH1Temp) == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, DIMM_H1_TEMP));
        }
        return failures;
    }

    @Override
    public int checkSystemTemp() {
        if (this.getSystemTemp() < this.staticSystemTempHighLimit) {
            return 0;
        }
        return 1;
    }

    public int checkSystemTemp2() {
        if (this.system2Temp < this.staticSystemTempHighLimit) {
            return 0;
        }
        return 1;
    }

    @Override
    public int checkCpu1CoreVoltage() {
        if (this.getRemoteCPU1Temp() == 7) {
            return 2;
        }
        if (this.getCpu1CoreVoltageFormula() == 0.0) {
            return 2;
        }
        if (this.getCpu1CoreVoltageFormula() <= this.getCpu1CoreVoltageLowLimit() || this.getCpu1CoreVoltageFormula() >= this.getCpu1CoreVoltageHighLimit()) {
            return 1;
        }
        return 0;
    }

    @Override
    public int checkCpu2CoreVoltage() {
        if (this.getRemoteCPU2Temp() == 7) {
            return 2;
        }
        if (this.getCpu2CoreVoltageFormula() == 0.0) {
            return 2;
        }
        if (this.getCpu2CoreVoltageFormula() <= this.getCpu2CoreVoltageLowLimit() || this.getCpu2CoreVoltageFormula() >= this.getCpu2CoreVoltageHighLimit()) {
            return 1;
        }
        return 0;
    }

    @Override
    public double getV1p2Formula() {
        return (double)(this.v1p2 & 0xFF) * 0.008 * 2.0;
    }

    @Override
    public double getV5sbFormula() {
        return (double)(this.v5sb & 0xFF) * 0.008 * 4.0 * 2.0;
    }

    @Override
    public double getV5Formula() {
        return (double)(this.v5 & 0xFF) * 0.008 * 4.0 * 2.0;
    }

    @Override
    public double getCpu1CoreVoltageFormula() {
        if (this.getRemoteCPU1Temp() == 7) {
            return 0.0;
        }
        return (double)(this.cpu1CoreVoltage & 0xFF) * 0.016;
    }

    @Override
    public double getCpu1CoreVoltageHighLimit() {
        return 1.54;
    }

    @Override
    public double getCpu1CoreVoltageLowLimit() {
        return 0.62;
    }

    @Override
    public double getCpu2CoreVoltageFormula() {
        if (this.getRemoteCPU2Temp() == 7) {
            return 0.0;
        }
        return (double)(this.cpu2CoreVoltage & 0xFF) * 0.016;
    }

    @Override
    public double getCpu2CoreVoltageHighLimit() {
        return 1.54;
    }

    @Override
    public double getCpu2CoreVoltageLowLimit() {
        return 0.62;
    }

    @Override
    public double getBatteryVoltageFormula() {
        return (double)(this.batteryVoltage & 0xFF) * 0.024 * 2.0;
    }

    @Override
    public double getV3p3Formula() {
        return (double)(this.v3p3 & 0xFF) * 0.024 * 2.0;
    }

    public double getV1p1Formula() {
        return (double)(this.v1p1 & 0xFF) * 0.016;
    }

    public double getV1p1HighLimit() {
        return 1.32;
    }

    public double getV1p1LowLimit() {
        return 1.08;
    }

    public int checkV1p1() {
        if (this.getV1p1Formula() == 0.0) {
            return 2;
        }
        if (this.getV1p1Formula() <= this.getV1p1LowLimit() || this.getV1p1Formula() >= this.getV1p1HighLimit()) {
            return 1;
        }
        return 0;
    }

    public double getVDIMMABVoltageFormula() {
        return (double)(this.vDIMMABVoltage & 0xFF) * 0.016;
    }

    public double getVDIMMCDVoltageFormula() {
        return (double)(this.vDIMMCDVoltage & 0xFF) * 0.016;
    }

    public double getVDIMMEFVoltageFormula() {
        return (double)(this.vDIMMEFVoltage & 0xFF) * 0.016;
    }

    public double getVDIMMGHVoltageFormula() {
        return (double)(this.vDIMMGHVoltage & 0xFF) * 0.016;
    }

    @Override
    public double getV12Formula() {
        return 2.0 * ((double)(this.v12 & 0xFF) * 0.008 / 0.1510574018126888);
    }

    public double getDIMMVoltageLowLimit() {
        return 1.15;
    }

    public double getDIMMVoltageHighLimit() {
        return 1.62;
    }

    public int checkVDIMMABVoltage() {
        if (this.getRemoteCPU1Temp() == 7) {
            return 2;
        }
        if (this.getVDIMMABVoltageFormula() == 0.0) {
            return 2;
        }
        if (this.getVDIMMABVoltageFormula() <= this.getDIMMVoltageLowLimit() || this.getVDIMMABVoltageFormula() >= this.getDIMMVoltageHighLimit()) {
            return 1;
        }
        return 0;
    }

    public int checkVDIMMCDVoltage() {
        if (this.getRemoteCPU1Temp() == 7) {
            return 2;
        }
        if (this.getVDIMMCDVoltageFormula() == 0.0) {
            return 2;
        }
        if (this.getVDIMMCDVoltageFormula() <= this.getDIMMVoltageLowLimit() || this.getVDIMMCDVoltageFormula() >= this.getDIMMVoltageHighLimit()) {
            return 1;
        }
        return 0;
    }

    public int checkVDIMMEFVoltage() {
        if (this.getRemoteCPU2Temp() == 7) {
            return 2;
        }
        if (this.getVDIMMEFVoltageFormula() == 0.0) {
            return 2;
        }
        if (this.getVDIMMEFVoltageFormula() <= this.getDIMMVoltageLowLimit() || this.getVDIMMEFVoltageFormula() >= this.getDIMMVoltageHighLimit()) {
            return 1;
        }
        return 0;
    }

    public int checkVDIMMGHVoltage() {
        if (this.getRemoteCPU2Temp() == 7) {
            return 2;
        }
        if (this.getVDIMMGHVoltageFormula() == 0.0) {
            return 2;
        }
        if (this.getVDIMMGHVoltageFormula() <= this.getDIMMVoltageLowLimit() || this.getVDIMMGHVoltageFormula() >= this.getDIMMVoltageHighLimit()) {
            return 1;
        }
        return 0;
    }

    public double getV3p3sbFormula() {
        return (double)(this.v3p3sb & 0xFF) * 0.024 * 2.0;
    }

    public double getV3p3sbHighLimit() {
        return 3.63;
    }

    public double getV3p3sbLowLimit() {
        return 2.96;
    }

    public int checkV3p3sb() {
        if (this.getV3p3sbFormula() == 0.0) {
            return 2;
        }
        if (this.getV3p3sbFormula() <= this.getV3p3sbLowLimit() || this.getV3p3sbFormula() >= this.getV3p3sbHighLimit()) {
            return 1;
        }
        return 0;
    }

    public int checkPCHTemp() {
        if (this.pchTemp < this.staticPCHTempHighLimit) {
            return 0;
        }
        return 1;
    }

    @Override
    public String toFormatedString() {
        this.formatedString = new StringBuffer();
        this.formatedString.append(String.format(this.formatTemplate, "Status", "Sensor", "Reading", "Low Limit", "High Limit"));
        this.formatedString.append(String.format(this.formatTemplate, "------", "------", "-------", "---------", "----------"));
        this.addRaw(this.checkRemoteCPU1Temp(), "CPU1 Temp", this.showCandF(this.getRemoteCPU1Temp()), "N/A", "" + this.showCandF(this.getCpu1TempLimit()));
        this.addRaw(this.checkRemoteCPU2Temp(), "CPU2 Temp", this.showCandF(this.getRemoteCPU2Temp()), "N/A", "" + this.showCandF(this.getCpu2TempLimit()));
        this.addRaw(this.checkPCHTemp(), PCH_TEMP, this.showCandF(this.pchTemp), "N/A", "" + this.showCandF(this.staticPCHTempHighLimit));
        this.addRaw(this.checkSystemTemp(), SYSTEM_TEMP_1, this.showCandF(this.getSystemTemp()), "N/A", "" + this.showCandF(this.staticSystemTempHighLimit));
        this.addRaw(this.checkSystemTemp2(), SYSTEM_TEMP_2, this.showCandF(this.system2Temp), "N/A", "" + this.showCandF(this.staticSystemTempHighLimit));
        this.addRaw(this.checkCpu1CoreVoltage(), "CPU1 Vcore", this.d2StrV(this.getCpu1CoreVoltageFormula()), this.d2StrV(this.getCpu1CoreVoltageLowLimit()), this.d2StrV(this.getCpu1CoreVoltageHighLimit()));
        this.addRaw(this.checkCpu2CoreVoltage(), "CPU2 Vcore", this.d2StrV(this.getCpu2CoreVoltageFormula()), this.d2StrV(this.getCpu2CoreVoltageLowLimit()), this.d2StrV(this.getCpu2CoreVoltageHighLimit()));
        this.addRaw(this.checkVDIMMABVoltage(), DIMM_AB_VOLTAGE, this.d2StrV(this.getVDIMMABVoltageFormula()), this.d2StrV(this.getDIMMVoltageLowLimit()), this.d2StrV(this.getDIMMVoltageHighLimit()));
        this.addRaw(this.checkVDIMMCDVoltage(), DIMM_CD_VOLTAGE, this.d2StrV(this.getVDIMMCDVoltageFormula()), this.d2StrV(this.getDIMMVoltageLowLimit()), this.d2StrV(this.getDIMMVoltageHighLimit()));
        this.addRaw(this.checkVDIMMEFVoltage(), DIMM_EF_VOLTAGE, this.d2StrV(this.getVDIMMEFVoltageFormula()), this.d2StrV(this.getDIMMVoltageLowLimit()), this.d2StrV(this.getDIMMVoltageHighLimit()));
        this.addRaw(this.checkVDIMMGHVoltage(), DIMM_GH_VOLTAGE, this.d2StrV(this.getVDIMMGHVoltageFormula()), this.d2StrV(this.getDIMMVoltageLowLimit()), this.d2StrV(this.getDIMMVoltageHighLimit()));
        this.addRaw(this.checkV1p1(), V1P1, this.d2StrV(this.getV1p1Formula()), this.d2StrV(this.getV1p1LowLimit()), this.d2StrV(this.getV1p1HighLimit()));
        this.addRaw(this.checkCPUVTT(), "CPU VTT", this.d2StrV(this.getV1p2Formula()), this.d2StrV(this.getCPUVTTLowLimit()), this.d2StrV(this.getCPUVTTHighLimit()));
        this.addRaw(this.checkV1p5(), "1.5V", this.d2StrV(this.getV1p5Formula()), this.d2StrV(this.getV1p5LowLimit()), this.d2StrV(this.getV1p5HighLimit()));
        this.addRaw(this.checkV3p3(), "3.3V", this.d2StrV(this.getV3p3Formula()), this.d2StrV(this.getV3p3LowLimit()), this.d2StrV(this.getV3p3HighLimit()));
        this.addRaw(this.checkV3p3sb(), V3P3SB, this.d2StrV(this.getV3p3sbFormula()), this.d2StrV(this.getV3p3sbLowLimit()), this.d2StrV(this.getV3p3sbHighLimit()));
        this.addRaw(this.checkV5(), "5V", this.d2StrV(this.getV5Formula()), this.d2StrV(this.getV5LowLimit()), this.d2StrV(this.getV5HighLimit()));
        this.addRaw(this.checkV12(), "12V", this.d2StrV(this.getV12Formula()), this.d2StrV(this.getV12LowLimit()), this.d2StrV(this.getV12HighLimit()));
        this.addRaw(this.checkBatteryVoltage(), "VBAT", this.d2StrV(this.getBatteryVoltageFormula()), this.d2StrV(this.getBatteryVoltageLowLimit()), this.d2StrV(this.getBatteryVoltageHighLimit()));
        this.addRaw(this.checkDIMMTemp(this.dimmA1Temp), DIMM_A1_TEMP, this.showCandF(this.dimmA1Temp), "N/A", "" + this.showCandF((byte)85));
        this.addRaw(this.checkDIMMTemp(this.dimmB1Temp), DIMM_B1_TEMP, this.showCandF(this.dimmB1Temp), "N/A", "" + this.showCandF((byte)85));
        this.addRaw(this.checkDIMMTemp(this.dimmC1Temp), DIMM_C1_TEMP, this.showCandF(this.dimmC1Temp), "N/A", "" + this.showCandF((byte)85));
        this.addRaw(this.checkDIMMTemp(this.dimmD1Temp), DIMM_D1_TEMP, this.showCandF(this.dimmD1Temp), "N/A", "" + this.showCandF((byte)85));
        this.addRaw(this.checkDIMMTemp(this.dimmE1Temp), DIMM_E1_TEMP, this.showCandF(this.dimmE1Temp), "N/A", "" + this.showCandF((byte)85));
        this.addRaw(this.checkDIMMTemp(this.dimmF1Temp), DIMM_F1_TEMP, this.showCandF(this.dimmF1Temp), "N/A", "" + this.showCandF((byte)85));
        this.addRaw(this.checkDIMMTemp(this.dimmG1Temp), DIMM_G1_TEMP, this.showCandF(this.dimmG1Temp), "N/A", "" + this.showCandF((byte)85));
        this.addRaw(this.checkDIMMTemp(this.dimmH1Temp), DIMM_H1_TEMP, this.showCandF(this.dimmH1Temp), "N/A", "" + this.showCandF((byte)85));
        return this.formatedString.toString();
    }

    @Override
    public ArrayList<TemperatureData> getTemperatures() {
        ArrayList<TemperatureData> list = new ArrayList<TemperatureData>();
        list.add(this.createTemperatureData(this.checkRemoteCPU1Temp(), "CPU1 Temp", this.showCandF(this.getRemoteCPU1Temp()), "N/A", "" + this.showCandF(this.getCpu1TempLimit())));
        list.add(this.createTemperatureData(this.checkRemoteCPU2Temp(), "CPU2 Temp", this.showCandF(this.getRemoteCPU2Temp()), "N/A", "" + this.showCandF(this.getCpu2TempLimit())));
        list.add(this.createTemperatureData(this.checkPCHTemp(), PCH_TEMP, this.showCandF(this.pchTemp), "N/A", "" + this.showCandF(this.staticPCHTempHighLimit)));
        list.add(this.createTemperatureData(this.checkSystemTemp(), SYSTEM_TEMP_1, this.showCandF(this.getSystemTemp()), "N/A", "" + this.showCandF(this.staticSystemTempHighLimit)));
        list.add(this.createTemperatureData(this.checkSystemTemp2(), SYSTEM_TEMP_2, this.showCandF(this.system2Temp), "N/A", "" + this.showCandF(this.staticSystemTempHighLimit)));
        list.add(this.createTemperatureData(this.checkDIMMTemp(this.dimmA1Temp), DIMM_A1_TEMP, this.showCandF(this.dimmA1Temp), "N/A", "" + this.showCandF((byte)85)));
        list.add(this.createTemperatureData(this.checkDIMMTemp(this.dimmB1Temp), DIMM_B1_TEMP, this.showCandF(this.dimmB1Temp), "N/A", "" + this.showCandF((byte)85)));
        list.add(this.createTemperatureData(this.checkDIMMTemp(this.dimmC1Temp), DIMM_C1_TEMP, this.showCandF(this.dimmC1Temp), "N/A", "" + this.showCandF((byte)85)));
        list.add(this.createTemperatureData(this.checkDIMMTemp(this.dimmD1Temp), DIMM_D1_TEMP, this.showCandF(this.dimmD1Temp), "N/A", "" + this.showCandF((byte)85)));
        list.add(this.createTemperatureData(this.checkDIMMTemp(this.dimmE1Temp), DIMM_E1_TEMP, this.showCandF(this.dimmE1Temp), "N/A", "" + this.showCandF((byte)85)));
        list.add(this.createTemperatureData(this.checkDIMMTemp(this.dimmF1Temp), DIMM_F1_TEMP, this.showCandF(this.dimmF1Temp), "N/A", "" + this.showCandF((byte)85)));
        list.add(this.createTemperatureData(this.checkDIMMTemp(this.dimmG1Temp), DIMM_G1_TEMP, this.showCandF(this.dimmG1Temp), "N/A", "" + this.showCandF((byte)85)));
        list.add(this.createTemperatureData(this.checkDIMMTemp(this.dimmH1Temp), DIMM_H1_TEMP, this.showCandF(this.dimmH1Temp), "N/A", "" + this.showCandF((byte)85)));
        return list;
    }

    public byte getSystem2Temp() {
        return this.system2Temp;
    }

    public byte getStaticPCHTempHighLimit() {
        return this.staticPCHTempHighLimit;
    }

    public byte getStaticSystemTempHighLimit() {
        return this.staticSystemTempHighLimit;
    }

    public byte getPchTemp() {
        return this.pchTemp;
    }

    public void setVDIMMABVoltage(byte VDIMMABVoltage) {
        this.vDIMMABVoltage = VDIMMABVoltage;
    }

    public void setVDIMMCDVoltage(byte VDIMMCDVoltage) {
        this.vDIMMCDVoltage = VDIMMCDVoltage;
    }

    public void setVDIMMEFVoltage(byte VDIMMEFVoltage) {
        this.vDIMMEFVoltage = VDIMMEFVoltage;
    }

    public void setVDIMMGHVoltage(byte VDIMMGHVoltage) {
        this.vDIMMGHVoltage = VDIMMGHVoltage;
    }

    @Override
    public double getBatteryVoltageHighLimit() {
        return 3.63;
    }

    @Override
    public double getBatteryVoltageLowLimit() {
        return 2.97;
    }

    public byte getCpu1TempLimit() {
        return this.cpu1TempLimit;
    }

    public byte getCpu2TempLimit() {
        return this.cpu2TempLimit;
    }

    public byte getDimmA1Temp() {
        return this.dimmA1Temp;
    }

    public byte getDimmB1Temp() {
        return this.dimmB1Temp;
    }

    public byte getDimmC1Temp() {
        return this.dimmC1Temp;
    }

    public byte getDimmD1Temp() {
        return this.dimmD1Temp;
    }

    public byte getDimmE1Temp() {
        return this.dimmE1Temp;
    }

    public byte getDimmF1Temp() {
        return this.dimmF1Temp;
    }

    public byte getDimmG1Temp() {
        return this.dimmG1Temp;
    }

    public byte getDimmH1Temp() {
        return this.dimmH1Temp;
    }
}

