/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ByteUtility;

public class VirtualMediaInfo {
    public static final byte SMB_IMAGE_MOUNT_IN_PROGRESS = 2;
    public static final byte ACTIVE_RESERVATION_FOR_THIS_DEVICE = 1;
    public static final byte EMPTY = 0;
    public static final byte FLOPPY = 1;
    public static final byte ISO_IMAGE = 2;
    public static final byte DRIVE_REDIRECTION = 3;
    public static final byte BYTE = 0;
    public static final byte KBYTE = 1;
    public static final byte MBYTE = 2;
    public static final byte GBYTE = 3;
    public static final byte READONLY = 0;
    public static final byte WRITABLE = 1;
    byte deviceID;
    byte numberOfDevices;
    byte virtualMediaStatus;
    byte deviceStatus;
    byte[] imageSize;
    byte imageSizeUnit;
    byte accessMode;
    String imageSource;

    public static VirtualMediaInfo fromRaw(byte deviceID, byte[] raw) {
        VirtualMediaInfo virtualMediaStatus = new VirtualMediaInfo();
        virtualMediaStatus.deviceID = deviceID;
        virtualMediaStatus.numberOfDevices = raw[0];
        if (raw.length == 1) {
            return virtualMediaStatus;
        }
        virtualMediaStatus.virtualMediaStatus = raw[1];
        virtualMediaStatus.deviceStatus = raw[2];
        if (virtualMediaStatus.deviceStatus == 0) {
            return virtualMediaStatus;
        }
        virtualMediaStatus.imageSize = new byte[4];
        System.arraycopy(raw, 3, virtualMediaStatus.imageSize, 0, 4);
        virtualMediaStatus.imageSizeUnit = raw[7];
        virtualMediaStatus.accessMode = raw[8];
        byte[] tempImageSource = new byte[raw.length - 9];
        System.arraycopy(raw, 9, tempImageSource, 0, raw.length - 9);
        virtualMediaStatus.imageSource = new String(tempImageSource);
        return virtualMediaStatus;
    }

    public String toFormatedString() {
        if (this.deviceID == 0) {
            return "numberOfDevices =" + this.numberOfDevices;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("\nDrive " + this.deviceID);
        sb.append("\nDevice Status = ");
        switch (this.deviceStatus) {
            case 0: {
                sb.append("empty");
                break;
            }
            case 1: {
                sb.append("Internal image set");
                break;
            }
            case 2: {
                sb.append("CD-ROM image on Windows share set");
                break;
            }
            case 3: {
                sb.append("Mass storage device redirection active");
            }
        }
        if (this.deviceStatus == 0) {
            return sb.toString();
        }
        sb.append("\nImage Size = " + ByteUtility.fourBytesToLongByLSBFirst(this.imageSize));
        switch (this.imageSizeUnit) {
            case 0: {
                sb.append(" (bytes)");
                break;
            }
            case 1: {
                sb.append(" (K bytes)");
                break;
            }
            case 2: {
                sb.append(" (M bytes)");
                break;
            }
            case 3: {
                sb.append(" (G bytes)");
            }
        }
        sb.append("\nAccess Mode = ");
        switch (this.accessMode) {
            case 0: {
                sb.append("Read-Only");
                break;
            }
            case 1: {
                sb.append("Writable");
            }
        }
        sb.append("\nImage source = " + this.imageSource);
        return sb.toString();
    }

    public String toString() {
        if (this.deviceID == 0) {
            return "numberOfDevices =" + this.numberOfDevices;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("\nDrive " + this.deviceID);
        sb.append("\nDevice Status = ");
        switch (this.deviceStatus) {
            case 0: {
                sb.append("empty");
                break;
            }
            case 1: {
                sb.append("Internal image set");
                break;
            }
            case 2: {
                sb.append("CD-ROM image on Windows share set");
                break;
            }
            case 3: {
                sb.append("Mass storage device redirection active");
            }
        }
        if (this.deviceStatus == 0) {
            return sb.toString();
        }
        sb.append("\nImage Size = " + ByteUtility.fourBytesToLongByLSBFirst(this.imageSize));
        switch (this.imageSizeUnit) {
            case 0: {
                sb.append(" (bytes)");
                break;
            }
            case 1: {
                sb.append(" (K bytes)");
                break;
            }
            case 2: {
                sb.append(" (M bytes)");
                break;
            }
            case 3: {
                sb.append(" (G bytes)");
            }
        }
        sb.append("\nAccess Mode = ");
        switch (this.accessMode) {
            case 0: {
                sb.append("Read-Only");
                break;
            }
            case 1: {
                sb.append("Writable");
            }
        }
        sb.append("\nImage source = " + this.imageSource);
        return sb.toString();
    }

    public String getAccessModeString() {
        switch (this.accessMode) {
            case 0: {
                return "Read-Only";
            }
            case 1: {
                return "Writable";
            }
        }
        return null;
    }

    public String getImageSizeString() {
        StringBuffer sb = new StringBuffer();
        sb.append(ByteUtility.fourBytesToLongByLSBFirst(this.imageSize));
        switch (this.imageSizeUnit) {
            case 0: {
                sb.append(" (byte)");
                break;
            }
            case 1: {
                sb.append(" (K byte)");
                break;
            }
            case 2: {
                sb.append(" (M byte)");
                break;
            }
            case 3: {
                sb.append(" (G byte)");
            }
        }
        return sb.toString();
    }

    public byte getAccessMode() {
        return this.accessMode;
    }

    public byte getDeviceID() {
        return this.deviceID;
    }

    public byte getDeviceStatus() {
        return this.deviceStatus;
    }

    public byte[] getImageSize() {
        return this.imageSize;
    }

    public byte getImageSizeUnit() {
        return this.imageSizeUnit;
    }

    public String getImageSource() {
        return this.imageSource;
    }

    public byte getNumberOfDevices() {
        return this.numberOfDevices;
    }

    public byte getVirtualMediaStatus() {
        return this.virtualMediaStatus;
    }
}

