/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Observable;
import java.util.Observer;

public class MessageCenter
extends Observable {
    String currentMessage;
    ArrayList history = new ArrayList();
    private static final MessageCenter instance = new MessageCenter();

    private MessageCenter() {
        this.addObserver(new SystemOutMessageObserver());
    }

    public static MessageCenter getInstance() {
        return instance;
    }

    public synchronized void put(Object obj) {
        this.put(this, (Object)obj.toString());
    }

    public synchronized void put(Object from, Object obj) {
        if (obj != null) {
            this.put(from.getClass().getName(), obj.toString());
        } else {
            this.put(from.getClass().getName(), "null");
        }
    }

    public synchronized void put(String className, String msg) {
        this.currentMessage = msg;
        ClassMessage classMessage = new ClassMessage();
        classMessage.from = className;
        classMessage.content = msg;
        classMessage.time = this.getDateTime();
        this.setChanged();
        this.notifyObservers(classMessage);
    }

    public String getMessage() {
        return this.currentMessage;
    }

    public String getDateTime() {
        SimpleDateFormat f = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss EEE");
        return f.format(Calendar.getInstance().getTime());
    }

    public static String getSystemDateTime() {
        GregorianCalendar cd1 = new GregorianCalendar();
        String dateTime = "";
        int s_yy = cd1.get(1);
        dateTime = dateTime + s_yy + "/";
        int s_mon = cd1.get(2) + 1;
        if (s_mon < 10) {
            dateTime = dateTime + "0";
        }
        dateTime = dateTime + s_mon + "/";
        int s_dd = cd1.get(5);
        if (s_dd < 10) {
            dateTime = dateTime + "0";
        }
        dateTime = dateTime + s_dd + " ";
        int s_hh = cd1.get(11);
        if (s_hh < 10) {
            dateTime = dateTime + "0";
        }
        dateTime = dateTime + s_hh + ":";
        int s_min = cd1.get(12);
        if (s_min < 10) {
            dateTime = dateTime + "0";
        }
        dateTime = dateTime + s_min + ":";
        int s_ss = cd1.get(13);
        if (s_ss < 10) {
            dateTime = dateTime + "0";
        }
        dateTime = dateTime + s_ss + "." + cd1.get(14);
        return dateTime;
    }

    public static void main(String[] args) {
        MessageCenter.getInstance().put("this is a test");
    }

    class SystemOutMessageObserver
    implements Observer {
        SystemOutMessageObserver() {
        }

        @Override
        public void update(Observable o, Object arg) {
            ClassMessage classMessage = (ClassMessage)arg;
            System.out.println(arg);
        }
    }

    public class ClassMessage {
        public String time;
        public String from;
        public String content;

        public String toString() {
            return "[" + this.time + "][" + this.from + "][" + this.content + "]";
        }
    }
}

