/*
 * Decompiled with CFR 0.152.
 */
package tw.com.aten.vstorage;

import com.supermicro.ipmi.IPMIInterfaceConfig;
import java.util.HashMap;
import tw.com.aten.bean.InfoRepository;
import tw.com.aten.vstorage.VirtualStorage;

public class VirtualStorageManager {
    private static VirtualStorageManager instance = new VirtualStorageManager();
    HashMap<String, VirtualStorage> virtualStorages = new HashMap();

    private VirtualStorageManager() {
    }

    public static VirtualStorageManager getInstance() {
        return instance;
    }

    public VirtualStorage createVirtualStorage(IPMIInterfaceConfig config) {
        VirtualStorage.loadLibrary();
        InfoRepository infoRepository = InfoRepository.createInfoRepository(config.getIp(), config.getUserName(), config.getPassword());
        VirtualStorage vs = new VirtualStorage(infoRepository);
        this.virtualStorages.put(config.getIp(), vs);
        return vs;
    }

    public VirtualStorage getVirtualStorage(IPMIInterfaceConfig config) {
        VirtualStorage vs = this.virtualStorages.get(config.getIp());
        if (vs == null) {
            vs = this.createVirtualStorage(config);
        }
        return vs;
    }

    public String getMountStatus() {
        StringBuffer sb = new StringBuffer();
        if (this.virtualStorages.keySet().size() == 0) {
            return "None";
        }
        for (String item : this.virtualStorages.keySet()) {
            VirtualStorage vs = this.virtualStorages.get(item);
            sb.append("[" + item.toString() + "]:\n");
            sb.append(vs.mountStatus());
        }
        return sb.toString();
    }
}

