/*
 * Decompiled with CFR 0.152.
 */
package nn.pp.rc;

import nn.pp.rc.GenericTimer;

class TimerQueue
extends Thread {
    private static TimerQueue sharedInst;
    GenericTimer firstTimer;
    boolean running = true;
    private static final Object classLock;

    private TimerQueue() {
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanUp() {
        Object object = classLock;
        synchronized (object) {
            if (sharedInst != null) {
                TimerQueue.sharedInst.running = false;
                try {
                    sharedInst.notify();
                }
                catch (IllegalMonitorStateException illegalMonitorStateException) {
                    // empty catch block
                }
            }
            sharedInst = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TimerQueue sharedInstance() {
        Object object = classLock;
        synchronized (object) {
            if (sharedInst == null) {
                sharedInst = new TimerQueue();
            }
            return sharedInst;
        }
    }

    synchronized void addTimer(GenericTimer timer, long expirationTime) {
        if (timer.running) {
            return;
        }
        GenericTimer previousTimer = null;
        GenericTimer nextTimer = this.firstTimer;
        while (nextTimer != null && nextTimer.expirationTime <= expirationTime) {
            previousTimer = nextTimer;
            nextTimer = nextTimer.nextTimer;
        }
        if (previousTimer == null) {
            this.firstTimer = timer;
        } else {
            previousTimer.nextTimer = timer;
        }
        timer.expirationTime = expirationTime;
        timer.nextTimer = nextTimer;
        timer.running = true;
        this.notify();
    }

    synchronized void removeTimer(GenericTimer timer) {
        if (!timer.running) {
            return;
        }
        GenericTimer previousTimer = null;
        GenericTimer nextTimer = this.firstTimer;
        boolean found = false;
        while (nextTimer != null) {
            if (nextTimer == timer) {
                found = true;
                break;
            }
            previousTimer = nextTimer;
            nextTimer = nextTimer.nextTimer;
        }
        if (!found) {
            return;
        }
        if (previousTimer == null) {
            this.firstTimer = timer.nextTimer;
        } else {
            previousTimer.nextTimer = timer.nextTimer;
        }
        timer.expirationTime = 0L;
        timer.nextTimer = null;
        timer.running = false;
    }

    synchronized boolean containsTimer(GenericTimer timer) {
        return timer.running;
    }

    synchronized long postExpiredTimers() {
        long timeToWait;
        do {
            GenericTimer timer;
            if ((timer = this.firstTimer) == null) {
                return 0L;
            }
            long currentTime = System.currentTimeMillis();
            timeToWait = timer.expirationTime - currentTime;
            if (timeToWait > 0L) continue;
            try {
                timer.post();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            this.removeTimer(timer);
            if (timer.isRepeats()) {
                this.addTimer(timer, currentTime + (long)timer.getDelay());
            }
            try {
                this.wait(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (timeToWait <= 0L);
        return timeToWait;
    }

    @Override
    public synchronized void run() {
        try {
            while (this.running) {
                long timeToWait = this.postExpiredTimers();
                try {
                    this.wait(timeToWait);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (ThreadDeath td) {
            this.running = false;
            GenericTimer timer = this.firstTimer;
            while (timer != null) {
                timer = timer.nextTimer;
            }
            throw td;
        }
    }

    static {
        classLock = new Object();
    }
}

