/*
 * Decompiled with CFR 0.152.
 */
package nn.pp.rc;

import java.util.Enumeration;
import java.util.Vector;
import nn.pp.rc.T;

public class RFBEncoding {
    protected static final int modeAuto = 0;
    protected static final int modeFix = 1;
    protected static final int modeAdvanced = 2;
    protected static final int modeDefault = 0;
    protected static final int fixVideoHi = 0;
    protected static final int fixVideo = 1;
    protected static final int fixLanHi = 2;
    protected static final int fixLan = 3;
    protected static final int fixDsl = 4;
    protected static final int fixUmts = 5;
    protected static final int fixIsdn = 6;
    protected static final int fixModem = 7;
    protected static final int fixGprs = 8;
    protected static final int fixGsm = 9;
    protected static final int fixDefault = 2;
    protected static final int comprVideo = 0;
    protected static final int comprNone = 1;
    protected static final int comprLevel1 = 2;
    protected static final int comprLevel2 = 3;
    protected static final int comprLevel3 = 4;
    protected static final int comprLevel4 = 5;
    protected static final int comprLevel5 = 6;
    protected static final int comprLevel6 = 7;
    protected static final int comprLevel7 = 8;
    protected static final int comprLevel8 = 9;
    protected static final int comprLevel9 = 10;
    protected static final int comprDefault = 1;
    protected static final int color16Bit = 0;
    protected static final int color8Bit = 1;
    protected static final int color4Bit = 2;
    protected static final int color4Grey = 3;
    protected static final int color3Grey = 4;
    protected static final int color2Grey = 5;
    protected static final int color1Grey = 6;
    protected static final int colorDefault = 0;
    private boolean supportHw;
    private boolean lossy;
    protected Vector modes;
    protected Vector fixEncs;
    protected Vector comps;
    protected Vector colors;
    protected encMode currentMode;
    protected encFix currentFix;
    protected encCompression currentComp;
    protected encColorDepth currentColor;
    protected encMode[] init_modes = new encMode[]{new encMode(0, T._("Automatic"), "auto"), new encMode(1, T._("Predefined"), "preconf"), new encMode(2, T._("Advanced"), "manual")};
    protected encFix[] init_fixEncs = new encFix[]{new encFix(0, T._("Video Optimized Hicolor"), "videohi", 0, 0, false), new encFix(1, T._("Video Optimized"), "video", 0, 1, false), new encFix(2, T._("LAN Hicolor"), "lanhi", 1, 0, false), new encFix(3, T._("LAN"), "lan", 1, 1, false), new encFix(4, T._("DSL"), "dsl", 3, 1, false), new encFix(5, T._("UMTS"), "umts", 5, 1, true), new encFix(6, T._("ISDN"), "isdn", 7, 2, true), new encFix(7, T._("Modem"), "modem", 8, 5, true), new encFix(8, T._("GPRS"), "gprs", 9, 5, true), new encFix(9, T._("GSM"), "gsm", 10, 6, true)};
    protected int[] colorDepths16_8 = new int[]{0, 1};
    protected int[] colorDepths8421 = new int[]{1, 2, 3, 5, 6};
    protected encCompression[] init_comps = new encCompression[]{new encCompression(0, T._("Video Optimized"), "video", 10, 0, this.colorDepths16_8, false, true), new encCompression(1, T._("0 - none"), "uncompressed", 5, 0, this.colorDepths16_8, false, true), new encCompression(2, T._("1 - fastest"), "comp1", 7, 1, this.colorDepths8421, false, true), new encCompression(3, T._("2"), "comp2", 7, 2, this.colorDepths8421, false, true), new encCompression(4, T._("3"), "comp3", 7, 3, this.colorDepths8421, false, true), new encCompression(5, T._("4"), "comp4", 7, 4, this.colorDepths8421, false, true), new encCompression(6, T._("5"), "comp5", 7, 5, this.colorDepths8421, false, true), new encCompression(7, T._("6"), "comp6", 7, 6, this.colorDepths8421, true, true), new encCompression(8, T._("7"), "comp7", 7, 7, this.colorDepths8421, true, true), new encCompression(9, T._("8"), "comp8", 7, 8, this.colorDepths8421, true, true), new encCompression(10, T._("9 - best"), "comp9", 7, 9, this.colorDepths8421, true, true)};
    protected encColorDepth[] init_colors = new encColorDepth[]{new encColorDepth(0, T._("16 Bit Hicolor"), "color_16bpp", 0, 0, 1, true), new encColorDepth(1, T._("8 Bit - 256 Colors"), "color_8bpp", 8, 2, 3, false), new encColorDepth(2, T._("4 Bit - 16 Colors"), "color_4bpp", 4, 4, 5, false), new encColorDepth(3, T._("4 Bit - Grayscale"), "grey_4bpp", 3, 6, 7, false), new encColorDepth(5, T._("2 Bit - Grayscale"), "grey_2bpp", 2, 10, 11, false), new encColorDepth(6, T._("1 Bit - Black/White"), "grey_1bpp", 1, 12, 13, false)};

    public RFBEncoding() {
        this(true);
    }

    public RFBEncoding(boolean supportHw) {
        this.supportHw = supportHw;
        this.lossy = false;
        this.initCompressionTypes();
    }

    public RFBEncoding(boolean supportHw, String selEnc, String fixEnc, String encAdvCR, String encAdvCD) {
        this(supportHw);
        this.currentMode = this.lookupModeFromShortname(selEnc);
        if (this.currentMode == null) {
            this.currentMode = this.lookupModeFromID(0);
        }
        this.currentFix = this.lookupFixFromShortname(fixEnc);
        if (this.currentFix == null) {
            this.currentFix = this.lookupFixFromID(2);
        }
        this.currentColor = this.lookupColorFromShortname(encAdvCD);
        if (this.currentColor == null) {
            this.currentColor = this.lookupColorFromID(0);
        }
        this.currentComp = this.lookupCompFromShortname(encAdvCR);
        if (this.currentComp == null) {
            this.currentComp = this.lookupCompFromID(1);
        }
        if (this.currentMode.id == 1) {
            this.setFixEncoding(this.currentFix.name);
        }
    }

    protected void initCompressionTypes() {
        int i;
        this.modes = new Vector(this.init_modes.length);
        this.fixEncs = new Vector(this.init_fixEncs.length);
        this.comps = new Vector(this.init_comps.length);
        this.colors = new Vector(this.init_colors.length);
        for (i = 0; i < this.init_modes.length; ++i) {
            this.modes.addElement(this.init_modes[i]);
        }
        for (i = 0; i < this.init_fixEncs.length; ++i) {
            this.fixEncs.addElement(this.init_fixEncs[i]);
        }
        for (i = 0; i < this.init_comps.length; ++i) {
            this.comps.addElement(this.init_comps[i]);
        }
        for (i = 0; i < this.init_colors.length; ++i) {
            this.colors.addElement(this.init_colors[i]);
        }
    }

    protected encodingParam lookupParamFromID(int id, Vector v) {
        Enumeration el = v.elements();
        while (el.hasMoreElements()) {
            encodingParam entry = (encodingParam)el.nextElement();
            if (entry.id != id) continue;
            return entry;
        }
        return null;
    }

    protected encodingParam lookupParamFromName(String name, Vector v) {
        Enumeration el = v.elements();
        while (el.hasMoreElements()) {
            encodingParam entry = (encodingParam)el.nextElement();
            if (!entry.name.equals(name)) continue;
            return entry;
        }
        return null;
    }

    protected encodingParam lookupParamFromShortname(String shortname, Vector v) {
        Enumeration el = v.elements();
        while (el.hasMoreElements()) {
            encodingParam entry = (encodingParam)el.nextElement();
            if (!entry.shortname.equals(shortname)) continue;
            return entry;
        }
        return null;
    }

    protected encMode lookupModeFromID(int id) {
        return (encMode)this.lookupParamFromID(id, this.modes);
    }

    protected encFix lookupFixFromID(int id) {
        return (encFix)this.lookupParamFromID(id, this.fixEncs);
    }

    protected encCompression lookupCompFromID(int id) {
        return (encCompression)this.lookupParamFromID(id, this.comps);
    }

    protected encColorDepth lookupColorFromID(int id) {
        return (encColorDepth)this.lookupParamFromID(id, this.colors);
    }

    protected encMode lookupModeFromName(String name) {
        return (encMode)this.lookupParamFromName(name, this.modes);
    }

    protected encFix lookupFixFromName(String name) {
        return (encFix)this.lookupParamFromName(name, this.fixEncs);
    }

    protected encCompression lookupCompFromName(String name) {
        return (encCompression)this.lookupParamFromName(name, this.comps);
    }

    protected encColorDepth lookupColorFromName(String name) {
        return (encColorDepth)this.lookupParamFromName(name, this.colors);
    }

    protected encMode lookupModeFromShortname(String name) {
        return (encMode)this.lookupParamFromShortname(name, this.modes);
    }

    protected encFix lookupFixFromShortname(String name) {
        return (encFix)this.lookupParamFromShortname(name, this.fixEncs);
    }

    protected encCompression lookupCompFromShortname(String name) {
        return (encCompression)this.lookupParamFromShortname(name, this.comps);
    }

    protected encColorDepth lookupColorFromShortname(String name) {
        return (encColorDepth)this.lookupParamFromShortname(name, this.colors);
    }

    public String toString() {
        return "RFBEncoding mode=" + this.currentMode + ", fix=" + this.currentFix + ", compression=" + this.currentComp + ", color=" + this.currentColor + ", lossy=" + this.lossy;
    }

    public int[] getRFBEncodings(boolean honorAuto) {
        int[] encodings = new int[4];
        int index = 0;
        if (honorAuto && this.currentMode.id == 0) {
            int encoding;
            encCompression autoComp = this.lookupCompFromID(6);
            encColorDepth autoColor = this.lookupColorFromID(1);
            if (this.supportHw) {
                encoding = 128;
                encoding |= autoColor.rfbLRLESubencLossless << 12;
                encoding |= autoComp.rfbCompressLevel << 8;
                encodings[index++] = 255;
            } else {
                encoding = autoComp.rfbEncoding;
                encoding |= autoColor.subformat << 12;
                encoding |= autoComp.rfbCompressLevel << 8;
                encodings[index++] = 127;
            }
            encodings[index++] = encoding;
        } else if (this.supportHw && this.currentComp.useLRLE) {
            int encoding = 128;
            encoding = this.lossy ? (encoding |= this.currentColor.rfbLRLESubencLossy << 12) : (encoding |= this.currentColor.rfbLRLESubencLossless << 12);
            encoding |= this.currentComp.rfbCompressLevel << 8;
            if (this.currentComp.id == 0) {
                encoding |= 0x10000;
            }
            encodings[index++] = encoding;
        } else {
            int encoding = this.currentComp.rfbEncoding;
            encoding |= this.currentColor.subformat << 12;
            encoding |= this.currentComp.rfbCompressLevel << 8;
            if (this.currentComp.id == 0) {
                encoding |= 0x10000;
            }
            encodings[index++] = encoding;
            if (this.currentComp.useCache) {
                encodings[index++] = 9;
            }
        }
        return encodings;
    }

    public boolean isTightCacheUsed() {
        return this.currentComp.useCache;
    }

    public boolean isModeAuto() {
        return this.currentMode.id == 0;
    }

    public boolean needsTrueColor() {
        if (this.supportHw) {
            return this.currentComp.useLRLE || this.currentMode.id == 0;
        }
        return this.currentMode.id != 0 && this.currentColor.needTrueColor;
    }

    public String[] getFixNames() {
        String[] names = new String[this.fixEncs.size()];
        int i = 0;
        Enumeration el = this.fixEncs.elements();
        while (el.hasMoreElements()) {
            encFix entry = (encFix)el.nextElement();
            names[i++] = entry.name;
        }
        return names;
    }

    public String[] getCompressionNames() {
        String[] names = new String[this.comps.size()];
        int i = 0;
        Enumeration el = this.comps.elements();
        while (el.hasMoreElements()) {
            encCompression entry = (encCompression)el.nextElement();
            names[i++] = entry.name;
        }
        return names;
    }

    public String[] getColorNames() {
        String[] names = new String[this.colors.size()];
        int i = 0;
        Enumeration el = this.colors.elements();
        while (el.hasMoreElements()) {
            encColorDepth entry = (encColorDepth)el.nextElement();
            names[i++] = entry.name;
        }
        return names;
    }

    public String getCurrentFixName() {
        return this.currentFix.name;
    }

    public String getCurrentCompName() {
        return this.currentComp.name;
    }

    public String getCurrentColorName() {
        return this.currentColor.name;
    }

    public boolean isColorPossible(String name) {
        if (this.supportHw) {
            return true;
        }
        encColorDepth color = this.lookupColorFromName(name);
        if (color == null) {
            return false;
        }
        for (int i = 0; i < this.currentComp.supportedColors.length; ++i) {
            if (this.currentComp.supportedColors[i] != color.id) continue;
            return true;
        }
        return false;
    }

    public boolean isHwSupported() {
        return this.supportHw;
    }

    public boolean isLossy() {
        return this.lossy;
    }

    public boolean setFixEncoding(String name) {
        encFix fix = this.lookupFixFromName(name);
        if (fix == null) {
            return false;
        }
        encCompression comp = this.lookupCompFromID(fix.compression);
        encColorDepth color = this.lookupColorFromID(fix.color);
        if (comp == null || color == null || this.currentComp == comp && this.currentColor == color && fix.lossy != this.lossy) {
            return false;
        }
        this.currentComp = comp;
        this.currentColor = color;
        this.lossy = fix.lossy;
        return true;
    }

    public boolean setCompression(String name) {
        encCompression comp = this.lookupCompFromName(name);
        if (comp == null || this.currentComp == comp) {
            return false;
        }
        this.currentComp = comp;
        if (!this.supportHw) {
            boolean found = false;
            for (int i = 0; i < this.currentComp.supportedColors.length; ++i) {
                if (this.currentComp.supportedColors[i] != this.currentColor.id) continue;
                found = true;
            }
            if (!found) {
                this.currentColor = this.lookupColorFromID(this.currentComp.supportedColors[0]);
            }
        }
        return true;
    }

    public boolean setColorDepth(String name) {
        encColorDepth color = this.lookupColorFromName(name);
        if (color == null || this.currentColor == color) {
            return false;
        }
        this.currentColor = color;
        return true;
    }

    public boolean setLossyState(boolean lossy) {
        if (this.lossy == lossy) {
            return false;
        }
        this.lossy = lossy;
        return true;
    }

    protected class encColorDepth
    extends encodingParam {
        public boolean needTrueColor;
        int subformat;
        int rfbLRLESubencLossy;
        int rfbLRLESubencLossless;

        public encColorDepth(int id, String name, String shortname, int subformat, int rfbLRLESubencLossy, int rfbLRLESubencLossless, boolean truecolor) {
            super(id, name, shortname);
            this.subformat = subformat;
            this.rfbLRLESubencLossy = rfbLRLESubencLossy;
            this.rfbLRLESubencLossless = rfbLRLESubencLossless;
            this.needTrueColor = truecolor;
        }
    }

    protected class encCompression
    extends encodingParam {
        public int rfbEncoding;
        public int rfbCompressLevel;
        public int[] supportedColors;
        public boolean useCache;
        public boolean useLRLE;
        public boolean needTrueColor;

        public encCompression(int id, String name, String shortname, int encoding, int level, int[] colors, boolean cache, boolean lrle) {
            super(id, name, shortname);
            this.rfbEncoding = encoding;
            this.rfbCompressLevel = level;
            this.supportedColors = colors;
            this.useCache = cache;
            this.useLRLE = lrle;
        }
    }

    protected class encFix
    extends encodingParam {
        public int compression;
        public int color;
        public boolean useCache;
        public boolean lossy;

        public encFix(int id, String name, String shortname, int compression, int color, boolean lossy) {
            super(id, name, shortname);
            this.compression = compression;
            this.color = color;
            this.lossy = lossy;
        }
    }

    protected class encMode
    extends encodingParam {
        public encMode(int id, String name, String shortname) {
            super(id, name, shortname);
        }
    }

    protected class encodingParam {
        public int id;
        public String shortname;
        public String name;

        public encodingParam(int id, String name, String shortname) {
            this.id = id;
            this.name = name;
            this.shortname = shortname;
        }

        public String toString() {
            return new String("name=" + this.name + "(short=" + this.shortname + ",id=" + this.id + ")");
        }
    }
}

