/*
 * Decompiled with CFR 0.152.
 */
package nn.pp.drvredir;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.Socket;
import java.text.MessageFormat;
import nn.pp.drvredir.DriveAccess;
import nn.pp.rc.ErlaConnector;
import nn.pp.rc.RFBProfile;
import nn.pp.rc.T;

class MSPProto
extends ErlaConnector {
    static final String protoInitMsg = "e-RIC MSP P";
    static final String mspProtocolVersion = "e-RIC MSP 01.02\n";
    static final int MSP_TYPE_LOGIN = 0;
    static final int MSP_TYPE_RQ_CONNECTION = 1;
    static final int MSP_TYPE_SEND_DATA = 2;
    static final int MSP_TYPE_QUIT_CONNECTION = 3;
    static final int MSP_TYPE_PING = 4;
    static final int MSP_TYPE_PONG = 5;
    static final int MSP_TYPE_SESSION_ID = 6;
    static final int MSP_TYPE_RSP_CONNECTION = 128;
    static final int MSP_TYPE_RQ_DATA = 129;
    static final int MSP_TYPE_DATA_ACK = 130;
    static final int MSP_QUIT_USER_CANCELLED = 0;
    static final int MSP_QUIT_DEVICE_CANCELLED = 1;
    static final int MSP_DATA_OKAY = 0;
    static final int MSP_DATA_ERROR = 1;
    static final int MSP_DATA_NO_CD = 2;
    static final int MSP_DATA_NOT_COMPLETE = 3;
    static final int MSP_CONNECTION_RESP_OKAY = 0;
    static final int MSP_CONNECTION_RESP_NOT_AVAILABLE = 1;
    static final int MSP_CONNECTION_RESP_ALREADY_CONNECTED = 2;
    static final int MSP_CONNECTION_RESP_ALREADY_IMAGE = 3;
    static final int MSP_CONNECTION_RESP_PROTOCOL_ERROR = 4;
    static final int MSP_CONNECTION_RESP_AUTH_FAILED = 5;
    static final int MSP_CONNECTION_RESP_NO_PERMISSION = 6;
    static final int MSP_CONNECTION_RESP_INTERNAL_ERROR = 7;
    static final int MSP_CONNECTION_RESP_NO_SUCH_MS_INDEX = 8;
    static final int MSP_DISC_TYPE_CDROM = 0;
    static final int MSP_DISC_TYPE_FLOPPY = 1;
    static final int MSP_DISC_TYPE_REMOVABLE = 2;
    static final int MSP_DISC_TYPE_SOLID = 3;
    static final int MSP_DISC_NONE = 255;
    RFBProfile profile;
    PrintStream logger;
    DriveAccess drvAccess;
    boolean writeSupport;
    int msIndex;
    private Socket sock;
    private DataInputStream is;
    private DataOutputStream os;
    private boolean connected = false;
    private boolean supportProto_1_2 = false;
    private byte[] readbuf = null;
    private byte[] writebuf = null;

    MSPProto(RFBProfile prof, PrintStream logger, DriveAccess drvAccess, int msIndex) {
        super(prof, logger, "MSP");
        this.profile = prof;
        this.logger = logger;
        this.drvAccess = drvAccess;
        this.msIndex = msIndex;
    }

    static void debug(String s) {
    }

    void initializeMSPConnection(boolean writeSupport) throws Exception {
        this.writeSupport = writeSupport;
        this.connectNetwork();
        this.sendClientInit();
        this.negotiateProtocolVersion();
        if (this.profile.username != null && this.profile.password != null) {
            this.sendLogin(this.profile.username, this.profile.password);
        } else {
            this.sendAuth();
        }
        this.processResponse();
        this.sendConnectionRequest(false);
        this.processResponse();
    }

    void closeConnection(boolean sendQuitMessage) {
        if (!this.connected) {
            return;
        }
        if (sendQuitMessage) {
            try {
                this.sendQuitMessage(0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.disconnectNetwork();
        this.connected = false;
    }

    void processProtocol() throws IOException {
        if (!this.connected) {
            throw new IOException("Cannot process protocol, not connected.");
        }
        block7: while (this.connected) {
            int type = this.is.readByte() & 0xFF;
            switch (type) {
                case 4: {
                    this.processPingMessage();
                    continue block7;
                }
                case 5: {
                    this.processPongMessage();
                    continue block7;
                }
                case 3: {
                    this.processQuitMessage();
                    continue block7;
                }
                case 129: {
                    this.processDataRequestMessage();
                    continue block7;
                }
                case 2: {
                    this.processSendDataMessage();
                    continue block7;
                }
            }
            MSPProto.debug("Unknown MSP message received: " + Integer.toHexString(type));
            throw new IOException("Unknown protocol message received.");
        }
    }

    void sendMediumRemoval() throws IOException {
        this.sendConnectionRequest(true);
    }

    void sendMediumChange() throws IOException {
        this.sendConnectionRequest(false);
    }

    private void connectNetwork() throws IOException {
        this.logger.println("Connecting Drive Redirection to " + this.profile.remoteHost);
        if (this.profile.sslRequired || !this.profile.noTrialAndError) {
            this.sock = this.connectSSL(this.profile.remoteHost, this.profile.sslPort);
        }
        if (this.sock == null && !this.profile.sslRequired) {
            this.sock = this.connect(this.profile.remoteHost, this.profile.primaryPort);
        }
        if (this.sock == null && !this.profile.sslRequired && this.profile.useProxy) {
            this.sock = this.connectProxy(this.profile.proxyHost, this.profile.proxyPort, this.profile.remoteHost, this.profile.primaryPort);
        }
        if (this.sock == null) {
            throw new IOException(this.sockerr + " (" + T._("no connect options left") + ")");
        }
        this.connected = true;
        this.os = new DataOutputStream(this.sock.getOutputStream());
        this.is = new DataInputStream(new BufferedInputStream(this.sock.getInputStream(), 32768));
    }

    private void disconnectNetwork() {
        try {
            this.sock.close();
        }
        catch (IOException e) {
            e.printStackTrace(this.logger);
        }
    }

    private synchronized void sendClientInit() throws IOException {
        int l;
        MSPProto.debug("Sending Client initialization message.");
        this.os.write(protoInitMsg.getBytes());
        for (int i = l = protoInitMsg.length(); i < 19; ++i) {
            this.os.write(0);
        }
    }

    private synchronized void negotiateProtocolVersion() throws IOException {
        MSPProto.debug("Reading server version message.");
        byte[] b = new byte[16];
        this.is.readFully(b);
        if (b[0] != 101 || b[1] != 45 || b[2] != 82 || b[3] != 73 || b[4] != 67 || b[5] != 32 || b[6] != 77 || b[7] != 83 || b[8] != 80 || b[9] != 32 || b[10] < 48 || b[10] > 57 || b[11] < 48 || b[11] > 57 || b[12] != 46 || b[13] < 48 || b[13] > 57 || b[14] < 48 || b[14] > 57 || b[15] != 10) {
            throw new IOException(MessageFormat.format(T._("Host {0} hasn't a valid server version"), this.profile.remoteHost));
        }
        int serverMajor = (b[10] - 48) * 10 + (b[11] - 48);
        int serverMinor = (b[13] - 48) * 10 + (b[14] - 48);
        MSPProto.debug("MSP server supports protocol version " + serverMajor + "." + serverMinor + ".");
        int version = serverMajor * 1000 + serverMinor;
        if (version >= 1002) {
            this.supportProto_1_2 = true;
        }
        MSPProto.debug("Sending Client version message.");
        this.os.write(mspProtocolVersion.getBytes());
    }

    private synchronized void sendLogin(String user, String pass) throws IOException {
        MSPProto.debug("Logging in. Username: " + user + " Password: " + pass);
        this.os.writeByte(0);
        this.os.writeByte(0);
        this.os.writeShort(user.length() & 0xFFFF);
        this.os.writeShort(pass.length() & 0xFFFF);
        this.os.write(user.getBytes(), 0, user.length());
        this.os.write(pass.getBytes(), 0, pass.length());
    }

    private synchronized void sendAuth() throws Exception {
        MSPProto.debug("Sending session id.");
        this.os.writeByte(6);
        byte[] challenge_msg = new byte[73];
        byte[] challenge = new byte[64];
        MSPProto.debug("1");
        this.is.readFully(challenge_msg);
        System.arraycopy(challenge_msg, 9, challenge, 0, challenge.length);
        byte[] response = new byte[41];
        System.arraycopy("MSP RESP=".getBytes("ISO-8859-1"), 0, response, 0, 9);
        this.getChallengeResponse(challenge, response, 9);
        this.os.write(response);
        this.os.flush();
    }

    private synchronized void processResponse() throws IOException {
        MSPProto.debug("Processing connection response message.");
        int type = this.is.read();
        int ack = this.is.read();
        int reason = this.is.read();
        MSPProto.debug("Got connection response, ack = " + ack + ", reason = " + reason);
        if (ack == 0 || reason != 0) {
            switch (reason) {
                case 5: {
                    throw new IOException("Authentication failed.");
                }
                case 6: {
                    throw new IOException("You are not allowed to establish Drive Redirection.");
                }
                case 1: {
                    throw new IOException("Drive Redirection not available.");
                }
                case 2: {
                    throw new IOException("There is already a Drive Reconnection active on this device.");
                }
                case 3: {
                    throw new IOException("Another virtual image is already set on this device.");
                }
                case 8: {
                    throw new IOException("Mass storage index not available.");
                }
            }
            throw new IOException("Other response error: " + reason);
        }
        MSPProto.debug("Successfully logged in.");
    }

    private synchronized void sendConnectionRequest(boolean noMedium) throws IOException {
        int driveType = noMedium ? 255 : this.drvAccess.getMSPDriveType();
        if (this.supportProto_1_2) {
            this.os.write(1);
            this.os.write(this.msIndex);
            this.os.write(0);
            this.os.write(this.writeSupport ? 0 : 1);
            this.os.write(driveType);
            this.os.write(0);
            this.os.writeShort(this.drvAccess.getSectorSize() & 0xFFFF);
            this.os.writeInt(this.drvAccess.getSectorNo() & 0xFFFFFFFF);
        } else {
            this.os.write(1);
            this.os.write(0);
            this.os.write(this.writeSupport ? 0 : 1);
            this.os.write(driveType);
            this.os.writeShort(this.drvAccess.getSectorSize() & 0xFFFF);
            this.os.writeShort(0);
            this.os.writeInt(this.drvAccess.getSectorNo() & 0xFFFFFFFF);
        }
    }

    private String getQuitReason(int reason) {
        switch (reason) {
            case 0: {
                return "User cancelled connection";
            }
            case 1: {
                return "Device cancelled connection";
            }
        }
        return "Unknown quit reason";
    }

    private synchronized void sendQuitMessage(int reason) throws IOException {
        MSPProto.debug("Sending quit message, reason = " + this.getQuitReason(reason) + " (" + reason + ")");
        this.os.write(3);
        this.os.write(reason & 0xFF);
    }

    private synchronized void processPingMessage() throws IOException {
        MSPProto.debug("Got ping message, sending pong.");
        this.os.write(5);
    }

    private synchronized void processPongMessage() throws IOException {
        MSPProto.debug("Got pong message.");
    }

    private synchronized void processQuitMessage() throws IOException {
        int reason = this.is.readByte() & 0xFF;
        MSPProto.debug("Got quit message, reason = " + this.getQuitReason(reason) + " (" + reason + ")");
        throw new IOException(this.getQuitReason(reason));
    }

    private void checkReadBufSize(int newSize) {
        if (this.readbuf == null || this.readbuf.length < newSize) {
            this.readbuf = new byte[newSize];
        }
    }

    private void checkWriteBufSize(int newSize) {
        if (this.writebuf == null || this.writebuf.length < newSize) {
            this.writebuf = new byte[newSize];
        }
    }

    private synchronized void processDataRequestMessage() throws IOException {
        MSPProto.debug("Reading data request message.");
        int sectorSize = this.drvAccess.getSectorSize();
        this.is.read();
        int count = this.is.readShort() & 0xFFFF;
        long startsec = this.is.readInt() & 0xFFFFFFFF;
        MSPProto.debug("Requested " + count + " sectors beginning from " + startsec);
        int code = 0;
        try {
            this.checkReadBufSize(count * sectorSize);
        }
        catch (Exception e) {
            code = 1;
            this.logger.println("Could not incerase read buffer.");
            e.printStackTrace();
        }
        if (code == 0) {
            try {
                this.drvAccess.readCDSectors(startsec, count, this.readbuf);
            }
            catch (Exception e) {
                code = 2;
                e.printStackTrace();
            }
        }
        if (code != 0) {
            count = 0;
        }
        this.os.writeByte(2);
        this.os.writeByte(code & 0xFF);
        this.os.writeShort(code == 0 ? count & 0xFFFF : 0);
        this.os.writeShort(code == 0 ? sectorSize & 0xFFFF : 0);
        this.os.writeShort(0);
        this.os.writeInt(0);
        if (code == 0) {
            this.os.write(this.readbuf, 0, count * sectorSize);
        }
    }

    private synchronized void processSendDataMessage() throws IOException {
        this.is.readByte();
        int count = this.is.readShort() & 0xFFFF;
        int sectorSize = this.is.readShort() & 0xFFFF;
        this.is.readShort();
        long startsec = this.is.readInt() & 0xFFFFFFFF;
        this.checkWriteBufSize(count * sectorSize);
        this.is.readFully(this.writebuf, 0, count * sectorSize);
        int ack = 0;
        try {
            if (this.writeSupport) {
                this.drvAccess.writeCDSectors(startsec, count, this.writebuf);
                ack = 1;
            } else {
                MSPProto.debug("Cannot write data because device is read only.");
            }
        }
        catch (Exception e) {
            this.logger.println("Could not write drive sectors.");
            e.printStackTrace();
        }
        this.os.writeByte(130);
        this.os.writeByte(ack & 0xFF);
    }
}

