/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.util.StringUtil;
import java.util.ArrayList;
import java.util.List;

public class SmbiosSummaryCommand {
    String[] baseboard;
    ArrayList<String[]> bios = new ArrayList();
    ArrayList<String[]> processor = new ArrayList();
    ArrayList<String[]> memoryDevice = new ArrayList();
    ArrayList<String[]> storage = new ArrayList();
    int totalProcessor;
    int availableProcessor;
    int totalMemory;
    int availableMemory;
    String formatTemplate1 = " =========================================================\n";
    String formatTemplate2 = " ---------------------------------------------------------\n";

    public void setBaseboard(String[] baseboard) {
        this.baseboard = baseboard;
    }

    public void setBios(String[] bios) {
        this.bios.add(bios);
    }

    public void setProcessor(String[] processor) {
        this.processor.add(processor);
    }

    public void setMemoryDevice(String[] memoryDevice) {
        this.memoryDevice.add(memoryDevice);
    }

    public void setStorage(String[] storage) {
        this.storage.add(storage);
    }

    public void addTotalProcessor() {
        ++this.totalProcessor;
    }

    public void addAvailableProcessor() {
        ++this.availableProcessor;
    }

    public void addTotalMemory() {
        ++this.totalMemory;
    }

    public void addAvailableMemory() {
        ++this.availableMemory;
    }

    public void reset() {
        this.bios.clear();
        this.processor.clear();
        this.memoryDevice.clear();
        this.storage.clear();
        this.totalProcessor = 0;
        this.availableProcessor = 0;
        this.totalMemory = 0;
        this.availableMemory = 0;
    }

    public void printSummary() {
        MOut.G().print("\n");
        MOut.G().print(this.formatTemplate1);
        MOut.G().print(this.toFormatedHeader("BIOS"));
        MOut.G().print(this.toFormatedDualString(this.bios));
        MOut.G().print(this.toFormatedHeader("Processor (" + this.availableProcessor + "/" + this.totalProcessor + ")"));
        MOut.G().print(this.toFormatedString(this.processor));
        MOut.G().print(this.toFormatedHeader("Memory Device (" + this.availableMemory + "/" + this.totalMemory + ")"));
        MOut.G().print(this.toFormatedDualString(this.memoryDevice));
        MOut.G().print(this.toFormatedHeader("Storage"));
        if (this.storage.isEmpty()) {
            MOut.G().print(" None \n");
            MOut.G().print(this.formatTemplate1);
        } else {
            MOut.G().print(this.toFormatedDualString(this.storage));
        }
    }

    String toFormatedHeader(String title) {
        StringBuffer header = new StringBuffer();
        header.append(String.format(StringUtil.center(title, 60) + "\n", new Object[0]));
        header.append(String.format(this.formatTemplate2, new Object[0]));
        return header.toString();
    }

    String toFormatedString(List<String[]> list) {
        String format = " %-7s %49s \n";
        StringBuffer fStr = new StringBuffer();
        for (String[] str : list) {
            fStr.append(String.format(format, str[0], str[1]));
        }
        fStr.append(String.format(this.formatTemplate1, new Object[0]));
        return fStr.toString();
    }

    String toFormatedDualString(List<String[]> list) {
        String format = " %-27s | %27s \n";
        StringBuffer fStr = new StringBuffer();
        for (String[] str : list) {
            fStr.append(String.format(format, str[0], str[1]));
        }
        fStr.append(String.format(this.formatTemplate1, new Object[0]));
        return fStr.toString();
    }
}

