/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.IOException;

public class KVMCommand
extends SuperBladeCommand {
    public KVMCommand() {
        this.isSupportBackgroundModeForTaskRunCommand = false;
    }

    @Override
    public void runCommand() throws Exception {
        if (!this.isKVMSupported()) {
            this.printSlaveCMMUnavailableMessage();
            return;
        }
        File f = new File("KVMPlugIn.jar");
        if (!f.exists()) {
            MOut.G(this).println("Cannot find KVMPlugIn.jar");
            this.statusCode = 149;
            return;
        }
        boolean result = GraphicsEnvironment.isHeadless();
        if (result) {
            MOut.G(this).print("No graphic environment here !");
            return;
        }
        MOut.G(this).print("Starting KVM Process...");
        File jre = new File("jre");
        String execString = jre.isDirectory() ? (System.getProperty("os.name").indexOf("Windows") >= 0 ? ".\\jre\\bin\\java -jar KVMPlugIn.jar " + this.config.getIp() + " " + this.config.getUserName() + " " + this.config.getPassword() : "./jre/bin/java -jar KVMPlugIn.jar " + this.config.getIp() + " " + this.config.getUserName() + " " + this.config.getPassword()) : "java -jar KVMPlugIn.jar " + this.config.getIp() + " " + this.config.getUserName() + " " + this.config.getPassword();
        try {
            Process process = Runtime.getRuntime().exec(execString);
        }
        catch (IOException ex) {
            MOut.G(this).println(" Failed");
            return;
        }
        MOut.G(this).println("Done");
        MOut.G(this).println("Please wait for KVM window");
    }

    public boolean isKVMSupported() {
        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(this.config.getIp());
        if (guid == null) {
            return false;
        }
        if (IPMIMessagingCommand.isCMMGUID(guid)) {
            return this.isCurrentCMMMaster();
        }
        if (IPMIMessagingCommand.isPepperconGUID(guid)) {
            return true;
        }
        if (IPMIMessagingCommand.isPepperconNoneKVMGUID(guid)) {
            return true;
        }
        if (IPMIMessagingCommand.isSIMBL(guid)) {
            return true;
        }
        if (IPMIMessagingCommand.isOSAGUID(guid)) {
            return false;
        }
        return false;
    }
}

