/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.IPMIMicroBladeOEMCommand;
import com.supermicro.ipmi.blade.BladeSystemEntity;
import com.supermicro.ipmi.blade.CMMModuleEntity;
import com.supermicro.ipmi.microblade.CMM2CMMInfo;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class AllCMMStatusCommand
extends SuperBladeCommand {
    @Override
    public void runCommand() throws Exception {
        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(this.config.getIp());
        if (IPMIMessagingCommand.isMicroBladeCMMGUID(guid)) {
            IPMIMicroBladeOEMCommand ipmiMicroBladeOEMCommand = new IPMIMicroBladeOEMCommand(null);
            ipmiMicroBladeOEMCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
            CMM2CMMInfo cmm2cmmInfo = ipmiMicroBladeOEMCommand.getCMM2CMMInfo();
            int cmmCount = 1;
            if (cmm2cmmInfo.isOtherCMMPresent()) {
                ++cmmCount;
            }
            StringBuffer sb = new StringBuffer();
            sb.append("CMM Module(" + cmmCount + "/2)\n");
            sb.append("----------------\n");
            String formatHeaderTemplate = " %-5s | %-6s | %-8s\n";
            sb.append(String.format(formatHeaderTemplate, "CMM", "M/S", "Status"));
            sb.append(String.format(formatHeaderTemplate, "---", "---", "------"));
            String index = "CMM 1";
            String master = cmm2cmmInfo.isMaster() ? "Master" : "Slave";
            String status = "OK";
            sb.append(String.format(formatHeaderTemplate, index, master, status));
            if (cmmCount > 1) {
                index = "CMM 2";
                master = cmm2cmmInfo.isMaster() ? "Slave" : "Master";
                status = cmm2cmmInfo.isOtherCMMAlive() ? "OK" : "Err";
                sb.append(String.format(formatHeaderTemplate, index, master, status));
            }
            MOut.G(this).println(sb.toString());
            int masterDevice = 1;
            if (cmm2cmmInfo.isMaster() && cmm2cmmInfo.isOtherCMMPresent() && cmm2cmmInfo.isOtherCMMAlive()) {
                masterDevice = 2;
            }
            MOut.G(this).println("CMM " + masterDevice + " is being managed now");
            MOut.G(this).println("");
            MOut.G(this).println("CMM IP address:");
            MOut.G(this).println("---------------");
            MOut.G(this).println("CMM 1 IP: " + this.config.getIp());
            this.statusCode = 0;
            return;
        }
        if (!this.isMaster) {
            this.printSlaveCMMUnavailableMessage();
            this.statusCode = 150;
            return;
        }
        BladeSystemEntity bladeSystem = new BladeSystemEntity(this.config);
        bladeSystem.setEnableAllQuery(false);
        bladeSystem.setIsQueryCMMModuleEntity(true);
        bladeSystem.getData();
        if (!bladeSystem.isLoginSuccessful) {
            MOut.G(this).println("Login error!");
            this.statusCode = 146;
            return;
        }
        MOut.G(this).println(bladeSystem.toCMMFormatedString());
        int currentCMM = 0;
        for (int i = 0; i < bladeSystem.getCmmModules().length; ++i) {
            if (!bladeSystem.getCmmModules()[i].isConnected()) continue;
            MOut.G(this).println("CMM " + (i + 1) + " is being managed now");
            currentCMM = i;
        }
        MOut.G(this).println("");
        MOut.G(this).println("CMM IP address:");
        MOut.G(this).println("---------------");
        CMMModuleEntity cmm1 = bladeSystem.getCmmModules()[0];
        CMMModuleEntity cmm2 = bladeSystem.getCmmModules()[1];
        String otherCMMIP = this.ipmiCMMOEMCommand.getCMMOtherIP();
        if (currentCMM == 0) {
            if (cmm1.getPresent() > 0) {
                MOut.G(this).println("CMM 1 IP: " + this.config.getIp());
            }
            if (cmm2.getPresent() > 0) {
                MOut.G(this).println("CMM 2 IP: " + otherCMMIP);
            }
        } else {
            if (cmm1.getPresent() > 0) {
                MOut.G(this).println("CMM 1 IP: " + otherCMMIP);
            }
            if (cmm2.getPresent() > 0) {
                MOut.G(this).println("CMM 2 IP: " + this.config.getIp());
            }
        }
        this.statusCode = 0;
    }
}

