/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ConfigAccessor;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.IPMIOEMPortServiceCommand;
import com.supermicro.ipmi.stunnel.StunnelParameters;
import com.supermicro.ipmi.stunnel.StunnelUtility;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class ATENKVMCommand
extends SuperBladeCommand {
    public static final int timeout = 5;

    public ATENKVMCommand() {
        this.isSupportBackgroundModeForTaskRunCommand = false;
    }

    @Override
    public void runCommand() throws Exception {
        int vmType = 2;
        String ip = this.config.getIp();
        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(this.config.getIp());
        if (IPMIMessagingCommand.isATENAspeedGUID(guid) || IPMIMessagingCommand.isSAS3_946E90GUID(guid) || IPMIMessagingCommand.isAST2400GUID(guid) || IPMIMessagingCommand.isAST2500GUID(guid) || IPMIMessagingCommand.is8USuperBladeGUID(guid) || IPMIMessagingCommand.isAST2500HW1GUID(guid) || IPMIMessagingCommand.isH11GUID(guid) || IPMIMessagingCommand.isP8DTUGUID(guid) || IPMIMessagingCommand.isPOWER9GUID(guid) || IPMIMessagingCommand.isH12GUID(guid)) {
            vmType = 0;
        }
        if (!this.isATENKVMSupported()) {
            this.printUnavailableMessage();
            return;
        }
        boolean result = GraphicsEnvironment.isHeadless();
        if (result) {
            MOut.G(this).print("No graphic environment here !");
            return;
        }
        File f = new File("iKVM.jar");
        if (!f.exists()) {
            MOut.G(this).println("Cannot find iKVM.jar");
            this.statusCode = 149;
            return;
        }
        IPMIOEMPortServiceCommand ipmiOEMPortServiceCommand = new IPMIOEMPortServiceCommand(null);
        ipmiOEMPortServiceCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        String port = "5900";
        try {
            port = String.valueOf(ipmiOEMPortServiceCommand.getPort((byte)2));
        }
        catch (IPMIException iPMIException) {
            // empty catch block
        }
        ConfigAccessor ca = new ConfigAccessor(".", "SMCIPMITool.properties");
        if (ca.getProperty("bmc_security") == null) {
            ca.setProperty("bmc_security", "on");
        }
        String isUseStunnel = ca.getProperty("bmc_security");
        boolean isStunnelSupport = ipmiOEMPortServiceCommand.checkStunnelSupport();
        boolean isIPv6 = false;
        if ("on".equals(isUseStunnel) && isStunnelSupport) {
            String kvmPort = "3520";
            int CAMode = 0;
            int stunnelVer = ipmiOEMPortServiceCommand.checkStunenelVer();
            if (stunnelVer > 1) {
                try {
                    kvmPort = String.valueOf(ipmiOEMPortServiceCommand.getPort((byte)2));
                }
                catch (IPMIException e) {
                    kvmPort = "3520";
                }
            }
            switch (stunnelVer) {
                case 3: {
                    CAMode = 0;
                    break;
                }
                case 5: {
                    CAMode = 1;
                    break;
                }
                case 7: {
                    CAMode = 2;
                    break;
                }
                default: {
                    CAMode = 0;
                }
            }
            MOut.G(this).println("This device support stunnel.");
            StunnelParameters parameters = new StunnelParameters.Builder(ip, kvmPort).command("iKVM").build();
            try {
                StunnelUtility.configAndStartStunnel(parameters, this.ipmiCMMOEMCommand.getIPMIInterface(), CAMode);
                this.startKVM(vmType, parameters.getSturnnlPort(), parameters.getStunnelIP(), this.config.getUserName(), this.config.getPassword(), parameters.getBMCIP(), parameters.getStunnelFolder());
            }
            catch (Exception e) {
                MOut.G(this).println("Config stunnel or start stunnel fail " + e);
            }
        } else {
            ip = this.config.getIp();
            this.startKVM(vmType, port, ip, this.config.getUserName(), this.config.getPassword());
        }
    }

    public void printUnavailableMessage() {
        MOut.G(this).println("This function is unavailable for this device.");
    }

    public boolean isATENKVMSupported() {
        boolean result = false;
        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(this.config.getIp());
        if (guid == null) {
            result = false;
        } else if (IPMIMessagingCommand.isATENGUID(guid) || IPMIMessagingCommand.isATENAspeedGUID(guid) || IPMIMessagingCommand.isMicroBladeNodeGUID(guid) || IPMIMessagingCommand.isATENSuperBladeGUID(guid) || IPMIMessagingCommand.isSAS3_946E90GUID(guid) || IPMIMessagingCommand.isAST2400GUID(guid) || IPMIMessagingCommand.isAST2500GUID(guid) || IPMIMessagingCommand.isP8DTUGUID(guid) || IPMIMessagingCommand.isPOWER9GUID(guid) || IPMIMessagingCommand.is8USuperBladeGUID(guid) || IPMIMessagingCommand.isAST2500HW1GUID(guid) || IPMIMessagingCommand.isH11GUID(guid) || IPMIMessagingCommand.isH12GUID(guid)) {
            result = true;
        }
        return result;
    }

    public void startKVM(int vmType, String port, String ip, String id, String pw) {
        MOut.G(this).print("Starting iKVM Process...");
        File jre = new File("jre");
        File f = new File("." + File.separator + ip + ".temp");
        try {
            FileWriter fw = new FileWriter("." + File.separator + ip + ".temp");
            fw.write("ID: " + id + "\n");
            fw.write("Password: " + pw + "\n");
            fw.write("Port: " + port + "\n");
            fw.write("Vm: " + vmType + "\n");
            fw.close();
        }
        catch (IOException fw) {
            // empty catch block
        }
        String execString = jre.isDirectory() ? (System.getProperty("os.name").indexOf("Windows") >= 0 ? ".\\jre\\bin\\java -Djava.library.path=. -jar iKVM.jar " + ip + " 0 0 --FR" : "./jre/bin/java -Djava.library.path=. -jar iKVM.jar " + ip + " 0 0 --FR") : "java -Djava.library.path=. -jar iKVM.jar " + ip + " 0 0 --FR";
        try {
            Runtime.getRuntime().exec(execString);
        }
        catch (IOException ex) {
            MOut.G(this).println(" Failed " + ex);
            return;
        }
        MOut.G(this).println("Done");
        MOut.G(this).println("Please wait for iKVM window");
    }

    public void startKVM(int vmType, String port, String ip, String id, String pw, String BMCIP, String stunnleFolder) {
        MOut.G(this).print("Starting iKVM Process...");
        File jre = new File("jre");
        File f = new File("." + File.separator + BMCIP + ".temp");
        try {
            FileWriter fw = new FileWriter("." + File.separator + BMCIP + ".temp");
            fw.write("ID: " + id + "\n");
            fw.write("Password: " + pw + "\n");
            fw.write("Port: " + port + "\n");
            fw.write("Vm: " + vmType + "\n");
            fw.close();
        }
        catch (IOException fw) {
            // empty catch block
        }
        String execString = jre.isDirectory() ? (System.getProperty("os.name").indexOf("Windows") >= 0 ? ".\\jre\\bin\\java -Djava.library.path=. -jar iKVM.jar " + ip + " 0 0 --FR --BMCIP" + BMCIP + " --stunnelFolder-" + stunnleFolder : "./jre/bin/java -Djava.library.path=. -jar iKVM.jar " + ip + " 0 0 --FR --BMCIP" + BMCIP + " --stunnelFolder-" + stunnleFolder) : "java -Djava.library.path=. -jar iKVM.jar " + ip + " 0 0 --FR --BMCIP" + BMCIP + " --stunnelFolder-" + stunnleFolder;
        try {
            Runtime.getRuntime().exec(execString);
        }
        catch (IOException ex) {
            MOut.G(this).println(" Failed " + ex);
            return;
        }
        MOut.G(this).println("Done");
        MOut.G(this).println("Please wait for iKVM window");
    }
}

