/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.nm.cups;

import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.IPMINM20Command;
import com.supermicro.ipmi.nm.Common;
import com.supermicro.ipmi.nm.cups.CUPSPolicyParam;
import java.util.HashMap;
import java.util.Map;

public class SetCUPSPolicy {
    private static final Map<String, String> completionCodeToString = new HashMap<String, String>();
    private IPMINM20Command ipmiCommand;
    private CUPSPolicyParam policy;

    public SetCUPSPolicy(IPMINM20Command ipmiCommand, CUPSPolicyParam policy) {
        this.ipmiCommand = ipmiCommand;
        this.policy = policy;
    }

    public void execute() throws IPMIException {
        IPMIMessage resMessage = this.ipmiCommand.setCUPSPolicyCommand(this.policy.policyID, this.policy.targetID, this.policy.policyStatus, this.policy.policyType, this.policy.policyActions, this.policy.CUPSThreshold, this.policy.avgWindow);
        if (resMessage != null) {
            if (resMessage.completionCode != 0) {
                throw Common.cCodeToException(completionCodeToString, resMessage);
            }
        } else {
            throw new IPMIException("Call SetCUPSPolicies failed");
        }
    }

    static {
        completionCodeToString.put("80", "Policy ID Invalid.");
    }
}

