/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMICommand;
import com.supermicro.ipmi.IPMIInterface;
import com.supermicro.ipmi.IPMIMessage;
import java.util.Arrays;

public class MDRRegionReadCommand
extends IPMICommand {
    final byte intelRSDSpec = (byte)4;
    final byte smbiosRegion = 1;
    final byte iSCSIRegion = (byte)4;
    int readLength;
    int updateCount;
    byte[] data;
    boolean isReadLength = false;
    boolean isUpdateCount = false;
    boolean isData = false;

    public MDRRegionReadCommand(IPMIInterface ipmiInterface) {
        super(ipmiInterface);
    }

    public int readLength() {
        return this.readLength;
    }

    public int updateCount() {
        return this.updateCount;
    }

    public String getData() {
        return ByteUtility.bytesToHex(this.data).trim();
    }

    public byte[] getDataByte() {
        return this.data;
    }

    public MDRRegionReadCommand getMDRRegionRead(int dataLength, byte[] offset) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{4, 1, (byte)dataLength};
        byte[] destData = new byte[5];
        System.arraycopy(data, 0, destData, 0, data.length);
        System.arraycopy(offset, 0, destData, data.length, offset.length);
        ipmiMessage.setCommandAndData((byte)-80, (byte)34, destData);
        IPMIMessage resMessage = this.getIPMIInterface().send(ipmiMessage);
        MDRRegionReadCommand mdrRegionRead = new MDRRegionReadCommand(this.getIPMIInterface());
        if (resMessage != null && resMessage.completionCode == 0) {
            try {
                mdrRegionRead.readLength = Integer.parseInt(ByteUtility.byteToHex(resMessage.data[1]), 16);
                mdrRegionRead.isReadLength = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                mdrRegionRead.updateCount = resMessage.data[2];
                mdrRegionRead.isUpdateCount = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                byte[] finalData = new byte[resMessage.data.length - 3];
                finalData = Arrays.copyOfRange(resMessage.data, 3, resMessage.data.length);
                mdrRegionRead.data = finalData;
                mdrRegionRead.isData = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return mdrRegionRead;
    }

    public String toFormatedHeader() {
        String formatTemplate = " %-20s | %20s \n";
        StringBuffer header = new StringBuffer();
        header.append(String.format(formatTemplate, "Item", "Value"));
        header.append(String.format(formatTemplate, "----", "-----"));
        return header.toString();
    }

    public String toFormatedString() {
        String format = " %-20s | %20s \n";
        StringBuffer fStr = new StringBuffer();
        fStr.append(String.format(format, "Read Length", this.isReadLength ? Integer.valueOf(this.readLength()) : "N/A"));
        fStr.append(String.format(format, "Update Count", this.isUpdateCount ? Integer.valueOf(this.updateCount()) : "N/A"));
        fStr.append(String.format(format, "Data", this.isData ? this.getData() : "N/A"));
        return fStr.toString();
    }
}

