/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text.nm.suspendperiod;

import com.supermicro.ipmi.text.nm.suspendperiod.AbstractSuspenPeriodCommand;
import com.supermicro.ipmi.text.nm.suspendperiod.SuspendPeriodRaw;
import java.text.ParseException;

public class UpdatePeriod
extends AbstractSuspenPeriodCommand {
    private int domainId;
    private int policyId;
    private int periodId;
    private int startTimeInMinute = -1;
    private int stopTimeInMinute = -1;
    private int[] days;

    public UpdatePeriod(String[] parameters) {
        super(parameters);
        try {
            this.validate(parameters);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Invalid value: " + e.getMessage());
        }
    }

    protected void validate(String[] parameters) throws ParseException {
        if (parameters == null || parameters.length < 4 || parameters.length > 6) {
            this.help();
            throw new IllegalArgumentException();
        }
        this.domainId = Integer.parseInt(parameters[0]);
        this.policyId = Integer.parseInt(parameters[1]);
        this.periodId = Integer.parseInt(parameters[2]);
        if (this.domainId < 0 || this.policyId < 0 || this.policyId > 255 || this.periodId < 1 || this.periodId > 5) {
            throw new IllegalArgumentException("Invalid value");
        }
        for (int i = 3; i < parameters.length; ++i) {
            String[] split = parameters[i].split("=");
            if ("start".equalsIgnoreCase(split[0])) {
                this.startTimeInMinute = this.getTimeInMinute(split[1]);
                continue;
            }
            if ("stop".equalsIgnoreCase(split[0])) {
                this.stopTimeInMinute = this.getTimeInMinute(split[1]);
                continue;
            }
            if ("days".equalsIgnoreCase(split[0])) {
                this.days = this.getDays(split[1]);
                continue;
            }
            throw new IllegalArgumentException("Invalid parameter");
        }
    }

    @Override
    public byte[] getNewPeriod(byte[] currentPeriod) {
        SuspendPeriodRaw period = new SuspendPeriodRaw(currentPeriod);
        return period.update(this.periodId, this.startTimeInMinute, this.stopTimeInMinute, this.getRecurrencePattern(this.days));
    }

    @Override
    public int getDomainId() {
        return this.domainId;
    }

    @Override
    public int getPolicyId() {
        return this.policyId;
    }

    @Override
    public void help() {
        System.out.println("update <domainId> <policyId> <periodId> [start=<startTime> stop=<stopTime> days=<days>]");
        System.out.println("domainId :");
        System.out.println("\t0 \u00a1V Entire platform");
        System.out.println("\t1 \u00a1V CPU subsystem");
        System.out.println("\t2 \u00a1V Memory subsystem");
        System.out.println("\t3 \u00a1V HW Proection (NM3.0)");
        System.out.println("\t4 \u00a1V High Power I/O subsystem");
        System.out.println("policyId : 0~255");
        System.out.println("periodId : 1~5");
        System.out.println("startTime: Policy suspend start time (HHmm) [0000~2359]");
        System.out.println("stopTime : Policy suspend stop time (HHmm) [0006~2400]");
        System.out.println("\t* If there is a need to specify an end-time that is beyond midnight, use two suspend periods.");
        System.out.println("days     : Suspend period recurrence");
        System.out.println("\t1 \u00a1V Monday, 2 \u00a1V Tuesday, 3 \u00a1V Wednesday, 4 \u00a1V Thursday, 5 \u00a1V Friday, 6 - Saturday, 7 - Sunday");
        System.out.println("\tex: every Monday, Wednesday, Sunday => 137");
    }
}

