/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text.nm.summary;

import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMINM20Command;
import com.supermicro.ipmi.text.nm.summary.NMCUPSUtil;
import com.supermicro.ipmi.util.StringUtil;

public class CUPSUtilizationInfo {
    private NMCUPSUtil.CUPS usage;
    private boolean exception = false;
    private String splitLine = "+------------------------------------+";
    private String splitLineD = "+====================================+";
    private String format = "|%-24s|%11s|\n";
    private String[] fields = new String[]{"Domain", "Usage (%)"};

    public CUPSUtilizationInfo(IPMINM20Command ipmiCommand) {
        try {
            NMCUPSUtil cups = new NMCUPSUtil(ipmiCommand);
            this.usage = cups.getCUPS();
        }
        catch (IPMIException e) {
            this.exception = true;
            System.out.format("[Error] Get CUPS Information %s", e.getMessage() == null ? "" : ":" + e.getMessage());
        }
    }

    public void lineDisplay() {
        if (this.exception) {
            return;
        }
        System.out.format("CUPS (%%):\n\tCore: %d, Memory: %d, IO: %d\n", this.usage.core, this.usage.mem, this.usage.io);
    }

    public void display() {
        System.out.println(StringUtil.center("CUPS Utilization", this.splitLine.length()));
        System.out.println(this.splitLine);
        System.out.format(this.format, this.fields);
        System.out.println(this.splitLineD);
        System.out.format(this.format, "Core", this.usage.core);
        System.out.println(this.splitLine);
        System.out.format(this.format, "Memory", this.usage.mem);
        System.out.println(this.splitLine);
        System.out.format(this.format, "IO", this.usage.io);
        System.out.println(this.splitLine);
    }
}

