/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;
import java.io.File;
import tw.com.aten.vstorage.VirtualStorage;
import tw.com.aten.vstorage.VirtualStorageManager;

public class VMWACommand
extends SuperBladeCommand {
    private SubCommand subCommand = SubCommand.NO_COMMAND;

    public VMWACommand() {
        this.isSupportBackgroundModeForTaskRunCommand = false;
    }

    @Override
    public String[] getSubCommandsForTabCompletion() {
        return new String[]{"dev1list", "dev1drv", "dev2list", "dev2cd", "dev2dvd", "dev2iso", "dev1stop", "dev2stop", "log", "allstatus", "status"};
    }

    @Override
    public boolean preValidate() {
        boolean passValidate = false;
        if (!this.isVirutalMediaSupported()) {
            this.printSlaveCMMUnavailableMessage();
            return false;
        }
        if (this.parameters != null) {
            if (this.parameters[0].equalsIgnoreCase("dev1list")) {
                this.subCommand = SubCommand.DEV1_LIST;
                passValidate = true;
            } else if (this.parameters[0].equalsIgnoreCase("dev1drv")) {
                this.subCommand = SubCommand.DEV1_DRV;
                passValidate = true;
            } else if (this.parameters[0].equalsIgnoreCase("dev2list")) {
                this.subCommand = SubCommand.DEV2_LIST;
                passValidate = true;
            } else if (this.parameters[0].equalsIgnoreCase("dev2cd")) {
                this.subCommand = SubCommand.DEV2_CD;
                passValidate = true;
            } else if (this.parameters[0].equalsIgnoreCase("dev2dvd")) {
                this.subCommand = SubCommand.DEV2_DVD;
                passValidate = true;
            } else if (this.parameters[0].equalsIgnoreCase("dev2iso")) {
                this.subCommand = SubCommand.DEV2_ISO;
                passValidate = true;
            } else if (this.parameters[0].equalsIgnoreCase("dev1stop")) {
                this.subCommand = SubCommand.DEV1_STOP;
                passValidate = true;
            } else if (this.parameters[0].equalsIgnoreCase("dev2stop")) {
                this.subCommand = SubCommand.DEV2_STOP;
                passValidate = true;
            } else if (this.parameters[0].equalsIgnoreCase("log")) {
                this.subCommand = SubCommand.LOG;
                passValidate = true;
            } else if (this.parameters[0].equalsIgnoreCase("allstatus")) {
                this.subCommand = SubCommand.ALL_STATUS;
                passValidate = true;
            } else if (this.parameters[0].equalsIgnoreCase("status")) {
                this.subCommand = SubCommand.STATUS;
                passValidate = true;
            }
        } else {
            this.printUsage();
            return false;
        }
        switch (this.subCommand) {
            case DEV1_LIST: 
            case DEV2_LIST: 
            case DEV1_STOP: 
            case DEV2_STOP: 
            case LOG: 
            case ALL_STATUS: 
            case STATUS: {
                break;
            }
            case DEV1_DRV: 
            case DEV2_CD: 
            case DEV2_DVD: 
            case DEV2_ISO: {
                if (this.parameters.length == 2) break;
                passValidate = false;
            }
        }
        if (!passValidate) {
            this.printUsage();
            return false;
        }
        return true;
    }

    public void printUsage() {
        MOut.G(this).println("Available commands:");
        MOut.G(this).println("dev1list             List available devices for virtual device 1");
        MOut.G(this).println("dev1drv <index>      Mount drive for virtual device 1");
        MOut.G(this).println("dev1stop             Stop virtual device 1");
        MOut.G(this).println("dev2list             List available devices for virtual device 2");
        MOut.G(this).println("dev2cd  <index>      Mount CD/DVD for virtual device 2");
        MOut.G(this).println("dev2iso <filename>   Mount ISO file for virtual device 2");
        MOut.G(this).println("dev2stop             Stop virtual device 2");
        MOut.G(this).println("allstatus            Show all VMWA status");
        MOut.G(this).println("status               Show status");
        MOut.G(this).println("log                  Show log");
        MOut.G(this).println("");
        MOut.G(this).println("");
        MOut.G(this).println("Note: ");
        MOut.G(this).println("* Support 2 virtual devices (device 1 & device 2)");
        MOut.G(this).println("  Device 1 will be Hard Disk,USB or Floppy");
        MOut.G(this).println("  Device 2 will be CD,DVD or ISO file");
        MOut.G(this).println("* List available devices before mount virtual media when plug in ");
        MOut.G(this).println("  Removable device");
    }

    @Override
    public void runCommand() throws Exception {
        switch (this.subCommand) {
            case DEV1_LIST: {
                this.dev1List();
                break;
            }
            case DEV2_LIST: {
                this.dev2List();
                break;
            }
            case DEV1_STOP: {
                this.dev1Stop();
                break;
            }
            case DEV2_STOP: {
                this.dev2Stop();
                break;
            }
            case LOG: {
                this.log();
                break;
            }
            case ALL_STATUS: {
                this.allStatus();
                break;
            }
            case STATUS: {
                this.status();
                break;
            }
            case DEV1_DRV: {
                this.dev1Drv();
                break;
            }
            case DEV2_CD: {
                this.dev2cd();
                break;
            }
            case DEV2_DVD: {
                this.dev2dvd();
                break;
            }
            case DEV2_ISO: {
                this.dev2iso();
            }
        }
    }

    public void dev1List() {
        String str = VirtualStorageManager.getInstance().getVirtualStorage(this.config).dev1List();
        MOut.G(this).print(str);
    }

    public void dev2List() {
        String str = VirtualStorageManager.getInstance().getVirtualStorage(this.config).dev2List();
        MOut.G(this).print(str);
    }

    public void dev1Stop() {
        VirtualStorageManager.getInstance().getVirtualStorage(this.config).dev1Unmount();
        MOut.G(this).print("done");
    }

    public void dev2Stop() {
        VirtualStorageManager.getInstance().getVirtualStorage(this.config).dev2Unmount();
        MOut.G(this).print("done");
    }

    public void log() {
        String str = VirtualStorageManager.getInstance().getVirtualStorage(this.config).getLog();
        MOut.G(this).print(str);
    }

    public void allStatus() {
        String str = VirtualStorageManager.getInstance().getMountStatus();
        MOut.G(this).print(str);
    }

    public void status() {
        String str = VirtualStorageManager.getInstance().getVirtualStorage(this.config).mountStatus();
        MOut.G(this).print(str);
    }

    public void dev1Drv() {
        int index;
        VirtualStorage vs = VirtualStorageManager.getInstance().getVirtualStorage(this.config);
        String p1 = this.parameters[1];
        try {
            index = Integer.parseInt(p1);
        }
        catch (NumberFormatException ex) {
            MOut.G(this).println(ex.getMessage());
            return;
        }
        if (!vs.checkIsDev1IndexValid(index)) {
            MOut.G(this).print("Index invalid");
            return;
        }
        if (vs.getDev1MountIndex() != 0) {
            MOut.G(this).print("Device 1 is mounted already");
            return;
        }
        MOut.G(this).println("Mounting " + vs.getDev1Array()[index]);
        vs.dev1Mount(index);
        MOut.G(this).print(vs.lastMessage());
    }

    public void dev2cd() {
        int index;
        VirtualStorage vs = VirtualStorageManager.getInstance().getVirtualStorage(this.config);
        String p1 = this.parameters[1];
        try {
            index = Integer.parseInt(p1);
        }
        catch (NumberFormatException ex) {
            MOut.G(this).println(ex.getMessage());
            return;
        }
        if (!vs.checkIsDev2IndexValid(index)) {
            MOut.G(this).print("Index invalid");
            return;
        }
        if (vs.getDev2MountIndex() != 0) {
            MOut.G(this).print("Device 2 is mounted already");
            return;
        }
        MOut.G(this).println("Mounting " + vs.getDev2Array()[index]);
        vs.dev2CDMount(index);
        MOut.G(this).print(vs.lastMessage());
    }

    public void dev2dvd() {
        int index;
        VirtualStorage vs = VirtualStorageManager.getInstance().getVirtualStorage(this.config);
        String p1 = this.parameters[1];
        try {
            index = Integer.parseInt(p1);
        }
        catch (NumberFormatException ex) {
            MOut.G(this).println(ex.getMessage());
            return;
        }
        if (!vs.checkIsDev2IndexValid(index)) {
            MOut.G(this).print("Index invalid");
            return;
        }
        if (vs.getDev2MountIndex() != 0) {
            MOut.G(this).print("Device 2 is mounted already");
            return;
        }
        MOut.G(this).println("Mounting " + vs.getDev2Array()[index]);
        vs.dev2CDMount(index);
        MOut.G(this).print(vs.lastMessage());
    }

    public void dev2iso() {
        VirtualStorage vs = VirtualStorageManager.getInstance().getVirtualStorage(this.config);
        String p1 = this.parameters[1];
        File f = new File(p1);
        if (!f.exists()) {
            MOut.G(this).println(p1 + " is not exist");
            return;
        }
        if (vs.getDev2MountIndex() != 0) {
            MOut.G(this).print("Device 2 is mounted already");
            return;
        }
        MOut.G(this).println("Mounting ISO file: " + p1);
        vs.dev2ISOMount(p1);
        MOut.G(this).print(vs.lastMessage());
    }

    @Override
    public boolean isVirutalMediaSupported() {
        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(this.config.getIp());
        if (guid == null) {
            return false;
        }
        return IPMIMessagingCommand.isATENGUID(guid) || IPMIMessagingCommand.isATENAspeedGUID(guid) || IPMIMessagingCommand.isMicroBladeNodeGUID(guid) || IPMIMessagingCommand.isATENSuperBladeGUID(guid) || IPMIMessagingCommand.isSAS3_946E90GUID(guid) || IPMIMessagingCommand.isAST2400GUID(guid) || IPMIMessagingCommand.isAST2500GUID(guid) || IPMIMessagingCommand.isP8DTUGUID(guid) || IPMIMessagingCommand.isPOWER9GUID(guid) || IPMIMessagingCommand.is8USuperBladeGUID(guid) || IPMIMessagingCommand.isAST2500HW1GUID(guid) || IPMIMessagingCommand.isH11GUID(guid) || IPMIMessagingCommand.isH12GUID(guid);
    }

    @Override
    public void printSlaveCMMUnavailableMessage() {
        MOut.G(this).println("This function is unavailable for this device");
    }

    static enum SubCommand {
        DEV1_LIST,
        DEV1_DRV,
        DEV2_LIST,
        DEV2_CD,
        DEV2_DVD,
        DEV2_ISO,
        DEV1_STOP,
        DEV2_STOP,
        LOG,
        ALL_STATUS,
        STATUS,
        NO_COMMAND;

    }
}

