/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIBMCFileCommand;
import com.supermicro.ipmi.IPMINVMECommand;
import com.supermicro.ipmi.lic.SWKeyExpiredException;
import com.supermicro.ipmi.lic.SWLicenseAdapter;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class NVMEGetVPDCommand
extends SuperBladeCommand {
    byte aoc;
    byte slot;
    byte group;

    @Override
    public boolean preValidate() {
        this.aoc = 0;
        this.slot = 0;
        this.group = 0;
        if (this.parameters == null || this.parameters.length < 4) {
            MOut.G(this).println("Usage: nvme getVPD <aoc> <group> <slot> <fileName>");
            return false;
        }
        try {
            this.aoc = Byte.parseByte(this.parameters[0], 10);
        }
        catch (NumberFormatException e) {
            MOut.G(this).println(e.getMessage());
            return false;
        }
        try {
            this.group = Byte.parseByte(this.parameters[1], 10);
        }
        catch (NumberFormatException e) {
            MOut.G(this).println(e.getMessage());
            return false;
        }
        try {
            this.slot = Byte.parseByte(this.parameters[2], 10);
        }
        catch (NumberFormatException e) {
            MOut.G(this).println(e.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        this.closeSessionIfExist();
        boolean isPassSWKey = false;
        try {
            if (SWLicenseAdapter.isSWFRUSupported(this.config) && SWLicenseAdapter.check_SFT_SUM_LIC_ProductKey(this.config)) {
                isPassSWKey = true;
            }
        }
        catch (SWKeyExpiredException e) {
            MOut.G(this).println("Node product key is expired");
            this.statusCode = 155;
            return;
        }
        this.createSession();
        if (!isPassSWKey) {
            MOut.G(this).println("DCMS-single license is required");
            this.statusCode = 149;
            return;
        }
        IPMINVMECommand ipmiNVMECommand = new IPMINVMECommand(null);
        ipmiNVMECommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        IPMIBMCFileCommand ipmiBMCFileCommand = new IPMIBMCFileCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        ipmiNVMECommand.assignVPDparameters(this.aoc, this.group, this.slot);
        boolean result = ipmiBMCFileCommand.generalFileDownload((byte)22, this.parameters[3]);
        this.statusCode = result ? 0 : 149;
    }
}

