/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMITwinProCommand;
import com.supermicro.ipmi.IPMITwinProMCUUpdater;
import com.supermicro.ipmi.IPMITwinProNXMCUUpdater;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class MCUUpdateCommand
extends SuperBladeCommand {
    @Override
    public boolean preValidate() {
        if (this.parameters == null) {
            MOut.G(this).println("MCU filename is needed");
            MOut.G(this).println("Usage: tp mcuUpdate <filename>");
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        IPMITwinProCommand ipmiTwinProCommand = new IPMITwinProCommand(null);
        ipmiTwinProCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        try {
            if (!ipmiTwinProCommand.isSupportTwinProCommand()) {
                this.statusCode = 153;
                MOut.G(this).println("Not supported device");
                return;
            }
        }
        catch (Exception e) {
            this.statusCode = 153;
            MOut.G(this).println("Cannot get MCU Info");
            return;
        }
        if (ipmiTwinProCommand.getConfigID() == 12) {
            this.statusCode = 153;
            MOut.G(this).println("Not supported device");
            return;
        }
        byte[] dataToWrite = new byte[]{-3};
        byte readCount = 1;
        byte mcuID = ipmiTwinProCommand.sendTwinPro80hCommand(readCount, dataToWrite)[0];
        MOut.G(this).println("*****************************************************");
        MOut.G(this).println(" WARNING!");
        MOut.G(this).println(" The whole Twin system will be shutdown after update");
        MOut.G(this).println("*****************************************************");
        MOut.G(this).println();
        byte[] fileByteArray = this.readToByteArray(this.parameters[0]);
        if (mcuID == -88 || mcuID == -89 || mcuID == -90) {
            IPMITwinProNXMCUUpdater updater = new IPMITwinProNXMCUUpdater(this.ipmiCMMOEMCommand.getIPMIInterface());
            updater.setMOut(MOut.G(this));
            updater.setMCUFirmwareName(this.parameters[0]);
            updater.setMCUFirmware(fileByteArray);
            if (this.parameters.length == 2 && this.parameters[this.parameters.length - 1].toLowerCase().contains("-force_update")) {
                updater.setPassChecking(true);
            }
            this.statusCode = updater.update(mcuID) ? 0 : 149;
        } else {
            IPMITwinProMCUUpdater updater = new IPMITwinProMCUUpdater(this.ipmiCMMOEMCommand.getIPMIInterface());
            updater.setMOut(MOut.G(this));
            updater.setMCUFirmwareName(this.parameters[0]);
            this.statusCode = updater.update() ? 0 : 149;
        }
    }

    private byte[] readToByteArray(String filename) throws Exception {
        byte[] getBytes = new byte[]{};
        try {
            File file = new File(filename);
            getBytes = new byte[(int)file.length()];
            FileInputStream is = new FileInputStream(file);
            ((InputStream)is).read(getBytes);
            ((InputStream)is).close();
        }
        catch (FileNotFoundException e) {
            throw new FileNotFoundException(" File is not exist.");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return getBytes;
    }
}

