/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMIBMCFileCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import javax.xml.bind.DatatypeConverter;

public class DiagDownloadCommand
extends SuperBladeCommand {
    @Override
    public boolean preValidate() {
        if (this.parameters == null) {
            MOut.G(this).println("File name is needed");
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        byte optionCode = 15;
        IPMIBMCFileCommand ipmiBMCFileCommand = new IPMIBMCFileCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        boolean result = ipmiBMCFileCommand.generalFileDownload(optionCode, this.parameters[0]);
        this.refactoryMultiJson(this.parameters[0]);
        this.statusCode = result ? 0 : 149;
    }

    public void refactoryMultiJson(String fileName) {
        try {
            File file = new File(fileName);
            byte[] data = new byte[(int)file.length()];
            FileInputStream fileInputStream = new FileInputStream(file);
            fileInputStream.read(data);
            fileInputStream.close();
            byte[] contentBytes = null;
            int firstLeftBrackets = ByteUtility.bytesToHexNoSpace(data).indexOf("5B");
            int firstLeftParentheses = ByteUtility.bytesToHexNoSpace(data).indexOf("7B");
            if (firstLeftBrackets > firstLeftParentheses) {
                return;
            }
            String contentStr = ByteUtility.bytesToHexNoSpace(data).substring(firstLeftBrackets);
            contentBytes = DatatypeConverter.parseHexBinary((String)contentStr);
            BufferedWriter writer = new BufferedWriter(new FileWriter(fileName));
            writer.write(new String(contentBytes));
            writer.close();
        }
        catch (FileNotFoundException ex) {
            MOut.G(this).println("Unable to open file '" + fileName + "'");
        }
        catch (IOException ex) {
            MOut.G(this).println("Error reading file '" + fileName + "'");
        }
    }
}

