/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMICMMOEMCommand;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.IPMIMicroBladeOEMCommand;
import com.supermicro.ipmi.blade.BladeEntity;
import com.supermicro.ipmi.blade.BladeSystemEntity;
import com.supermicro.ipmi.microblade.BladeRemoteInfo;
import com.supermicro.ipmi.microblade.NodeSensorInfo;
import com.supermicro.ipmi.microblade.NodeStatusInfo;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class BladeConfigCommand
extends SuperBladeCommand {
    boolean isMicroBlade = false;

    @Override
    public boolean preValidate() {
        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(this.config.getIp());
        if (IPMIMessagingCommand.isMicroBladeCMMGUID(guid)) {
            this.isMicroBlade = true;
            int maxBladeSize = this.getBladeMaxSize();
            return true;
        }
        int maxBladeSize = this.getBladeMaxSize();
        byte bladeIndex = Byte.parseByte((String)this.preParameters.get(1));
        if (bladeIndex < 1 || bladeIndex > maxBladeSize) {
            MOut.G(this).println("blade Index out of range");
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        if (this.isMicroBlade) {
            IPMIMicroBladeOEMCommand ipmiMicroBladeOEMCommand = new IPMIMicroBladeOEMCommand(null);
            ipmiMicroBladeOEMCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
            String bladeIndex = (String)this.preParameters.get(1);
            byte bIndex = (byte)NodeSensorInfo.getBladeIndex(bladeIndex);
            BladeRemoteInfo bladeRemoteInfo = ipmiMicroBladeOEMCommand.getBladeRemoteInfo(bIndex);
            NodeStatusInfo nodeStatusInfo = ipmiMicroBladeOEMCommand.getNodeStatus(bIndex, (byte)0);
            if (!nodeStatusInfo.initialized() || !bladeRemoteInfo.isPresent()) {
                MOut.G(this).println("Blade " + bladeIndex + " is not presented");
                this.statusCode = 151;
                return;
            }
            NodeSensorInfo nodeSensorInfo = ipmiMicroBladeOEMCommand.getNodeSensor(bIndex, (byte)0);
            MOut.G(this).print(nodeSensorInfo.to7UConfigFormatString());
            this.statusCode = 0;
            return;
        }
        if (!this.isMaster) {
            this.printSlaveCMMUnavailableMessage();
            this.statusCode = 150;
            return;
        }
        BladeSystemEntity bladeSystem = new BladeSystemEntity(this.config);
        bladeSystem.setEnableAllQuery(false);
        bladeSystem.setIsQueryBladeEntity(true);
        bladeSystem.setIsQueryMBSensorEntity(true);
        bladeSystem.getData();
        if (!bladeSystem.isLoginSuccessful) {
            MOut.G(this).println("Login error!");
            this.statusCode = 146;
            return;
        }
        byte bladeIndex = Byte.parseByte((String)this.preParameters.get(1));
        BladeEntity bladeEntity = bladeSystem.getBlades()[bladeIndex - 1];
        if (bladeEntity.getPresent() == 0) {
            MOut.G(this).println("Blade " + bladeIndex + " is not presented");
            this.statusCode = 151;
            return;
        }
        IPMICMMOEMCommand.BladeHWInfo bladeHWInfo = this.ipmiCMMOEMCommand.getBladeHWInfo(bladeIndex);
        MOut.G(this).println(bladeHWInfo.toFormatString());
        this.statusCode = 0;
    }
}

