/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.task.mbtauto;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class BatchCommand {
    ArrayList<ArrayList<String>> commandArrays = new ArrayList();

    public void load(String filename) throws Exception {
        String line;
        BufferedReader in = new BufferedReader(new FileReader(filename));
        while ((line = in.readLine()) != null) {
            if (line.length() == 0 || line.startsWith(";")) continue;
            ArrayList<String> command = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(line, " ");
            while (st.hasMoreTokens()) {
                command.add(st.nextToken().trim());
            }
            this.commandArrays.add(command);
        }
        in.close();
    }

    public String[][] toStringArray() {
        String[][] commandArrayStrings = new String[this.commandArrays.size()][];
        for (int i = 0; i < this.commandArrays.size(); ++i) {
            commandArrayStrings[i] = new String[this.commandArrays.get(i).size()];
            for (int j = 0; j < this.commandArrays.get(i).size(); ++j) {
                commandArrayStrings[i][j] = this.commandArrays.get(i).get(j);
            }
        }
        return commandArrayStrings;
    }

    public void testPrint() {
        String[][] commandArrayStrings = this.toStringArray();
        for (int i = 0; i < this.commandArrays.size(); ++i) {
            for (int j = 0; j < this.commandArrays.get(i).size(); ++j) {
                System.out.print(commandArrayStrings[i][j] + " ");
            }
            System.out.println();
        }
    }

    public static void main(String[] args) throws Exception {
        BatchCommand script = new BatchCommand();
        script.load("c:\\test.cmd");
        script.testPrint();
    }
}

