/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.loc;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.loc.TagLoc;

public class TagLocSDR {
    public byte[] recordID = new byte[2];
    public byte SDRVersion = (byte)81;
    public byte recordType = (byte)-64;
    public byte recordLength;
    public byte[] manufacturerID;
    public byte tagLocID = TagLoc.TAGLOC_ID;
    public byte tagLocVer = 0;
    public TagLoc tagLoc;

    public TagLocSDR() {
        this.manufacturerID = new byte[]{124, 42, 0};
        this.tagLoc = new TagLoc();
    }

    public String toString() {
        String str = "";
        str = str + "recordID       = " + ByteUtility.bytesToHex(this.recordID) + "\n";
        str = str + "SDRVersion     = " + ByteUtility.byteToHex(this.SDRVersion) + "h\n";
        str = str + "recordType     = " + ByteUtility.byteToHex(this.recordType) + "h\n";
        str = str + "recordLength   = " + this.recordLength + "\n";
        str = str + "manufacturerID = " + ByteUtility.bytesToHex(this.manufacturerID) + "\n";
        str = str + "tagLocID       = " + ByteUtility.byteToHex(this.tagLocID) + "h\n";
        str = str + "tagLocVer      = " + ByteUtility.byteToHex(this.tagLocVer) + "h\n";
        str = str + this.tagLoc.toString();
        return str;
    }

    public void fromSDRRaw(byte[] rawSDR) {
        int index = 2;
        this.recordID[0] = rawSDR[index];
        this.recordID[1] = rawSDR[++index];
        this.SDRVersion = rawSDR[++index];
        this.recordType = rawSDR[++index];
        this.recordLength = rawSDR[++index];
        this.manufacturerID[0] = rawSDR[++index];
        this.manufacturerID[1] = rawSDR[++index];
        this.manufacturerID[2] = rawSDR[++index];
        this.tagLocID = rawSDR[++index];
        this.tagLocVer = rawSDR[++index];
        byte[] raw2 = new byte[rawSDR.length - ++index];
        System.arraycopy(rawSDR, index, raw2, 0, raw2.length);
        this.tagLoc.fromRaw(raw2);
    }

    public byte[] toRaw() {
        byte[] tagLocRaw = this.tagLoc.toRaw();
        byte[] data = new byte[10 + tagLocRaw.length];
        this.recordLength = (byte)(5 + tagLocRaw.length);
        data[0] = this.recordID[0];
        data[1] = this.recordID[1];
        data[2] = this.SDRVersion;
        data[3] = this.recordType;
        data[4] = this.recordLength;
        data[5] = this.manufacturerID[0];
        data[6] = this.manufacturerID[1];
        data[7] = this.manufacturerID[2];
        data[8] = this.tagLocID;
        data[9] = this.tagLocVer;
        System.arraycopy(tagLocRaw, 0, data, 10, tagLocRaw.length);
        return data;
    }

    public static boolean isTagLocSDR(byte[] rawSDR) {
        return rawSDR[5] == -64 && rawSDR[7] == 124 && rawSDR[8] == 42 && rawSDR[9] == 0 && rawSDR[10] == TagLoc.TAGLOC_ID;
    }
}

