/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.CipherSuite;
import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.IPMINetworkInterface;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.MessageCenter;
import com.supermicro.ipmi.RMCPPlus;
import com.supermicro.ipmi.RMCPPlusSession;
import com.supermicro.ipmi.algo.CipherAlgorithmFactory;
import java.util.Calendar;

public class RMCPPlusSessionController
implements ISessionController {
    IPMIMessagingCommand ipmiMessagingCommand;
    IPMIInterfaceConfig config;
    RMCPPlusSession rmcpPlusSession;
    RMCPPlus rmcpPlus;
    public OpenSessionRequest openSessionRequest = new OpenSessionRequest();
    public OpenSessionResponse openSessionResponse = new OpenSessionResponse();
    public RAKPMessage1 rakpMessage1 = new RAKPMessage1();
    public RAKPMessage2 rakpMessage2 = new RAKPMessage2();
    public RAKPMessage3 rakpMessage3 = new RAKPMessage3();
    public RAKPMessage4 rakpMessage4 = new RAKPMessage4();
    byte messageTag = 1;
    static byte consoleSessionIDCount = 1;
    byte[] consoleSessionID = new byte[]{1, 0, 0, 0};
    byte[] SIK = null;
    byte[] K1 = null;
    byte[] K2 = null;
    Calendar startTime;

    public RMCPPlus getRMCPPlus() {
        return this.rmcpPlus;
    }

    @Override
    public IPMINetworkInterface startup(IPMIInterfaceConfig config) {
        this.startTime = Calendar.getInstance();
        this.config = config;
        this.rmcpPlus = new RMCPPlus();
        this.rmcpPlus.initialize(config);
        this.rmcpPlusSession = this.rmcpPlus.rmcpPlusSession;
        this.ipmiMessagingCommand = new IPMIMessagingCommand(this.rmcpPlus);
        boolean rakpResult = this.openSession();
        if (!rakpResult) {
            return null;
        }
        MessageCenter.getInstance().put(this, (Object)"RAKP Open session finish");
        MessageCenter.getInstance().put(this, (Object)"Set Session Privilege Level");
        IPMIMessage resMessage = this.ipmiMessagingCommand.setSessionPrivilegeLevelCommand(config.getPrivilege());
        if (resMessage != null) {
            if (resMessage.completionCode != 0) {
                switch (resMessage.completionCode) {
                    case -128: {
                        MessageCenter.getInstance().put(this, (Object)"Requested level not available for this user");
                        break;
                    }
                    case -127: {
                        MessageCenter.getInstance().put(this, (Object)"Requested level exceeds Channel and/or User Privilege Limit");
                        break;
                    }
                    case -126: {
                        MessageCenter.getInstance().put(this, (Object)"Cannot disable User Level authentication");
                        break;
                    }
                    default: {
                        MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
                    }
                }
                return null;
            }
        } else {
            MessageCenter.getInstance().put(this, (Object)"set Session Privilege Level Error");
            return null;
        }
        MessageCenter.getInstance().put(this, (Object)("Set Session Privilege Level finished. Level = " + resMessage.data[0]));
        return this.rmcpPlus;
    }

    @Override
    public boolean closeSession() {
        if (this.ipmiMessagingCommand != null) {
            IPMIMessage resMessage = this.ipmiMessagingCommand.closeSessionCommand();
            if (resMessage != null) {
                if (resMessage.completionCode == 0) {
                    MessageCenter.getInstance().put(this, (Object)"Close session successfully");
                    this.rmcpPlus.stopProxy();
                    this.closeSocket();
                    return true;
                }
                MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
                return false;
            }
            MessageCenter.getInstance().put(this, (Object)"Close session Error");
            return false;
        }
        MessageCenter.getInstance().put("messageingCommand is null");
        return false;
    }

    public boolean openSession() {
        byte[] result = null;
        boolean resolveResult = false;
        this.createRAKPOpenSessionMessage();
        MessageCenter.getInstance().put(this, (Object)"Sending RAKP open session request ...");
        result = this.rmcpPlus.sendRAKPMessage((byte)16, this.openSessionRequest.raw());
        if (result == null) {
            MessageCenter.getInstance().put(this, (Object)"Send RAKP Open Session Request error");
            return false;
        }
        resolveResult = this.resolveOpenSessionResponse(result);
        if (!resolveResult) {
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Got RAKP open session respose");
        this.createRAKPMessage1();
        MessageCenter.getInstance().put(this, (Object)"Sending RAKP Message 1 ...");
        result = this.rmcpPlus.sendRAKPMessage((byte)18, this.rakpMessage1.raw());
        if (result == null) {
            MessageCenter.getInstance().put(this, (Object)"Send RAKP Message 1 error");
            return false;
        }
        resolveResult = this.resolveRAKPMessage2(result);
        if (!resolveResult) {
            return false;
        }
        this.createRAKPMessage3();
        MessageCenter.getInstance().put(this, (Object)"Sending RAKP Message 3 ...");
        result = this.rmcpPlus.sendRAKPMessage((byte)20, this.rakpMessage3.raw());
        if (result == null) {
            MessageCenter.getInstance().put(this, (Object)"Send RAKP Message 3 error");
            return false;
        }
        resolveResult = this.resolveRAKPMessage4(result);
        if (!resolveResult) {
            return false;
        }
        System.arraycopy(this.openSessionResponse.managedSystemSessionID, 0, this.rmcpPlusSession.sessionID, 0, 4);
        this.rmcpPlusSession.IncreaseSessionSeq();
        return true;
    }

    private void createRAKPOpenSessionMessage() {
        this.openSessionRequest.messageTag = this.messageTag;
        this.openSessionRequest.requestedMaxPrivilegeLevel = this.config.getPrivilege();
        this.openSessionRequest.reserved[0] = 0;
        this.openSessionRequest.reserved[1] = 0;
        consoleSessionIDCount = (byte)(consoleSessionIDCount + 1);
        System.arraycopy(this.consoleSessionID, 0, this.openSessionRequest.remoteConsoleSessionID, 0, 4);
        byte[] auth = new byte[]{0, 0, 0, 8, CipherSuite.getAuthenticationAlgorithmByID(this.config.getCipherSuiteID()), 0, 0, 0};
        System.arraycopy(auth, 0, this.openSessionRequest.authenticationPayload, 0, 8);
        byte[] integirty = new byte[]{1, 0, 0, 8, CipherSuite.getIntegrityAlgorithmByID(this.config.getCipherSuiteID()), 0, 0, 0};
        System.arraycopy(integirty, 0, this.openSessionRequest.integrityPayload, 0, 8);
        byte[] confidentiality = new byte[]{2, 0, 0, 8, CipherSuite.getConfidentialityAlgorithmByID(this.config.getCipherSuiteID()), 0, 0, 0};
        System.arraycopy(confidentiality, 0, this.openSessionRequest.confidentialityPayload, 0, 8);
    }

    private boolean resolveOpenSessionResponse(byte[] recvBuf) {
        int index = 16;
        byte payLoadType = recvBuf[5];
        if (payLoadType != 17) {
            MessageCenter.getInstance().put(this, (Object)"Open Session Response error: Not a Open Session Response Payload");
            return false;
        }
        this.openSessionResponse.messageTag = recvBuf[index];
        this.openSessionResponse.RMCPPlusStatusCode = recvBuf[++index];
        if (this.openSessionResponse.RMCPPlusStatusCode != 0) {
            MessageCenter.getInstance().put(this, (Object)("RMCP Open Session Response error: " + RMCPPlus.RMCPPlusStatusCode[this.openSessionResponse.RMCPPlusStatusCode]));
            return false;
        }
        this.openSessionResponse.maxPrivilegeLevel = recvBuf[++index];
        ++index;
        System.arraycopy(recvBuf, ++index, this.openSessionResponse.remoteConsoleSessionID, 0, 4);
        System.arraycopy(recvBuf, index += 4, this.openSessionResponse.managedSystemSessionID, 0, 4);
        System.arraycopy(recvBuf, index += 4, this.openSessionResponse.authenticationPayload, 0, 8);
        System.arraycopy(recvBuf, index += 8, this.openSessionResponse.integrityPayload, 0, 8);
        System.arraycopy(recvBuf, index += 8, this.openSessionResponse.confidentialityPayload, 0, 8);
        System.arraycopy(this.openSessionResponse.managedSystemSessionID, 0, this.rmcpPlusSession.sessionID, 0, 4);
        return true;
    }

    private void createRAKPMessage1() {
        this.rakpMessage1.messageTag = this.messageTag;
        byte[] reserved1 = new byte[]{0, 0, 0};
        System.arraycopy(reserved1, 0, this.rakpMessage1.reserved1, 0, 3);
        System.arraycopy(this.openSessionResponse.managedSystemSessionID, 0, this.rakpMessage1.managedSystemSessionID, 0, 4);
        System.arraycopy(ByteUtility.random16Bytes(), 0, this.rakpMessage1.remoteConsoleRandomNumber, 0, 16);
        this.rakpMessage1.requestedMaxPrivilegeLevel = this.config.getPrivilege();
        byte[] reserved2 = new byte[]{0, 0};
        System.arraycopy(reserved2, 0, this.rakpMessage1.reserved2, 0, 2);
        if (this.config.getUserName().length() > 0) {
            this.rakpMessage1.userNameLength = (byte)this.config.getUserName().length();
            this.rakpMessage1.userName = new byte[this.config.getUserName().length()];
            System.arraycopy(this.config.getUserName().getBytes(), 0, this.rakpMessage1.userName, 0, this.config.getUserName().length());
        } else {
            this.rakpMessage1.userNameLength = 0;
        }
    }

    private boolean resolveRAKPMessage2(byte[] recvBuf) {
        int index = 16;
        byte payLoadType = recvBuf[5];
        if (payLoadType != 19) {
            MessageCenter.getInstance().put(this, (Object)"RAKP Message 2 error: Not a RAKP Message 2 Payload");
            return false;
        }
        this.rakpMessage2.messageTag = recvBuf[index];
        this.rakpMessage2.RMCPPlusStatusCode = recvBuf[++index];
        if (this.rakpMessage2.RMCPPlusStatusCode != 0) {
            MessageCenter.getInstance().put(this, (Object)("RAKP Message 2 error: " + RMCPPlus.RMCPPlusStatusCode[this.rakpMessage2.RMCPPlusStatusCode]));
            return false;
        }
        ++index;
        ++index;
        System.arraycopy(recvBuf, ++index, this.rakpMessage2.remoteConsoleSessionID, 0, 4);
        System.arraycopy(recvBuf, index += 4, this.rakpMessage2.managedSystemRandomNumber, 0, 16);
        System.arraycopy(recvBuf, index += 16, this.rakpMessage2.managedSystemGUID, 0, 16);
        index += 16;
        switch (CipherSuite.getAuthenticationAlgorithmByID(this.config.getCipherSuiteID())) {
            case 0: {
                break;
            }
            case 2: {
                this.rakpMessage2.keyExchangeAuthenticationCode = new byte[16];
                System.arraycopy(recvBuf, index, this.rakpMessage2.keyExchangeAuthenticationCode, 0, 16);
                break;
            }
            case 1: {
                this.rakpMessage2.keyExchangeAuthenticationCode = new byte[20];
                System.arraycopy(recvBuf, index, this.rakpMessage2.keyExchangeAuthenticationCode, 0, 20);
            }
        }
        boolean hmac = this.checkRAKPMessage2HMAC();
        if (!hmac) {
            MessageCenter.getInstance().put(this, (Object)"RAKP Message 2 error: Verify error. Maybe the password invalid");
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"RAKP 2 Key verify Successful");
        this.SIK = this.calculateSIK();
        this.K1 = this.calculateK1();
        this.K2 = this.calculateK2();
        this.rmcpPlusSession.SIK = this.SIK;
        this.rmcpPlusSession.K1 = this.K1;
        this.rmcpPlusSession.K2 = this.K2;
        return true;
    }

    private boolean checkRAKPMessage2HMAC() {
        byte[] result;
        if (CipherSuite.getAuthenticationAlgorithmByID(this.config.getCipherSuiteID()) == 0) {
            return true;
        }
        byte[] plainText = null;
        int size = 0;
        size = this.consoleSessionID.length + this.openSessionResponse.managedSystemSessionID.length + this.rakpMessage1.remoteConsoleRandomNumber.length + this.rakpMessage2.managedSystemRandomNumber.length + this.rakpMessage2.managedSystemGUID.length + 1 + 1;
        if (this.rakpMessage1.userNameLength != 0) {
            size += this.rakpMessage1.userName.length;
        }
        plainText = new byte[size];
        System.arraycopy(this.consoleSessionID, 0, plainText, 0, 4);
        System.arraycopy(this.openSessionResponse.managedSystemSessionID, 0, plainText, 4, 4);
        System.arraycopy(this.rakpMessage1.remoteConsoleRandomNumber, 0, plainText, 8, 16);
        System.arraycopy(this.rakpMessage2.managedSystemRandomNumber, 0, plainText, 24, 16);
        System.arraycopy(this.rakpMessage2.managedSystemGUID, 0, plainText, 40, 16);
        plainText[56] = this.rakpMessage1.requestedMaxPrivilegeLevel;
        plainText[57] = this.rakpMessage1.userNameLength;
        if (this.rakpMessage1.userNameLength != 0) {
            System.arraycopy(this.rakpMessage1.userName, 0, plainText, 58, this.rakpMessage1.userName.length);
        }
        return ByteUtility.bytesToHex(result = GlobalDefine.OEM_RAKP_FLAG || this.config.isSmcRAKP() ? CipherAlgorithmFactory.createRAKPAlgorithm(this.rmcpPlusSession.cipherSuite).mac(this.config.getOEMKG(), plainText) : CipherAlgorithmFactory.createRAKPAlgorithm(this.rmcpPlusSession.cipherSuite).mac(this.config.getPassword().getBytes(), plainText)).equals(ByteUtility.bytesToHex(this.rakpMessage2.keyExchangeAuthenticationCode));
    }

    private byte[] calculateSIK() {
        byte[] plainText = null;
        int size = 0;
        size = this.rakpMessage1.remoteConsoleRandomNumber.length + this.rakpMessage2.managedSystemRandomNumber.length + 1 + 1;
        if (this.rakpMessage1.userNameLength != 0) {
            size += this.rakpMessage1.userName.length;
        }
        plainText = new byte[size];
        System.arraycopy(this.rakpMessage1.remoteConsoleRandomNumber, 0, plainText, 0, 16);
        System.arraycopy(this.rakpMessage2.managedSystemRandomNumber, 0, plainText, 16, 16);
        plainText[32] = this.rakpMessage1.requestedMaxPrivilegeLevel;
        plainText[33] = this.rakpMessage1.userNameLength;
        if (this.rakpMessage1.userNameLength != 0) {
            System.arraycopy(this.rakpMessage1.userName, 0, plainText, 34, this.rakpMessage1.userName.length);
        }
        byte[] result = CipherAlgorithmFactory.createRAKPAlgorithm(this.rmcpPlusSession.cipherSuite).mac(this.config.getPassword().getBytes(), plainText);
        return result;
    }

    private byte[] calculateK1() {
        if (CipherSuite.getIntegrityAlgorithmByID(this.config.getCipherSuiteID()) == 0) {
            return new byte[0];
        }
        byte[] const1 = new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        byte[] k1 = CipherAlgorithmFactory.createRAKPAlgorithm(this.rmcpPlusSession.cipherSuite).mac(this.SIK, const1);
        byte[] k1_128 = new byte[16];
        System.arraycopy(k1, 0, k1_128, 0, 16);
        if (CipherSuite.getIntegrityAlgorithmByID(this.config.getCipherSuiteID()) == 1) {
            return k1;
        }
        return k1_128;
    }

    private byte[] calculateK2() {
        if (CipherSuite.getIntegrityAlgorithmByID(this.config.getCipherSuiteID()) == 0) {
            return new byte[0];
        }
        byte[] const2 = new byte[]{2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2};
        byte[] k2 = CipherAlgorithmFactory.createRAKPAlgorithm(this.rmcpPlusSession.cipherSuite).mac(this.SIK, const2);
        byte[] k2_128 = new byte[16];
        System.arraycopy(k2, 0, k2_128, 0, 16);
        return k2_128;
    }

    private void createRAKPMessage3() {
        this.rakpMessage3.messageTag = this.messageTag;
        this.rakpMessage3.RMCPPlusStatusCode = 0;
        byte[] reserved = new byte[]{0, 0};
        System.arraycopy(reserved, 0, this.rakpMessage3.reserved, 0, 2);
        System.arraycopy(this.openSessionResponse.managedSystemSessionID, 0, this.rakpMessage3.managedSystemSessionID, 0, 4);
        this.rakpMessage3.keyExchangeAuthenticationCode = this.createRAKPMessage3HMAC();
    }

    private byte[] createRAKPMessage3HMAC() {
        if (CipherSuite.getAuthenticationAlgorithmByID(this.config.getCipherSuiteID()) == 0) {
            return new byte[0];
        }
        byte[] plainText = null;
        int size = 0;
        size = this.rakpMessage2.managedSystemRandomNumber.length + this.consoleSessionID.length + 1 + 1;
        if (this.rakpMessage1.userNameLength != 0) {
            size += this.rakpMessage1.userName.length;
        }
        plainText = new byte[size];
        System.arraycopy(this.rakpMessage2.managedSystemRandomNumber, 0, plainText, 0, 16);
        System.arraycopy(this.consoleSessionID, 0, plainText, 16, 4);
        plainText[20] = this.rakpMessage1.requestedMaxPrivilegeLevel;
        plainText[21] = this.rakpMessage1.userNameLength;
        if (this.rakpMessage1.userNameLength != 0) {
            System.arraycopy(this.rakpMessage1.userName, 0, plainText, 22, this.rakpMessage1.userName.length);
        }
        byte[] result = GlobalDefine.OEM_RAKP_FLAG || this.config.isSmcRAKP() ? CipherAlgorithmFactory.createRAKPAlgorithm(this.rmcpPlusSession.cipherSuite).mac(this.config.getOEMKG(), plainText) : CipherAlgorithmFactory.createRAKPAlgorithm(this.rmcpPlusSession.cipherSuite).mac(this.config.getPassword().getBytes(), plainText);
        return result;
    }

    private boolean resolveRAKPMessage4(byte[] recvBuf) {
        int index = 16;
        byte payLoadType = recvBuf[5];
        if (payLoadType != 21) {
            MessageCenter.getInstance().put(this, (Object)"RAKP Message 4 error: Not a RAKP Message 4 Payload");
            return false;
        }
        this.rakpMessage4.messageTag = recvBuf[index];
        this.rakpMessage4.RMCPPlusStatusCode = recvBuf[++index];
        if (this.rakpMessage4.RMCPPlusStatusCode != 0) {
            MessageCenter.getInstance().put(this, (Object)("RAKP Message 4 error: " + RMCPPlus.RMCPPlusStatusCode[this.rakpMessage4.RMCPPlusStatusCode]));
            return false;
        }
        ++index;
        ++index;
        System.arraycopy(recvBuf, ++index, this.rakpMessage4.mgmtConsoleSessionID, 0, 4);
        index += 4;
        switch (CipherSuite.getAuthenticationAlgorithmByID(this.config.getCipherSuiteID())) {
            case 0: {
                break;
            }
            case 2: {
                this.rakpMessage4.integrityCheckValue = new byte[16];
                System.arraycopy(recvBuf, index, this.rakpMessage4.integrityCheckValue, 0, 16);
                break;
            }
            case 1: {
                this.rakpMessage4.integrityCheckValue = new byte[12];
                System.arraycopy(recvBuf, index, this.rakpMessage4.integrityCheckValue, 0, 12);
            }
        }
        boolean hmac = this.checkRAKPMessage4HMAC();
        if (!hmac) {
            MessageCenter.getInstance().put(this, (Object)"RAKP Message 4 error: Verify error. Maybe the password invalid");
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)" RAKP 4 Key verify Successful");
        return true;
    }

    private boolean checkRAKPMessage4HMAC() {
        if (CipherSuite.getAuthenticationAlgorithmByID(this.config.getCipherSuiteID()) == 0) {
            return true;
        }
        byte[] plainText = null;
        int size = 0;
        size = this.rakpMessage1.remoteConsoleRandomNumber.length + this.openSessionResponse.managedSystemSessionID.length + this.rakpMessage2.managedSystemGUID.length;
        plainText = new byte[size];
        System.arraycopy(this.rakpMessage1.remoteConsoleRandomNumber, 0, plainText, 0, 16);
        System.arraycopy(this.openSessionResponse.managedSystemSessionID, 0, plainText, 16, 4);
        System.arraycopy(this.rakpMessage2.managedSystemGUID, 0, plainText, 20, 16);
        byte[] result = CipherAlgorithmFactory.createRAKPAlgorithm(this.rmcpPlusSession.cipherSuite).mac(this.SIK, plainText);
        if (CipherSuite.getAuthenticationAlgorithmByID(this.config.getCipherSuiteID()) == 1) {
            byte[] b1 = new byte[12];
            byte[] b2 = new byte[12];
            System.arraycopy(result, 0, b1, 0, 12);
            System.arraycopy(this.rakpMessage4.integrityCheckValue, 0, b2, 0, 12);
            if (!ByteUtility.bytesToHex(b1).equals(ByteUtility.bytesToHex(b2))) {
                MessageCenter.getInstance().put(this, (Object)"RAKP4 Integrity check value error");
                return false;
            }
        } else if (!ByteUtility.bytesToHex(result).equals(ByteUtility.bytesToHex(this.rakpMessage4.integrityCheckValue))) {
            MessageCenter.getInstance().put(this, (Object)"RAKP4 Integrity check value error");
            return false;
        }
        return true;
    }

    public void closeSocket() {
        this.rmcpPlus.closeSocket();
    }

    public static void main(String[] args) {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("192.168.12.157");
        config.setUserName("oper");
        config.setPassword("oper");
        config.setPrivilege((byte)3);
        config.setCipherSuiteID((byte)3);
        RMCPPlusSessionController rmcpPlusSessionController = new RMCPPlusSessionController();
        rmcpPlusSessionController.startup(config);
        rmcpPlusSessionController.closeSession();
    }

    public class RAKPMessage4 {
        byte messageTag;
        byte RMCPPlusStatusCode;
        byte[] mgmtConsoleSessionID = new byte[4];
        byte[] integrityCheckValue;

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("\n << RAKPMessage 4: >>");
            sb.append("\n messageTag         = " + this.messageTag);
            sb.append("\n RMCPPlusStatusCode = " + this.RMCPPlusStatusCode);
            sb.append("\n mgmtConsoleSessionID = " + ByteUtility.bytesToHex(this.mgmtConsoleSessionID));
            if (this.integrityCheckValue != null) {
                sb.append("\n integrityCheckValue  = " + ByteUtility.bytesToHex(this.integrityCheckValue));
            }
            return sb.toString();
        }
    }

    public class RAKPMessage3 {
        byte messageTag;
        byte RMCPPlusStatusCode;
        byte[] reserved = new byte[2];
        byte[] managedSystemSessionID = new byte[4];
        byte[] keyExchangeAuthenticationCode = null;

        public byte[] raw() {
            byte[] raw = null;
            raw = new byte[8 + this.getAuthenticationByteSize()];
            raw[0] = this.messageTag;
            raw[1] = this.RMCPPlusStatusCode;
            System.arraycopy(this.reserved, 0, raw, 2, 2);
            System.arraycopy(this.managedSystemSessionID, 0, raw, 4, 4);
            switch (CipherSuite.getAuthenticationAlgorithmByID(RMCPPlusSessionController.this.config.getCipherSuiteID())) {
                case 0: {
                    break;
                }
                case 2: {
                    System.arraycopy(this.keyExchangeAuthenticationCode, 0, raw, 8, 16);
                    break;
                }
                case 1: {
                    System.arraycopy(this.keyExchangeAuthenticationCode, 0, raw, 8, 20);
                }
            }
            return raw;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("\n << RAKPMessage 3: >>");
            sb.append("\n messageTag         = " + this.messageTag);
            sb.append("\n RMCPPlusStatusCode = " + this.RMCPPlusStatusCode);
            sb.append("\n reserved        = " + ByteUtility.bytesToHex(this.reserved));
            sb.append("\n managedSystemSessionID     = " + ByteUtility.bytesToHex(this.managedSystemSessionID));
            if (this.keyExchangeAuthenticationCode != null) {
                sb.append("\n keyExchangeAuthenticationCode = " + ByteUtility.bytesToHex(this.keyExchangeAuthenticationCode));
            }
            return sb.toString();
        }

        private byte getAuthenticationByteSize() {
            byte b = 0;
            switch (CipherSuite.getAuthenticationAlgorithmByID(RMCPPlusSessionController.this.config.getCipherSuiteID())) {
                case 0: {
                    b = 0;
                    break;
                }
                case 2: {
                    b = 16;
                    break;
                }
                case 1: {
                    b = 20;
                }
            }
            return b;
        }
    }

    public class RAKPMessage2 {
        byte messageTag;
        byte RMCPPlusStatusCode;
        byte[] remoteConsoleSessionID = new byte[4];
        byte[] managedSystemRandomNumber = new byte[16];
        byte[] managedSystemGUID = new byte[16];
        byte[] keyExchangeAuthenticationCode = null;

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("\n << RAKPMessage 2: >>");
            sb.append("\n messageTag         = " + this.messageTag);
            sb.append("\n RMCPPlusStatusCode = " + this.RMCPPlusStatusCode);
            sb.append("\n remoteConsoleSessionID        = " + ByteUtility.bytesToHex(this.remoteConsoleSessionID));
            sb.append("\n managedSystemRandomNumber     = " + ByteUtility.bytesToHex(this.managedSystemRandomNumber));
            sb.append("\n managedSystemGUID             = " + ByteUtility.bytesToHex(this.managedSystemGUID));
            if (this.keyExchangeAuthenticationCode != null) {
                sb.append("\n keyExchangeAuthenticationCode = " + ByteUtility.bytesToHex(this.keyExchangeAuthenticationCode));
            }
            return sb.toString();
        }
    }

    public class RAKPMessage1 {
        byte messageTag;
        byte[] reserved1 = new byte[3];
        byte[] managedSystemSessionID = new byte[4];
        byte[] remoteConsoleRandomNumber = new byte[16];
        byte requestedMaxPrivilegeLevel;
        byte[] reserved2 = new byte[2];
        byte userNameLength;
        byte[] userName;

        public byte[] raw() {
            byte[] raw = new byte[28 + this.userNameLength];
            raw[0] = this.messageTag;
            System.arraycopy(this.reserved1, 0, raw, 1, 3);
            System.arraycopy(this.managedSystemSessionID, 0, raw, 4, 4);
            System.arraycopy(this.remoteConsoleRandomNumber, 0, raw, 8, 16);
            raw[24] = this.requestedMaxPrivilegeLevel;
            System.arraycopy(this.reserved2, 0, raw, 25, 2);
            raw[27] = this.userNameLength;
            if (this.userNameLength != 0 && this.userName.length != 0) {
                System.arraycopy(this.userName, 0, raw, 28, this.userName.length);
            }
            return raw;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("\n << RAKPMessage 1: >>");
            sb.append("\n messageTag = " + this.messageTag);
            sb.append("\n reserved1  = " + ByteUtility.bytesToHex(this.reserved1));
            sb.append("\n managedSystemSessionID     = " + ByteUtility.bytesToHex(this.managedSystemSessionID));
            sb.append("\n remoteConsoleRandomNumber  = " + ByteUtility.bytesToHex(this.remoteConsoleRandomNumber));
            sb.append("\n requestedMaxPrivilegeLevel = " + this.requestedMaxPrivilegeLevel);
            sb.append("\n reserved2      = " + ByteUtility.bytesToHex(this.reserved2));
            sb.append("\n userNameLength = " + this.userNameLength);
            if (this.userName != null && this.userName.length > 0) {
                sb.append("\n userName       = " + ByteUtility.bytesToHex(this.userName));
            }
            return sb.toString();
        }
    }

    public class OpenSessionResponse {
        byte messageTag;
        byte RMCPPlusStatusCode;
        byte maxPrivilegeLevel;
        byte[] remoteConsoleSessionID = new byte[4];
        byte[] managedSystemSessionID = new byte[4];
        byte[] authenticationPayload = new byte[8];
        byte[] integrityPayload = new byte[8];
        byte[] confidentialityPayload = new byte[8];

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("\n << OpenSessionResponse: >>");
            sb.append("\n messageTag         = " + this.messageTag);
            sb.append("\n RMCPPlusStatusCode = " + this.RMCPPlusStatusCode);
            sb.append("\n maxPrivilegeLevel  = " + this.maxPrivilegeLevel);
            sb.append("\n remoteConsoleSessionID = " + ByteUtility.bytesToHex(this.remoteConsoleSessionID));
            sb.append("\n managedSystemSessionID = " + ByteUtility.bytesToHex(this.managedSystemSessionID));
            sb.append("\n authenticationPayload  = " + ByteUtility.bytesToHex(this.authenticationPayload));
            sb.append("\n integrityPayload       = " + ByteUtility.bytesToHex(this.integrityPayload));
            sb.append("\n confidentialityPayload = " + ByteUtility.bytesToHex(this.confidentialityPayload));
            return sb.toString();
        }
    }

    public class OpenSessionRequest {
        byte messageTag;
        byte requestedMaxPrivilegeLevel;
        byte[] reserved = new byte[2];
        byte[] remoteConsoleSessionID = new byte[4];
        byte[] authenticationPayload = new byte[8];
        byte[] integrityPayload = new byte[8];
        byte[] confidentialityPayload = new byte[8];

        public byte[] raw() {
            byte[] raw = new byte[32];
            raw[0] = this.messageTag;
            raw[1] = this.requestedMaxPrivilegeLevel;
            System.arraycopy(this.reserved, 0, raw, 2, 2);
            System.arraycopy(this.remoteConsoleSessionID, 0, raw, 4, 4);
            System.arraycopy(this.authenticationPayload, 0, raw, 8, 8);
            System.arraycopy(this.integrityPayload, 0, raw, 16, 8);
            System.arraycopy(this.confidentialityPayload, 0, raw, 24, 8);
            return raw;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("\n << OpenSessionRequest: >>");
            sb.append("\n messageTag         = " + this.messageTag);
            sb.append("\n requestedMaxPrivilegeLevel = " + this.requestedMaxPrivilegeLevel);
            sb.append("\n reserved = " + ByteUtility.bytesToHex(this.reserved));
            sb.append("\n remoteConsoleSessionID = " + ByteUtility.bytesToHex(this.remoteConsoleSessionID));
            sb.append("\n authenticationPayload  = " + ByteUtility.bytesToHex(this.authenticationPayload));
            sb.append("\n integrityPayload       = " + ByteUtility.bytesToHex(this.integrityPayload));
            sb.append("\n confidentialityPayload = " + ByteUtility.bytesToHex(this.confidentialityPayload));
            return sb.toString();
        }
    }
}

