/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ByteUtility;

public class HDDStatus {
    public static byte MR_PD_STATE_UNCONFIGURED_GOOD = 0;
    public static byte MR_PD_STATE_UNCONFIGURED_BAD = 1;
    public static byte MR_PD_STATE_HOT_SPARE = (byte)2;
    public static byte MR_PD_STATE_OFFLINE = (byte)16;
    public static byte MR_PD_STATE_FAILED = (byte)17;
    public static byte MR_PD_STATE_REBUILD = (byte)20;
    public static byte MR_PD_STATE_ONLINE = (byte)24;
    public static byte MR_PD_STATE_COPYBACK = (byte)32;
    public static byte MR_PD_STATE_SYSTEM = (byte)64;
    public static byte MR_PD_STATE_SHIELD_UNCONFIGURED = (byte)-128;
    public static byte MR_PD_STATE_SHIELD_HOT_SPARE = (byte)-126;
    public static byte MR_PD_STATE_SHIELD_CONFIGURED = (byte)-112;
    public static String[][] fwstateDescription = new String[][]{{"0", "Unconfigured good drive"}, {"1", "Unconfigured bad drive"}, {"2", "Hot spare drive"}, {"16", "Configured-good drive(data invalid)"}, {"17", "Configured-bad drive (data invalid)"}, {"20", "Configured-drive is rebuilding"}, {"24", "Configured-drive is online"}, {"32", "drive is getting copied"}, {"64", "drive is exposed and controlled by host"}, {"128", "UnConfigured - shielded"}, {"130", "Hot Spare - shielded"}, {"144", "Configured - shielded"}};
    public static String[][] fwstateShortDescription = new String[][]{{"0", "UNCONFIG_GOOD"}, {"1", "UNCONFIG_BAD"}, {"2", "HOT_SPARE"}, {"16", "OFFLINE"}, {"17", "FAILED"}, {"20", "REBUILD"}, {"24", "ONLINE"}, {"32", "COPYBACK"}, {"64", "SYSTEM"}, {"128", "S_UNCONFIG"}, {"130", "S_HOT_SPARE"}, {"144", "S_CONFIGURED"}};
    public static String[][] linkSpeedDescription = new String[][]{{"00", "N/A"}, {"01", "1.5Gb/s"}, {"02", "3.0Gb/s"}, {"03", "6.0Gb/s"}, {"04", "12.0Gb/s"}};
    public String vendor;
    public String modelname;
    public String revision;
    public int mediaErrCount;
    public int otherErrCount;
    public int predFailCount;
    public int lastPredFailEventSeqNum;
    public int fwstate;
    public byte linkSpeed;
    public long CoercedSize;
    public long size;
    public byte temperature;
    public byte slotNumber;
    public byte enclosureID;
    public int deviceID;
    public int seqNum;
    public int userDataBlockSize;
    public byte[] raw;
    public int index;
    public static int deviceId = 0;
    byte[] vendorBytes = new byte[8];
    byte[] modelnameBytes = new byte[16];
    byte[] revisionBytes = new byte[4];
    byte[] mediaErrCountBytes = new byte[4];
    byte[] otherErrCountBytes = new byte[4];
    byte[] predFailCountBytes = new byte[4];
    byte[] lastPredFailEventSeqNumBytes = new byte[4];
    byte[] fwstateBytes = new byte[2];
    byte[] coercedSizeLBytes = new byte[4];
    byte[] coercedSizeHBytes = new byte[4];
    byte[] deviceIdBytes = new byte[2];
    byte[] seqNumBytes = new byte[2];
    byte[] userDataBlockSizeBytes = new byte[2];

    public void setIndex(int index) {
        this.index = index;
    }

    public boolean fromRaw(byte[] raw) {
        int index = 0;
        if (raw.length < 80) {
            return false;
        }
        System.arraycopy(raw, index, this.vendorBytes, 0, this.vendorBytes.length);
        this.vendor = new String(this.vendorBytes);
        System.arraycopy(raw, index += this.vendorBytes.length, this.modelnameBytes, 0, this.modelnameBytes.length);
        this.modelname = new String(this.modelnameBytes);
        System.arraycopy(raw, index += this.modelnameBytes.length, this.revisionBytes, 0, this.revisionBytes.length);
        this.revision = new String(this.revisionBytes);
        System.arraycopy(raw, index += this.revisionBytes.length, this.mediaErrCountBytes, 0, this.mediaErrCountBytes.length);
        this.mediaErrCount = ByteUtility.fourBytesToIntByLSBFirst(this.mediaErrCountBytes);
        System.arraycopy(raw, index += this.mediaErrCountBytes.length, this.otherErrCountBytes, 0, this.otherErrCountBytes.length);
        this.otherErrCount = ByteUtility.fourBytesToIntByLSBFirst(this.otherErrCountBytes);
        System.arraycopy(raw, index += this.otherErrCountBytes.length, this.predFailCountBytes, 0, this.predFailCountBytes.length);
        this.predFailCount = ByteUtility.fourBytesToIntByLSBFirst(this.predFailCountBytes);
        System.arraycopy(raw, index += this.predFailCountBytes.length, this.lastPredFailEventSeqNumBytes, 0, this.lastPredFailEventSeqNumBytes.length);
        this.lastPredFailEventSeqNum = ByteUtility.fourBytesToIntByLSBFirst(this.lastPredFailEventSeqNumBytes);
        System.arraycopy(raw, index += this.lastPredFailEventSeqNumBytes.length, this.fwstateBytes, 0, this.fwstateBytes.length);
        this.fwstate = ByteUtility.twoBytesToInt(this.fwstateBytes);
        this.linkSpeed = raw[index += this.fwstateBytes.length];
        System.arraycopy(raw, ++index, this.coercedSizeLBytes, 0, this.coercedSizeLBytes.length);
        System.arraycopy(raw, index += this.coercedSizeLBytes.length, this.coercedSizeHBytes, 0, this.coercedSizeHBytes.length);
        this.CoercedSize = (ByteUtility.fourBytesToLongByLSBFirst(this.coercedSizeHBytes) << 32) + ByteUtility.fourBytesToLongByLSBFirst(this.coercedSizeLBytes);
        this.temperature = raw[index += this.coercedSizeHBytes.length];
        this.slotNumber = raw[++index];
        this.enclosureID = raw[++index];
        System.arraycopy(raw, ++index, this.deviceIdBytes, 0, this.deviceIdBytes.length);
        this.deviceID = ByteUtility.twoBytesToInt(this.deviceIdBytes);
        System.arraycopy(raw, index += this.deviceIdBytes.length, this.seqNumBytes, 0, this.seqNumBytes.length);
        this.seqNum = ByteUtility.twoBytesToInt(this.seqNumBytes);
        System.arraycopy(raw, index += this.seqNumBytes.length, this.userDataBlockSizeBytes, 0, this.userDataBlockSizeBytes.length);
        index += this.userDataBlockSizeBytes.length;
        this.userDataBlockSize = ByteUtility.twoBytesToInt(this.userDataBlockSizeBytes);
        this.size = this.CoercedSize * (long)this.userDataBlockSize >> 30;
        this.raw = raw;
        return true;
    }

    public String getlinkSpeedLabel(byte index) {
        String s = ByteUtility.byteToHex(index);
        for (int i = 0; i < linkSpeedDescription.length; ++i) {
            if (!s.equals(linkSpeedDescription[i][0])) continue;
            return linkSpeedDescription[i][1];
        }
        return "undefined";
    }

    public String getFWStatusLabel(int index) {
        String s = "" + index;
        for (int i = 0; i < fwstateDescription.length; ++i) {
            if (!s.equals(fwstateDescription[i][0])) continue;
            return fwstateDescription[i][1];
        }
        return "undefined";
    }

    public String getFWStatusShortLabel(int index) {
        String s = "" + index;
        for (int i = 0; i < fwstateShortDescription.length; ++i) {
            if (!s.equals(fwstateShortDescription[i][0])) continue;
            return fwstateShortDescription[i][1];
        }
        return "UNDEFINED";
    }

    public String toFormatedDevice() {
        return " Device ID: " + deviceId + "\n";
    }

    public String toFormatedHeader() {
        String formatTemplate = " %-20s | %-20s\n";
        StringBuffer header = new StringBuffer();
        header.append(String.format(formatTemplate, "Field", "Value"));
        header.append(String.format(formatTemplate, "-----", "-----"));
        return header.toString();
    }

    public String toFormatedString() {
        String formatTemplate = " %-20s | %-20s\n";
        StringBuffer formatedString = new StringBuffer();
        formatedString.append(String.format(formatTemplate, "Vendor", this.vendor));
        formatedString.append(String.format(formatTemplate, "Name", this.modelname));
        formatedString.append(String.format(formatTemplate, "Revision", this.revision));
        formatedString.append(String.format(formatTemplate, "Media Err Count", this.mediaErrCount));
        formatedString.append(String.format(formatTemplate, "Other Err Count", this.otherErrCount));
        formatedString.append(String.format(formatTemplate, "Pred Fail Count", this.predFailCount));
        formatedString.append(String.format(formatTemplate, "Last Pred Fail Seq", this.lastPredFailEventSeqNum));
        formatedString.append(String.format(formatTemplate, "FW State", this.getFWStatusLabel(this.fwstate)));
        formatedString.append(String.format(formatTemplate, "Link Speed", this.getlinkSpeedLabel(this.linkSpeed)));
        formatedString.append(String.format(formatTemplate, "Size", ByteUtility.readableFileSize(this.size * 1024L * 1024L * 1024L)));
        formatedString.append(String.format(formatTemplate, "Temperature", this.showCandF(this.temperature)));
        formatedString.append(String.format(formatTemplate, "Enclosure ID", this.enclosureID));
        return formatedString.toString();
    }

    public static String toTableFormatedHeader() {
        String formatTemplate = " %5s | %3s | %-8s | %-16s | %-4s | %-8s | %-8s | %-4s | %-10s \n";
        StringBuffer header = new StringBuffer();
        header.append(String.format(formatTemplate, "Index", "EID", "Vendor", "Name", "Ver", "Speed", "Size", "Temp", "Status"));
        header.append(String.format(formatTemplate, "-----", "---", "------", "----", "---", "-----", "----", "----", "------"));
        return header.toString();
    }

    public String toTableFormatedString() {
        String formatTemplate = " %5s | %3s | %-8s | %-16s | %-4s | %-8s | %-8s | %-4s | %-10s \n";
        StringBuffer formatedString = new StringBuffer();
        formatedString.append(String.format(formatTemplate, "" + this.index, this.enclosureID, this.vendor, this.modelname, this.revision, this.getlinkSpeedLabel(this.linkSpeed), ByteUtility.readableFileSize(this.size * 1024L * 1024L * 1024L), this.temperature == -1 ? "N/A" : this.temperature + "C", this.getFWStatusShortLabel(this.fwstate)));
        return formatedString.toString();
    }

    public String toTableFormatedString(int devID) {
        String formatTemplate = " %5s | %3s | %-8s | %-16s | %-4s | %-8s | %-8s | %-4s | %-10s \n";
        StringBuffer formatedString = new StringBuffer();
        formatedString.append(String.format(formatTemplate, "" + this.index, this.enclosureID, this.vendor, this.modelname, this.revision, this.getlinkSpeedLabel(this.linkSpeed), ByteUtility.readableFileSize(this.size * 1024L * 1024L * 1024L), this.temperature == -1 ? "N/A" : this.temperature + "C", this.getFWStatusShortLabel(this.fwstate)));
        return formatedString.toString();
    }

    protected String showCandF(byte c) {
        if (c == -1) {
            return "N/A";
        }
        long f = Math.round(1.8 * (double)c + 32.0);
        return c + "C/" + (f < 100L ? " " : "") + f + "F";
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.toFormatedDevice());
        sb.append(this.toFormatedHeader());
        sb.append(this.toFormatedString());
        return sb.toString();
    }
}

