/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.gui;

import com.ami.iusb.IUSBRedirSession;
import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.gui.FSFrame;
import com.ami.kvm.jviewer.gui.JVFrame;
import com.ami.kvm.jviewer.gui.JVMenu;
import com.ami.kvm.jviewer.gui.JViewerContainer;
import com.ami.kvm.jviewer.gui.JViewerPanel;
import com.ami.kvm.jviewer.gui.JViewerParams;
import com.ami.kvm.jviewer.gui.JViewerView;
import com.ami.kvm.jviewer.gui.LocaleStrings;
import com.ami.kvm.jviewer.gui.WindowFrame;
import com.ami.kvm.jviewer.gui.vMediaDialog;
import com.ami.kvm.jviewer.hid.KVMClient;
import com.ami.kvm.jviewer.kvmpkts.USBKeyboardRep;
import com.ami.kvm.jviewer.kvmpkts.USBMouseRep;
import com.ami.kvm.jviewer.video.JVVideo;
import com.supermicro.ipmi.IPMIAMIOEMCommand;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMINetworkInterface;
import com.supermicro.ipmi.IPMIVersion;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.SessionControllerFactory;
import com.supermicro.softkeyboard.SoftKeyboardDialog;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.GregorianCalendar;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class JViewerApp {
    SoftKeyboardDialog softKeyboardDialog;
    private String serverIP;
    private String userID;
    private String password;
    private byte priv;
    public static boolean cmTest = false;
    public static final int FULL_FRAME_MODE = 0;
    public static final int WINDOW_FRAME_MODE = 1;
    public static final int PANEL_MODE = 2;
    private JViewerParams params = new JViewerParams();
    private JFrame m_frame;
    private JViewerContainer jviewerContainer;
    private WindowFrame m_wndFrame;
    private JViewerPanel jViewerPanel;
    private KVMClient m_KVMClnt;
    public JViewerView m_view;
    private FSFrame m_fsFrame;
    private IUSBRedirSession m_IUSBSession;
    public vMediaDialog m_mediaDlg = null;
    private int m_wndMode;
    private boolean panelMode;
    private String m_session_token;
    private boolean m_bUseSSL = false;
    private byte[] m_serverIP;
    private int m_serverPort;
    private int m_HIDPort;
    private int m_cdPort;
    private int m_fdPort;
    public boolean m_FullKeyboard = false;
    private boolean m_bVMUseSSL = false;
    private boolean m_bVideoPaused = false;
    public static boolean showCursor = false;
    private boolean connected = false;
    JVVideo vidClnt = null;
    BufferedImage orgImage = null;
    BufferedImage capImage = null;

    public void createUI() {
        this.m_wndFrame = new WindowFrame(this);
        this.m_fsFrame = new FSFrame(this);
        this.m_IUSBSession = new IUSBRedirSession(this);
        this.jViewerPanel = new JViewerPanel(this);
        this.jviewerContainer = this.m_wndFrame;
        this.m_view = new JViewerView(1024, 768, this);
    }

    public JViewerView getRCView() {
        return this.m_view;
    }

    public KVMClient getKVMClient() {
        return this.m_KVMClnt;
    }

    public JVMenu getJVMenu() {
        if (this.isPanelMode()) {
            return this.jviewerContainer.getMenu();
        }
        return this.jviewerContainer.getMenu();
    }

    public void setFrame(JFrame frame) {
        this.m_frame = frame;
    }

    public JFrame getFrame() {
        return this.m_frame;
    }

    public String getSessionToken() {
        if (this.m_session_token == null) {
            try {
                this.m_session_token = this.helpGetKVMSessionToken();
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(null, "Failed to get session token", "Error", 0);
            }
        }
        return this.m_session_token;
    }

    public void setStatus(String msg) {
        this.jviewerContainer.setStatus(msg);
    }

    public void resetStatus() {
        this.jviewerContainer.resetStatus();
    }

    public boolean isFullScreenMode() {
        return this.m_wndMode == 0;
    }

    public void setAppWndLabel(String label) {
        try {
            String ssl = this.m_bUseSSL ? "(SSL) " : " ";
            byte mouseMode = this.m_view.GetUSBMouseMode();
            this.jviewerContainer.setWndLabel(ssl + " " + label);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setAppWndLabelPowerOff() {
        this.jviewerContainer.setWndLabel(" " + LocaleStrings.GetString("D_1_JVAPP"));
    }

    public int getCDPort() {
        return this.m_cdPort;
    }

    public int getFDPort() {
        return this.m_fdPort;
    }

    public boolean isSecureConnection() {
        return this.m_bUseSSL;
    }

    public void helpConnectToServer(String serverIP, String userID, String password, byte priv, int serverPort, int hid_port, int cdserver_port, int fdserver_port) throws Exception {
        this.serverIP = serverIP;
        this.userID = userID;
        this.password = password;
        this.priv = priv;
        this.OnConnectToServer(JViewerApp.getServerIP(serverIP), serverPort, hid_port, null, false, false, cdserver_port, fdserver_port, 511);
        try {
            byte mouseMode = this.getMouseMode();
            this.getJVMenu().setMouseMode(mouseMode);
        }
        catch (Exception ex) {
            this.getJVMenu().menuItemMouseModeAbsolute.setEnabled(false);
            this.getJVMenu().menuItemMouseModeRelative.setEnabled(false);
        }
    }

    public void helpConnectToServer(String serverIP, String userID, String password, byte priv) throws Exception {
        this.helpConnectToServer(serverIP, userID, password, priv, 5901, 5900, 5120, 5123);
    }

    public String helpGetKVMSessionToken() throws Exception {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp(this.serverIP);
        config.setUserName(this.userID);
        config.setPassword(this.password);
        config.setPrivilege(this.priv);
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        IPMIAMIOEMCommand ipmiAMIOEMCommand = new IPMIAMIOEMCommand(null);
        IPMINetworkInterface rmcp = sessionController.startup(config);
        if (rmcp == null) {
            throw new Exception("Can't login");
        }
        ipmiAMIOEMCommand.setIPMIInterface(rmcp);
        String token = ipmiAMIOEMCommand.getKVMSessionToken();
        sessionController.closeSession();
        return token;
    }

    public void OnConnectToServer(byte[] serverIP, int serverPort, int hid_port, String token, boolean bUseSSL, boolean bVMUseSSL, int cdserver_port, int fdserver_port, int userPriv) {
        int ret;
        JVMenu menu;
        this.m_serverIP = serverIP;
        this.m_serverPort = serverPort;
        this.m_HIDPort = hid_port;
        this.m_session_token = token;
        if (this.panelMode) {
            this.jViewerPanel.attachView();
            this.m_wndMode = 2;
            this.jviewerContainer = this.jViewerPanel;
            menu = this.jviewerContainer.getMenu();
            menu.notifyFullScreen(false);
        } else {
            this.m_wndFrame.attachView();
            this.m_wndMode = 1;
            this.m_frame = this.m_wndFrame;
            this.jviewerContainer = this.m_wndFrame;
            menu = this.jviewerContainer.getMenu();
            menu.notifyFullScreen(false);
        }
        this.m_bUseSSL = bUseSSL;
        this.m_cdPort = cdserver_port;
        this.m_fdPort = fdserver_port;
        this.m_bVMUseSSL = bVMUseSSL;
        if (!this.getParams().isKVMEnabled() && (ret = JOptionPane.showConfirmDialog(this.m_frame, LocaleStrings.GetString("D_20_JVAPP"), LocaleStrings.GetString("A_1_GLOBAL"), 0)) == 1) {
            if (!this.panelMode) {
                System.exit(0);
            }
            return;
        }
        if (this.getParams().isKVMUser() && this.getParams().isKVMEnabled()) {
            this.OnVideoStartRedirection();
        } else if (this.getParams().isVMediaUser()) {
            this.OnvMedia();
        }
        this.OnShowCursor(false);
        Debug.out.println("isKVM User " + this.getParams().isKVMUser());
        Debug.out.println("isVMedia User " + this.getParams().isVMediaUser());
    }

    public void OnVideoStartRedirection() {
        Debug.out.println("OnVideoStartRedirection");
        this.vidClnt = new JVVideo(this);
        this.m_KVMClnt = new KVMClient(this.m_serverIP, this.m_serverPort, this.m_HIDPort, this.vidClnt, this.m_bUseSSL, this);
        if (-1 == this.m_KVMClnt.startRedirection()) {
            JOptionPane.showMessageDialog(this.m_frame, LocaleStrings.GetString("D_2_JVAPP"), LocaleStrings.GetString("A_1_GLOBAL"), 0);
            if (!this.panelMode) {
                System.exit(0);
            }
            this.connected = false;
            return;
        }
        JVFrame.setServerIP(this.m_serverIP);
        this.m_view.addKMListeners();
        Debug.out.println("End of OnVideoStartRedirection");
        this.OnVideoRefresh();
        if (this.isPanelMode()) {
            this.jViewerPanel.setConnectedUIStatus();
        }
        this.connected = true;
        if (cmTest) {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    JViewerApp.this.cmTest();
                }
            };
            thread.start();
        }
        if (this.softKeyboardDialog == null) {
            this.softKeyboardDialog = new SoftKeyboardDialog();
        }
        this.softKeyboardDialog.setKVMClient(this.m_KVMClnt);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.softKeyboardDialog.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        this.softKeyboardDialog.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
    }

    public void cmTest() {
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.m_view.sendDVO();
        this.OnVideoRefresh();
        int retVal = this.testVideoSignal();
        System.exit(retVal);
    }

    public int testVideoSignal() {
        this.orgImage = null;
        try {
            this.orgImage = ImageIO.read(new File("kvm.bmp"));
        }
        catch (IOException ex) {
            this.captureScreenToFile();
            return 6;
        }
        this.capImage = this.m_view.GetRedirImage();
        if (this.capImage == null) {
            return 1;
        }
        if (this.orgImage == null) {
            return 2;
        }
        int devide = 8;
        int width = this.capImage.getWidth();
        int height = this.capImage.getHeight();
        int cellWidth = width / devide;
        int cellHeight = height / devide;
        for (int i = 1; i <= devide; ++i) {
            for (int j = 1; j <= devide; ++j) {
                int x = i * cellWidth - cellWidth / 2;
                int y = j * cellHeight - cellHeight / 2;
                int rgb1 = -1;
                int rgb2 = -1;
                boolean sizeDiff = false;
                try {
                    rgb1 = this.capImage.getRGB(x, y);
                    rgb2 = this.orgImage.getRGB(x, y);
                }
                catch (ArrayIndexOutOfBoundsException ex1) {
                    sizeDiff = true;
                }
                if (!sizeDiff && rgb1 == rgb2) continue;
                this.captureScreenToFile();
                this.orgImage = null;
                this.capImage = null;
                if (sizeDiff) {
                    System.out.println("Resolution don't match");
                    return 7;
                }
                if (rgb1 == rgb2) continue;
                System.out.println("Color is different at (" + i + "," + j + ")");
                return 5;
            }
        }
        this.orgImage = null;
        this.capImage = null;
        return 0;
    }

    private void captureScreenToFile() {
        BufferedImage currentImage = this.m_view.GetRedirImage();
        File file = new File(this.serverIP + "_" + JViewerApp.getSystemDateTime() + "-kvm.bmp");
        try {
            ImageIO.write((RenderedImage)currentImage, "bmp", file);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static String getSystemDateTime() {
        GregorianCalendar cd1 = new GregorianCalendar();
        String dateTime = "";
        int s_yy = cd1.get(1);
        dateTime = dateTime + s_yy + "-";
        int s_mon = cd1.get(2) + 1;
        if (s_mon < 10) {
            dateTime = dateTime + "0";
        }
        dateTime = dateTime + s_mon + "-";
        int s_dd = cd1.get(5);
        if (s_dd < 10) {
            dateTime = dateTime + "0";
        }
        dateTime = dateTime + s_dd + "-";
        int s_hh = cd1.get(11);
        if (s_hh < 10) {
            dateTime = dateTime + "0";
        }
        dateTime = dateTime + s_hh + ".";
        int s_min = cd1.get(12);
        if (s_min < 10) {
            dateTime = dateTime + "0";
        }
        dateTime = dateTime + s_min + ".";
        int s_ss = cd1.get(13);
        if (s_ss < 10) {
            dateTime = dateTime + "0";
        }
        dateTime = dateTime + s_ss + "." + cd1.get(14);
        return dateTime;
    }

    public void OnVideoStopRedirection() {
        Debug.out.println("OnVideoStopRedirection");
        this.m_view.removeKMListeners();
        JVFrame.setServerIP(null);
        if (this.m_KVMClnt != null) {
            this.m_KVMClnt.stopRedirection();
        }
        if (this.isPanelMode()) {
            this.jViewerPanel.setDisconnectedUIStatus();
        }
        this.connected = false;
        this.m_session_token = null;
        this.vidClnt.clearBuffer();
        this.m_KVMClnt.getFragReader().clearBuffer();
        this.m_view.clearBuffer();
        this.OnCloseSoftKeyboard();
        System.gc();
    }

    public void OnVideoRestart() {
        Debug.out.println("OnVideoRestart");
        this.OnVideoStopRedirection();
        this.OnVideoStartRedirection();
    }

    public void OnVideoFullScreen(boolean state) {
        Debug.out.println("OnVideoFullScreen =" + state);
        if (state) {
            this.setScreenMode(0);
            if (this.panelMode && this.isConnected()) {
                this.jViewerPanel.showFullScreenModeMessage();
                this.jViewerPanel.setAllDisableUIStatus();
            }
        } else if (this.panelMode) {
            this.jViewerPanel.hideFullScreenModeMessage();
            if (this.isConnected()) {
                this.jViewerPanel.setConnectedUIStatus();
            }
            this.setScreenMode(2);
        } else {
            this.setScreenMode(1);
        }
    }

    public void setScreenMode(int screenMode) {
        switch (screenMode) {
            case 0: {
                this.setFullScreenMode();
                break;
            }
            case 1: {
                this.setWindowScreenMode();
                break;
            }
            case 2: {
                this.setPanelScreenMode();
            }
        }
        this.OnVideoRefresh();
    }

    private void setPanelScreenMode() {
        this.m_fsFrame.detachView();
        this.m_wndFrame.detachView();
        this.jViewerPanel.attachView();
        this.m_frame = this.m_wndFrame;
        this.jviewerContainer = this.jViewerPanel;
        this.m_wndMode = 2;
        this.jviewerContainer.getMenu().notifyFullScreen(false);
        this.jviewerContainer.getMenu().refreshMenu();
    }

    private void setWindowScreenMode() {
        this.m_fsFrame.detachView();
        this.jViewerPanel.detachView();
        this.m_wndFrame.attachView();
        this.m_frame = this.m_wndFrame;
        this.jviewerContainer = this.m_wndFrame;
        this.m_wndMode = 1;
        this.jviewerContainer.getMenu().notifyFullScreen(false);
        this.jviewerContainer.getMenu().refreshMenu();
    }

    private void setFullScreenMode() {
        if (this.m_wndMode == 2) {
            this.jViewerPanel.detachView();
        } else if (this.m_wndMode == 1) {
            this.m_wndFrame.detachView();
        }
        this.m_fsFrame.attachView();
        this.m_frame = this.m_fsFrame;
        this.jviewerContainer = this.m_fsFrame;
        this.m_wndMode = 0;
        this.jviewerContainer.getMenu().notifyFullScreen(true);
        this.jviewerContainer.getMenu().refreshMenu();
    }

    public void OnVideoExit() {
        Debug.out.println("OnVideoExit");
        this.jviewerContainer.exitApp();
    }

    public void OnVideoPause() {
        if (!this.m_KVMClnt.redirection()) {
            return;
        }
        if (this.m_KVMClnt.sendPauseVideo() != 0) {
            this.m_view.DisableKMListeners(true);
            this.m_bVideoPaused = true;
        }
    }

    public void OnVideoResume() {
        if (!this.m_KVMClnt.redirection()) {
            return;
        }
        if (this.m_KVMClnt.sendResumeVideo() != 0) {
            this.m_view.DisableKMListeners(false);
            this.m_bVideoPaused = false;
        }
    }

    public void OnVideoRefresh() {
        if (!this.m_KVMClnt.redirection()) {
            return;
        }
        this.m_KVMClnt.sendRefreshVideo();
    }

    public void OnVideoCapture() {
        if (!this.m_KVMClnt.redirection() || this.m_view == null) {
            return;
        }
        String imagePath = "";
        try {
            boolean done = false;
            do {
                JFileChooser chooser = new JFileChooser();
                class JpegImageFilter
                extends FileFilter {
                    JpegImageFilter() {
                    }

                    @Override
                    public boolean accept(File f) {
                        String filename = f.getName();
                        return filename.endsWith(".bmp") || f.isDirectory();
                    }

                    @Override
                    public String getDescription() {
                        return "bmp";
                    }

                    public String getExtension(String filePath) {
                        int dot = filePath.lastIndexOf(".");
                        return dot != -1 ? filePath.substring(dot + 1) : "";
                    }
                }
                chooser.setFileFilter(new JpegImageFilter());
                if (chooser.showSaveDialog(this.m_frame) == 0) {
                    int ret;
                    File file;
                    imagePath = chooser.getSelectedFile().getAbsolutePath();
                    String fileExtension = new JpegImageFilter().getExtension(imagePath).toLowerCase();
                    if (!fileExtension.equals("bmp")) {
                        imagePath = imagePath + ".bmp";
                    }
                    if ((file = new File(imagePath)).exists() && (ret = JOptionPane.showConfirmDialog(this.m_frame, LocaleStrings.GetString("D_3_JVAPP"), LocaleStrings.GetString("D_4_JVAPP"), 0)) != 0) {
                        continue;
                    }
                } else {
                    return;
                }
                done = true;
            } while (!done);
            BufferedImage currentImage = this.m_view.GetRedirImage();
            File file = new File(imagePath);
            ImageIO.write((RenderedImage)currentImage, "bmp", file);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this.m_frame, LocaleStrings.GetString("D_5_JVAPP") + imagePath, LocaleStrings.GetString("A_1_GLOBAL"), 0);
        }
    }

    public void OnKeyboardHoldRightAltKey(boolean state) {
        Debug.out.println("OnKeyboardHoldRightAltKey");
        if (!this.m_KVMClnt.redirection()) {
            return;
        }
        USBKeyboardRep keyRep = new USBKeyboardRep();
        keyRep.set(18, 3, state);
        this.m_KVMClnt.sendKMMessage(keyRep);
        this.jviewerContainer.getMenu().notifyRAlt(state);
    }

    public void OnKeyboardHoldLeftAltKey(boolean state) {
        Debug.out.println("OnKeyboardHoldLeftAltKey");
        if (!this.m_KVMClnt.redirection()) {
            return;
        }
        USBKeyboardRep keyRep = new USBKeyboardRep();
        keyRep.set(18, 2, state);
        this.m_KVMClnt.sendKMMessage(keyRep);
        this.jviewerContainer.getMenu().notifyLAlt(state);
    }

    public void OnKeyboardLeftWindowsKeyHoldDown(boolean state) {
        Debug.out.println("OnKeyboardLeftWindowsKeyHoldDown");
        if (!this.m_KVMClnt.redirection()) {
            return;
        }
        USBKeyboardRep keyRep = new USBKeyboardRep();
        keyRep.set(524, 2, state);
        this.m_KVMClnt.sendKMMessage(keyRep);
        this.jviewerContainer.getMenu().notifyLWinDown(state);
    }

    public void OnKeyboardLeftWindowsKeyPressRelease() {
        Debug.out.println("OnKeyboardLeftWindowsKeyPressRelease");
        if (!this.m_KVMClnt.redirection()) {
            return;
        }
        USBKeyboardRep keyRep = new USBKeyboardRep();
        keyRep.set(524, 2, true);
        this.m_KVMClnt.sendKMMessage(keyRep);
        keyRep.set(524, 2, false);
        this.m_KVMClnt.sendKMMessage(keyRep);
    }

    public void OnKeyboardRightWindowsKeyHoldDown(boolean state) {
        Debug.out.println("OnKeyboardRightWindowsKeyHoldDown");
        if (!this.m_KVMClnt.redirection()) {
            return;
        }
        USBKeyboardRep keyRep = new USBKeyboardRep();
        keyRep.set(524, 3, state);
        this.m_KVMClnt.sendKMMessage(keyRep);
        this.jviewerContainer.getMenu().notifyRWinDown(state);
    }

    public void OnKeyboardRightWindowsKeyPressRelease() {
        Debug.out.println("OnKeyboardRightWindowsKeyPressRelease");
        if (!this.m_KVMClnt.redirection()) {
            return;
        }
        USBKeyboardRep keyRep = new USBKeyboardRep();
        keyRep.set(524, 3, true);
        this.m_KVMClnt.sendKMMessage(keyRep);
        keyRep.set(524, 3, false);
        this.m_KVMClnt.sendKMMessage(keyRep);
    }

    public void OnKeyboardAltCtrlDel() {
        Debug.out.println("OnKeyboardAltCtrlDel");
        if (!this.m_KVMClnt.redirection()) {
            return;
        }
        USBKeyboardRep keyRep = new USBKeyboardRep();
        keyRep.set(17, 2, true);
        this.m_KVMClnt.sendKMMessage(keyRep);
        keyRep.set(18, 2, true);
        this.m_KVMClnt.sendKMMessage(keyRep);
        keyRep.set(127, 1, true);
        this.m_KVMClnt.sendKMMessage(keyRep);
        keyRep.set(127, 1, false);
        this.m_KVMClnt.sendKMMessage(keyRep);
        keyRep.set(18, 2, false);
        this.m_KVMClnt.sendKMMessage(keyRep);
        keyRep.set(17, 2, false);
        this.m_KVMClnt.sendKMMessage(keyRep);
    }

    public void OnKeyboardAltTab() {
        if (!this.m_KVMClnt.redirection()) {
            return;
        }
        USBKeyboardRep keyRep = new USBKeyboardRep();
        keyRep.set(18, 2, true);
        this.m_KVMClnt.sendKMMessage(keyRep);
        keyRep.set(9, 1, true);
        this.m_KVMClnt.sendKMMessage(keyRep);
        keyRep.set(9, 1, false);
        this.m_KVMClnt.sendKMMessage(keyRep);
        keyRep.set(18, 2, false);
        this.m_KVMClnt.sendKMMessage(keyRep);
    }

    public void OnKeyboardAltEsc() {
        if (!this.m_KVMClnt.redirection()) {
            return;
        }
        USBKeyboardRep keyRep = new USBKeyboardRep();
        keyRep.set(18, 2, true);
        this.m_KVMClnt.sendKMMessage(keyRep);
        keyRep.set(27, 1, true);
        this.m_KVMClnt.sendKMMessage(keyRep);
        keyRep.set(27, 1, false);
        this.m_KVMClnt.sendKMMessage(keyRep);
        keyRep.set(18, 2, false);
        this.m_KVMClnt.sendKMMessage(keyRep);
    }

    public void OnKeyboardCtrlEsc() {
        if (!this.m_KVMClnt.redirection()) {
            return;
        }
        USBKeyboardRep keyRep = new USBKeyboardRep();
        keyRep.set(17, 2, true);
        this.m_KVMClnt.sendKMMessage(keyRep);
        keyRep.set(27, 1, true);
        this.m_KVMClnt.sendKMMessage(keyRep);
        keyRep.set(27, 1, false);
        this.m_KVMClnt.sendKMMessage(keyRep);
        keyRep.set(17, 2, false);
        this.m_KVMClnt.sendKMMessage(keyRep);
    }

    public void OnKeyboardAltSpace() {
        if (!this.m_KVMClnt.redirection()) {
            return;
        }
        USBKeyboardRep keyRep = new USBKeyboardRep();
        keyRep.set(18, 2, true);
        this.m_KVMClnt.sendKMMessage(keyRep);
        keyRep.set(32, 1, true);
        this.m_KVMClnt.sendKMMessage(keyRep);
        keyRep.set(32, 1, false);
        this.m_KVMClnt.sendKMMessage(keyRep);
        keyRep.set(18, 2, false);
        this.m_KVMClnt.sendKMMessage(keyRep);
    }

    public void OnKeyboardAltEnter() {
        if (!this.m_KVMClnt.redirection()) {
            return;
        }
        USBKeyboardRep keyRep = new USBKeyboardRep();
        keyRep.set(18, 2, true);
        this.m_KVMClnt.sendKMMessage(keyRep);
        keyRep.set(10, 1, true);
        this.m_KVMClnt.sendKMMessage(keyRep);
        keyRep.set(10, 1, false);
        this.m_KVMClnt.sendKMMessage(keyRep);
        keyRep.set(18, 2, false);
        this.m_KVMClnt.sendKMMessage(keyRep);
    }

    public void OnKeyboardAltHyphen() {
        if (!this.m_KVMClnt.redirection()) {
            return;
        }
        USBKeyboardRep keyRep = new USBKeyboardRep();
        keyRep.set(18, 2, true);
        this.m_KVMClnt.sendKMMessage(keyRep);
        keyRep.set(45, 1, true);
        this.m_KVMClnt.sendKMMessage(keyRep);
        keyRep.set(45, 1, false);
        this.m_KVMClnt.sendKMMessage(keyRep);
        keyRep.set(18, 2, false);
        this.m_KVMClnt.sendKMMessage(keyRep);
    }

    public void OnKeyboardAltF4() {
        if (!this.m_KVMClnt.redirection()) {
            return;
        }
        USBKeyboardRep keyRep = new USBKeyboardRep();
        keyRep.set(18, 2, true);
        this.m_KVMClnt.sendKMMessage(keyRep);
        keyRep.set(115, 1, true);
        this.m_KVMClnt.sendKMMessage(keyRep);
        keyRep.set(115, 1, false);
        this.m_KVMClnt.sendKMMessage(keyRep);
        keyRep.set(18, 2, false);
        this.m_KVMClnt.sendKMMessage(keyRep);
    }

    public void OnKeyboardAltPrntScrn() {
        if (!this.m_KVMClnt.redirection()) {
            return;
        }
        USBKeyboardRep keyRep = new USBKeyboardRep();
        keyRep.set(18, 2, true);
        this.m_KVMClnt.sendKMMessage(keyRep);
        keyRep.set(154, 1, true);
        this.m_KVMClnt.sendKMMessage(keyRep);
        keyRep.set(154, 1, false);
        this.m_KVMClnt.sendKMMessage(keyRep);
        keyRep.set(18, 2, false);
        this.m_KVMClnt.sendKMMessage(keyRep);
    }

    public void OnKeyboardPrntScrn() {
        USBKeyboardRep keyRep = new USBKeyboardRep();
        keyRep.set(154, 1, true);
        this.m_KVMClnt.sendKMMessage(keyRep);
        keyRep.set(154, 1, false);
        this.m_KVMClnt.sendKMMessage(keyRep);
    }

    public void OnKeyboardF1() {
        USBKeyboardRep keyRep = new USBKeyboardRep();
        keyRep.set(112, 1, true);
        this.m_KVMClnt.sendKMMessage(keyRep);
        keyRep.set(112, 1, false);
        this.m_KVMClnt.sendKMMessage(keyRep);
    }

    public void OnKeyboardPause() {
        USBKeyboardRep keyRep = new USBKeyboardRep();
        keyRep.set(19, 1, true);
        this.m_KVMClnt.sendKMMessage(keyRep);
        keyRep.set(19, 1, false);
        this.m_KVMClnt.sendKMMessage(keyRep);
    }

    private void SendKey(int key, int keyLocation, USBKeyboardRep keyRep) {
        keyRep.set(key, keyLocation, true);
        this.m_KVMClnt.sendKMMessage(keyRep);
        keyRep.set(key, keyLocation, false);
        this.m_KVMClnt.sendKMMessage(keyRep);
    }

    public void OnKeyboardFullKeyboard(boolean state) {
        Debug.out.println("OnKeyboardFullKeyboard");
        this.m_FullKeyboard = state;
    }

    public void OnUSBMouseSyncCursor(boolean state) {
        Debug.out.println("OnUSBMouseSyncCursor");
        showCursor = true;
        boolean ret = this.m_view.USBsyncCursor(state);
        if (state && !ret) {
            this.jviewerContainer.getMenu().notifyMouseRedir(false);
        } else if (state && ret) {
            this.jviewerContainer.getMenu().notifyMouseRedir(true);
        } else if (!state) {
            this.jviewerContainer.getMenu().notifyMouseRedir(false);
        }
    }

    public void OnShowCursor(boolean state) {
        Debug.out.println("OnShowCursor");
        if (state) {
            showCursor = true;
            this.m_view.ShowCursor(true);
        } else {
            showCursor = false;
            this.m_view.ShowCursor(false);
        }
    }

    public void OnHelpAboutJViewer() {
        Debug.out.println("OnHelpAboutJViewer");
        JOptionPane.showMessageDialog(this.m_frame, LocaleStrings.GetString("A_1_GLOBAL") + " " + LocaleStrings.GetString("D_7_JVAPP") + " 1.33.01 (SMC 2.04)\n" + LocaleStrings.GetString("D_8_JVAPP"), LocaleStrings.GetString("D_9_JVAPP"), 1);
    }

    public void OnSessionStopCmd(short stop_status) {
        if (stop_status == 1) {
            JOptionPane.showMessageDialog(this.m_frame, LocaleStrings.GetString("D_12_JVAPP"), LocaleStrings.GetString("A_1_GLOBAL"), 0);
        } else if (stop_status == 2) {
            JOptionPane.showMessageDialog(this.m_frame, LocaleStrings.GetString("D_13_JVAPP"), LocaleStrings.GetString("A_1_GLOBAL"), 1);
        } else if (stop_status == 4) {
            JOptionPane.showMessageDialog(this.m_frame, LocaleStrings.GetString("D_14_JVAPP"), LocaleStrings.GetString("A_1_GLOBAL"), 1);
        } else if (stop_status == 3) {
            JOptionPane.showMessageDialog(this.m_frame, LocaleStrings.GetString("D_15_JVAPP"), LocaleStrings.GetString("A_1_GLOBAL"), 1);
        } else if (stop_status == 5) {
            JOptionPane.showMessageDialog(this.m_frame, LocaleStrings.GetString("D_16_JVAPP"), LocaleStrings.GetString("A_1_GLOBAL"), 1);
        } else if (stop_status == 6) {
            JOptionPane.showMessageDialog(this.m_frame, LocaleStrings.GetString("D_17_JVAPP"), LocaleStrings.GetString("A_1_GLOBAL"), 1);
        } else if (stop_status == 7) {
            JOptionPane.showMessageDialog(this.m_frame, LocaleStrings.GetString("D_21_JVAPP"), LocaleStrings.GetString("A_1_GLOBAL"), 1);
        } else {
            JOptionPane.showMessageDialog(this.m_frame, LocaleStrings.GetString("D_18_JVAPP"), LocaleStrings.GetString("A_1_GLOBAL"), 1);
        }
        if (!this.panelMode) {
            System.exit(0);
        }
    }

    public void OnGetMouseMode(short status, byte mouse_mode) {
        Debug.out.println("Mouse mode response packet received");
        if (status == 0) {
            this.m_view.SetUSBMouseMode(mouse_mode);
            this.OnUSBMouseSyncCursor(true);
        } else {
            this.m_view.SetUSBMouseMode(USBMouseRep.INVALID_MOUSE_MODE);
        }
    }

    public void OnvMedia() {
        String serverIP = null;
        try {
            serverIP = InetAddress.getByAddress(this.m_serverIP).getHostAddress();
        }
        catch (UnknownHostException e) {
            Debug.out.println("Invalid IP address");
        }
        this.m_mediaDlg = new vMediaDialog(this.m_frame, this.m_IUSBSession, serverIP, this.getCDPort(), this.getFDPort(), this.m_bVMUseSSL, this.getSessionToken(), this);
        this.m_mediaDlg.DisplayDialog();
        this.m_mediaDlg = null;
    }

    public void OnSoftKeyboard() {
        this.softKeyboardDialog.setVisible(true);
    }

    public void OnCloseSoftKeyboard() {
        this.softKeyboardDialog.setVisible(false);
    }

    public void OnChangeColorMode(byte color_mode) {
        JVMenu menu = this.getJVMenu();
        menu.notifyColorMode(this.m_view.m_current_color_mode);
        this.m_KVMClnt.send_color_mode_pkt(color_mode);
    }

    public void reportCDROMAbnormal() {
        this.m_IUSBSession.stopCDROMAbnormal();
        if (this.m_mediaDlg != null) {
            this.m_mediaDlg.updateCDROMRedirStatus();
        }
    }

    public void reportFloppyAbnormal() {
        this.m_IUSBSession.stopFloppyAbnormal();
        if (this.m_mediaDlg != null) {
            this.m_mediaDlg.updateFloppyRedirStatus();
        }
    }

    public boolean IsCDROMRedirRunning() {
        return this.m_IUSBSession.getCDROMRedirStatus() == 1;
    }

    public boolean IsFloppyRedirRunning() {
        return this.m_IUSBSession.getFloppyRedirStatus() == 1;
    }

    public JViewerParams getParams() {
        return this.params;
    }

    public JViewerPanel getJViewerPanel(JFrame frame) {
        this.m_frame = frame;
        return this.jViewerPanel;
    }

    public boolean isPanelMode() {
        return this.panelMode;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public String getUserID() {
        return this.userID;
    }

    public String getPassword() {
        return this.password;
    }

    public String getServerIP() {
        return this.serverIP;
    }

    public void setPanelMode(boolean panelMode) {
        this.panelMode = panelMode;
    }

    public void setUserID(String userID) {
        this.userID = userID;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setServerIP(String serverIP) {
        this.serverIP = serverIP;
    }

    public void generalErrorMessage(String message) {
        JOptionPane.showMessageDialog(this.m_frame, message, LocaleStrings.GetString("A_1_GLOBAL"), 0);
    }

    private static byte[] getServerIP(String ipStr) {
        boolean invalidIP = false;
        try {
            InetAddress hostAddress = InetAddress.getByName(ipStr);
            ipStr = hostAddress.getHostAddress();
        }
        catch (UnknownHostException hostAddress) {
            // empty catch block
        }
        if (ipStr.trim().length() <= 0) {
            return null;
        }
        String[] ipDgtStr = ipStr.split("\\.");
        if (ipDgtStr.length != 4) {
            return null;
        }
        byte[] ipDgt = new byte[4];
        for (int i = 0; i < 4; ++i) {
            try {
                ipDgt[i] = (byte)Short.parseShort(ipDgtStr[i]);
            }
            catch (NumberFormatException e) {
                return null;
            }
            if (ipDgt[i] <= 255) continue;
            return null;
        }
        return ipDgt;
    }

    public void OnMouseModeAbsolute() {
        byte mode = 0;
        try {
            mode = this.getMouseMode();
            if (mode == 2) {
                this.getJVMenu().setMouseMode(mode);
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        int result = JOptionPane.showConfirmDialog(this.jViewerPanel, "It needs to restart KVM session. Are you sure to continue ?", "Info", 2);
        if (result != 0) {
            this.getJVMenu().setMouseMode(mode);
            return;
        }
        this.m_view.SetUSBMouseMode(USBMouseRep.ABSOLUTE_MOUSE_MODE);
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    JViewerApp.this.jViewerPanel.setCursor(new Cursor(3));
                    JViewerApp.this.OnVideoStopRedirection();
                    ((JViewerApp)JViewerApp.this).jViewerPanel.jStartButton.setEnabled(false);
                    JViewerApp.this.sleep1Sec();
                    JViewerApp.this.setMouseMode((byte)2);
                    byte mode = JViewerApp.this.getMouseMode();
                    JViewerApp.this.getJVMenu().setMouseMode(mode);
                    JViewerApp.this.sleep1Sec();
                    JViewerApp.this.OnVideoStartRedirection();
                    JViewerApp.this.jViewerPanel.setCursor(new Cursor(0));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        thread.start();
    }

    public void OnMouseModeRelative() {
        byte mode = 0;
        try {
            mode = this.getMouseMode();
            if (mode == 1) {
                this.getJVMenu().setMouseMode(mode);
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        int result = JOptionPane.showConfirmDialog(this.jViewerPanel, "It needs to restart KVM session. Are you sure to continue ?", "Info", 2);
        if (result != 0) {
            this.getJVMenu().setMouseMode(mode);
            return;
        }
        this.m_view.SetUSBMouseMode(USBMouseRep.RELATIVE_MOUSE_MODE);
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    JViewerApp.this.jViewerPanel.setCursor(new Cursor(3));
                    JViewerApp.this.OnVideoStopRedirection();
                    ((JViewerApp)JViewerApp.this).jViewerPanel.jStartButton.setEnabled(false);
                    JViewerApp.this.sleep1Sec();
                    JViewerApp.this.setMouseMode((byte)1);
                    byte mode = JViewerApp.this.getMouseMode();
                    JViewerApp.this.getJVMenu().setMouseMode(mode);
                    JViewerApp.this.sleep1Sec();
                    JViewerApp.this.OnVideoStartRedirection();
                    JViewerApp.this.jViewerPanel.setCursor(new Cursor(0));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        thread.start();
    }

    private void sleep1Sec() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void stopVM() {
        if (this.m_IUSBSession != null) {
            this.m_IUSBSession.StopCDROMRedir();
            this.m_IUSBSession.StopFloppyRedir();
            this.m_IUSBSession.StopISORedir();
        }
    }

    public byte getMouseMode() throws Exception {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp(this.serverIP);
        config.setUserName(this.userID);
        config.setPassword(this.password);
        config.setPrivilege((byte)4);
        IPMIAMIOEMCommand ipmiAMIOEMCommand = new IPMIAMIOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(config, ipmiAMIOEMCommand);
        if (sessionController == null) {
            throw new IPMIException("Cannot connect to BMC");
        }
        byte mode = ipmiAMIOEMCommand.getMouseMode();
        sessionController.closeSession();
        return mode;
    }

    public boolean setMouseMode(byte mode) throws Exception {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp(this.serverIP);
        config.setUserName(this.userID);
        config.setPassword(this.password);
        config.setPrivilege((byte)4);
        IPMIAMIOEMCommand ipmiAMIOEMCommand = new IPMIAMIOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(config, ipmiAMIOEMCommand);
        if (sessionController == null) {
            throw new IPMIException("Cannot connect to BMC");
        }
        ipmiAMIOEMCommand.setMouseMode(mode);
        sessionController.closeSession();
        return true;
    }

    public boolean isShowCursor() {
        return showCursor;
    }

    public void setShowCursor(boolean showCursor) {
        JViewerApp.showCursor = showCursor;
    }
}

